// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package cloudbilling provides access to the Cloud Billing API.
//
// For product documentation, see: https://cloud.google.com/billing/docs/apis
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/cloudbilling/v1beta"
//	...
//	ctx := context.Background()
//	cloudbillingService, err := cloudbilling.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	cloudbillingService, err := cloudbilling.NewService(ctx, option.WithScopes(cloudbilling.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	cloudbillingService, err := cloudbilling.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	cloudbillingService, err := cloudbilling.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package cloudbilling // import "google.golang.org/api/cloudbilling/v1beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "cloudbilling:v1beta"
const apiName = "cloudbilling"
const apiVersion = "v1beta"
const basePath = "https://cloudbilling.googleapis.com/"
const basePathTemplate = "https://cloudbilling.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://cloudbilling.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// View and manage your Google Cloud Platform billing accounts
	CloudBillingScope = "https://www.googleapis.com/auth/cloud-billing"

	// View your Google Cloud Platform billing accounts
	CloudBillingReadonlyScope = "https://www.googleapis.com/auth/cloud-billing.readonly"

	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-billing",
		"https://www.googleapis.com/auth/cloud-billing.readonly",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.BillingAccounts = NewBillingAccountsService(s)
	s.SkuGroups = NewSkuGroupsService(s)
	s.Skus = NewSkusService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	BillingAccounts *BillingAccountsService

	SkuGroups *SkuGroupsService

	Skus *SkusService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewBillingAccountsService(s *Service) *BillingAccountsService {
	rs := &BillingAccountsService{s: s}
	rs.Services = NewBillingAccountsServicesService(s)
	rs.SkuGroups = NewBillingAccountsSkuGroupsService(s)
	rs.Skus = NewBillingAccountsSkusService(s)
	return rs
}

type BillingAccountsService struct {
	s *Service

	Services *BillingAccountsServicesService

	SkuGroups *BillingAccountsSkuGroupsService

	Skus *BillingAccountsSkusService
}

func NewBillingAccountsServicesService(s *Service) *BillingAccountsServicesService {
	rs := &BillingAccountsServicesService{s: s}
	return rs
}

type BillingAccountsServicesService struct {
	s *Service
}

func NewBillingAccountsSkuGroupsService(s *Service) *BillingAccountsSkuGroupsService {
	rs := &BillingAccountsSkuGroupsService{s: s}
	rs.Skus = NewBillingAccountsSkuGroupsSkusService(s)
	return rs
}

type BillingAccountsSkuGroupsService struct {
	s *Service

	Skus *BillingAccountsSkuGroupsSkusService
}

func NewBillingAccountsSkuGroupsSkusService(s *Service) *BillingAccountsSkuGroupsSkusService {
	rs := &BillingAccountsSkuGroupsSkusService{s: s}
	return rs
}

type BillingAccountsSkuGroupsSkusService struct {
	s *Service
}

func NewBillingAccountsSkusService(s *Service) *BillingAccountsSkusService {
	rs := &BillingAccountsSkusService{s: s}
	rs.Price = NewBillingAccountsSkusPriceService(s)
	rs.Prices = NewBillingAccountsSkusPricesService(s)
	return rs
}

type BillingAccountsSkusService struct {
	s *Service

	Price *BillingAccountsSkusPriceService

	Prices *BillingAccountsSkusPricesService
}

func NewBillingAccountsSkusPriceService(s *Service) *BillingAccountsSkusPriceService {
	rs := &BillingAccountsSkusPriceService{s: s}
	return rs
}

type BillingAccountsSkusPriceService struct {
	s *Service
}

func NewBillingAccountsSkusPricesService(s *Service) *BillingAccountsSkusPricesService {
	rs := &BillingAccountsSkusPricesService{s: s}
	return rs
}

type BillingAccountsSkusPricesService struct {
	s *Service
}

func NewSkuGroupsService(s *Service) *SkuGroupsService {
	rs := &SkuGroupsService{s: s}
	rs.Skus = NewSkuGroupsSkusService(s)
	return rs
}

type SkuGroupsService struct {
	s *Service

	Skus *SkuGroupsSkusService
}

func NewSkuGroupsSkusService(s *Service) *SkuGroupsSkusService {
	rs := &SkuGroupsSkusService{s: s}
	return rs
}

type SkuGroupsSkusService struct {
	s *Service
}

func NewSkusService(s *Service) *SkusService {
	rs := &SkusService{s: s}
	rs.Price = NewSkusPriceService(s)
	rs.Prices = NewSkusPricesService(s)
	return rs
}

type SkusService struct {
	s *Service

	Price *SkusPriceService

	Prices *SkusPricesService
}

func NewSkusPriceService(s *Service) *SkusPriceService {
	rs := &SkusPriceService{s: s}
	return rs
}

type SkusPriceService struct {
	s *Service
}

func NewSkusPricesService(s *Service) *SkusPricesService {
	rs := &SkusPricesService{s: s}
	return rs
}

type SkusPricesService struct {
	s *Service
}

// Decimal: A representation of a decimal value, such as 2.5. Clients may
// convert values into language-native decimal formats, such as Java's
// BigDecimal
// (https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/math/BigDecimal.html)
// or Python's decimal.Decimal
// (https://docs.python.org/3/library/decimal.html).
type Decimal struct {
	// Value: The decimal value, as a string. The string representation consists of
	// an optional sign, `+` (`U+002B`) or `-` (`U+002D`), followed by a sequence
	// of zero or more decimal digits ("the integer"), optionally followed by a
	// fraction, optionally followed by an exponent. An empty string **should** be
	// interpreted as `0`. The fraction consists of a decimal point followed by
	// zero or more decimal digits. The string must contain at least one digit in
	// either the integer or the fraction. The number formed by the sign, the
	// integer and the fraction is referred to as the significand. The exponent
	// consists of the character `e` (`U+0065`) or `E` (`U+0045`) followed by one
	// or more decimal digits. Services **should** normalize decimal values before
	// storing them by: - Removing an explicitly-provided `+` sign (`+2.5` ->
	// `2.5`). - Replacing a zero-length integer value with `0` (`.5` -> `0.5`). -
	// Coercing the exponent character to upper-case, with explicit sign (`2.5e8`
	// -> `2.5E+8`). - Removing an explicitly-provided zero exponent (`2.5E0` ->
	// `2.5`). Services **may** perform additional normalization based on its own
	// needs and the internal decimal implementation selected, such as shifting the
	// decimal point and exponent value together (example: `2.5E-1` <-> `0.25`).
	// Additionally, services **may** preserve trailing zeroes in the fraction to
	// indicate increased precision, but are not required to do so. Note that only
	// the `.` character is supported to divide the integer and the fraction; `,`
	// **should not** be supported regardless of locale. Additionally, thousand
	// separators **should not** be supported. If a service does support them,
	// values **must** be normalized. The ENBF grammar is: DecimalString = '' |
	// [Sign] Significand [Exponent]; Sign = '+' | '-'; Significand = Digits '.' |
	// [Digits] '.' Digits; Exponent = ('e' | 'E') [Sign] Digits; Digits = { '0' |
	// '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' }; Services **should**
	// clearly document the range of supported values, the maximum supported
	// precision (total number of digits), and, if applicable, the scale (number of
	// digits after the decimal point), as well as how it behaves when receiving
	// out-of-bounds values. Services **may** choose to accept values passed as
	// input even when the value has a higher precision or scale than the service
	// supports, and **should** round the value to fit the supported scale.
	// Alternatively, the service **may** error with `400 Bad Request`
	// (`INVALID_ARGUMENT` in gRPC) if precision would be lost. Services **should**
	// error with `400 Bad Request` (`INVALID_ARGUMENT` in gRPC) if the service
	// receives a value outside of the supported range.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Value") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Decimal) MarshalJSON() ([]byte, error) {
	type NoMethod Decimal
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaAggregationInfo: Encapsulates
// the aggregation information such as aggregation level and interval for a
// billing account price.
type GoogleCloudBillingBillingaccountpricesV1betaAggregationInfo struct {
	// Interval: Interval at which usage is aggregated to compute cost. Example:
	// "MONTHLY" interval indicates that usage is aggregated every month.
	//
	// Possible values:
	//   "INTERVAL_UNSPECIFIED" - Default unspecified value.
	//   "INTERVAL_MONTHLY" - Usage is aggregated every month.
	//   "INTERVAL_DAILY" - Usage is aggregated every day.
	Interval string `json:"interval,omitempty"`
	// Level: Level at which usage is aggregated to compute cost. Example:
	// "ACCOUNT" level indicates that usage is aggregated across all projects in a
	// single account.
	//
	// Possible values:
	//   "LEVEL_UNSPECIFIED" - Default unspecified value.
	//   "LEVEL_ACCOUNT" - Usage is aggregated at an account level.
	//   "LEVEL_PROJECT" - Usage is aggregated at a project level.
	Level string `json:"level,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Interval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Interval") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaAggregationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaAggregationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaBillingAccountPrice:
// Encapsulates the latest price for a billing account SKU.
type GoogleCloudBillingBillingaccountpricesV1betaBillingAccountPrice struct {
	// CurrencyCode: ISO-4217 currency code for the price.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Name: Resource name for the latest billing account price.
	Name string `json:"name,omitempty"`
	// PriceReason: Background information on the origin of the price.
	PriceReason *GoogleCloudBillingBillingaccountpricesV1betaPriceReason `json:"priceReason,omitempty"`
	// Rate: Rate price metadata. Billing account SKUs with `Rate` price are
	// offered by pricing tiers. The price can have 1 or more rate pricing tiers.
	Rate *GoogleCloudBillingBillingaccountpricesV1betaRate `json:"rate,omitempty"`
	// ValueType: Type of the price. The possible values are: ["unspecified",
	// "rate"].
	ValueType string `json:"valueType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaBillingAccountPrice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaBillingAccountPrice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaDefaultPrice: Encapsulates a
// default price which is the current list price.
type GoogleCloudBillingBillingaccountpricesV1betaDefaultPrice struct {
}

// GoogleCloudBillingBillingaccountpricesV1betaFixedDiscount: Encapsulates a
// discount off the list price, anchored to the list price as of a fixed time.
type GoogleCloudBillingBillingaccountpricesV1betaFixedDiscount struct {
	// DiscountPercent: Percentage of the fixed discount.
	DiscountPercent *Decimal `json:"discountPercent,omitempty"`
	// DiscountScopeType: Type of the fixed discount scope which indicates the
	// source of the discount. It can have values such as 'unspecified' and
	// 'sku-group'.
	DiscountScopeType string `json:"discountScopeType,omitempty"`
	// FixTime: Time that the fixed discount is anchored to.
	FixTime string `json:"fixTime,omitempty"`
	// SkuGroup: SKU group where the fixed discount comes from.
	SkuGroup string `json:"skuGroup,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiscountPercent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscountPercent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaFixedDiscount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaFixedDiscount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaFixedPrice: Encapsulates a set
// fixed price applicable during the terms of a contract agreement.
type GoogleCloudBillingBillingaccountpricesV1betaFixedPrice struct {
}

// GoogleCloudBillingBillingaccountpricesV1betaFloatingDiscount: Encapsulates a
// discount off the current list price, not anchored to any list price as of a
// fixed time.
type GoogleCloudBillingBillingaccountpricesV1betaFloatingDiscount struct {
	// DiscountPercent: Percentage of the floating discount.
	DiscountPercent *Decimal `json:"discountPercent,omitempty"`
	// DiscountScopeType: Type of the floating discount scope which indicates the
	// source of the discount. It can have values such as 'unspecified' and
	// 'sku-group'.
	DiscountScopeType string `json:"discountScopeType,omitempty"`
	// SkuGroup: SKU group where the floating discount comes from.
	SkuGroup string `json:"skuGroup,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiscountPercent") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiscountPercent") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaFloatingDiscount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaFloatingDiscount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaListBillingAccountPricesResponse:
//
//	Response message for ListBillingAccountPrices.
type GoogleCloudBillingBillingaccountpricesV1betaListBillingAccountPricesResponse struct {
	// BillingAccountPrices: The returned billing account prices.
	BillingAccountPrices []*GoogleCloudBillingBillingaccountpricesV1betaBillingAccountPrice `json:"billingAccountPrices,omitempty"`
	// NextPageToken: Token that can be sent as `page_token` in the subsequent
	// request to retrieve the next page. If this field is empty, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BillingAccountPrices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingAccountPrices") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaListBillingAccountPricesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaListBillingAccountPricesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaListPriceAsCeiling: Encapsulates
// a contract feature that the list price (DefaultPrice) will be used for the
// price if the current list price drops lower than the custom fixed price.
// Available to new contracts after March 21, 2022. Applies to all fixed price
// SKUs in the contract, including FixedPrice, FixedDiscount, MigratedPrice,
// and MergedPrice.
type GoogleCloudBillingBillingaccountpricesV1betaListPriceAsCeiling struct {
}

// GoogleCloudBillingBillingaccountpricesV1betaMergedPrice: Encapsulates a
// price after merging from multiple sources. With merged tiers, each
// individual tier can be from a different source with different discount
// types.
type GoogleCloudBillingBillingaccountpricesV1betaMergedPrice struct {
}

// GoogleCloudBillingBillingaccountpricesV1betaMigratedPrice: Encapsulates a
// price migrated from other SKUs.
type GoogleCloudBillingBillingaccountpricesV1betaMigratedPrice struct {
	// SourceSku: Source SKU where the discount is migrated from. Format:
	// billingAccounts/{billing_account}/skus/{sku}
	SourceSku string `json:"sourceSku,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SourceSku") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SourceSku") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaMigratedPrice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaMigratedPrice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaPriceReason: Encapsulates a
// price reason which contains background information about the origin of the
// price.
type GoogleCloudBillingBillingaccountpricesV1betaPriceReason struct {
	// DefaultPrice: Default price which is the current list price.
	DefaultPrice *GoogleCloudBillingBillingaccountpricesV1betaDefaultPrice `json:"defaultPrice,omitempty"`
	// FixedDiscount: Discount off the list price, anchored to the list price as of
	// a fixed time.
	FixedDiscount *GoogleCloudBillingBillingaccountpricesV1betaFixedDiscount `json:"fixedDiscount,omitempty"`
	// FixedPrice: Fixed price applicable during the terms of a contract agreement.
	FixedPrice *GoogleCloudBillingBillingaccountpricesV1betaFixedPrice `json:"fixedPrice,omitempty"`
	// FloatingDiscount: Discount off the current list price, not anchored to any
	// list price as of a fixed time.
	FloatingDiscount *GoogleCloudBillingBillingaccountpricesV1betaFloatingDiscount `json:"floatingDiscount,omitempty"`
	// ListPriceAsCeiling: Contract feature that the list price (DefaultPrice) will
	// be used for the price if the current list price drops lower than the custom
	// fixed price. Available to new contracts after March 21, 2022. Applies to all
	// fixed price SKUs in the contract, including FixedPrice, FixedDiscount,
	// MigratedPrice, and MergedPrice.
	ListPriceAsCeiling *GoogleCloudBillingBillingaccountpricesV1betaListPriceAsCeiling `json:"listPriceAsCeiling,omitempty"`
	// MergedPrice: Price after merging from multiple sources.
	MergedPrice *GoogleCloudBillingBillingaccountpricesV1betaMergedPrice `json:"mergedPrice,omitempty"`
	// MigratedPrice: Price migrated from other SKUs.
	MigratedPrice *GoogleCloudBillingBillingaccountpricesV1betaMigratedPrice `json:"migratedPrice,omitempty"`
	// Type: Type of the price reason. It can have values such as 'unspecified',
	// 'default-price', 'fixed-price', 'fixed-discount', 'floating-discount',
	// 'migrated-price', 'merged-price', 'list-price-as-ceiling'.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultPrice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultPrice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaPriceReason) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaPriceReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaRate: Encapsulates a `Rate`
// price. Billing account SKUs with `Rate` price are offered by pricing tiers.
// The price have 1 or more rate pricing tiers.
type GoogleCloudBillingBillingaccountpricesV1betaRate struct {
	// AggregationInfo: Aggregation info for tiers such as aggregation level and
	// interval.
	AggregationInfo *GoogleCloudBillingBillingaccountpricesV1betaAggregationInfo `json:"aggregationInfo,omitempty"`
	// Tiers: All tiers associated with the `Rate` price.
	Tiers []*GoogleCloudBillingBillingaccountpricesV1betaRateTier `json:"tiers,omitempty"`
	// UnitInfo: Unit info such as name and quantity.
	UnitInfo *GoogleCloudBillingBillingaccountpricesV1betaUnitInfo `json:"unitInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregationInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaRate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaRate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaRateTier: Encapsulates a rate
// price tier.
type GoogleCloudBillingBillingaccountpricesV1betaRateTier struct {
	// ContractPrice: Negotiated contract price specific for a billing account.
	ContractPrice *Money `json:"contractPrice,omitempty"`
	// EffectiveDiscountPercent: Percentage of effective discount calculated using
	// the current list price per pricing tier. Formula used:
	// effective_discount_percent = (list_price - contract_price) / list_price ×
	// 100 If list_price and contract_price are zero, this field is the same as
	// `discount_percent` of FixedDiscount and FloatingDiscount. If your contract
	// does NOT have the feature LIST_PRICE_AS_CEILING enabled, the
	// effective_discount_percent can be negative if the SKU has a FixedDiscount
	// and the current list price is lower than the list price on the date of the
	// contract agreement. See the `FixedDiscount.fix_time` on when the discount
	// was set. If you have questions regarding pricing per SKU, contact your
	// Account team for more details.
	EffectiveDiscountPercent *Decimal `json:"effectiveDiscountPercent,omitempty"`
	// ListPrice: List price of one tier.
	ListPrice *Money `json:"listPrice,omitempty"`
	// StartAmount: Lower bound amount for a tier. Tiers 0-100, 100-200 will be
	// represented with two tiers with `start_amount` 0 and 100.
	StartAmount *Decimal `json:"startAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContractPrice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContractPrice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaRateTier) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaRateTier
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountpricesV1betaUnitInfo: Encapsulates the unit
// information for a Rate
type GoogleCloudBillingBillingaccountpricesV1betaUnitInfo struct {
	// Unit: Shorthand for the unit. Example: GiBy.mo.
	Unit string `json:"unit,omitempty"`
	// UnitDescription: Human-readable description of the unit. Example: gibibyte
	// month.
	UnitDescription string `json:"unitDescription,omitempty"`
	// UnitQuantity: Unit quantity for the tier. Example: if the RateTier price is
	// $1 per 1000000 Bytes, then `unit_quantity` is set to 1000000.
	UnitQuantity *Decimal `json:"unitQuantity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountpricesV1betaUnitInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountpricesV1betaUnitInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountservicesV1betaBillingAccountService:
// Encapsulates a Google Cloud service visible to a billing account.
type GoogleCloudBillingBillingaccountservicesV1betaBillingAccountService struct {
	// DisplayName: Description of the BillingAccountService. Example: "BigQuery",
	// "Compute Engine".
	DisplayName string `json:"displayName,omitempty"`
	// Name: Resource name for the BillingAccountService. Example:
	// "billingAccounts/012345-567890-ABCDEF/services/DA34-426B-A397".
	Name string `json:"name,omitempty"`
	// ServiceId: Identifier for the service. It is the string after the collection
	// identifier "services/". Example: "DA34-426B-A397".
	ServiceId string `json:"serviceId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountservicesV1betaBillingAccountService) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountservicesV1betaBillingAccountService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountservicesV1betaListBillingAccountServicesRespo
// nse: Response message for ListBillingAccountServices.
type GoogleCloudBillingBillingaccountservicesV1betaListBillingAccountServicesResponse struct {
	// BillingAccountServices: The returned billing account services.
	BillingAccountServices []*GoogleCloudBillingBillingaccountservicesV1betaBillingAccountService `json:"billingAccountServices,omitempty"`
	// NextPageToken: Token that can be sent as `page_token` in the subsequent
	// request to retrieve the next page. If this field is empty, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BillingAccountServices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingAccountServices") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountservicesV1betaListBillingAccountServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountservicesV1betaListBillingAccountServicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupsV1betaBillingAccountSkuGroup:
// Encapsulates a stock keeping (SKU) group visible to a billing account. A SKU
// group represents a collection of SKUs that are related to each other. For
// example, the `AI Platform APIs` SKU group includes SKUs from the Cloud
// Dialogflow API, the Cloud Text-to-Speech API, and additional related APIs.
type GoogleCloudBillingBillingaccountskugroupsV1betaBillingAccountSkuGroup struct {
	// DisplayName: Description of the BillingAccountSkuGroup. Example: "A2 VMs (1
	// Year CUD)".
	DisplayName string `json:"displayName,omitempty"`
	// Name: Resource name for the BillingAccountSkuGroup. Example:
	// "billingAccounts/012345-567890-ABCDEF/skuGroups/0e6403d1-4694-44d2-a696-7a78b
	// 1a69301".
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupsV1betaBillingAccountSkuGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupsV1betaBillingAccountSkuGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupsV1betaListBillingAccountSkuGroupsRes
// ponse: Response message for ListBillingAccountSkuGroups.
type GoogleCloudBillingBillingaccountskugroupsV1betaListBillingAccountSkuGroupsResponse struct {
	// BillingAccountSkuGroups: The returned publicly listed billing account SKU
	// groups.
	BillingAccountSkuGroups []*GoogleCloudBillingBillingaccountskugroupsV1betaBillingAccountSkuGroup `json:"billingAccountSkuGroups,omitempty"`
	// NextPageToken: Token that can be sent as `page_token` in the subsequent
	// request to retrieve the next page. If this field is empty, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BillingAccountSkuGroups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingAccountSkuGroups") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupsV1betaListBillingAccountSkuGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupsV1betaListBillingAccountSkuGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupskusV1betaBillingAccountSkuGroupSku:
// Encapsulates a SKU that is part of a billing account SKU group.
type GoogleCloudBillingBillingaccountskugroupskusV1betaBillingAccountSkuGroupSku struct {
	// BillingAccountService: BillingAccountService that the
	// BillingAccountSkuGroupSku belongs to.
	BillingAccountService string `json:"billingAccountService,omitempty"`
	// DisplayName: Description of the BillingAccountSkuGroupSku. Example: "A2
	// Instance Core running in Hong Kong".
	DisplayName string `json:"displayName,omitempty"`
	// GeoTaxonomy: Geographic metadata that applies to the
	// BillingAccountSkuGroupSku.
	GeoTaxonomy *GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomy `json:"geoTaxonomy,omitempty"`
	// Name: Resource name for the BillingAccountSkuGroupSku. Example:
	// "billingAccounts/012345-567890-ABCDEF/skuGroups/0e6403d1-4694-44d2-a696-7a78b
	// 1a69301/skus/AA95-CD31-42FE".
	Name string `json:"name,omitempty"`
	// ProductTaxonomy: List of product categories that apply to the
	// BillingAccountSkuGroupSku.
	ProductTaxonomy *GoogleCloudBillingBillingaccountskugroupskusV1betaProductTaxonomy `json:"productTaxonomy,omitempty"`
	// SkuId: Unique identifier for the SKU. It is the string after the collection
	// identifier "skus/" Example: "AA95-CD31-42FE".
	SkuId string `json:"skuId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BillingAccountService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingAccountService") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupskusV1betaBillingAccountSkuGroupSku) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupskusV1betaBillingAccountSkuGroupSku
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomy: Encapsulates
// geographic metadata, such as regions and multi-regions like `us-east4` or
// `European Union`.
type GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomy struct {
	// GlobalMetadata: Global geographic metadata with no regions.
	GlobalMetadata *GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyGlobal `json:"globalMetadata,omitempty"`
	// MultiRegionalMetadata: Multi-regional geographic metadata with 2 or more
	// regions.
	MultiRegionalMetadata *GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyMultiRegional `json:"multiRegionalMetadata,omitempty"`
	// RegionalMetadata: Regional geographic metadata with 1 region.
	RegionalMetadata *GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegional `json:"regionalMetadata,omitempty"`
	// Type: Type of geographic taxonomy associated with the billing account SKU
	// group SKU.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. Unspecified type.
	//   "TYPE_GLOBAL" - Global geographic taxonomy with no regions.
	//   "TYPE_REGIONAL" - Regional geographic taxonomy with 1 region.
	//   "TYPE_MULTI_REGIONAL" - Multi-regional geographic taxonomy with 2 or more
	// regions.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GlobalMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlobalMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyGlobal:
// Encapsulates a global geographic taxonomy.
type GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyGlobal struct {
}

// GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyMultiRegional:
// Encapsulates a multi-regional geographic taxonomy.
type GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyMultiRegional struct {
	// Regions: Google Cloud regions associated with the multi-regional geographic
	// taxonomy.
	Regions []*GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegion `json:"regions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Regions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Regions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyMultiRegional) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyMultiRegional
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegion:
// Encapsulates a Google Cloud region.
type GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegion struct {
	// Region: Description of a Google Cloud region. Example: "us-west2".
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Region") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Region") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegional:
// Encapsulates a regional geographic taxonomy.
type GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegional struct {
	// Region: Google Cloud region associated with the regional geographic
	// taxonomy.
	Region *GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegion `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Region") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Region") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegional) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupskusV1betaGeoTaxonomyRegional
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupskusV1betaListBillingAccountSkuGroupS
// kusResponse: Response message for ListBillingAccountSkuGroupSkus.
type GoogleCloudBillingBillingaccountskugroupskusV1betaListBillingAccountSkuGroupSkusResponse struct {
	// BillingAccountSkuGroupSkus: The returned billing account SKU group SKUs.
	BillingAccountSkuGroupSkus []*GoogleCloudBillingBillingaccountskugroupskusV1betaBillingAccountSkuGroupSku `json:"billingAccountSkuGroupSkus,omitempty"`
	// NextPageToken: Token that can be sent as `page_token` in the subsequent
	// request to retrieve the next page. If this field is empty, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BillingAccountSkuGroupSkus")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingAccountSkuGroupSkus") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupskusV1betaListBillingAccountSkuGroupSkusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupskusV1betaListBillingAccountSkuGroupSkusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupskusV1betaProductTaxonomy:
// Encapsulates product categories, such as `Serverless`, `Cloud Run`,
// `TaskQueue`, and others.
type GoogleCloudBillingBillingaccountskugroupskusV1betaProductTaxonomy struct {
	// TaxonomyCategories: All product categories that the billing account SKU
	// group SKU belong to.
	TaxonomyCategories []*GoogleCloudBillingBillingaccountskugroupskusV1betaTaxonomyCategory `json:"taxonomyCategories,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TaxonomyCategories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TaxonomyCategories") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupskusV1betaProductTaxonomy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupskusV1betaProductTaxonomy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskugroupskusV1betaTaxonomyCategory:
// Encapsulates a product category.
type GoogleCloudBillingBillingaccountskugroupskusV1betaTaxonomyCategory struct {
	// Category: Name of the product category.
	Category string `json:"category,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskugroupskusV1betaTaxonomyCategory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskugroupskusV1betaTaxonomyCategory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskusV1betaBillingAccountSku: Encapsulates a
// stock keeping unit (SKU) visible to a billing account. A SKU distinctly
// identifies a resource that you can purchase. For a list of available SKUs,
// see SKUs (https://cloud.google.com/skus).
type GoogleCloudBillingBillingaccountskusV1betaBillingAccountSku struct {
	// BillingAccountService: BillingAccountService that the BillingAccountSku
	// belongs to.
	BillingAccountService string `json:"billingAccountService,omitempty"`
	// DisplayName: Description of the BillingAccountSku. Example: "A2 Instance
	// Core running in Hong Kong".
	DisplayName string `json:"displayName,omitempty"`
	// GeoTaxonomy: Geographic metadata that applies to the BillingAccountSku.
	GeoTaxonomy *GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomy `json:"geoTaxonomy,omitempty"`
	// Name: Resource name for the BillingAccountSku. Example:
	// "billingAccounts/012345-567890-ABCDEF/skus/AA95-CD31-42FE".
	Name string `json:"name,omitempty"`
	// ProductTaxonomy: List of product categories that apply to the
	// BillingAccountSku.
	ProductTaxonomy *GoogleCloudBillingBillingaccountskusV1betaProductTaxonomy `json:"productTaxonomy,omitempty"`
	// SkuId: Unique identifier for the SKU. It is the string after the collection
	// identifier "skus/" Example: "AA95-CD31-42FE".
	SkuId string `json:"skuId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BillingAccountService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingAccountService") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskusV1betaBillingAccountSku) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskusV1betaBillingAccountSku
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomy: Encapsulates
// geographic metadata, such as regions and multi-regions like `us-east4` or
// `European Union`.
type GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomy struct {
	// GlobalMetadata: Global geographic metadata with no regions.
	GlobalMetadata *GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyGlobal `json:"globalMetadata,omitempty"`
	// MultiRegionalMetadata: Multi-regional geographic metadata with 2 or more
	// regions.
	MultiRegionalMetadata *GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyMultiRegional `json:"multiRegionalMetadata,omitempty"`
	// RegionalMetadata: Regional geographic metadata with 1 region.
	RegionalMetadata *GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegional `json:"regionalMetadata,omitempty"`
	// Type: Type of geographic taxonomy associated with the billing account SKU.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. Unspecified type.
	//   "TYPE_GLOBAL" - Global geographic taxonomy with no regions.
	//   "TYPE_REGIONAL" - Regional geographic taxonomy with 1 region.
	//   "TYPE_MULTI_REGIONAL" - Multi-regional geographic taxonomy with 2 or more
	// regions.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GlobalMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlobalMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyGlobal: Encapsulates a
// global geographic taxonomy.
type GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyGlobal struct {
}

// GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyMultiRegional:
// Encapsulates a multi-regional geographic taxonomy.
type GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyMultiRegional struct {
	// Regions: Google Cloud regions associated with the multi-regional geographic
	// taxonomy.
	Regions []*GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegion `json:"regions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Regions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Regions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyMultiRegional) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyMultiRegional
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegion: Encapsulates a
// Google Cloud region.
type GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegion struct {
	// Region: Description of a Google Cloud region. Example: "us-west2".
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Region") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Region") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegional: Encapsulates
// a regional geographic taxonomy.
type GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegional struct {
	// Region: Google Cloud region associated with the regional geographic
	// taxonomy.
	Region *GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegion `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Region") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Region") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegional) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskusV1betaGeoTaxonomyRegional
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskusV1betaListBillingAccountSkusResponse:
// Response message for ListBillingAccountSkus.
type GoogleCloudBillingBillingaccountskusV1betaListBillingAccountSkusResponse struct {
	// BillingAccountSkus: The returned billing account SKUs.
	BillingAccountSkus []*GoogleCloudBillingBillingaccountskusV1betaBillingAccountSku `json:"billingAccountSkus,omitempty"`
	// NextPageToken: Token that can be sent as `page_token` in the subsequent
	// request to retrieve the next page. If this field is empty, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BillingAccountSkus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BillingAccountSkus") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskusV1betaListBillingAccountSkusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskusV1betaListBillingAccountSkusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskusV1betaProductTaxonomy: Encapsulates
// product categories, such as `Serverless`, `Cloud Run`, `TaskQueue`, and
// others.
type GoogleCloudBillingBillingaccountskusV1betaProductTaxonomy struct {
	// TaxonomyCategories: All product categories that the billing account SKU
	// belong to.
	TaxonomyCategories []*GoogleCloudBillingBillingaccountskusV1betaTaxonomyCategory `json:"taxonomyCategories,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TaxonomyCategories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TaxonomyCategories") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskusV1betaProductTaxonomy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskusV1betaProductTaxonomy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingBillingaccountskusV1betaTaxonomyCategory: Encapsulates a
// product category.
type GoogleCloudBillingBillingaccountskusV1betaTaxonomyCategory struct {
	// Category: Name of the product category.
	Category string `json:"category,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingBillingaccountskusV1betaTaxonomyCategory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingBillingaccountskusV1betaTaxonomyCategory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingPricesV1betaAggregationInfo: Encapsulates the aggregation
// information such as aggregation level and interval for a price.
type GoogleCloudBillingPricesV1betaAggregationInfo struct {
	// Interval: Interval at which usage is aggregated to compute cost. Example:
	// "MONTHLY" interval indicates that usage is aggregated every month.
	//
	// Possible values:
	//   "INTERVAL_UNSPECIFIED" - Default unspecified value.
	//   "INTERVAL_MONTHLY" - Usage is aggregated every month.
	//   "INTERVAL_DAILY" - Usage is aggregated every day.
	Interval string `json:"interval,omitempty"`
	// Level: Level at which usage is aggregated to compute cost. Example:
	// "ACCOUNT" level indicates that usage is aggregated across all projects in a
	// single account.
	//
	// Possible values:
	//   "LEVEL_UNSPECIFIED" - Default unspecified value.
	//   "LEVEL_ACCOUNT" - Usage is aggregated at an account level.
	//   "LEVEL_PROJECT" - Usage is aggregated at a project level.
	Level string `json:"level,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Interval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Interval") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingPricesV1betaAggregationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingPricesV1betaAggregationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingPricesV1betaListPricesResponse: Response message for
// ListPrices.
type GoogleCloudBillingPricesV1betaListPricesResponse struct {
	// NextPageToken: Token that can be sent as `page_token` in the subsequent
	// request to retrieve the next page. If this field is empty, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Prices: The returned publicly listed prices.
	Prices []*GoogleCloudBillingPricesV1betaPrice `json:"prices,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingPricesV1betaListPricesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingPricesV1betaListPricesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingPricesV1betaPrice: Encapsulates the latest price for a
// SKU.
type GoogleCloudBillingPricesV1betaPrice struct {
	// CurrencyCode: ISO-4217 currency code for the price.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Name: Resource name for the latest price.
	Name string `json:"name,omitempty"`
	// Rate: Rate price metadata. SKUs with `Rate` price are offered by pricing
	// tiers. The price can have 1 or more rate pricing tiers.
	Rate *GoogleCloudBillingPricesV1betaRate `json:"rate,omitempty"`
	// ValueType: Type of the price. It can have values: ["unspecified", "rate"].
	ValueType string `json:"valueType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingPricesV1betaPrice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingPricesV1betaPrice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingPricesV1betaRate: Encapsulates a `Rate` price. SKUs with
// `Rate` price are offered by pricing tiers. The price have 1 or more rate
// pricing tiers.
type GoogleCloudBillingPricesV1betaRate struct {
	// AggregationInfo: Aggregation info for tiers such as aggregation level and
	// interval.
	AggregationInfo *GoogleCloudBillingPricesV1betaAggregationInfo `json:"aggregationInfo,omitempty"`
	// Tiers: All tiers associated with the `Rate` price.
	Tiers []*GoogleCloudBillingPricesV1betaRateTier `json:"tiers,omitempty"`
	// UnitInfo: Unit info such as name and quantity.
	UnitInfo *GoogleCloudBillingPricesV1betaUnitInfo `json:"unitInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregationInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregationInfo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingPricesV1betaRate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingPricesV1betaRate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingPricesV1betaRateTier: Encapsulates a rate price tier.
type GoogleCloudBillingPricesV1betaRateTier struct {
	// ListPrice: List price of one tier.
	ListPrice *Money `json:"listPrice,omitempty"`
	// StartAmount: Lower bound amount for a tier. Tiers 0-100, 100-200 will be
	// represented with two tiers with `start_amount` 0 and 100.
	StartAmount *Decimal `json:"startAmount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ListPrice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ListPrice") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingPricesV1betaRateTier) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingPricesV1betaRateTier
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingPricesV1betaUnitInfo: Encapsulates the unit information
// for a Rate
type GoogleCloudBillingPricesV1betaUnitInfo struct {
	// Unit: Shorthand for the unit. Example: GiBy.mo.
	Unit string `json:"unit,omitempty"`
	// UnitDescription: Human-readable description of the unit. Example: gibibyte
	// month.
	UnitDescription string `json:"unitDescription,omitempty"`
	// UnitQuantity: Unit quantity for the tier. Example: if the RateTier price is
	// $1 per 1000000 Bytes, then `unit_quantity` is set to 1000000.
	UnitQuantity *Decimal `json:"unitQuantity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Unit") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Unit") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingPricesV1betaUnitInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingPricesV1betaUnitInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupsV1betaListSkuGroupsResponse: Response message for
// ListSkuGroups.
type GoogleCloudBillingSkugroupsV1betaListSkuGroupsResponse struct {
	// NextPageToken: Token that can be sent as `page_token` in the subsequent
	// request to retrieve the next page. If this field is empty, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SkuGroups: The returned publicly listed SKU groups.
	SkuGroups []*GoogleCloudBillingSkugroupsV1betaSkuGroup `json:"skuGroups,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupsV1betaListSkuGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupsV1betaListSkuGroupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupsV1betaSkuGroup: Encapsulates a publicly listed
// stock keeping unit (SKU) group. A SKU group represents a collection of SKUs
// that are related to each other. For example, the `AI Platform APIs` SKU
// group includes SKUs from the Cloud Dialogflow API, the Cloud Text-to-Speech
// API, and additional related APIs.
type GoogleCloudBillingSkugroupsV1betaSkuGroup struct {
	// DisplayName: Description of the SKU group. Example: "A2 VMs (1 Year CUD)".
	DisplayName string `json:"displayName,omitempty"`
	// Name: Resource name for the SKU group. Example:
	// "skuGroups/0e6403d1-4694-44d2-a696-7a78b1a69301".
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupsV1betaSkuGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupsV1betaSkuGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupskusV1betaGeoTaxonomy: Encapsulates geographic
// metadata, such as regions and multi-regions like `us-east4` or `European
// Union`.
type GoogleCloudBillingSkugroupskusV1betaGeoTaxonomy struct {
	// GlobalMetadata: Global geographic metadata with no regions.
	GlobalMetadata *GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyGlobal `json:"globalMetadata,omitempty"`
	// MultiRegionalMetadata: Multi-regional geographic metadata with 2 or more
	// regions.
	MultiRegionalMetadata *GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyMultiRegional `json:"multiRegionalMetadata,omitempty"`
	// RegionalMetadata: Regional geographic metadata with 1 region.
	RegionalMetadata *GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegional `json:"regionalMetadata,omitempty"`
	// Type: Type of geographic taxonomy associated with the SKU group SKU.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default value. Unspecified type.
	//   "TYPE_GLOBAL" - Global geographic taxonomy with no regions.
	//   "TYPE_REGIONAL" - Regional geographic taxonomy with 1 region.
	//   "TYPE_MULTI_REGIONAL" - Multi-regional geographic taxonomy with 2 or more
	// regions.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GlobalMetadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GlobalMetadata") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupskusV1betaGeoTaxonomy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupskusV1betaGeoTaxonomy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyGlobal: Encapsulates a global
// geographic taxonomy.
type GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyGlobal struct {
}

// GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyMultiRegional: Encapsulates a
// multi-regional geographic taxonomy.
type GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyMultiRegional struct {
	// Regions: Google Cloud regions associated with the multi-regional geographic
	// taxonomy.
	Regions []*GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegion `json:"regions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Regions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Regions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyMultiRegional) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyMultiRegional
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegion: Encapsulates a Google
// Cloud region.
type GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegion struct {
	// Region: Description of a Google Cloud region. Example: "us-west2".
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Region") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Region") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegional: Encapsulates a
// regional geographic taxonomy.
type GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegional struct {
	// Region: Google Cloud region associated with the regional geographic
	// taxonomy.
	Region *GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegion `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Region") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Region") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegional) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupskusV1betaGeoTaxonomyRegional
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupskusV1betaListSkuGroupSkusResponse: Response
// message for ListSkuGroupSkus.
type GoogleCloudBillingSkugroupskusV1betaListSkuGroupSkusResponse struct {
	// NextPageToken: Token that can be sent as `page_token` in the subsequent
	// request to retrieve the next page. If this field is empty, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SkuGroupSkus: The returned SKU group SKUs.
	SkuGroupSkus []*GoogleCloudBillingSkugroupskusV1betaSkuGroupSku `json:"skuGroupSkus,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupskusV1betaListSkuGroupSkusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupskusV1betaListSkuGroupSkusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupskusV1betaProductTaxonomy: Encapsulates product
// categories, such as `Serverless`, `Cloud Run`, `TaskQueue`, and others.
type GoogleCloudBillingSkugroupskusV1betaProductTaxonomy struct {
	// TaxonomyCategories: All product categories that the SKU group SKU belongs
	// to.
	TaxonomyCategories []*GoogleCloudBillingSkugroupskusV1betaTaxonomyCategory `json:"taxonomyCategories,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TaxonomyCategories") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TaxonomyCategories") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupskusV1betaProductTaxonomy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupskusV1betaProductTaxonomy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupskusV1betaSkuGroupSku: Encapsulates a publicly
// listed stock keeping unit (SKU) that is part of a publicly listed SKU group.
// A SKU group represents a collection of SKUs that are related to each other.
// For example, the `AI Platform APIs` SKU group includes SKUs from the Cloud
// Dialogflow API, the Cloud Text-to-Speech API, and additional related APIs.
type GoogleCloudBillingSkugroupskusV1betaSkuGroupSku struct {
	// DisplayName: Description of the SkuGroupSku. Example: "A2 Instance Core
	// running in Hong Kong".
	DisplayName string `json:"displayName,omitempty"`
	// GeoTaxonomy: Geographic metadata that applies to the SkuGroupSku.
	GeoTaxonomy *GoogleCloudBillingSkugroupskusV1betaGeoTaxonomy `json:"geoTaxonomy,omitempty"`
	// Name: Resource name for the SkuGroupSku. Example:
	// "skuGroups/0e6403d1-4694-44d2-a696-7a78b1a69301/skus/AA95-CD31-42FE".
	Name string `json:"name,omitempty"`
	// ProductTaxonomy: List of product categories that apply to the SkuGroupSku.
	ProductTaxonomy *GoogleCloudBillingSkugroupskusV1betaProductTaxonomy `json:"productTaxonomy,omitempty"`
	// Service: Service that the SkuGroupSku belongs to.
	Service string `json:"service,omitempty"`
	// SkuId: Unique identifier for the SKU. It is the string after the collection
	// identifier "skus/" Example: "AA95-CD31-42FE".
	SkuId string `json:"skuId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupskusV1betaSkuGroupSku) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupskusV1betaSkuGroupSku
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudBillingSkugroupskusV1betaTaxonomyCategory: Encapsulates a product
// category.
type GoogleCloudBillingSkugroupskusV1betaTaxonomyCategory struct {
	// Category: Name of the product category.
	Category string `json:"category,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Category") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Category") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudBillingSkugroupskusV1betaTaxonomyCategory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudBillingSkugroupskusV1betaTaxonomyCategory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Money: Represents an amount of money with its currency type.
type Money struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Nanos: Number of nano (10^-9) units of the amount. The value must be between
	// -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos`
	// must be positive or zero. If `units` is zero, `nanos` can be positive, zero,
	// or negative. If `units` is negative, `nanos` must be negative or zero. For
	// example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`
	// Units: The whole units of the amount. For example if `currencyCode` is
	// "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Money) MarshalJSON() ([]byte, error) {
	type NoMethod Money
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BillingAccountsServicesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a Google Cloud service visible to a billing account.
//
//   - name: The name of the billing account service to retrieve. Format:
//     billingAccounts/{billing_account}/services/{service}.
func (r *BillingAccountsServicesService) Get(name string) *BillingAccountsServicesGetCall {
	c := &BillingAccountsServicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsServicesGetCall) Fields(s ...googleapi.Field) *BillingAccountsServicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsServicesGetCall) IfNoneMatch(entityTag string) *BillingAccountsServicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsServicesGetCall) Context(ctx context.Context) *BillingAccountsServicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsServicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsServicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.services.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.services.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountservicesV1betaBillingAccountService.ServerRe
// sponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsServicesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountservicesV1betaBillingAccountService, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountservicesV1betaBillingAccountService{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.services.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsServicesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists services visible to a billing account.
//
//   - parent: The billing account to list billing account service from. Format:
//     billingAccounts/{billing_account}.
func (r *BillingAccountsServicesService) List(parent string) *BillingAccountsServicesListCall {
	c := &BillingAccountsServicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of billing
// account service to return. Results may return fewer than this value. Default
// value is 50 and maximum value is 5000.
func (c *BillingAccountsServicesListCall) PageSize(pageSize int64) *BillingAccountsServicesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token received from
// a previous ListBillingAccountServices call to retrieve the next page of
// results. If this field is empty, the first page is returned.
func (c *BillingAccountsServicesListCall) PageToken(pageToken string) *BillingAccountsServicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsServicesListCall) Fields(s ...googleapi.Field) *BillingAccountsServicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsServicesListCall) IfNoneMatch(entityTag string) *BillingAccountsServicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsServicesListCall) Context(ctx context.Context) *BillingAccountsServicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsServicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsServicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.services.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.services.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountservicesV1betaListBillingAccountServicesResp
// onse.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsServicesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountservicesV1betaListBillingAccountServicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountservicesV1betaListBillingAccountServicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.services.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsServicesListCall) Pages(ctx context.Context, f func(*GoogleCloudBillingBillingaccountservicesV1betaListBillingAccountServicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsSkuGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a SKU group visible to a billing account.
//
//   - name: The name of the BillingAccountSkuGroup to retrieve. Format:
//     billingAccounts/{billing_account}/skuGroups/{sku_group}.
func (r *BillingAccountsSkuGroupsService) Get(name string) *BillingAccountsSkuGroupsGetCall {
	c := &BillingAccountsSkuGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSkuGroupsGetCall) Fields(s ...googleapi.Field) *BillingAccountsSkuGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSkuGroupsGetCall) IfNoneMatch(entityTag string) *BillingAccountsSkuGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSkuGroupsGetCall) Context(ctx context.Context) *BillingAccountsSkuGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSkuGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSkuGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skuGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.skuGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountskugroupsV1betaBillingAccountSkuGroup.Server
// Response.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSkuGroupsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountskugroupsV1betaBillingAccountSkuGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountskugroupsV1betaBillingAccountSkuGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skuGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsSkuGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists SKU groups visible to a billing account.
//
//   - parent: The billing account to list billing account SKU groups from.
//     Format: billingAccounts/{billing_account}.
func (r *BillingAccountsSkuGroupsService) List(parent string) *BillingAccountsSkuGroupsListCall {
	c := &BillingAccountsSkuGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of billing
// account SKU groups to return. Results may return fewer than this value.
// Default value is 50 and maximum value is 5000.
func (c *BillingAccountsSkuGroupsListCall) PageSize(pageSize int64) *BillingAccountsSkuGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token received from
// a previous ListBillingAccountSkuGroups call to retrieve the next page of
// results. If this field is empty, the first page is returned.
func (c *BillingAccountsSkuGroupsListCall) PageToken(pageToken string) *BillingAccountsSkuGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSkuGroupsListCall) Fields(s ...googleapi.Field) *BillingAccountsSkuGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSkuGroupsListCall) IfNoneMatch(entityTag string) *BillingAccountsSkuGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSkuGroupsListCall) Context(ctx context.Context) *BillingAccountsSkuGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSkuGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSkuGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/skuGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skuGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.skuGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountskugroupsV1betaListBillingAccountSkuGroupsRe
// sponse.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSkuGroupsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountskugroupsV1betaListBillingAccountSkuGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountskugroupsV1betaListBillingAccountSkuGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skuGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsSkuGroupsListCall) Pages(ctx context.Context, f func(*GoogleCloudBillingBillingaccountskugroupsV1betaListBillingAccountSkuGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsSkuGroupsSkusGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a SKU that is part of a billing account SKU group.
//
//   - name: The name of the billing account SKU group SKU to retrieve. Format:
//     billingAccounts/{billing_account}/skuGroups/{sku_group}/skus/{sku}.
func (r *BillingAccountsSkuGroupsSkusService) Get(name string) *BillingAccountsSkuGroupsSkusGetCall {
	c := &BillingAccountsSkuGroupsSkusGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSkuGroupsSkusGetCall) Fields(s ...googleapi.Field) *BillingAccountsSkuGroupsSkusGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSkuGroupsSkusGetCall) IfNoneMatch(entityTag string) *BillingAccountsSkuGroupsSkusGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSkuGroupsSkusGetCall) Context(ctx context.Context) *BillingAccountsSkuGroupsSkusGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSkuGroupsSkusGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSkuGroupsSkusGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skuGroups.skus.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.skuGroups.skus.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountskugroupskusV1betaBillingAccountSkuGroupSku.
// ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSkuGroupsSkusGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountskugroupskusV1betaBillingAccountSkuGroupSku, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountskugroupskusV1betaBillingAccountSkuGroupSku{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skuGroups.skus.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsSkuGroupsSkusListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists SKUs that is part of billing account SKU groups.
//
//   - parent: The billing account SKU group to list billing account SKU group
//     SKUs from. Format: billingAccounts/{billing_account}/skuGroups/{sku_group}.
func (r *BillingAccountsSkuGroupsSkusService) List(parent string) *BillingAccountsSkuGroupsSkusListCall {
	c := &BillingAccountsSkuGroupsSkusListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of billing
// account SKU group SKUs to return. Results may return fewer than this value.
// Default value is 50 and maximum value is 5000.
func (c *BillingAccountsSkuGroupsSkusListCall) PageSize(pageSize int64) *BillingAccountsSkuGroupsSkusListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token received from
// a previous ListBillingAccountSkuGroupSkus call to retrieve the next page of
// results. If this field is empty, the first page is returned.
func (c *BillingAccountsSkuGroupsSkusListCall) PageToken(pageToken string) *BillingAccountsSkuGroupsSkusListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSkuGroupsSkusListCall) Fields(s ...googleapi.Field) *BillingAccountsSkuGroupsSkusListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSkuGroupsSkusListCall) IfNoneMatch(entityTag string) *BillingAccountsSkuGroupsSkusListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSkuGroupsSkusListCall) Context(ctx context.Context) *BillingAccountsSkuGroupsSkusListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSkuGroupsSkusListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSkuGroupsSkusListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/skus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skuGroups.skus.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.skuGroups.skus.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountskugroupskusV1betaListBillingAccountSkuGroup
// SkusResponse.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSkuGroupsSkusListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountskugroupskusV1betaListBillingAccountSkuGroupSkusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountskugroupskusV1betaListBillingAccountSkuGroupSkusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skuGroups.skus.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsSkuGroupsSkusListCall) Pages(ctx context.Context, f func(*GoogleCloudBillingBillingaccountskugroupskusV1betaListBillingAccountSkuGroupSkusResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsSkusGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a SKU visible to a billing account.
//
//   - name: The name of the billing account SKU to retrieve. Format:
//     billingAccounts/{billing_account}/skus/{sku}.
func (r *BillingAccountsSkusService) Get(name string) *BillingAccountsSkusGetCall {
	c := &BillingAccountsSkusGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSkusGetCall) Fields(s ...googleapi.Field) *BillingAccountsSkusGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSkusGetCall) IfNoneMatch(entityTag string) *BillingAccountsSkusGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSkusGetCall) Context(ctx context.Context) *BillingAccountsSkusGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSkusGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSkusGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skus.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.skus.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountskusV1betaBillingAccountSku.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSkusGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountskusV1betaBillingAccountSku, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountskusV1betaBillingAccountSku{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skus.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsSkusListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists SKUs visible to a billing account.
//
//   - parent: The billing account to list billing account SKU from. Format:
//     billingAccounts/{billing_account}.
func (r *BillingAccountsSkusService) List(parent string) *BillingAccountsSkusListCall {
	c := &BillingAccountsSkusListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Options for how to filter the
// billing account SKUs. Currently, only filter on `billing_account_service` is
// supported. Only !=, = operators are supported. Examples: -
// billing_account_service =
// "billingAccounts/012345-567890-ABCDEF/services/DA34-426B-A397"
func (c *BillingAccountsSkusListCall) Filter(filter string) *BillingAccountsSkusListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of billing
// account SKUs to return. Results may return fewer than this value. Default
// value is 50 and maximum value is 5000.
func (c *BillingAccountsSkusListCall) PageSize(pageSize int64) *BillingAccountsSkusListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token received from
// a previous ListBillingAccountSkus call to retrieve the next page of results.
// If this field is empty, the first page is returned.
func (c *BillingAccountsSkusListCall) PageToken(pageToken string) *BillingAccountsSkusListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSkusListCall) Fields(s ...googleapi.Field) *BillingAccountsSkusListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSkusListCall) IfNoneMatch(entityTag string) *BillingAccountsSkusListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSkusListCall) Context(ctx context.Context) *BillingAccountsSkusListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSkusListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSkusListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/skus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skus.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.skus.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountskusV1betaListBillingAccountSkusResponse.Ser
// verResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSkusListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountskusV1betaListBillingAccountSkusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountskusV1betaListBillingAccountSkusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skus.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsSkusListCall) Pages(ctx context.Context, f func(*GoogleCloudBillingBillingaccountskusV1betaListBillingAccountSkusResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsSkusPriceGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest price for SKUs available to your Cloud Billing account.
//
//   - name: Name of the billing account price to retrieve. Format:
//     billingAccounts/{billing_account}/skus/{sku}/price.
func (r *BillingAccountsSkusPriceService) Get(name string) *BillingAccountsSkusPriceGetCall {
	c := &BillingAccountsSkusPriceGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// CurrencyCode sets the optional parameter "currencyCode": ISO-4217 currency
// code for the price. If not specified, the currency of the billing account is
// used.
func (c *BillingAccountsSkusPriceGetCall) CurrencyCode(currencyCode string) *BillingAccountsSkusPriceGetCall {
	c.urlParams_.Set("currencyCode", currencyCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSkusPriceGetCall) Fields(s ...googleapi.Field) *BillingAccountsSkusPriceGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSkusPriceGetCall) IfNoneMatch(entityTag string) *BillingAccountsSkusPriceGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSkusPriceGetCall) Context(ctx context.Context) *BillingAccountsSkusPriceGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSkusPriceGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSkusPriceGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skus.price.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.skus.price.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountpricesV1betaBillingAccountPrice.ServerRespon
// se.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSkusPriceGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountpricesV1betaBillingAccountPrice, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountpricesV1betaBillingAccountPrice{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skus.price.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsSkusPricesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the latest prices for SKUs available to your Cloud Billing
// account.
//
//   - parent: To list all Billing Account SKUs, use `-` as the SKU ID. Format:
//     `billingAccounts/{billing_account}/skus/-` Note: Specifying an actual SKU
//     resource id will return a collection of one Billing Account Price.
func (r *BillingAccountsSkusPricesService) List(parent string) *BillingAccountsSkusPricesListCall {
	c := &BillingAccountsSkusPricesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// CurrencyCode sets the optional parameter "currencyCode": ISO-4217 currency
// code for the price. If not specified, currency of billing account will be
// used.
func (c *BillingAccountsSkusPricesListCall) CurrencyCode(currencyCode string) *BillingAccountsSkusPricesListCall {
	c.urlParams_.Set("currencyCode", currencyCode)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of billing
// account price to return. Results may return fewer than this value. Default
// value is 50 and maximum value is 5000.
func (c *BillingAccountsSkusPricesListCall) PageSize(pageSize int64) *BillingAccountsSkusPricesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token received from
// a previous ListBillingAccountPrices call to retrieve the next page of
// results. If this field is empty, the first page is returned.
func (c *BillingAccountsSkusPricesListCall) PageToken(pageToken string) *BillingAccountsSkusPricesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSkusPricesListCall) Fields(s ...googleapi.Field) *BillingAccountsSkusPricesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSkusPricesListCall) IfNoneMatch(entityTag string) *BillingAccountsSkusPricesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSkusPricesListCall) Context(ctx context.Context) *BillingAccountsSkusPricesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSkusPricesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSkusPricesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/prices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skus.prices.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.billingAccounts.skus.prices.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingBillingaccountpricesV1betaListBillingAccountPricesResponse
// .ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSkusPricesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingBillingaccountpricesV1betaListBillingAccountPricesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingBillingaccountpricesV1betaListBillingAccountPricesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.billingAccounts.skus.prices.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsSkusPricesListCall) Pages(ctx context.Context, f func(*GoogleCloudBillingBillingaccountpricesV1betaListBillingAccountPricesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type SkuGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a publicly listed SKU group.
//
// - name: The name of the SKU group to retrieve. Format: skuGroups/{sku_group}.
func (r *SkuGroupsService) Get(name string) *SkuGroupsGetCall {
	c := &SkuGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SkuGroupsGetCall) Fields(s ...googleapi.Field) *SkuGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SkuGroupsGetCall) IfNoneMatch(entityTag string) *SkuGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SkuGroupsGetCall) Context(ctx context.Context) *SkuGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SkuGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SkuGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.skuGroups.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.skuGroups.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingSkugroupsV1betaSkuGroup.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *SkuGroupsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingSkugroupsV1betaSkuGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingSkugroupsV1betaSkuGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.skuGroups.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SkuGroupsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all publicly listed SKU groups.
func (r *SkuGroupsService) List() *SkuGroupsListCall {
	c := &SkuGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of SKU
// groups to return. Results may return fewer than this value. Default value is
// 50 and maximum value is 5000.
func (c *SkuGroupsListCall) PageSize(pageSize int64) *SkuGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token received from
// a previous ListSkuGroups call to retrieve the next page of results. If this
// field is empty, the first page is returned.
func (c *SkuGroupsListCall) PageToken(pageToken string) *SkuGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SkuGroupsListCall) Fields(s ...googleapi.Field) *SkuGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SkuGroupsListCall) IfNoneMatch(entityTag string) *SkuGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SkuGroupsListCall) Context(ctx context.Context) *SkuGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SkuGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SkuGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/skuGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.skuGroups.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.skuGroups.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingSkugroupsV1betaListSkuGroupsResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *SkuGroupsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingSkugroupsV1betaListSkuGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingSkugroupsV1betaListSkuGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.skuGroups.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *SkuGroupsListCall) Pages(ctx context.Context, f func(*GoogleCloudBillingSkugroupsV1betaListSkuGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type SkuGroupsSkusGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a publicly listed SKU that is part of a publicly listed SKU group.
//
//   - name: The name of the SKU group SKU to retrieve. Format:
//     skuGroups/{sku_group}/skus/{sku}.
func (r *SkuGroupsSkusService) Get(name string) *SkuGroupsSkusGetCall {
	c := &SkuGroupsSkusGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SkuGroupsSkusGetCall) Fields(s ...googleapi.Field) *SkuGroupsSkusGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SkuGroupsSkusGetCall) IfNoneMatch(entityTag string) *SkuGroupsSkusGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SkuGroupsSkusGetCall) Context(ctx context.Context) *SkuGroupsSkusGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SkuGroupsSkusGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SkuGroupsSkusGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.skuGroups.skus.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.skuGroups.skus.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingSkugroupskusV1betaSkuGroupSku.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *SkuGroupsSkusGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingSkugroupskusV1betaSkuGroupSku, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingSkugroupskusV1betaSkuGroupSku{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.skuGroups.skus.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SkuGroupsSkusListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all publicly listed SKUs contained by a publicly listed SKU
// group.
//
//   - parent: The SkuGroup to list SkuGroupSku from. Format:
//     skuGroups/{sku_group}.
func (r *SkuGroupsSkusService) List(parent string) *SkuGroupsSkusListCall {
	c := &SkuGroupsSkusListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of SKU group
// SKUs to return. Results may return fewer than this value. Default value is
// 50 and maximum value is 5000.
func (c *SkuGroupsSkusListCall) PageSize(pageSize int64) *SkuGroupsSkusListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token received from
// a previous ListSkuGroupSkus call to retrieve the next page of results. If
// this field is empty, the first page is returned.
func (c *SkuGroupsSkusListCall) PageToken(pageToken string) *SkuGroupsSkusListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SkuGroupsSkusListCall) Fields(s ...googleapi.Field) *SkuGroupsSkusListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SkuGroupsSkusListCall) IfNoneMatch(entityTag string) *SkuGroupsSkusListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SkuGroupsSkusListCall) Context(ctx context.Context) *SkuGroupsSkusListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SkuGroupsSkusListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SkuGroupsSkusListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/skus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.skuGroups.skus.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.skuGroups.skus.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingSkugroupskusV1betaListSkuGroupSkusResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SkuGroupsSkusListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingSkugroupskusV1betaListSkuGroupSkusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingSkugroupskusV1betaListSkuGroupSkusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.skuGroups.skus.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *SkuGroupsSkusListCall) Pages(ctx context.Context, f func(*GoogleCloudBillingSkugroupskusV1betaListSkuGroupSkusResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type SkusPriceGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest price for the given SKU.
//
// - name: Name of the latest price to retrieve. Format: skus/{sku}/price.
func (r *SkusPriceService) Get(name string) *SkusPriceGetCall {
	c := &SkusPriceGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// CurrencyCode sets the optional parameter "currencyCode": ISO-4217 currency
// code for the price. If not specified, USD will be used.
func (c *SkusPriceGetCall) CurrencyCode(currencyCode string) *SkusPriceGetCall {
	c.urlParams_.Set("currencyCode", currencyCode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SkusPriceGetCall) Fields(s ...googleapi.Field) *SkusPriceGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SkusPriceGetCall) IfNoneMatch(entityTag string) *SkusPriceGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SkusPriceGetCall) Context(ctx context.Context) *SkusPriceGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SkusPriceGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SkusPriceGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.skus.price.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.skus.price.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingPricesV1betaPrice.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *SkusPriceGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingPricesV1betaPrice, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingPricesV1betaPrice{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.skus.price.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SkusPricesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the latest prices for all SKUs.
//
//   - parent: To list the prices for all SKUs, use `-` as the SKU ID. Format:
//     `skus/-` Specifying a specific SKU ID returns a collection with one Price
//     object for the SKU.
func (r *SkusPricesService) List(parent string) *SkusPricesListCall {
	c := &SkusPricesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// CurrencyCode sets the optional parameter "currencyCode": ISO-4217 currency
// code for the price. If not specified, USD will be used.
func (c *SkusPricesListCall) CurrencyCode(currencyCode string) *SkusPricesListCall {
	c.urlParams_.Set("currencyCode", currencyCode)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of prices to
// return. Results may return fewer than this value. Default value is 50 and
// maximum value is 5000.
func (c *SkusPricesListCall) PageSize(pageSize int64) *SkusPricesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token received from
// a previous ListPrices call to retrieve the next page of results. If this
// field is empty, the first page is returned.
func (c *SkusPricesListCall) PageToken(pageToken string) *SkusPricesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SkusPricesListCall) Fields(s ...googleapi.Field) *SkusPricesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SkusPricesListCall) IfNoneMatch(entityTag string) *SkusPricesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SkusPricesListCall) Context(ctx context.Context) *SkusPricesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SkusPricesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SkusPricesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta/{+parent}/prices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "cloudbilling.skus.prices.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudbilling.skus.prices.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudBillingPricesV1betaListPricesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *SkusPricesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudBillingPricesV1betaListPricesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudBillingPricesV1betaListPricesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "cloudbilling.skus.prices.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *SkusPricesListCall) Pages(ctx context.Context, f func(*GoogleCloudBillingPricesV1betaListPricesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
