// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package logging provides access to the Cloud Logging API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/logging instead.
//
// For product documentation, see: https://cloud.google.com/logging/docs/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/logging/v2"
//	...
//	ctx := context.Background()
//	loggingService, err := logging.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	loggingService, err := logging.NewService(ctx, option.WithScopes(logging.LoggingWriteScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	loggingService, err := logging.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	loggingService, err := logging.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package logging // import "google.golang.org/api/logging/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "logging:v2"
const apiName = "logging"
const apiVersion = "v2"
const basePath = "https://logging.googleapis.com/"
const basePathTemplate = "https://logging.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://logging.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// View your data across Google Cloud services and see the email address of
	// your Google Account
	CloudPlatformReadOnlyScope = "https://www.googleapis.com/auth/cloud-platform.read-only"

	// Administrate log data for your projects
	LoggingAdminScope = "https://www.googleapis.com/auth/logging.admin"

	// View log data for your projects
	LoggingReadScope = "https://www.googleapis.com/auth/logging.read"

	// Submit log data for your projects
	LoggingWriteScope = "https://www.googleapis.com/auth/logging.write"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/cloud-platform.read-only",
		"https://www.googleapis.com/auth/logging.admin",
		"https://www.googleapis.com/auth/logging.read",
		"https://www.googleapis.com/auth/logging.write",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.BillingAccounts = NewBillingAccountsService(s)
	s.Entries = NewEntriesService(s)
	s.Exclusions = NewExclusionsService(s)
	s.Folders = NewFoldersService(s)
	s.Locations = NewLocationsService(s)
	s.Logs = NewLogsService(s)
	s.MonitoredResourceDescriptors = NewMonitoredResourceDescriptorsService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	s.Sinks = NewSinksService(s)
	s.V2 = NewV2Service(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	BillingAccounts *BillingAccountsService

	Entries *EntriesService

	Exclusions *ExclusionsService

	Folders *FoldersService

	Locations *LocationsService

	Logs *LogsService

	MonitoredResourceDescriptors *MonitoredResourceDescriptorsService

	Organizations *OrganizationsService

	Projects *ProjectsService

	Sinks *SinksService

	V2 *V2Service
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewBillingAccountsService(s *Service) *BillingAccountsService {
	rs := &BillingAccountsService{s: s}
	rs.Exclusions = NewBillingAccountsExclusionsService(s)
	rs.Locations = NewBillingAccountsLocationsService(s)
	rs.Logs = NewBillingAccountsLogsService(s)
	rs.Sinks = NewBillingAccountsSinksService(s)
	return rs
}

type BillingAccountsService struct {
	s *Service

	Exclusions *BillingAccountsExclusionsService

	Locations *BillingAccountsLocationsService

	Logs *BillingAccountsLogsService

	Sinks *BillingAccountsSinksService
}

func NewBillingAccountsExclusionsService(s *Service) *BillingAccountsExclusionsService {
	rs := &BillingAccountsExclusionsService{s: s}
	return rs
}

type BillingAccountsExclusionsService struct {
	s *Service
}

func NewBillingAccountsLocationsService(s *Service) *BillingAccountsLocationsService {
	rs := &BillingAccountsLocationsService{s: s}
	rs.Buckets = NewBillingAccountsLocationsBucketsService(s)
	rs.Operations = NewBillingAccountsLocationsOperationsService(s)
	rs.RecentQueries = NewBillingAccountsLocationsRecentQueriesService(s)
	rs.SavedQueries = NewBillingAccountsLocationsSavedQueriesService(s)
	return rs
}

type BillingAccountsLocationsService struct {
	s *Service

	Buckets *BillingAccountsLocationsBucketsService

	Operations *BillingAccountsLocationsOperationsService

	RecentQueries *BillingAccountsLocationsRecentQueriesService

	SavedQueries *BillingAccountsLocationsSavedQueriesService
}

func NewBillingAccountsLocationsBucketsService(s *Service) *BillingAccountsLocationsBucketsService {
	rs := &BillingAccountsLocationsBucketsService{s: s}
	rs.Links = NewBillingAccountsLocationsBucketsLinksService(s)
	rs.Views = NewBillingAccountsLocationsBucketsViewsService(s)
	return rs
}

type BillingAccountsLocationsBucketsService struct {
	s *Service

	Links *BillingAccountsLocationsBucketsLinksService

	Views *BillingAccountsLocationsBucketsViewsService
}

func NewBillingAccountsLocationsBucketsLinksService(s *Service) *BillingAccountsLocationsBucketsLinksService {
	rs := &BillingAccountsLocationsBucketsLinksService{s: s}
	return rs
}

type BillingAccountsLocationsBucketsLinksService struct {
	s *Service
}

func NewBillingAccountsLocationsBucketsViewsService(s *Service) *BillingAccountsLocationsBucketsViewsService {
	rs := &BillingAccountsLocationsBucketsViewsService{s: s}
	rs.Logs = NewBillingAccountsLocationsBucketsViewsLogsService(s)
	return rs
}

type BillingAccountsLocationsBucketsViewsService struct {
	s *Service

	Logs *BillingAccountsLocationsBucketsViewsLogsService
}

func NewBillingAccountsLocationsBucketsViewsLogsService(s *Service) *BillingAccountsLocationsBucketsViewsLogsService {
	rs := &BillingAccountsLocationsBucketsViewsLogsService{s: s}
	return rs
}

type BillingAccountsLocationsBucketsViewsLogsService struct {
	s *Service
}

func NewBillingAccountsLocationsOperationsService(s *Service) *BillingAccountsLocationsOperationsService {
	rs := &BillingAccountsLocationsOperationsService{s: s}
	return rs
}

type BillingAccountsLocationsOperationsService struct {
	s *Service
}

func NewBillingAccountsLocationsRecentQueriesService(s *Service) *BillingAccountsLocationsRecentQueriesService {
	rs := &BillingAccountsLocationsRecentQueriesService{s: s}
	return rs
}

type BillingAccountsLocationsRecentQueriesService struct {
	s *Service
}

func NewBillingAccountsLocationsSavedQueriesService(s *Service) *BillingAccountsLocationsSavedQueriesService {
	rs := &BillingAccountsLocationsSavedQueriesService{s: s}
	return rs
}

type BillingAccountsLocationsSavedQueriesService struct {
	s *Service
}

func NewBillingAccountsLogsService(s *Service) *BillingAccountsLogsService {
	rs := &BillingAccountsLogsService{s: s}
	return rs
}

type BillingAccountsLogsService struct {
	s *Service
}

func NewBillingAccountsSinksService(s *Service) *BillingAccountsSinksService {
	rs := &BillingAccountsSinksService{s: s}
	return rs
}

type BillingAccountsSinksService struct {
	s *Service
}

func NewEntriesService(s *Service) *EntriesService {
	rs := &EntriesService{s: s}
	return rs
}

type EntriesService struct {
	s *Service
}

func NewExclusionsService(s *Service) *ExclusionsService {
	rs := &ExclusionsService{s: s}
	return rs
}

type ExclusionsService struct {
	s *Service
}

func NewFoldersService(s *Service) *FoldersService {
	rs := &FoldersService{s: s}
	rs.Exclusions = NewFoldersExclusionsService(s)
	rs.Locations = NewFoldersLocationsService(s)
	rs.Logs = NewFoldersLogsService(s)
	rs.Sinks = NewFoldersSinksService(s)
	return rs
}

type FoldersService struct {
	s *Service

	Exclusions *FoldersExclusionsService

	Locations *FoldersLocationsService

	Logs *FoldersLogsService

	Sinks *FoldersSinksService
}

func NewFoldersExclusionsService(s *Service) *FoldersExclusionsService {
	rs := &FoldersExclusionsService{s: s}
	return rs
}

type FoldersExclusionsService struct {
	s *Service
}

func NewFoldersLocationsService(s *Service) *FoldersLocationsService {
	rs := &FoldersLocationsService{s: s}
	rs.Buckets = NewFoldersLocationsBucketsService(s)
	rs.LogScopes = NewFoldersLocationsLogScopesService(s)
	rs.Operations = NewFoldersLocationsOperationsService(s)
	rs.RecentQueries = NewFoldersLocationsRecentQueriesService(s)
	rs.SavedQueries = NewFoldersLocationsSavedQueriesService(s)
	return rs
}

type FoldersLocationsService struct {
	s *Service

	Buckets *FoldersLocationsBucketsService

	LogScopes *FoldersLocationsLogScopesService

	Operations *FoldersLocationsOperationsService

	RecentQueries *FoldersLocationsRecentQueriesService

	SavedQueries *FoldersLocationsSavedQueriesService
}

func NewFoldersLocationsBucketsService(s *Service) *FoldersLocationsBucketsService {
	rs := &FoldersLocationsBucketsService{s: s}
	rs.Links = NewFoldersLocationsBucketsLinksService(s)
	rs.Views = NewFoldersLocationsBucketsViewsService(s)
	return rs
}

type FoldersLocationsBucketsService struct {
	s *Service

	Links *FoldersLocationsBucketsLinksService

	Views *FoldersLocationsBucketsViewsService
}

func NewFoldersLocationsBucketsLinksService(s *Service) *FoldersLocationsBucketsLinksService {
	rs := &FoldersLocationsBucketsLinksService{s: s}
	return rs
}

type FoldersLocationsBucketsLinksService struct {
	s *Service
}

func NewFoldersLocationsBucketsViewsService(s *Service) *FoldersLocationsBucketsViewsService {
	rs := &FoldersLocationsBucketsViewsService{s: s}
	rs.Logs = NewFoldersLocationsBucketsViewsLogsService(s)
	return rs
}

type FoldersLocationsBucketsViewsService struct {
	s *Service

	Logs *FoldersLocationsBucketsViewsLogsService
}

func NewFoldersLocationsBucketsViewsLogsService(s *Service) *FoldersLocationsBucketsViewsLogsService {
	rs := &FoldersLocationsBucketsViewsLogsService{s: s}
	return rs
}

type FoldersLocationsBucketsViewsLogsService struct {
	s *Service
}

func NewFoldersLocationsLogScopesService(s *Service) *FoldersLocationsLogScopesService {
	rs := &FoldersLocationsLogScopesService{s: s}
	return rs
}

type FoldersLocationsLogScopesService struct {
	s *Service
}

func NewFoldersLocationsOperationsService(s *Service) *FoldersLocationsOperationsService {
	rs := &FoldersLocationsOperationsService{s: s}
	return rs
}

type FoldersLocationsOperationsService struct {
	s *Service
}

func NewFoldersLocationsRecentQueriesService(s *Service) *FoldersLocationsRecentQueriesService {
	rs := &FoldersLocationsRecentQueriesService{s: s}
	return rs
}

type FoldersLocationsRecentQueriesService struct {
	s *Service
}

func NewFoldersLocationsSavedQueriesService(s *Service) *FoldersLocationsSavedQueriesService {
	rs := &FoldersLocationsSavedQueriesService{s: s}
	return rs
}

type FoldersLocationsSavedQueriesService struct {
	s *Service
}

func NewFoldersLogsService(s *Service) *FoldersLogsService {
	rs := &FoldersLogsService{s: s}
	return rs
}

type FoldersLogsService struct {
	s *Service
}

func NewFoldersSinksService(s *Service) *FoldersSinksService {
	rs := &FoldersSinksService{s: s}
	return rs
}

type FoldersSinksService struct {
	s *Service
}

func NewLocationsService(s *Service) *LocationsService {
	rs := &LocationsService{s: s}
	rs.Buckets = NewLocationsBucketsService(s)
	rs.Operations = NewLocationsOperationsService(s)
	return rs
}

type LocationsService struct {
	s *Service

	Buckets *LocationsBucketsService

	Operations *LocationsOperationsService
}

func NewLocationsBucketsService(s *Service) *LocationsBucketsService {
	rs := &LocationsBucketsService{s: s}
	rs.Links = NewLocationsBucketsLinksService(s)
	rs.Views = NewLocationsBucketsViewsService(s)
	return rs
}

type LocationsBucketsService struct {
	s *Service

	Links *LocationsBucketsLinksService

	Views *LocationsBucketsViewsService
}

func NewLocationsBucketsLinksService(s *Service) *LocationsBucketsLinksService {
	rs := &LocationsBucketsLinksService{s: s}
	return rs
}

type LocationsBucketsLinksService struct {
	s *Service
}

func NewLocationsBucketsViewsService(s *Service) *LocationsBucketsViewsService {
	rs := &LocationsBucketsViewsService{s: s}
	return rs
}

type LocationsBucketsViewsService struct {
	s *Service
}

func NewLocationsOperationsService(s *Service) *LocationsOperationsService {
	rs := &LocationsOperationsService{s: s}
	return rs
}

type LocationsOperationsService struct {
	s *Service
}

func NewLogsService(s *Service) *LogsService {
	rs := &LogsService{s: s}
	return rs
}

type LogsService struct {
	s *Service
}

func NewMonitoredResourceDescriptorsService(s *Service) *MonitoredResourceDescriptorsService {
	rs := &MonitoredResourceDescriptorsService{s: s}
	return rs
}

type MonitoredResourceDescriptorsService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Exclusions = NewOrganizationsExclusionsService(s)
	rs.Locations = NewOrganizationsLocationsService(s)
	rs.Logs = NewOrganizationsLogsService(s)
	rs.Sinks = NewOrganizationsSinksService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Exclusions *OrganizationsExclusionsService

	Locations *OrganizationsLocationsService

	Logs *OrganizationsLogsService

	Sinks *OrganizationsSinksService
}

func NewOrganizationsExclusionsService(s *Service) *OrganizationsExclusionsService {
	rs := &OrganizationsExclusionsService{s: s}
	return rs
}

type OrganizationsExclusionsService struct {
	s *Service
}

func NewOrganizationsLocationsService(s *Service) *OrganizationsLocationsService {
	rs := &OrganizationsLocationsService{s: s}
	rs.Buckets = NewOrganizationsLocationsBucketsService(s)
	rs.LogScopes = NewOrganizationsLocationsLogScopesService(s)
	rs.Operations = NewOrganizationsLocationsOperationsService(s)
	rs.RecentQueries = NewOrganizationsLocationsRecentQueriesService(s)
	rs.SavedQueries = NewOrganizationsLocationsSavedQueriesService(s)
	return rs
}

type OrganizationsLocationsService struct {
	s *Service

	Buckets *OrganizationsLocationsBucketsService

	LogScopes *OrganizationsLocationsLogScopesService

	Operations *OrganizationsLocationsOperationsService

	RecentQueries *OrganizationsLocationsRecentQueriesService

	SavedQueries *OrganizationsLocationsSavedQueriesService
}

func NewOrganizationsLocationsBucketsService(s *Service) *OrganizationsLocationsBucketsService {
	rs := &OrganizationsLocationsBucketsService{s: s}
	rs.Links = NewOrganizationsLocationsBucketsLinksService(s)
	rs.Views = NewOrganizationsLocationsBucketsViewsService(s)
	return rs
}

type OrganizationsLocationsBucketsService struct {
	s *Service

	Links *OrganizationsLocationsBucketsLinksService

	Views *OrganizationsLocationsBucketsViewsService
}

func NewOrganizationsLocationsBucketsLinksService(s *Service) *OrganizationsLocationsBucketsLinksService {
	rs := &OrganizationsLocationsBucketsLinksService{s: s}
	return rs
}

type OrganizationsLocationsBucketsLinksService struct {
	s *Service
}

func NewOrganizationsLocationsBucketsViewsService(s *Service) *OrganizationsLocationsBucketsViewsService {
	rs := &OrganizationsLocationsBucketsViewsService{s: s}
	rs.Logs = NewOrganizationsLocationsBucketsViewsLogsService(s)
	return rs
}

type OrganizationsLocationsBucketsViewsService struct {
	s *Service

	Logs *OrganizationsLocationsBucketsViewsLogsService
}

func NewOrganizationsLocationsBucketsViewsLogsService(s *Service) *OrganizationsLocationsBucketsViewsLogsService {
	rs := &OrganizationsLocationsBucketsViewsLogsService{s: s}
	return rs
}

type OrganizationsLocationsBucketsViewsLogsService struct {
	s *Service
}

func NewOrganizationsLocationsLogScopesService(s *Service) *OrganizationsLocationsLogScopesService {
	rs := &OrganizationsLocationsLogScopesService{s: s}
	return rs
}

type OrganizationsLocationsLogScopesService struct {
	s *Service
}

func NewOrganizationsLocationsOperationsService(s *Service) *OrganizationsLocationsOperationsService {
	rs := &OrganizationsLocationsOperationsService{s: s}
	return rs
}

type OrganizationsLocationsOperationsService struct {
	s *Service
}

func NewOrganizationsLocationsRecentQueriesService(s *Service) *OrganizationsLocationsRecentQueriesService {
	rs := &OrganizationsLocationsRecentQueriesService{s: s}
	return rs
}

type OrganizationsLocationsRecentQueriesService struct {
	s *Service
}

func NewOrganizationsLocationsSavedQueriesService(s *Service) *OrganizationsLocationsSavedQueriesService {
	rs := &OrganizationsLocationsSavedQueriesService{s: s}
	return rs
}

type OrganizationsLocationsSavedQueriesService struct {
	s *Service
}

func NewOrganizationsLogsService(s *Service) *OrganizationsLogsService {
	rs := &OrganizationsLogsService{s: s}
	return rs
}

type OrganizationsLogsService struct {
	s *Service
}

func NewOrganizationsSinksService(s *Service) *OrganizationsSinksService {
	rs := &OrganizationsSinksService{s: s}
	return rs
}

type OrganizationsSinksService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Exclusions = NewProjectsExclusionsService(s)
	rs.Locations = NewProjectsLocationsService(s)
	rs.Logs = NewProjectsLogsService(s)
	rs.Metrics = NewProjectsMetricsService(s)
	rs.Sinks = NewProjectsSinksService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Exclusions *ProjectsExclusionsService

	Locations *ProjectsLocationsService

	Logs *ProjectsLogsService

	Metrics *ProjectsMetricsService

	Sinks *ProjectsSinksService
}

func NewProjectsExclusionsService(s *Service) *ProjectsExclusionsService {
	rs := &ProjectsExclusionsService{s: s}
	return rs
}

type ProjectsExclusionsService struct {
	s *Service
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Buckets = NewProjectsLocationsBucketsService(s)
	rs.LogScopes = NewProjectsLocationsLogScopesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.RecentQueries = NewProjectsLocationsRecentQueriesService(s)
	rs.SavedQueries = NewProjectsLocationsSavedQueriesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Buckets *ProjectsLocationsBucketsService

	LogScopes *ProjectsLocationsLogScopesService

	Operations *ProjectsLocationsOperationsService

	RecentQueries *ProjectsLocationsRecentQueriesService

	SavedQueries *ProjectsLocationsSavedQueriesService
}

func NewProjectsLocationsBucketsService(s *Service) *ProjectsLocationsBucketsService {
	rs := &ProjectsLocationsBucketsService{s: s}
	rs.Links = NewProjectsLocationsBucketsLinksService(s)
	rs.Views = NewProjectsLocationsBucketsViewsService(s)
	return rs
}

type ProjectsLocationsBucketsService struct {
	s *Service

	Links *ProjectsLocationsBucketsLinksService

	Views *ProjectsLocationsBucketsViewsService
}

func NewProjectsLocationsBucketsLinksService(s *Service) *ProjectsLocationsBucketsLinksService {
	rs := &ProjectsLocationsBucketsLinksService{s: s}
	return rs
}

type ProjectsLocationsBucketsLinksService struct {
	s *Service
}

func NewProjectsLocationsBucketsViewsService(s *Service) *ProjectsLocationsBucketsViewsService {
	rs := &ProjectsLocationsBucketsViewsService{s: s}
	rs.Logs = NewProjectsLocationsBucketsViewsLogsService(s)
	return rs
}

type ProjectsLocationsBucketsViewsService struct {
	s *Service

	Logs *ProjectsLocationsBucketsViewsLogsService
}

func NewProjectsLocationsBucketsViewsLogsService(s *Service) *ProjectsLocationsBucketsViewsLogsService {
	rs := &ProjectsLocationsBucketsViewsLogsService{s: s}
	return rs
}

type ProjectsLocationsBucketsViewsLogsService struct {
	s *Service
}

func NewProjectsLocationsLogScopesService(s *Service) *ProjectsLocationsLogScopesService {
	rs := &ProjectsLocationsLogScopesService{s: s}
	return rs
}

type ProjectsLocationsLogScopesService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsRecentQueriesService(s *Service) *ProjectsLocationsRecentQueriesService {
	rs := &ProjectsLocationsRecentQueriesService{s: s}
	return rs
}

type ProjectsLocationsRecentQueriesService struct {
	s *Service
}

func NewProjectsLocationsSavedQueriesService(s *Service) *ProjectsLocationsSavedQueriesService {
	rs := &ProjectsLocationsSavedQueriesService{s: s}
	return rs
}

type ProjectsLocationsSavedQueriesService struct {
	s *Service
}

func NewProjectsLogsService(s *Service) *ProjectsLogsService {
	rs := &ProjectsLogsService{s: s}
	return rs
}

type ProjectsLogsService struct {
	s *Service
}

func NewProjectsMetricsService(s *Service) *ProjectsMetricsService {
	rs := &ProjectsMetricsService{s: s}
	return rs
}

type ProjectsMetricsService struct {
	s *Service
}

func NewProjectsSinksService(s *Service) *ProjectsSinksService {
	rs := &ProjectsSinksService{s: s}
	return rs
}

type ProjectsSinksService struct {
	s *Service
}

func NewSinksService(s *Service) *SinksService {
	rs := &SinksService{s: s}
	return rs
}

type SinksService struct {
	s *Service
}

func NewV2Service(s *Service) *V2Service {
	rs := &V2Service{s: s}
	return rs
}

type V2Service struct {
	s *Service
}

// AppHub: Metadata associated with App Hub.
type AppHub struct {
	// Application: Metadata associated with the application.
	Application *AppHubApplication `json:"application,omitempty"`
	// Service: Metadata associated with the service.
	Service *AppHubService `json:"service,omitempty"`
	// Workload: Metadata associated with the workload.
	Workload *AppHubWorkload `json:"workload,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Application") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Application") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppHub) MarshalJSON() ([]byte, error) {
	type NoMethod AppHub
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppHubApplication: Resource identifiers associated with an AppHub
// application AppHub resources are of the form
// projects//locations//applications/
// projects//locations//applications//services/
// projects//locations//applications//workloads/ These resources can be
// reconstructed from the components below.
type AppHubApplication struct {
	// Container: Resource container that owns the application. Example:
	// "projects/management_project"
	Container string `json:"container,omitempty"`
	// Id: Application Id. Example: "my-app"
	Id string `json:"id,omitempty"`
	// Location: Location associated with the Application. Example: "us-east1"
	Location string `json:"location,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Container") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Container") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppHubApplication) MarshalJSON() ([]byte, error) {
	type NoMethod AppHubApplication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppHubService: Metadata associated with an App Hub service.
type AppHubService struct {
	// CriticalityType: Service criticality type Example: "CRITICAL"
	CriticalityType string `json:"criticalityType,omitempty"`
	// EnvironmentType: Service environment type Example: "DEV"
	EnvironmentType string `json:"environmentType,omitempty"`
	// Id: Service Id. Example: "my-service"
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CriticalityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CriticalityType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppHubService) MarshalJSON() ([]byte, error) {
	type NoMethod AppHubService
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AppHubWorkload: Metadata associated with an App Hub workload.
type AppHubWorkload struct {
	// CriticalityType: Workload criticality type Example: "CRITICAL"
	CriticalityType string `json:"criticalityType,omitempty"`
	// EnvironmentType: Workload environment type Example: "DEV"
	EnvironmentType string `json:"environmentType,omitempty"`
	// Id: Workload Id. Example: "my-workload"
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CriticalityType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CriticalityType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppHubWorkload) MarshalJSON() ([]byte, error) {
	type NoMethod AppHubWorkload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigQueryDataset: Describes a BigQuery dataset that was created by a link.
type BigQueryDataset struct {
	// DatasetId: Output only. The full resource name of the BigQuery dataset. The
	// DATASET_ID will match the ID of the link, so the link must match the naming
	// restrictions of BigQuery datasets (alphanumeric characters and underscores
	// only).The dataset will have a resource path of
	// "bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID"
	DatasetId string `json:"datasetId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DatasetId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatasetId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigQueryDataset) MarshalJSON() ([]byte, error) {
	type NoMethod BigQueryDataset
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BigQueryOptions: Options that change functionality of a sink exporting data
// to BigQuery.
type BigQueryOptions struct {
	// UsePartitionedTables: Optional. Whether to use BigQuery's partition tables
	// (https://cloud.google.com/bigquery/docs/partitioned-tables). By default,
	// Cloud Logging creates dated tables based on the log entries' timestamps,
	// e.g. syslog_20170523. With partitioned tables the date suffix is no longer
	// present and special query syntax
	// (https://cloud.google.com/bigquery/docs/querying-partitioned-tables) has to
	// be used instead. In both cases, tables are sharded based on UTC timezone.
	UsePartitionedTables bool `json:"usePartitionedTables,omitempty"`
	// UsesTimestampColumnPartitioning: Output only. True if new timestamp column
	// based partitioning is in use, false if legacy ingress-time partitioning is
	// in use.All new sinks will have this field set true and will use timestamp
	// column based partitioning. If use_partitioned_tables is false, this value
	// has no meaning and will be false. Legacy sinks using partitioned tables will
	// have this field set to false.
	UsesTimestampColumnPartitioning bool `json:"usesTimestampColumnPartitioning,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UsePartitionedTables") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UsePartitionedTables") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BigQueryOptions) MarshalJSON() ([]byte, error) {
	type NoMethod BigQueryOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates members, or principals, with a role.
type Binding struct {
	// Condition: The condition that is associated with this binding.If the
	// condition evaluates to true, then this binding applies to the current
	// request.If the condition evaluates to false, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding.To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. members can have the following values: allUsers: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. allAuthenticatedUsers: A special identifier that represents
	// anyone who is authenticated with a Google account or a service account. Does
	// not include identities that come from external identity providers (IdPs)
	// through identity federation. user:{emailid}: An email address that
	// represents a specific Google account. For example, alice@example.com .
	// serviceAccount:{emailid}: An email address that represents a Google service
	// account. For example, my-other-app@appspot.gserviceaccount.com.
	// serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, my-project.svc.id.goog[my-namespace/my-kubernetes-sa].
	// group:{emailid}: An email address that represents a Google group. For
	// example, admins@example.com. domain:{domain}: The G Suite domain (primary)
	// that represents all the users of that domain. For example, google.com or
	// example.com.
	// principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subj
	// ect/{subject_attribute_value}: A single identity in a workforce identity
	// pool.
	// principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/g
	// roup/{group_id}: All workforce identities in a group.
	// principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/a
	// ttribute.{attribute_name}/{attribute_value}: All workforce identities with a
	// specific attribute value.
	// principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/*
	// : All identities in a workforce identity pool.
	// principal://iam.googleapis.com/projects/{project_number}/locations/global/wor
	// kloadIdentityPools/{pool_id}/subject/{subject_attribute_value}: A single
	// identity in a workload identity pool.
	// principalSet://iam.googleapis.com/projects/{project_number}/locations/global/
	// workloadIdentityPools/{pool_id}/group/{group_id}: A workload identity pool
	// group.
	// principalSet://iam.googleapis.com/projects/{project_number}/locations/global/
	// workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}:
	//  All identities in a workload identity pool with a certain attribute.
	// principalSet://iam.googleapis.com/projects/{project_number}/locations/global/
	// workloadIdentityPools/{pool_id}/*: All identities in a workload identity
	// pool. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique
	// identifier) representing a user that has been recently deleted. For example,
	// alice@example.com?uid=123456789012345678901. If the user is recovered, this
	// value reverts to user:{emailid} and the recovered user retains the role in
	// the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email
	// address (plus unique identifier) representing a service account that has
	// been recently deleted. For example,
	// my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the
	// service account is undeleted, this value reverts to serviceAccount:{emailid}
	// and the undeleted service account retains the role in the binding.
	// deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique
	// identifier) representing a Google group that has been recently deleted. For
	// example, admins@example.com?uid=123456789012345678901. If the group is
	// recovered, this value reverts to group:{emailid} and the recovered group
	// retains the role in the binding.
	// deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool_
	// id}/subject/{subject_attribute_value}: Deleted single identity in a
	// workforce identity pool. For example,
	// deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-poo
	// l-id/subject/my-subject-attribute-value.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of members, or principals. For
	// example, roles/viewer, roles/editor, or roles/owner.For an overview of the
	// IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BucketMetadata: Metadata for LongRunningUpdateBucket Operations.
type BucketMetadata struct {
	// CreateBucketRequest: LongRunningCreateBucket RPC request.
	CreateBucketRequest *CreateBucketRequest `json:"createBucketRequest,omitempty"`
	// EndTime: The end time of an operation.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: The create time of an operation.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. State of an operation.
	//
	// Possible values:
	//   "OPERATION_STATE_UNSPECIFIED" - Should not be used.
	//   "OPERATION_STATE_SCHEDULED" - The operation is scheduled.
	//   "OPERATION_STATE_WAITING_FOR_PERMISSIONS" - Waiting for necessary
	// permissions.
	//   "OPERATION_STATE_RUNNING" - The operation is running.
	//   "OPERATION_STATE_SUCCEEDED" - The operation was completed successfully.
	//   "OPERATION_STATE_FAILED" - The operation failed.
	//   "OPERATION_STATE_CANCELLED" - The operation was cancelled by the user.
	//   "OPERATION_STATE_PENDING" - The operation is waiting for quota.
	State string `json:"state,omitempty"`
	// UpdateBucketRequest: LongRunningUpdateBucket RPC request.
	UpdateBucketRequest *UpdateBucketRequest `json:"updateBucketRequest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateBucketRequest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateBucketRequest") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BucketMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod BucketMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BucketOptions: BucketOptions describes the bucket boundaries used to create
// a histogram for the distribution. The buckets can be in a linear sequence,
// an exponential sequence, or each bucket can be specified explicitly.
// BucketOptions does not include the number of values in each bucket.A bucket
// has an inclusive lower bound and exclusive upper bound for the values that
// are counted for that bucket. The upper bound of a bucket must be strictly
// greater than the lower bound. The sequence of N buckets for a distribution
// consists of an underflow bucket (number 0), zero or more finite buckets
// (number 1 through N - 2) and an overflow bucket (number N - 1). The buckets
// are contiguous: the lower bound of bucket i (i > 0) is the same as the upper
// bound of bucket i - 1. The buckets span the whole range of finite values:
// lower bound of the underflow bucket is -infinity and the upper bound of the
// overflow bucket is +infinity. The finite buckets are so-called because both
// bounds are finite.
type BucketOptions struct {
	// ExplicitBuckets: The explicit buckets.
	ExplicitBuckets *Explicit `json:"explicitBuckets,omitempty"`
	// ExponentialBuckets: The exponential buckets.
	ExponentialBuckets *Exponential `json:"exponentialBuckets,omitempty"`
	// LinearBuckets: The linear bucket.
	LinearBuckets *Linear `json:"linearBuckets,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExplicitBuckets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExplicitBuckets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BucketOptions) MarshalJSON() ([]byte, error) {
	type NoMethod BucketOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelOperationRequest: The request message for Operations.CancelOperation.
type CancelOperationRequest struct {
}

// CmekSettings: Describes the customer-managed encryption key (CMEK) settings
// associated with a project, folder, organization, billing account, or
// flexible resource.Note: CMEK for the Log Router can currently only be
// configured for Google Cloud organizations. Once configured, it applies to
// all projects and folders in the Google Cloud organization.See Enabling CMEK
// for Log Router
// (https://cloud.google.com/logging/docs/routing/managed-encryption) for more
// information.
type CmekSettings struct {
	// KmsKeyName: Optional. The resource name for the configured Cloud KMS key.KMS
	// key name format:
	// "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KE
	// Y]" For
	// example:"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKey
	// s/my-key"To enable CMEK for the Log Router, set this field to a valid
	// kms_key_name for which the associated service account has the needed
	// cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.The Cloud
	// KMS key used by the Log Router can be updated by changing the kms_key_name
	// to a new valid key name or disabled by setting the key name to an empty
	// string. Encryption operations that are in progress will be completed with
	// the key that was in use when they started. Decryption operations will be
	// completed using the key that was used at the time of encryption unless
	// access to that key has been revoked.To disable CMEK for the Log Router, set
	// this field to an empty string.See Enabling CMEK for Log Router
	// (https://cloud.google.com/logging/docs/routing/managed-encryption) for more
	// information.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// KmsKeyVersionName: Output only. The CryptoKeyVersion resource name for the
	// configured Cloud KMS key.KMS key name format:
	// "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KE
	// Y]/cryptoKeyVersions/[VERSION]" For
	// example:"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKey
	// s/my-key/cryptoKeyVersions/1"This is a read-only field used to convey the
	// specific configured CryptoKeyVersion of kms_key that has been configured. It
	// will be populated in cases where the CMEK settings are bound to a single key
	// version.If this field is populated, the kms_key is tied to a specific
	// CryptoKeyVersion.
	KmsKeyVersionName string `json:"kmsKeyVersionName,omitempty"`
	// Name: Output only. The resource name of the CMEK settings.
	Name string `json:"name,omitempty"`
	// ServiceAccountId: Output only. The service account that will be used by the
	// Log Router to access your Cloud KMS key.Before enabling CMEK for Log Router,
	// you must first assign the cloudkms.cryptoKeyEncrypterDecrypter role to the
	// service account that the Log Router will use to access your Cloud KMS key.
	// Use GetCmekSettings to obtain the service account ID.See Enabling CMEK for
	// Log Router
	// (https://cloud.google.com/logging/docs/routing/managed-encryption) for more
	// information.
	ServiceAccountId string `json:"serviceAccountId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CmekSettings) MarshalJSON() ([]byte, error) {
	type NoMethod CmekSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CopyLogEntriesMetadata: Metadata for CopyLogEntries long running operations.
type CopyLogEntriesMetadata struct {
	// CancellationRequested: Identifies whether the user has requested
	// cancellation of the operation.
	CancellationRequested bool `json:"cancellationRequested,omitempty"`
	// Destination: Destination to which to copy log entries.For example, a Cloud
	// Storage bucket:"storage.googleapis.com/my-cloud-storage-bucket"
	Destination string `json:"destination,omitempty"`
	// EndTime: The end time of an operation.
	EndTime string `json:"endTime,omitempty"`
	// Progress: Estimated progress of the operation (0 - 100%).
	Progress int64 `json:"progress,omitempty"`
	// Request: CopyLogEntries RPC request. This field is deprecated and not used.
	Request *CopyLogEntriesRequest `json:"request,omitempty"`
	// Source: Source from which to copy log entries.For example, a log
	// bucket:"projects/my-project/locations/global/buckets/my-source-bucket"
	Source string `json:"source,omitempty"`
	// StartTime: The create time of an operation.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. State of an operation.
	//
	// Possible values:
	//   "OPERATION_STATE_UNSPECIFIED" - Should not be used.
	//   "OPERATION_STATE_SCHEDULED" - The operation is scheduled.
	//   "OPERATION_STATE_WAITING_FOR_PERMISSIONS" - Waiting for necessary
	// permissions.
	//   "OPERATION_STATE_RUNNING" - The operation is running.
	//   "OPERATION_STATE_SUCCEEDED" - The operation was completed successfully.
	//   "OPERATION_STATE_FAILED" - The operation failed.
	//   "OPERATION_STATE_CANCELLED" - The operation was cancelled by the user.
	//   "OPERATION_STATE_PENDING" - The operation is waiting for quota.
	State string `json:"state,omitempty"`
	// Verb: Name of the verb executed by the operation.For example,"copy"
	Verb string `json:"verb,omitempty"`
	// WriterIdentity: The IAM identity of a service account that must be granted
	// access to the destination.If the service account is not granted permission
	// to the destination within an hour, the operation will be cancelled.For
	// example: "serviceAccount:foo@bar.com"
	WriterIdentity string `json:"writerIdentity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CancellationRequested") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CancellationRequested") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CopyLogEntriesMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod CopyLogEntriesMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CopyLogEntriesRequest: The parameters to CopyLogEntries.
type CopyLogEntriesRequest struct {
	// Destination: Required. Destination to which to copy log entries. For
	// example: "storage.googleapis.com/GCS_BUCKET"
	Destination string `json:"destination,omitempty"`
	// Filter: Optional. A filter specifying which log entries to copy. The filter
	// must be no more than 20k characters. An empty filter matches all log
	// entries.
	Filter string `json:"filter,omitempty"`
	// Name: Required. Log bucket from which to copy log entries.For
	// example:"projects/my-project/locations/global/buckets/my-source-bucket"
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Destination") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Destination") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CopyLogEntriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CopyLogEntriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CopyLogEntriesResponse: Response type for CopyLogEntries long running
// operations.
type CopyLogEntriesResponse struct {
	// LogEntriesCopiedCount: Number of log entries copied.
	LogEntriesCopiedCount int64 `json:"logEntriesCopiedCount,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "LogEntriesCopiedCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogEntriesCopiedCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CopyLogEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CopyLogEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateBucketRequest: The parameters to CreateBucket.
type CreateBucketRequest struct {
	// Bucket: Required. The new bucket. The region specified in the new bucket
	// must be compliant with any Location Restriction Org Policy. The name field
	// in the bucket is ignored.
	Bucket *LogBucket `json:"bucket,omitempty"`
	// BucketId: Required. A client-assigned identifier such as "my-bucket".
	// Identifiers are limited to 100 characters and can include only letters,
	// digits, underscores, hyphens, and periods. Bucket identifiers must start
	// with an alphanumeric character.
	BucketId string `json:"bucketId,omitempty"`
	// Parent: Required. The resource in which to create the log bucket:
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
	// example:"projects/my-project/locations/global"
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateBucketRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateBucketRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CreateLinkRequest: The parameters to CreateLink.
type CreateLinkRequest struct {
	// Link: Required. The new link.
	Link *Link `json:"link,omitempty"`
	// LinkId: Required. The ID to use for the link. The link_id can have up to 100
	// characters. A valid link_id must only have alphanumeric characters and
	// underscores within it.
	LinkId string `json:"linkId,omitempty"`
	// Parent: Required. The full resource name of the bucket to create a link for.
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	Parent string `json:"parent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Link") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Link") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CreateLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateLinkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DefaultSinkConfig: Describes the custom _Default sink configuration that is
// used to override the built-in _Default sink configuration in newly created
// resource containers, such as projects or folders.
type DefaultSinkConfig struct {
	// Exclusions: Optional. Specifies the set of exclusions to be added to the
	// _Default sink in newly created resource containers.
	Exclusions []*LogExclusion `json:"exclusions,omitempty"`
	// Filter: Optional. An advanced logs filter
	// (https://cloud.google.com/logging/docs/view/advanced-queries). The only
	// exported log entries are those that are in the resource owning the sink and
	// that match the filter.For
	// example:logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity>=ERRORTo
	// match all logs, don't add exclusions and use the following line as the value
	// of filter:logName:*Cannot be empty or unset when the value of mode is
	// OVERWRITE.
	Filter string `json:"filter,omitempty"`
	// Mode: Required. Determines the behavior to apply to the built-in _Default
	// sink inclusion filter.Exclusions are always appended, as built-in _Default
	// sinks have no exclusions.
	//
	// Possible values:
	//   "FILTER_WRITE_MODE_UNSPECIFIED" - The filter's write mode is unspecified.
	// This mode must not be used.
	//   "APPEND" - The contents of filter will be appended to the built-in
	// _Default sink filter. Using the append mode with an empty filter will keep
	// the sink inclusion filter unchanged.
	//   "OVERWRITE" - The contents of filter will overwrite the built-in _Default
	// sink filter.
	Mode string `json:"mode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Exclusions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Exclusions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DefaultSinkConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DefaultSinkConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DeleteLinkRequest: The parameters to DeleteLink.
type DeleteLinkRequest struct {
	// Name: Required. The full resource name of the link to delete.
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
	// K_ID]"
	// "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/
	// links/[LINK_ID]"
	// "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET
	// _ID]/links/[LINK_ID]"
	// "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_
	// ID]"
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DeleteLinkRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DeleteLinkRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Explicit: Specifies a set of buckets with arbitrary widths.There are
// size(bounds) + 1 (= N) buckets. Bucket i has the following boundaries:Upper
// bound (0 <= i < N-1): boundsi Lower bound (1 <= i < N); boundsi - 1The
// bounds field must contain at least one element. If bounds has only one
// element, then there are no finite buckets, and that single element is the
// common boundary of the overflow and underflow buckets.
type Explicit struct {
	// Bounds: The values must be monotonically increasing.
	Bounds []float64 `json:"bounds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bounds") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bounds") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Explicit) MarshalJSON() ([]byte, error) {
	type NoMethod Explicit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Explicit) UnmarshalJSON(data []byte) error {
	type NoMethod Explicit
	var s1 struct {
		Bounds []gensupport.JSONFloat64 `json:"bounds"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Bounds = make([]float64, len(s1.Bounds))
	for i := range s1.Bounds {
		s.Bounds[i] = float64(s1.Bounds[i])
	}
	return nil
}

// Exponential: Specifies an exponential sequence of buckets that have a width
// that is proportional to the value of the lower bound. Each bucket represents
// a constant relative uncertainty on a specific value in the bucket.There are
// num_finite_buckets + 2 (= N) buckets. Bucket i has the following
// boundaries:Upper bound (0 <= i < N-1): scale * (growth_factor ^ i).Lower
// bound (1 <= i < N): scale * (growth_factor ^ (i - 1)).
type Exponential struct {
	// GrowthFactor: Must be greater than 1.
	GrowthFactor float64 `json:"growthFactor,omitempty"`
	// NumFiniteBuckets: Must be greater than 0.
	NumFiniteBuckets int64 `json:"numFiniteBuckets,omitempty"`
	// Scale: Must be greater than 0.
	Scale float64 `json:"scale,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GrowthFactor") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GrowthFactor") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Exponential) MarshalJSON() ([]byte, error) {
	type NoMethod Exponential
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Exponential) UnmarshalJSON(data []byte) error {
	type NoMethod Exponential
	var s1 struct {
		GrowthFactor gensupport.JSONFloat64 `json:"growthFactor"`
		Scale        gensupport.JSONFloat64 `json:"scale"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.GrowthFactor = float64(s1.GrowthFactor)
	s.Scale = float64(s1.Scale)
	return nil
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec.Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetIamPolicyRequest: Request message for GetIamPolicy method.
type GetIamPolicyRequest struct {
	// Options: OPTIONAL: A GetPolicyOptions object for specifying options to
	// GetIamPolicy.
	Options *GetPolicyOptions `json:"options,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Options") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Options") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetPolicyOptions: Encapsulates settings provided to GetIamPolicy.
type GetPolicyOptions struct {
	// RequestedPolicyVersion: Optional. The maximum policy version that will be
	// used to format the policy.Valid values are 0, 1, and 3. Requests specifying
	// an invalid value will be rejected.Requests for policies with any conditional
	// role bindings must specify version 3. Policies with no conditional role
	// bindings may specify any valid value or leave the field unset.The policy in
	// the response might use the policy version that you specified, or it might
	// use a lower policy version. For example, if you specify version 3, but the
	// policy has no conditional role bindings, the response uses version 1.To
	// learn which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	RequestedPolicyVersion int64 `json:"requestedPolicyVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestedPolicyVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestedPolicyVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetPolicyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GetPolicyOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HttpRequest: A common proto for logging HTTP requests. Only contains
// semantics defined by the HTTP specification. Product-specific logging
// information MUST be defined in a separate message.
type HttpRequest struct {
	// CacheFillBytes: The number of HTTP response bytes inserted into cache. Set
	// only when a cache fill was attempted.
	CacheFillBytes int64 `json:"cacheFillBytes,omitempty,string"`
	// CacheHit: Whether or not an entity was served from cache (with or without
	// validation).
	CacheHit bool `json:"cacheHit,omitempty"`
	// CacheLookup: Whether or not a cache lookup was attempted.
	CacheLookup bool `json:"cacheLookup,omitempty"`
	// CacheValidatedWithOriginServer: Whether or not the response was validated
	// with the origin server before being served from cache. This field is only
	// meaningful if cache_hit is True.
	CacheValidatedWithOriginServer bool `json:"cacheValidatedWithOriginServer,omitempty"`
	// Latency: The request processing latency on the server, from the time the
	// request was received until the response was sent. For WebSocket connections,
	// this field refers to the entire time duration of the connection.
	Latency string `json:"latency,omitempty"`
	// Protocol: Protocol used for the request. Examples: "HTTP/1.1", "HTTP/2"
	Protocol string `json:"protocol,omitempty"`
	// Referer: The referer URL of the request, as defined in HTTP/1.1 Header Field
	// Definitions (https://datatracker.ietf.org/doc/html/rfc2616#section-14.36).
	Referer string `json:"referer,omitempty"`
	// RemoteIp: The IP address (IPv4 or IPv6) of the client that issued the HTTP
	// request. This field can include port information. Examples: "192.168.1.1",
	// "10.0.0.1:80", "FE80::0202:B3FF:FE1E:8329".
	RemoteIp string `json:"remoteIp,omitempty"`
	// RequestMethod: The request method. Examples: "GET", "HEAD", "PUT", "POST".
	RequestMethod string `json:"requestMethod,omitempty"`
	// RequestSize: The size of the HTTP request message in bytes, including the
	// request headers and the request body.
	RequestSize int64 `json:"requestSize,omitempty,string"`
	// RequestUrl: The scheme (http, https), the host name, the path and the query
	// portion of the URL that was requested. Example:
	// "http://example.com/some/info?color=red".
	RequestUrl string `json:"requestUrl,omitempty"`
	// ResponseSize: The size of the HTTP response message sent back to the client,
	// in bytes, including the response headers and the response body.
	ResponseSize int64 `json:"responseSize,omitempty,string"`
	// ServerIp: The IP address (IPv4 or IPv6) of the origin server that the
	// request was sent to. This field can include port information. Examples:
	// "192.168.1.1", "10.0.0.1:80", "FE80::0202:B3FF:FE1E:8329".
	ServerIp string `json:"serverIp,omitempty"`
	// Status: The response code indicating the status of response. Examples: 200,
	// 404.
	Status int64 `json:"status,omitempty"`
	// UserAgent: The user agent sent by the client. Example: "Mozilla/4.0
	// (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)".
	UserAgent string `json:"userAgent,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CacheFillBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CacheFillBytes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HttpRequest) MarshalJSON() ([]byte, error) {
	type NoMethod HttpRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IndexConfig: Configuration for an indexed field.
type IndexConfig struct {
	// CreateTime: Output only. The timestamp when the index was last modified.This
	// is used to return the timestamp, and will be ignored if supplied during
	// update.
	CreateTime string `json:"createTime,omitempty"`
	// FieldPath: Required. The LogEntry field path to index.Note that some paths
	// are automatically indexed, and other paths are not eligible for indexing.
	// See indexing documentation(
	// https://cloud.google.com/logging/docs/analyze/custom-index) for details.For
	// example: jsonPayload.request.status
	FieldPath string `json:"fieldPath,omitempty"`
	// Type: Required. The type of data in this index.
	//
	// Possible values:
	//   "INDEX_TYPE_UNSPECIFIED" - The index's type is unspecified.
	//   "INDEX_TYPE_STRING" - The index is a string-type index.
	//   "INDEX_TYPE_INTEGER" - The index is a integer-type index.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IndexConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IndexConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LabelDescriptor: A description of a label.
type LabelDescriptor struct {
	// Description: A human-readable description for the label.
	Description string `json:"description,omitempty"`
	// Key: The label key.
	Key string `json:"key,omitempty"`
	// ValueType: The type of data that can be assigned to the label.
	//
	// Possible values:
	//   "STRING" - A variable-length string. This is the default.
	//   "BOOL" - Boolean; true or false.
	//   "INT64" - A 64-bit signed integer.
	ValueType string `json:"valueType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LabelDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod LabelDescriptor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Linear: Specifies a linear sequence of buckets that all have the same width
// (except overflow and underflow). Each bucket represents a constant absolute
// uncertainty on the specific value in the bucket.There are num_finite_buckets
// + 2 (= N) buckets. Bucket i has the following boundaries:Upper bound (0 <= i
// < N-1): offset + (width * i).Lower bound (1 <= i < N): offset + (width * (i
// - 1)).
type Linear struct {
	// NumFiniteBuckets: Must be greater than 0.
	NumFiniteBuckets int64 `json:"numFiniteBuckets,omitempty"`
	// Offset: Lower bound of the first bucket.
	Offset float64 `json:"offset,omitempty"`
	// Width: Must be greater than 0.
	Width float64 `json:"width,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumFiniteBuckets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumFiniteBuckets") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Linear) MarshalJSON() ([]byte, error) {
	type NoMethod Linear
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *Linear) UnmarshalJSON(data []byte) error {
	type NoMethod Linear
	var s1 struct {
		Offset gensupport.JSONFloat64 `json:"offset"`
		Width  gensupport.JSONFloat64 `json:"width"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Offset = float64(s1.Offset)
	s.Width = float64(s1.Width)
	return nil
}

// Link: Describes a link connected to an analytics enabled bucket.
type Link struct {
	// BigqueryDataset: Optional. The information of a BigQuery Dataset. When a
	// link is created, a BigQuery dataset is created along with it, in the same
	// project as the LogBucket it's linked to. This dataset will also have
	// BigQuery Views corresponding to the LogViews in the bucket.
	BigqueryDataset *BigQueryDataset `json:"bigqueryDataset,omitempty"`
	// CreateTime: Output only. The creation timestamp of the link.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Describes this link.The maximum length of the
	// description is 8000 characters.
	Description string `json:"description,omitempty"`
	// LifecycleState: Output only. The resource lifecycle state.
	//
	// Possible values:
	//   "LIFECYCLE_STATE_UNSPECIFIED" - Unspecified state. This is only
	// used/useful for distinguishing unset values.
	//   "ACTIVE" - The normal and active state.
	//   "DELETE_REQUESTED" - The resource has been marked for deletion by the
	// user. For some resources (e.g. buckets), this can be reversed by an
	// un-delete operation.
	//   "UPDATING" - The resource has been marked for an update by the user. It
	// will remain in this state until the update is complete.
	//   "CREATING" - The resource has been marked for creation by the user. It
	// will remain in this state until the creation is complete.
	//   "FAILED" - The resource is in an INTERNAL error state.
	LifecycleState string `json:"lifecycleState,omitempty"`
	// Name: Output only. The resource name of the link. The name can have up to
	// 100 characters. A valid link id (at the end of the link name) must only have
	// alphanumeric characters and underscores within it.
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
	// K_ID]"
	// "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/
	// links/[LINK_ID]"
	// "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET
	// _ID]/links/[LINK_ID]"
	// "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LINK_
	// ID]" For
	// example:`projects/my-project/locations/global/buckets/my-bucket/links/my_link
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BigqueryDataset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryDataset") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Link) MarshalJSON() ([]byte, error) {
	type NoMethod Link
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LinkMetadata: Metadata for long running Link operations.
type LinkMetadata struct {
	// CreateLinkRequest: CreateLink RPC request.
	CreateLinkRequest *CreateLinkRequest `json:"createLinkRequest,omitempty"`
	// DeleteLinkRequest: DeleteLink RPC request.
	DeleteLinkRequest *DeleteLinkRequest `json:"deleteLinkRequest,omitempty"`
	// EndTime: The end time of an operation.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: The start time of an operation.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. State of an operation.
	//
	// Possible values:
	//   "OPERATION_STATE_UNSPECIFIED" - Should not be used.
	//   "OPERATION_STATE_SCHEDULED" - The operation is scheduled.
	//   "OPERATION_STATE_WAITING_FOR_PERMISSIONS" - Waiting for necessary
	// permissions.
	//   "OPERATION_STATE_RUNNING" - The operation is running.
	//   "OPERATION_STATE_SUCCEEDED" - The operation was completed successfully.
	//   "OPERATION_STATE_FAILED" - The operation failed.
	//   "OPERATION_STATE_CANCELLED" - The operation was cancelled by the user.
	//   "OPERATION_STATE_PENDING" - The operation is waiting for quota.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateLinkRequest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateLinkRequest") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LinkMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod LinkMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBucketsResponse: The response from ListBuckets.
type ListBucketsResponse struct {
	// Buckets: A list of buckets.
	Buckets []*LogBucket `json:"buckets,omitempty"`
	// NextPageToken: If there might be more results than appear in this response,
	// then nextPageToken is included. To get the next set of results, call the
	// same method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Buckets") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Buckets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBucketsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBucketsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListExclusionsResponse: Result returned from ListExclusions.
type ListExclusionsResponse struct {
	// Exclusions: A list of exclusions.
	Exclusions []*LogExclusion `json:"exclusions,omitempty"`
	// NextPageToken: If there might be more results than appear in this response,
	// then nextPageToken is included. To get the next set of results, call the
	// same method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Exclusions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Exclusions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListExclusionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExclusionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLinksResponse: The response from ListLinks.
type ListLinksResponse struct {
	// Links: A list of links.
	Links []*Link `json:"links,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then nextPageToken is included. To get the next set of results,
	// call the same method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Links") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Links") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLinksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLogEntriesRequest: The parameters to ListLogEntries.
type ListLogEntriesRequest struct {
	// Filter: Optional. A filter that chooses which log entries to return. For
	// more information, see Logging query language
	// (https://{$universe.dns_names.final_documentation_domain}/logging/docs/view/logging-query-language).Only
	// log entries that match the filter are returned. An empty filter matches all
	// log entries in the resources listed in resource_names. Referencing a parent
	// resource that is not listed in resource_names will cause the filter to
	// return no results. The maximum length of a filter is 20,000 characters.To
	// make queries faster, you can make the filter more selective by using
	// restrictions on indexed fields
	// (https://{$universe.dns_names.final_documentation_domain}/logging/docs/view/logging-query-language#indexed-fields)
	// as well as limit the time range of the query by adding range restrictions on
	// the timestamp field.
	Filter string `json:"filter,omitempty"`
	// OrderBy: Optional. How the results should be sorted. Presently, the only
	// permitted values are "timestamp asc" (default) and "timestamp desc". The
	// first option returns entries in order of increasing values of
	// LogEntry.timestamp (oldest first), and the second option returns entries in
	// order of decreasing timestamps (newest first). Entries with equal timestamps
	// are returned in order of their insert_id values.We recommend setting the
	// order_by field to "timestamp desc" when listing recently ingested log
	// entries. If not set, the default value of "timestamp asc" may take a long
	// time to fetch matching logs that are only recently ingested.
	OrderBy string `json:"orderBy,omitempty"`
	// PageSize: Optional. The maximum number of results to return from this
	// request. Default is 50. If the value is negative, the request is
	// rejected.The presence of next_page_token in the response indicates that more
	// results might be available.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Optional. If present, then retrieve the next batch of results
	// from the preceding call to this method. page_token must be the value of
	// next_page_token from the previous response. The values of other method
	// parameters should be identical to those in the previous call.
	PageToken string `json:"pageToken,omitempty"`
	// ProjectIds: Optional. Deprecated. Use resource_names instead. One or more
	// project identifiers or project numbers from which to retrieve log entries.
	// Example: "my-project-1A".
	ProjectIds []string `json:"projectIds,omitempty"`
	// ResourceNames: Required. Names of one or more parent resources from which to
	// retrieve log entries. Resources may either be resource containers or
	// specific LogViews. For the case of resource containers, all logs ingested
	// into that container will be returned regardless of which LogBuckets they are
	// actually stored in - i.e. these queries may fan out to multiple regions. In
	// the event of region unavailability, specify a specific set of LogViews that
	// do not include the unavailable region. projects/[PROJECT_ID]
	// organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
	// folders/[FOLDER_ID]
	// projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW
	// _ID]
	// organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/v
	// iews/[VIEW_ID]
	// billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_
	// ID]/views/[VIEW_ID]
	// folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_I
	// D]Projects listed in the project_ids field are added to this list. A maximum
	// of 100 resources may be specified in a single request.
	ResourceNames []string `json:"resourceNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLogEntriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ListLogEntriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLogEntriesResponse: Result returned from ListLogEntries.
type ListLogEntriesResponse struct {
	// Entries: A list of log entries. If entries is empty, nextPageToken may still
	// be returned, indicating that more entries may exist. See nextPageToken for
	// more information.
	Entries []*LogEntry `json:"entries,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then nextPageToken is included. To get the next set of results,
	// call this method again using the value of nextPageToken as pageToken.If a
	// value for next_page_token appears and the entries field is empty, it means
	// that the search found no log entries so far but it did not have time to
	// search all the possible log entries. Retry the method with this value for
	// page_token to continue the search. Alternatively, consider speeding up the
	// search by changing your filter to specify a single log name or resource
	// type, or to narrow the time range of the search.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLogEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLogEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLogMetricsResponse: Result returned from ListLogMetrics.
type ListLogMetricsResponse struct {
	// Metrics: A list of logs-based metrics.
	Metrics []*LogMetric `json:"metrics,omitempty"`
	// NextPageToken: If there might be more results than appear in this response,
	// then nextPageToken is included. To get the next set of results, call this
	// method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLogMetricsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLogMetricsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLogScopesResponse: The response from ListLogScopes. Every project has a
// _Default log scope that cannot be modified or deleted.
type ListLogScopesResponse struct {
	// LogScopes: A list of log scopes.
	LogScopes []*LogScope `json:"logScopes,omitempty"`
	// NextPageToken: If there might be more results than appear in this response,
	// then nextPageToken is included. To get the next set of results, call the
	// same method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "LogScopes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogScopes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLogScopesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLogScopesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLogsResponse: Result returned from ListLogs.
type ListLogsResponse struct {
	// LogNames: A list of log names. For example,
	// "projects/my-project/logs/syslog" or
	// "organizations/123/logs/cloudresourcemanager.googleapis.com%2Factivity".
	LogNames []string `json:"logNames,omitempty"`
	// NextPageToken: If there might be more results than those appearing in this
	// response, then nextPageToken is included. To get the next set of results,
	// call this method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "LogNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLogsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLogsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMonitoredResourceDescriptorsResponse: Result returned from
// ListMonitoredResourceDescriptors.
type ListMonitoredResourceDescriptorsResponse struct {
	// NextPageToken: If there might be more results than those appearing in this
	// response, then nextPageToken is included. To get the next set of results,
	// call this method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ResourceDescriptors: A list of resource descriptors.
	ResourceDescriptors []*MonitoredResourceDescriptor `json:"resourceDescriptors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMonitoredResourceDescriptorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMonitoredResourceDescriptorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets ListOperationsRequest.return_partial_success and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRecentQueriesResponse: The response from ListRecentQueries.
type ListRecentQueriesResponse struct {
	// NextPageToken: If there might be more results than appear in this response,
	// then nextPageToken is included. To get the next set of results, call the
	// same method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// RecentQueries: A list of recent queries.
	RecentQueries []*RecentQuery `json:"recentQueries,omitempty"`
	// Unreachable: The unreachable resources. Each resource can be either 1) a
	// saved query if a specific query is unreachable or 2) a location if a
	// specific location is unreachable.
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]/recentQueries/[QUERY_ID]"
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
	// example:"projects/my-project/locations/global/recentQueries/12345678"
	// "projects/my-project/locations/global"If there are unreachable resources,
	// the response will first return pages that contain recent queries, and then
	// return pages that contain the unreachable resources.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRecentQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRecentQueriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSavedQueriesResponse: The response from ListSavedQueries.
type ListSavedQueriesResponse struct {
	// NextPageToken: If there might be more results than appear in this response,
	// then nextPageToken is included. To get the next set of results, call the
	// same method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SavedQueries: A list of saved queries.
	SavedQueries []*SavedQuery `json:"savedQueries,omitempty"`
	// Unreachable: The unreachable resources. It can be either 1) a saved query if
	// a specific query is unreachable or 2) a location if a specific location is
	// unreachabe.
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]"
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For example:
	// "projects/my-project/locations/global/savedQueries/12345678"
	// "projects/my-project/locations/global" If there are unreachable resources,
	// the response will first return pages that contain saved queries, and then
	// return pages that contain the unreachable resources.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSavedQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSavedQueriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSinksResponse: Result returned from ListSinks.
type ListSinksResponse struct {
	// NextPageToken: If there might be more results than appear in this response,
	// then nextPageToken is included. To get the next set of results, call the
	// same method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Sinks: A list of sinks.
	Sinks []*LogSink `json:"sinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSinksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListViewsResponse: The response from ListViews.
type ListViewsResponse struct {
	// NextPageToken: If there might be more results than appear in this response,
	// then nextPageToken is included. To get the next set of results, call the
	// same method again using the value of nextPageToken as pageToken.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Views: A list of views.
	Views []*LogView `json:"views,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListViewsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListViewsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example: "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocationMetadata: Cloud Logging specific location metadata.
type LocationMetadata struct {
	// LogAnalyticsEnabled: Indicates whether or not Log Analytics features are
	// supported in the given location.
	LogAnalyticsEnabled bool `json:"logAnalyticsEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LogAnalyticsEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogAnalyticsEnabled") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod LocationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogBucket: Describes a repository in which log entries are stored.
type LogBucket struct {
	// AnalyticsEnabled: Optional. Whether log analytics is enabled for this
	// bucket.Once enabled, log analytics features cannot be disabled.
	AnalyticsEnabled bool `json:"analyticsEnabled,omitempty"`
	// CmekSettings: Optional. The CMEK settings of the log bucket. If present, new
	// log entries written to this log bucket are encrypted using the CMEK key
	// provided in this configuration. If a log bucket has CMEK settings, the CMEK
	// settings cannot be disabled later by updating the log bucket. Changing the
	// KMS key is allowed.
	CmekSettings *CmekSettings `json:"cmekSettings,omitempty"`
	// CreateTime: Output only. The creation timestamp of the bucket. This is not
	// set for any of the default buckets.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Describes this bucket.
	Description string `json:"description,omitempty"`
	// IndexConfigs: Optional. A list of indexed fields and related configuration
	// data.
	IndexConfigs []*IndexConfig `json:"indexConfigs,omitempty"`
	// LifecycleState: Output only. The bucket lifecycle state.
	//
	// Possible values:
	//   "LIFECYCLE_STATE_UNSPECIFIED" - Unspecified state. This is only
	// used/useful for distinguishing unset values.
	//   "ACTIVE" - The normal and active state.
	//   "DELETE_REQUESTED" - The resource has been marked for deletion by the
	// user. For some resources (e.g. buckets), this can be reversed by an
	// un-delete operation.
	//   "UPDATING" - The resource has been marked for an update by the user. It
	// will remain in this state until the update is complete.
	//   "CREATING" - The resource has been marked for creation by the user. It
	// will remain in this state until the creation is complete.
	//   "FAILED" - The resource is in an INTERNAL error state.
	LifecycleState string `json:"lifecycleState,omitempty"`
	// Locked: Optional. Whether the bucket is locked.The retention period on a
	// locked bucket cannot be changed. Locked buckets may only be deleted if they
	// are empty.
	Locked bool `json:"locked,omitempty"`
	// Name: Output only. The resource name of the bucket.For
	// example:projects/my-project/locations/global/buckets/my-bucketFor a list of
	// supported locations, see Supported Regions
	// (https://cloud.google.com/logging/docs/region-support)For the location of
	// global it is unspecified where log entries are actually stored.After a
	// bucket has been created, the location cannot be changed.
	Name string `json:"name,omitempty"`
	// RestrictedFields: Optional. Log entry field paths that are denied access in
	// this bucket.The following fields and their children are eligible:
	// textPayload, jsonPayload, protoPayload, httpRequest, labels,
	// sourceLocation.Restricting a repeated field will restrict all values. Adding
	// a parent will block all child fields. (e.g. foo.bar will block foo.bar.baz)
	RestrictedFields []string `json:"restrictedFields,omitempty"`
	// RetentionDays: Optional. Logs will be retained by default for this amount of
	// time, after which they will automatically be deleted. The minimum retention
	// period is 1 day. If this value is set to zero at bucket creation time, the
	// default time of 30 days will be used.
	RetentionDays int64 `json:"retentionDays,omitempty"`
	// UpdateTime: Output only. The last update timestamp of the bucket.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AnalyticsEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyticsEnabled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogBucket) MarshalJSON() ([]byte, error) {
	type NoMethod LogBucket
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogEntry: An individual entry in a log.
type LogEntry struct {
	// Apphub: Output only. AppHub application metadata associated with this
	// LogEntry. May be empty if there is no associated AppHub application or
	// multiple associated applications (such as for VPC flow logs)
	Apphub *AppHub `json:"apphub,omitempty"`
	// ApphubDestination: Output only. AppHub application metadata associated with
	// the destination application. This is only populated if the log represented
	// "edge"-like data (such as for VPC flow logs) with a destination.
	ApphubDestination *AppHub `json:"apphubDestination,omitempty"`
	// ApphubSource: Output only. AppHub application metadata associated with the
	// source application. This is only populated if the log represented
	// "edge"-like data (such as for VPC flow logs) with a source.
	ApphubSource *AppHub `json:"apphubSource,omitempty"`
	// ErrorGroups: Output only. The Error Reporting
	// (https://cloud.google.com/error-reporting) error groups associated with this
	// LogEntry. Error Reporting sets the values for this field during error group
	// creation.For more information, see View error details(
	// https://cloud.google.com/error-reporting/docs/viewing-errors#view_error_details)This
	// field isn't available during log routing
	// (https://cloud.google.com/logging/docs/routing/overview)
	ErrorGroups []*LogErrorGroup `json:"errorGroups,omitempty"`
	// HttpRequest: Optional. Information about the HTTP request associated with
	// this log entry, if applicable.
	HttpRequest *HttpRequest `json:"httpRequest,omitempty"`
	// InsertId: Optional. A unique identifier for the log entry. If you provide a
	// value, then Logging considers other log entries in the same project, with
	// the same timestamp, and with the same insert_id to be duplicates which are
	// removed in a single query result. However, there are no guarantees of
	// de-duplication in the export of logs.If the insert_id is omitted when
	// writing a log entry, the Logging API assigns its own unique identifier in
	// this field.In queries, the insert_id is also used to order log entries that
	// have the same log_name and timestamp values.
	InsertId string `json:"insertId,omitempty"`
	// JsonPayload: The log entry payload, represented as a structure that is
	// expressed as a JSON object.
	JsonPayload googleapi.RawMessage `json:"jsonPayload,omitempty"`
	// Labels: Optional. A map of key, value pairs that provides additional
	// information about the log entry. The labels can be user-defined or
	// system-defined.User-defined labels are arbitrary key, value pairs that you
	// can use to classify logs.System-defined labels are defined by GCP services
	// for platform logs. They have two components - a service namespace component
	// and the attribute name. For example:
	// compute.googleapis.com/resource_name.Cloud Logging truncates label keys that
	// exceed 512 B and label values that exceed 64 KB upon their associated log
	// entry being written. The truncation is indicated by an ellipsis at the end
	// of the character string.
	Labels map[string]string `json:"labels,omitempty"`
	// LogName: Required. The resource name of the log to which this log entry
	// belongs: "projects/[PROJECT_ID]/logs/[LOG_ID]"
	// "organizations/[ORGANIZATION_ID]/logs/[LOG_ID]"
	// "billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]"
	// "folders/[FOLDER_ID]/logs/[LOG_ID]" A project number may be used in place of
	// PROJECT_ID. The project number is translated to its corresponding PROJECT_ID
	// internally and the log_name field will contain PROJECT_ID in queries and
	// exports.[LOG_ID] must be URL-encoded within log_name. Example:
	// "organizations/1234567890/logs/cloudresourcemanager.googleapis.com%2Factivity
	// ".[LOG_ID] must be less than 512 characters long and can only include the
	// following characters: upper and lower case alphanumeric characters,
	// forward-slash, underscore, hyphen, and period.For backward compatibility, if
	// log_name begins with a forward-slash, such as /projects/..., then the log
	// entry is processed as usual, but the forward-slash is removed. Listing the
	// log entry will not show the leading slash and filtering for a log name with
	// a leading slash will never return any results.
	LogName string `json:"logName,omitempty"`
	// Metadata: Output only. Deprecated. This field is not used by Logging. Any
	// value written to it is cleared.
	Metadata *MonitoredResourceMetadata `json:"metadata,omitempty"`
	// Operation: Optional. Information about an operation associated with the log
	// entry, if applicable.
	Operation *LogEntryOperation `json:"operation,omitempty"`
	// ProtoPayload: The log entry payload, represented as a protocol buffer. Some
	// Google Cloud Platform services use this field for their log entry
	// payloads.The following protocol buffer types are supported; user-defined
	// types are not supported:"type.googleapis.com/google.cloud.audit.AuditLog"
	// "type.googleapis.com/google.appengine.logging.v1.RequestLog"
	ProtoPayload googleapi.RawMessage `json:"protoPayload,omitempty"`
	// ReceiveTimestamp: Output only. The time the log entry was received by
	// Logging.
	ReceiveTimestamp string `json:"receiveTimestamp,omitempty"`
	// Resource: Required. The monitored resource that produced this log
	// entry.Example: a log entry that reports a database error would be associated
	// with the monitored resource designating the particular database that
	// reported the error.
	Resource *MonitoredResource `json:"resource,omitempty"`
	// Severity: Optional. The severity of the log entry. The default value is
	// LogSeverity.DEFAULT.
	//
	// Possible values:
	//   "DEFAULT" - (0) The log entry has no assigned severity level.
	//   "DEBUG" - (100) Debug or trace information.
	//   "INFO" - (200) Routine information, such as ongoing status or performance.
	//   "NOTICE" - (300) Normal but significant events, such as start up, shut
	// down, or a configuration change.
	//   "WARNING" - (400) Warning events might cause problems.
	//   "ERROR" - (500) Error events are likely to cause problems.
	//   "CRITICAL" - (600) Critical events cause more severe problems or outages.
	//   "ALERT" - (700) A person must take an action immediately.
	//   "EMERGENCY" - (800) One or more systems are unusable.
	Severity string `json:"severity,omitempty"`
	// SourceLocation: Optional. Source code location information associated with
	// the log entry, if any.
	SourceLocation *LogEntrySourceLocation `json:"sourceLocation,omitempty"`
	// SpanId: Optional. The ID of the Cloud Trace (https://cloud.google.com/trace)
	// span associated with the current operation in which the log is being
	// written. For example, if a span has the REST resource name of
	// "projects/some-project/traces/some-trace/spans/some-span-id", then the
	// span_id field is "some-span-id".A Span
	// (https://cloud.google.com/trace/docs/reference/v2/rest/v2/projects.traces/batchWrite#Span)
	// represents a single operation within a trace. Whereas a trace may involve
	// multiple different microservices running on multiple different machines, a
	// span generally corresponds to a single logical operation being performed in
	// a single instance of a microservice on one specific machine. Spans are the
	// nodes within the tree that is a trace.Applications that are instrumented for
	// tracing (https://cloud.google.com/trace/docs/setup) will generally assign a
	// new, unique span ID on each incoming request. It is also common to create
	// and record additional spans corresponding to internal processing elements as
	// well as issuing requests to dependencies.The span ID is expected to be a
	// 16-character, hexadecimal encoding of an 8-byte array and should not be
	// zero. It should be unique within the trace and should, ideally, be generated
	// in a manner that is uniformly random.Example values: 000000000000004a
	// 7a2190356c3fc94b 0000f00300090021 d39223e101960076
	SpanId string `json:"spanId,omitempty"`
	// Split: Optional. Information indicating this LogEntry is part of a sequence
	// of multiple log entries split from a single LogEntry.
	Split *LogSplit `json:"split,omitempty"`
	// TextPayload: The log entry payload, represented as a Unicode string (UTF-8).
	TextPayload string `json:"textPayload,omitempty"`
	// Timestamp: Optional. The time the event described by the log entry occurred.
	// This time is used to compute the log entry's age and to enforce the logs
	// retention period. If this field is omitted in a new log entry, then Logging
	// assigns it the current time. Timestamps have nanosecond accuracy, but
	// trailing zeros in the fractional seconds might be omitted when the timestamp
	// is displayed.Incoming log entries must have timestamps that don't exceed the
	// logs retention period
	// (https://cloud.google.com/logging/quotas#logs_retention_periods) in the
	// past, and that don't exceed 24 hours in the future. Log entries outside
	// those time boundaries are rejected by Logging.
	Timestamp string `json:"timestamp,omitempty"`
	// Trace: Optional. The REST resource name of the trace being written to Cloud
	// Trace (https://cloud.google.com/trace) in association with this log entry.
	// For example, if your trace data is stored in the Cloud project
	// "my-trace-project" and if the service that is creating the log entry
	// receives a trace header that includes the trace ID "12345", then the service
	// should use "projects/my-trace-project/traces/12345".The trace field provides
	// the link between logs and traces. By using this field, you can navigate from
	// a log entry to a trace.
	Trace string `json:"trace,omitempty"`
	// TraceSampled: Optional. The sampling decision of the span associated with
	// the log entry at the time the log entry was created. This field corresponds
	// to the sampled flag in the W3C trace-context specification
	// (https://www.w3.org/TR/trace-context/#sampled-flag). A non-sampled trace
	// value is still useful as a request correlation identifier. The default is
	// False.
	TraceSampled bool `json:"traceSampled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Apphub") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Apphub") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogEntry) MarshalJSON() ([]byte, error) {
	type NoMethod LogEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogEntryOperation: Additional information about a potentially long-running
// operation with which a log entry is associated.
type LogEntryOperation struct {
	// First: Optional. Set this to True if this is the first log entry in the
	// operation.
	First bool `json:"first,omitempty"`
	// Id: Optional. An arbitrary operation identifier. Log entries with the same
	// identifier are assumed to be part of the same operation.
	Id string `json:"id,omitempty"`
	// Last: Optional. Set this to True if this is the last log entry in the
	// operation.
	Last bool `json:"last,omitempty"`
	// Producer: Optional. An arbitrary producer identifier. The combination of id
	// and producer must be globally unique. Examples for producer:
	// "MyDivision.MyBigCompany.com", "github.com/MyProject/MyApplication".
	Producer string `json:"producer,omitempty"`
	// ForceSendFields is a list of field names (e.g. "First") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "First") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogEntryOperation) MarshalJSON() ([]byte, error) {
	type NoMethod LogEntryOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogEntrySourceLocation: Additional information about the source code
// location that produced the log entry.
type LogEntrySourceLocation struct {
	// File: Optional. Source file name. Depending on the runtime environment, this
	// might be a simple name or a fully-qualified name.
	File string `json:"file,omitempty"`
	// Function: Optional. Human-readable name of the function or method being
	// invoked, with optional context such as the class or package name. This
	// information may be used in contexts such as the logs viewer, where a file
	// and line number are less meaningful. The format can vary by language. For
	// example: qual.if.ied.Class.method (Java), dir/package.func (Go), function
	// (Python).
	Function string `json:"function,omitempty"`
	// Line: Optional. Line within the source file. 1-based; 0 indicates no line
	// number available.
	Line int64 `json:"line,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "File") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "File") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogEntrySourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod LogEntrySourceLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogErrorGroup: Contains metadata that associates the LogEntry to Error
// Reporting error groups.
type LogErrorGroup struct {
	// Id: The id is a unique identifier for a particular error group; it is the
	// last part of the error group resource name:
	// /project/[PROJECT_ID]/errors/[ERROR_GROUP_ID]. Example: COShysOX0r_51QE. The
	// id is derived from key parts of the error-log content and is treated as
	// Service Data. For information about how Service Data is handled, see Google
	// Cloud Privacy Notice (https://cloud.google.com/terms/cloud-privacy-notice).
	Id string `json:"id,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogErrorGroup) MarshalJSON() ([]byte, error) {
	type NoMethod LogErrorGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogExclusion: Specifies a set of log entries that are filtered out by a
// sink. If your Google Cloud resource receives a large volume of log entries,
// you can use exclusions to reduce your chargeable logs. Note that exclusions
// on organization-level and folder-level sinks don't apply to child resources.
// Note also that you cannot modify the _Required sink or exclude logs from it.
type LogExclusion struct {
	// CreateTime: Output only. The creation timestamp of the exclusion.This field
	// may not be present for older exclusions.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A description of this exclusion.
	Description string `json:"description,omitempty"`
	// Disabled: Optional. If set to True, then this exclusion is disabled and it
	// does not exclude any log entries. You can update an exclusion to change the
	// value of this field.
	Disabled bool `json:"disabled,omitempty"`
	// Filter: Required. An advanced logs filter
	// (https://cloud.google.com/logging/docs/view/advanced-queries) that matches
	// the log entries to be excluded. By using the sample function
	// (https://cloud.google.com/logging/docs/view/advanced-queries#sample), you
	// can exclude less than 100% of the matching log entries.For example, the
	// following query matches 99% of low-severity log entries from Google Cloud
	// Storage buckets:resource.type=gcs_bucket severity<ERROR sample(insertId,
	// 0.99)
	Filter string `json:"filter,omitempty"`
	// Name: Optional. A client-assigned identifier, such as
	// "load-balancer-exclusion". Identifiers are limited to 100 characters and can
	// include only letters, digits, underscores, hyphens, and periods. First
	// character has to be alphanumeric.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The last update timestamp of the exclusion.This
	// field may not be present for older exclusions.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogExclusion) MarshalJSON() ([]byte, error) {
	type NoMethod LogExclusion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogLine: Application log line emitted while processing a request.
type LogLine struct {
	// LogMessage: App-provided log message.
	LogMessage string `json:"logMessage,omitempty"`
	// Severity: Severity of this log entry.
	//
	// Possible values:
	//   "DEFAULT" - (0) The log entry has no assigned severity level.
	//   "DEBUG" - (100) Debug or trace information.
	//   "INFO" - (200) Routine information, such as ongoing status or performance.
	//   "NOTICE" - (300) Normal but significant events, such as start up, shut
	// down, or a configuration change.
	//   "WARNING" - (400) Warning events might cause problems.
	//   "ERROR" - (500) Error events are likely to cause problems.
	//   "CRITICAL" - (600) Critical events cause more severe problems or outages.
	//   "ALERT" - (700) A person must take an action immediately.
	//   "EMERGENCY" - (800) One or more systems are unusable.
	Severity string `json:"severity,omitempty"`
	// SourceLocation: Where in the source code this log message was written.
	SourceLocation *SourceLocation `json:"sourceLocation,omitempty"`
	// Time: Approximate time when this log entry was made.
	Time string `json:"time,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LogMessage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LogMessage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogLine) MarshalJSON() ([]byte, error) {
	type NoMethod LogLine
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogMetric: Describes a logs-based metric. The value of the metric is the
// number of log entries that match a logs filter in a given time
// interval.Logs-based metrics can also be used to extract values from logs and
// create a distribution of the values. The distribution records the statistics
// of the extracted values along with an optional histogram of the values as
// specified by the bucket options.
type LogMetric struct {
	// BucketName: Optional. The resource name of the Log Bucket that owns the Log
	// Metric. Only Log Buckets in projects are supported. The bucket has to be in
	// the same project as the metric.For
	// example:projects/my-project/locations/global/buckets/my-bucketIf empty, then
	// the Log Metric is considered a non-Bucket Log Metric.
	BucketName string `json:"bucketName,omitempty"`
	// BucketOptions: Optional. The bucket_options are required when the logs-based
	// metric is using a DISTRIBUTION value type and it describes the bucket
	// boundaries used to create a histogram of the extracted values.
	BucketOptions *BucketOptions `json:"bucketOptions,omitempty"`
	// CreateTime: Output only. The creation timestamp of the metric.This field may
	// not be present for older metrics.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A description of this metric, which is used in
	// documentation. The maximum length of the description is 8000 characters.
	Description string `json:"description,omitempty"`
	// Disabled: Optional. If set to True, then this metric is disabled and it does
	// not generate any points.
	Disabled bool `json:"disabled,omitempty"`
	// Filter: Required. An advanced logs filter
	// (https://cloud.google.com/logging/docs/view/advanced_filters) which is used
	// to match log entries. Example: "resource.type=gae_app AND severity>=ERROR"
	// The maximum length of the filter is 20000 characters.
	Filter string `json:"filter,omitempty"`
	// LabelExtractors: Optional. A map from a label key string to an extractor
	// expression which is used to extract data from a log entry field and assign
	// as the label value. Each label key specified in the LabelDescriptor must
	// have an associated extractor expression in this map. The syntax of the
	// extractor expression is the same as for the value_extractor field.The
	// extracted value is converted to the type defined in the label descriptor. If
	// either the extraction or the type conversion fails, the label will have a
	// default value. The default value for a string label is an empty string, for
	// an integer label its 0, and for a boolean label its false.Note that there
	// are upper bounds on the maximum number of labels and the number of active
	// time series that are allowed in a project.
	LabelExtractors map[string]string `json:"labelExtractors,omitempty"`
	// MetricDescriptor: Optional. The metric descriptor associated with the
	// logs-based metric. If unspecified, it uses a default metric descriptor with
	// a DELTA metric kind, INT64 value type, with no labels and a unit of "1".
	// Such a metric counts the number of log entries matching the filter
	// expression.The name, type, and description fields in the metric_descriptor
	// are output only, and is constructed using the name and description field in
	// the LogMetric.To create a logs-based metric that records a distribution of
	// log values, a DELTA metric kind with a DISTRIBUTION value type must be used
	// along with a value_extractor expression in the LogMetric.Each label in the
	// metric descriptor must have a matching label name as the key and an
	// extractor expression as the value in the label_extractors map.The
	// metric_kind and value_type fields in the metric_descriptor cannot be updated
	// once initially configured. New labels can be added in the metric_descriptor,
	// but existing labels cannot be modified except for their description.
	MetricDescriptor *MetricDescriptor `json:"metricDescriptor,omitempty"`
	// Name: Required. The client-assigned metric identifier. Examples:
	// "error_count", "nginx/requests".Metric identifiers are limited to 100
	// characters and can include only the following characters: A-Z, a-z, 0-9, and
	// the special characters _-.,+!*',()%/. The forward-slash character (/)
	// denotes a hierarchy of name pieces, and it cannot be the first character of
	// the name.This field is the [METRIC_ID] part of a metric resource name in the
	// format "projects/PROJECT_ID/metrics/METRIC_ID". Example: If the resource
	// name of a metric is "projects/my-project/metrics/nginx%2Frequests", this
	// field's value is "nginx/requests".
	Name string `json:"name,omitempty"`
	// ResourceName: Output only. The resource name of the metric:
	// "projects/[PROJECT_ID]/metrics/[METRIC_ID]"
	ResourceName string `json:"resourceName,omitempty"`
	// UpdateTime: Output only. The last update timestamp of the metric.This field
	// may not be present for older metrics.
	UpdateTime string `json:"updateTime,omitempty"`
	// ValueExtractor: Optional. A value_extractor is required when using a
	// distribution logs-based metric to extract the values to record from a log
	// entry. Two functions are supported for value extraction: EXTRACT(field) or
	// REGEXP_EXTRACT(field, regex). The arguments are: field: The name of the log
	// entry field from which the value is to be extracted. regex: A regular
	// expression using the Google RE2 syntax
	// (https://github.com/google/re2/wiki/Syntax) with a single capture group to
	// extract data from the specified log entry field. The value of the field is
	// converted to a string before applying the regex. It is an error to specify a
	// regex that does not include exactly one capture group.The result of the
	// extraction must be convertible to a double type, as the distribution always
	// records double values. If either the extraction or the conversion to double
	// fails, then those values are not recorded in the distribution.Example:
	// REGEXP_EXTRACT(jsonPayload.request, ".*quantity=(\d+).*")
	ValueExtractor string `json:"valueExtractor,omitempty"`
	// Version: Deprecated. The API version that created or updated this metric.
	// The v2 format is used by default and cannot be changed.
	//
	// Possible values:
	//   "V2" - Logging API v2.
	//   "V1" - Logging API v1.
	Version string `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BucketName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogMetric) MarshalJSON() ([]byte, error) {
	type NoMethod LogMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogScope: Describes a group of resources to read log entries from.
type LogScope struct {
	// CreateTime: Output only. The creation timestamp of the log scope.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Describes this log scope.The maximum length of the
	// description is 8000 characters.
	Description string `json:"description,omitempty"`
	// Name: Output only. The resource name of the log scope.Log scopes are only
	// available in the global location. For
	// example:projects/my-project/locations/global/logScopes/my-log-scope
	Name string `json:"name,omitempty"`
	// ResourceNames: Required. Names of one or more parent resources
	// (organizations and folders are not supported.): projects/[PROJECT_ID]May
	// alternatively be one or more views:
	// projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW
	// _ID]A log scope can include a maximum of 5 projects and a maximum of 100
	// resources in total.
	ResourceNames []string `json:"resourceNames,omitempty"`
	// UpdateTime: Output only. The last update timestamp of the log scope.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogScope) MarshalJSON() ([]byte, error) {
	type NoMethod LogScope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogSink: Describes a sink used to export log entries to one of the following
// destinations: a Cloud Logging log bucket, a Cloud Storage bucket, a BigQuery
// dataset, a Pub/Sub topic, a Cloud project.A logs filter controls which log
// entries are exported. The sink must be created within a project,
// organization, billing account, or folder.
type LogSink struct {
	// BigqueryOptions: Optional. Options that affect sinks exporting data to
	// BigQuery.
	BigqueryOptions *BigQueryOptions `json:"bigqueryOptions,omitempty"`
	// CreateTime: Output only. The creation timestamp of the sink.This field may
	// not be present for older sinks.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A description of this sink.The maximum length of the
	// description is 8000 characters.
	Description string `json:"description,omitempty"`
	// Destination: Required. The export destination:
	// "storage.googleapis.com/[GCS_BUCKET]"
	// "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]"
	// "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]"
	// "logging.googleapis.com/projects/[PROJECT_ID]"
	// "logging.googleapis.com/projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets
	// /[BUCKET_ID]" The sink's writer_identity, set when the sink is created, must
	// have permission to write to the destination or else the log entries are not
	// exported. For more information, see Exporting Logs with Sinks
	// (https://cloud.google.com/logging/docs/api/tasks/exporting-logs).
	Destination string `json:"destination,omitempty"`
	// Disabled: Optional. If set to true, then this sink is disabled and it does
	// not export any log entries.
	Disabled bool `json:"disabled,omitempty"`
	// Exclusions: Optional. Log entries that match any of these exclusion filters
	// will not be exported.If a log entry is matched by both filter and one of
	// exclusions it will not be exported.
	Exclusions []*LogExclusion `json:"exclusions,omitempty"`
	// Filter: Optional. An advanced logs filter
	// (https://cloud.google.com/logging/docs/view/advanced-queries). The only
	// exported log entries are those that are in the resource owning the sink and
	// that match the filter.For
	// example:logName="projects/[PROJECT_ID]/logs/[LOG_ID]" AND severity>=ERROR
	Filter string `json:"filter,omitempty"`
	// IncludeChildren: Optional. This field applies only to sinks owned by
	// organizations and folders. If the field is false, the default, only the logs
	// owned by the sink's parent resource are available for export. If the field
	// is true, then log entries from all the projects, folders, and billing
	// accounts contained in the sink's parent resource are also available for
	// export. Whether a particular log entry from the children is exported depends
	// on the sink's filter expression.For example, if this field is true, then the
	// filter resource.type=gce_instance would export all Compute Engine VM
	// instance log entries from all projects in the sink's parent.To only export
	// entries from certain child projects, filter on the project part of the log
	// name:logName:("projects/test-project1/" OR "projects/test-project2/") AND
	// resource.type=gce_instance
	IncludeChildren bool `json:"includeChildren,omitempty"`
	// InterceptChildren: Optional. This field applies only to sinks owned by
	// organizations and folders.When the value of 'intercept_children' is true,
	// the following restrictions apply: The sink must have the include_children
	// flag set to true. The sink destination must be a Cloud project.Also, the
	// following behaviors apply: Any logs matched by the sink won't be included by
	// non-_Required sinks owned by child resources. The sink appears in the
	// results of a ListSinks call from a child resource if the value of the filter
	// field in its request is either 'in_scope("ALL")' or 'in_scope("ANCESTOR")'.
	InterceptChildren bool `json:"interceptChildren,omitempty"`
	// Name: Optional. The client-assigned sink identifier, unique within the
	// project.For example: "my-syslog-errors-to-pubsub".Sink identifiers are
	// limited to 100 characters and can include only the following characters:
	// upper and lower-case alphanumeric characters, underscores, hyphens,
	// periods.First character has to be alphanumeric.
	Name string `json:"name,omitempty"`
	// OutputVersionFormat: Deprecated. This field is unused.
	//
	// Possible values:
	//   "VERSION_FORMAT_UNSPECIFIED" - An unspecified format version that will
	// default to V2.
	//   "V2" - LogEntry version 2 format.
	//   "V1" - LogEntry version 1 format.
	OutputVersionFormat string `json:"outputVersionFormat,omitempty"`
	// ResourceName: Output only. The resource name of the sink.
	// "projects/[PROJECT_ID]/sinks/[SINK_NAME]
	// "organizations/[ORGANIZATION_ID]/sinks/[SINK_NAME]
	// "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_NAME]
	// "folders/[FOLDER_ID]/sinks/[SINK_NAME] For example:
	// projects/my_project/sinks/SINK_NAME
	ResourceName string `json:"resourceName,omitempty"`
	// UpdateTime: Output only. The last update timestamp of the sink.This field
	// may not be present for older sinks.
	UpdateTime string `json:"updateTime,omitempty"`
	// WriterIdentity: Output only. An IAM identity—a service account or
	// group—under which Cloud Logging writes the exported log entries to the
	// sink's destination. This field is either set by specifying
	// custom_writer_identity or set automatically by sinks.create and sinks.update
	// based on the value of unique_writer_identity in those methods.Until you
	// grant this identity write-access to the destination, log entry exports from
	// this sink will fail. For more information, see Granting Access for a
	// Resource
	// (https://cloud.google.com/iam/docs/granting-roles-to-service-accounts#granting_access_to_a_service_account_for_a_resource).
	// Consult the destination service's documentation to determine the appropriate
	// IAM roles to assign to the identity.Sinks that have a destination that is a
	// log bucket in the same project as the sink cannot have a writer_identity and
	// no additional permissions are required.
	WriterIdentity string `json:"writerIdentity,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BigqueryOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BigqueryOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogSink) MarshalJSON() ([]byte, error) {
	type NoMethod LogSink
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogSplit: Additional information used to correlate multiple log entries.
// Used when a single LogEntry would exceed the Google Cloud Logging size limit
// and is split across multiple log entries.
type LogSplit struct {
	// Index: The index of this LogEntry in the sequence of split log entries. Log
	// entries are given |index| values 0, 1, ..., n-1 for a sequence of n log
	// entries.
	Index int64 `json:"index,omitempty"`
	// TotalSplits: The total number of log entries that the original LogEntry was
	// split into.
	TotalSplits int64 `json:"totalSplits,omitempty"`
	// Uid: A globally unique identifier for all log entries in a sequence of split
	// log entries. All log entries with the same |LogSplit.uid| are assumed to be
	// part of the same sequence of split log entries.
	Uid string `json:"uid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Index") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Index") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogSplit) MarshalJSON() ([]byte, error) {
	type NoMethod LogSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LogView: Describes a view over log entries in a bucket.
type LogView struct {
	// CreateTime: Output only. The creation timestamp of the view.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Describes this view.
	Description string `json:"description,omitempty"`
	// Filter: Optional. Filter that restricts which log entries in a bucket are
	// visible in this view.Filters must be logical conjunctions that use the AND
	// operator, and they can use any of the following qualifiers: SOURCE(), which
	// specifies a project, folder, organization, or billing account of origin.
	// resource.type, which specifies the resource type. LOG_ID(), which identifies
	// the log.They can also use the negations of these qualifiers with the NOT
	// operator.For example:SOURCE("projects/myproject") AND resource.type =
	// "gce_instance" AND NOT LOG_ID("stdout")
	Filter string `json:"filter,omitempty"`
	// Name: Output only. The resource name of the view.For
	// example:projects/my-project/locations/global/buckets/my-bucket/views/my-view
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. The last update timestamp of the view.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LogView) MarshalJSON() ([]byte, error) {
	type NoMethod LogView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoggingQuery: Describes a Cloud Logging query that can be run in Logs
// Explorer UI or via the logging API.In addition to the query itself,
// additional information may be stored to capture the display configuration
// and other UI state used in association with analysis of query results.
type LoggingQuery struct {
	// Filter: Required. An advanced query using the Logging Query Language
	// (https://cloud.google.com/logging/docs/view/logging-query-language). The
	// maximum length of the filter is 20000 characters.
	Filter string `json:"filter,omitempty"`
	// SummaryFieldEnd: Characters will be counted from the end of the string.
	SummaryFieldEnd int64 `json:"summaryFieldEnd,omitempty"`
	// SummaryFieldStart: Characters will be counted from the start of the string.
	SummaryFieldStart int64 `json:"summaryFieldStart,omitempty"`
	// SummaryFields: Optional. The set of summary fields to display for this saved
	// query.
	SummaryFields []*SummaryField `json:"summaryFields,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoggingQuery) MarshalJSON() ([]byte, error) {
	type NoMethod LoggingQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MetricDescriptor: Defines a metric type and its schema. Once a metric
// descriptor is created, deleting or altering it stops data collection and
// makes the metric type's existing data unusable.
type MetricDescriptor struct {
	// Description: A detailed description of the metric, which can be used in
	// documentation.
	Description string `json:"description,omitempty"`
	// DisplayName: A concise name for the metric, which can be displayed in user
	// interfaces. Use sentence case without an ending period, for example "Request
	// count". This field is optional but it is recommended to be set for any
	// metrics associated with user-visible concepts, such as Quota.
	DisplayName string `json:"displayName,omitempty"`
	// Labels: The set of labels that can be used to describe a specific instance
	// of this metric type. For example, the
	// appengine.googleapis.com/http/server/response_latencies metric type has a
	// label for the HTTP response code, response_code, so you can look at
	// latencies for successful responses or just for responses that failed.
	Labels []*LabelDescriptor `json:"labels,omitempty"`
	// LaunchStage: Optional. The launch stage of the metric definition.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// Terms of Service (https://cloud.google.com/terms/) and the Google Cloud
	// Platform Subject to the Deprecation Policy
	// (https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`
	// Metadata: Optional. Metadata which can be used to guide usage of the metric.
	Metadata *MetricDescriptorMetadata `json:"metadata,omitempty"`
	// MetricKind: Whether the metric records instantaneous values, changes to a
	// value, etc. Some combinations of metric_kind and value_type might not be
	// supported.
	//
	// Possible values:
	//   "METRIC_KIND_UNSPECIFIED" - Do not use this default value.
	//   "GAUGE" - An instantaneous measurement of a value.
	//   "DELTA" - The change in a value during a time interval.
	//   "CUMULATIVE" - A value accumulated over a time interval. Cumulative
	// measurements in a time series should have the same start time and increasing
	// end times, until an event resets the cumulative value to zero and sets a new
	// start time for the following points.
	MetricKind string `json:"metricKind,omitempty"`
	// MonitoredResourceTypes: Read-only. If present, then a time series, which is
	// identified partially by a metric type and a MonitoredResourceDescriptor,
	// that is associated with this metric type can only be associated with one of
	// the monitored resource types listed here.
	MonitoredResourceTypes []string `json:"monitoredResourceTypes,omitempty"`
	// Name: The resource name of the metric descriptor.
	Name string `json:"name,omitempty"`
	// Type: The metric type, including its DNS name prefix. The type is not
	// URL-encoded. All user-defined metric types have the DNS name
	// custom.googleapis.com or external.googleapis.com. Metric types should use a
	// natural hierarchical grouping. For example:
	// "custom.googleapis.com/invoice/paid/amount"
	// "external.googleapis.com/prometheus/up"
	// "appengine.googleapis.com/http/server/response_latencies"
	Type string `json:"type,omitempty"`
	// Unit: The units in which the metric value is reported. It is only applicable
	// if the value_type is INT64, DOUBLE, or DISTRIBUTION. The unit defines the
	// representation of the stored metric values.Different systems might scale the
	// values to be more easily displayed (so a value of 0.02kBy might be displayed
	// as 20By, and a value of 3523kBy might be displayed as 3.5MBy). However, if
	// the unit is kBy, then the value of the metric is always in thousands of
	// bytes, no matter how it might be displayed.If you want a custom metric to
	// record the exact number of CPU-seconds used by a job, you can create an
	// INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently 1s{CPU} or
	// just s). If the job uses 12,005 CPU-seconds, then the value is written as
	// 12005.Alternatively, if you want a custom metric to record data in a more
	// granular way, you can create a DOUBLE CUMULATIVE metric whose unit is
	// ks{CPU}, and then write the value 12.005 (which is 12005/1000), or use
	// Kis{CPU} and write 11.723 (which is 12005/1024).The supported units are a
	// subset of The Unified Code for Units of Measure
	// (https://unitsofmeasure.org/ucum.html) standard:Basic units (UNIT) bit bit
	// By byte s second min minute h hour d day 1 dimensionlessPrefixes (PREFIX) k
	// kilo (10^3) M mega (10^6) G giga (10^9) T tera (10^12) P peta (10^15) E exa
	// (10^18) Z zetta (10^21) Y yotta (10^24) m milli (10^-3) u micro (10^-6) n
	// nano (10^-9) p pico (10^-12) f femto (10^-15) a atto (10^-18) z zepto
	// (10^-21) y yocto (10^-24) Ki kibi (2^10) Mi mebi (2^20) Gi gibi (2^30) Ti
	// tebi (2^40) Pi pebi (2^50)GrammarThe grammar also includes these connectors:
	// / division or ratio (as an infix operator). For examples, kBy/{email} or
	// MiBy/10ms (although you should almost never have /s in a metric unit; rates
	// should always be computed at query time from the underlying cumulative or
	// delta value). . multiplication or composition (as an infix operator). For
	// examples, GBy.d or k{watt}.h.The grammar for a unit is as follows:
	// Expression = Component { "." Component } { "/" Component } ; Component = ( [
	// PREFIX ] UNIT | "%" ) [ Annotation ] | Annotation | "1" ; Annotation = "{"
	// NAME "}" ; Notes: Annotation is just a comment if it follows a UNIT. If the
	// annotation is used alone, then the unit is equivalent to 1. For examples,
	// {request}/s == 1/s, By{transmitted}/s == By/s. NAME is a sequence of
	// non-blank printable ASCII characters not containing { or }. 1 represents a
	// unitary dimensionless unit
	// (https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such as in 1/s.
	// It is typically used when none of the basic units are appropriate. For
	// example, "new users per day" can be represented as 1/d or {new-users}/d (and
	// a metric value 5 would mean "5 new users). Alternatively, "thousands of page
	// views per day" would be represented as 1000/d or k1/d or k{page_views}/d
	// (and a metric value of 5.3 would mean "5300 page views per day"). %
	// represents dimensionless value of 1/100, and annotates values giving a
	// percentage (so the metric values are typically in the range of 0..100, and a
	// metric value 3 means "3 percent"). 10^2.% indicates a metric contains a
	// ratio, typically in the range 0..1, that will be multiplied by 100 and
	// displayed as a percentage (so a metric value 0.03 means "3 percent").
	Unit string `json:"unit,omitempty"`
	// ValueType: Whether the measurement is an integer, a floating-point number,
	// etc. Some combinations of metric_kind and value_type might not be supported.
	//
	// Possible values:
	//   "VALUE_TYPE_UNSPECIFIED" - Do not use this default value.
	//   "BOOL" - The value is a boolean. This value type can be used only if the
	// metric kind is GAUGE.
	//   "INT64" - The value is a signed 64-bit integer.
	//   "DOUBLE" - The value is a double precision floating point number.
	//   "STRING" - The value is a text string. This value type can be used only if
	// the metric kind is GAUGE.
	//   "DISTRIBUTION" - The value is a Distribution.
	//   "MONEY" - The value is money.
	ValueType string `json:"valueType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MetricDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod MetricDescriptor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MetricDescriptorMetadata: Additional annotations that can be used to guide
// the usage of a metric.
type MetricDescriptorMetadata struct {
	// IngestDelay: The delay of data points caused by ingestion. Data points older
	// than this age are guaranteed to be ingested and available to be read,
	// excluding data loss due to errors.
	IngestDelay string `json:"ingestDelay,omitempty"`
	// LaunchStage: Deprecated. Must use the MetricDescriptor.launch_stage instead.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// Terms of Service (https://cloud.google.com/terms/) and the Google Cloud
	// Platform Subject to the Deprecation Policy
	// (https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`
	// SamplePeriod: The sampling period of metric data points. For metrics which
	// are written periodically, consecutive data points are stored at this time
	// interval, excluding data loss due to errors. Metrics with a higher
	// granularity have a smaller sampling period.
	SamplePeriod string `json:"samplePeriod,omitempty"`
	// TimeSeriesResourceHierarchyLevel: The scope of the timeseries data of the
	// metric.
	//
	// Possible values:
	//   "TIME_SERIES_RESOURCE_HIERARCHY_LEVEL_UNSPECIFIED" - Do not use this
	// default value.
	//   "PROJECT" - Scopes a metric to a project.
	//   "ORGANIZATION" - Scopes a metric to an organization.
	//   "FOLDER" - Scopes a metric to a folder.
	TimeSeriesResourceHierarchyLevel []string `json:"timeSeriesResourceHierarchyLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IngestDelay") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IngestDelay") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MetricDescriptorMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod MetricDescriptorMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MonitoredResource: An object representing a resource that can be used for
// monitoring, logging, billing, or other purposes. Examples include virtual
// machine instances, databases, and storage devices such as disks. The type
// field identifies a MonitoredResourceDescriptor object that describes the
// resource's schema. Information in the labels field identifies the actual
// resource and its attributes according to the schema. For example, a
// particular Compute Engine VM instance could be represented by the following
// object, because the MonitoredResourceDescriptor for "gce_instance" has
// labels "project_id", "instance_id" and "zone": { "type": "gce_instance",
// "labels": { "project_id": "my-project", "instance_id": "12345678901234",
// "zone": "us-central1-a" }}
type MonitoredResource struct {
	// Labels: Required. Values for all of the labels listed in the associated
	// monitored resource descriptor. For example, Compute Engine VM instances use
	// the labels "project_id", "instance_id", and "zone".
	Labels map[string]string `json:"labels,omitempty"`
	// Type: Required. The monitored resource type. This field must match the type
	// field of a MonitoredResourceDescriptor object. For example, the type of a
	// Compute Engine VM instance is gce_instance. Some descriptors include the
	// service name in the type; for example, the type of a Datastream stream is
	// datastream.googleapis.com/Stream.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MonitoredResource) MarshalJSON() ([]byte, error) {
	type NoMethod MonitoredResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MonitoredResourceDescriptor: An object that describes the schema of a
// MonitoredResource object using a type name and a set of labels. For example,
// the monitored resource descriptor for Google Compute Engine VM instances has
// a type of "gce_instance" and specifies the use of the labels "instance_id"
// and "zone" to identify particular VM instances.Different APIs can support
// different monitored resource types. APIs generally provide a list method
// that returns the monitored resource descriptors used by the API.
type MonitoredResourceDescriptor struct {
	// Description: Optional. A detailed description of the monitored resource type
	// that might be used in documentation.
	Description string `json:"description,omitempty"`
	// DisplayName: Optional. A concise name for the monitored resource type that
	// might be displayed in user interfaces. It should be a Title Cased Noun
	// Phrase, without any article or other determiners. For example, "Google Cloud
	// SQL Database".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Required. A set of labels used to describe instances of this
	// monitored resource type. For example, an individual Google Cloud SQL
	// database is identified by values for the labels "database_id" and "zone".
	Labels []*LabelDescriptor `json:"labels,omitempty"`
	// LaunchStage: Optional. The launch stage of the monitored resource
	// definition.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// Terms of Service (https://cloud.google.com/terms/) and the Google Cloud
	// Platform Subject to the Deprecation Policy
	// (https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`
	// Name: Optional. The resource name of the monitored resource descriptor:
	// "projects/{project_id}/monitoredResourceDescriptors/{type}" where {type} is
	// the value of the type field in this object and {project_id} is a project ID
	// that provides API-specific context for accessing the type. APIs that do not
	// use project information can use the resource name format
	// "monitoredResourceDescriptors/{type}".
	Name string `json:"name,omitempty"`
	// Type: Required. The monitored resource type. For example, the type
	// "cloudsql_database" represents databases in Google Cloud SQL. For a list of
	// types, see Monitored resource types
	// (https://cloud.google.com/monitoring/api/resources) and Logging resource
	// types (https://cloud.google.com/logging/docs/api/v2/resource-list).
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MonitoredResourceDescriptor) MarshalJSON() ([]byte, error) {
	type NoMethod MonitoredResourceDescriptor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MonitoredResourceMetadata: Auxiliary metadata for a MonitoredResource
// object. MonitoredResource objects contain the minimum set of information to
// uniquely identify a monitored resource instance. There is some other useful
// auxiliary metadata. Monitoring and Logging use an ingestion pipeline to
// extract metadata for cloud resources of all types, and store the metadata in
// this message.
type MonitoredResourceMetadata struct {
	// SystemLabels: Output only. Values for predefined system metadata labels.
	// System labels are a kind of metadata extracted by Google, including
	// "machine_image", "vpc", "subnet_id", "security_group", "name", etc. System
	// label values can be only strings, Boolean values, or a list of strings. For
	// example: { "name": "my-test-instance", "security_group": ["a", "b", "c"],
	// "spot_instance": false }
	SystemLabels googleapi.RawMessage `json:"systemLabels,omitempty"`
	// UserLabels: Output only. A map of user-defined metadata labels.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SystemLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SystemLabels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MonitoredResourceMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod MonitoredResourceMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is false, it means the operation is still in progress. If
	// true, the operation is completed, and either error or response is available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the name
	// should be a resource name ending with operations/{unique_id}.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as Delete, the response is
	// google.protobuf.Empty. If the original method is standard Get/Create/Update,
	// the response should be the resource. For other methods, the response should
	// have the type XxxResponse, where Xxx is the original method name. For
	// example, if the original method name is TakeSnapshot(), the inferred
	// response type is TakeSnapshotResponse.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OpsAnalyticsQuery: Describes an analytics query that can be run in the Log
// Analytics page of Google Cloud console.Preview: This is a preview feature
// and may be subject to change before final release.
type OpsAnalyticsQuery struct {
	// SqlQueryText: Required. A logs analytics SQL query, which generally follows
	// BigQuery format.This is the SQL query that appears in the Log Analytics UI's
	// query editor.
	SqlQueryText string `json:"sqlQueryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SqlQueryText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SqlQueryText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OpsAnalyticsQuery) MarshalJSON() ([]byte, error) {
	type NoMethod OpsAnalyticsQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources.A Policy is a collection of
// bindings. A binding binds one or more members, or principals, to a single
// role. Principals can be user accounts, service accounts, Google groups, and
// domains (such as G Suite). A role is a named list of permissions; each role
// can be an IAM predefined role or a user-created custom role.For some types
// of Google Cloud resources, a binding can also specify a condition, which is
// a logical expression that allows access to a resource only if the expression
// evaluates to true. A condition can add constraints based on attributes of
// the request, the resource, or both. To learn which resources support
// conditions in their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).JSON
// example: { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } YAML example: bindings: - members: -
// user:mike@example.com - group:admins@example.com - domain:google.com -
// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
// roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
// role: roles/resourcemanager.organizationViewer condition: title: expirable
// access description: Does not grant access after Sep 2020 expression:
// request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
// version: 3 For a description of IAM and its features, see the IAM
// documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// Bindings: Associates a list of members, or principals, with a role.
	// Optionally, may specify a condition that determines how and when the
	// bindings are applied. Each of the bindings must contain at least one
	// principal.The bindings in a Policy can refer to up to 1,500 principals; up
	// to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the bindings grant 50
	// different roles to user:alice@example.com, and not to any other principal,
	// then you can add another 1,450 principals to the bindings in the Policy.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: etag is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the etag in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An etag is returned in the response to getIamPolicy, and systems
	// are expected to put that etag in the request to setIamPolicy to ensure that
	// their change will be applied to the same version of the policy.Important: If
	// you use IAM Conditions, you must include the etag field whenever you call
	// setIamPolicy. If you omit this field, then IAM allows you to overwrite a
	// version 3 policy with a version 1 policy, and all of the conditions in the
	// version 3 policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy.Valid values are 0, 1, and 3.
	// Requests that specify an invalid value are rejected.Any operation that
	// affects conditional role bindings must specify version 3. This requirement
	// applies to the following operations: Getting a policy that includes a
	// conditional role binding Adding a conditional role binding to a policy
	// Changing a conditional role binding in a policy Removing any role binding,
	// with or without a condition, from a policy that includes
	// conditionsImportant: If you use IAM Conditions, you must include the etag
	// field whenever you call setIamPolicy. If you omit this field, then IAM
	// allows you to overwrite a version 3 policy with a version 1 policy, and all
	// of the conditions in the version 3 policy are lost.If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset.To learn which resources support conditions
	// in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bindings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RecentQuery: Describes a recent query executed on the Logs Explorer or Log
// Analytics page within the last ~ 30 days.
type RecentQuery struct {
	// LastRunTime: Output only. The timestamp when this query was last run.
	LastRunTime string `json:"lastRunTime,omitempty"`
	// LoggingQuery: Logging query that can be executed in Logs Explorer or via
	// Logging API.
	LoggingQuery *LoggingQuery `json:"loggingQuery,omitempty"`
	// Name: Output only. Resource name of the recent query.In the format:
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]/recentQueries/[QUERY_ID]" For
	// a list of supported locations, see Supported Regions
	// (https://cloud.google.com/logging/docs/region-support)The QUERY_ID is a
	// system generated alphanumeric ID.
	Name string `json:"name,omitempty"`
	// OpsAnalyticsQuery: Analytics query that can be executed in Log Analytics.
	OpsAnalyticsQuery *OpsAnalyticsQuery `json:"opsAnalyticsQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastRunTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastRunTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RecentQuery) MarshalJSON() ([]byte, error) {
	type NoMethod RecentQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RequestLog: Complete log information about a single HTTP request to an App
// Engine application.
type RequestLog struct {
	// AppEngineRelease: App Engine release version.
	AppEngineRelease string `json:"appEngineRelease,omitempty"`
	// AppId: Application that handled this request.
	AppId string `json:"appId,omitempty"`
	// Cost: An indication of the relative cost of serving this request.
	Cost float64 `json:"cost,omitempty"`
	// EndTime: Time when the request finished.
	EndTime string `json:"endTime,omitempty"`
	// Finished: Whether this request is finished or active.
	Finished bool `json:"finished,omitempty"`
	// First: Whether this is the first RequestLog entry for this request. If an
	// active request has several RequestLog entries written to Stackdriver
	// Logging, then this field will be set for one of them.
	First bool `json:"first,omitempty"`
	// Host: Internet host and port number of the resource being requested.
	Host string `json:"host,omitempty"`
	// HttpVersion: HTTP version of request. Example: "HTTP/1.1".
	HttpVersion string `json:"httpVersion,omitempty"`
	// InstanceId: An identifier for the instance that handled the request.
	InstanceId string `json:"instanceId,omitempty"`
	// InstanceIndex: If the instance processing this request belongs to a manually
	// scaled module, then this is the 0-based index of the instance. Otherwise,
	// this value is -1.
	InstanceIndex int64 `json:"instanceIndex,omitempty"`
	// Ip: Origin IP address.
	Ip string `json:"ip,omitempty"`
	// Latency: Latency of the request.
	Latency string `json:"latency,omitempty"`
	// Line: A list of log lines emitted by the application while serving this
	// request.
	Line []*LogLine `json:"line,omitempty"`
	// MegaCycles: Number of CPU megacycles used to process request.
	MegaCycles int64 `json:"megaCycles,omitempty,string"`
	// Method: Request method. Example: "GET", "HEAD", "PUT", "POST", "DELETE".
	Method string `json:"method,omitempty"`
	// ModuleId: Module of the application that handled this request.
	ModuleId string `json:"moduleId,omitempty"`
	// Nickname: The logged-in user who made the request.Most likely, this is the
	// part of the user's email before the @ sign. The field value is the same for
	// different requests from the same user, but different users can have similar
	// names. This information is also available to the application via the App
	// Engine Users API.This field will be populated starting with App Engine
	// 1.9.21.
	Nickname string `json:"nickname,omitempty"`
	// PendingTime: Time this request spent in the pending request queue.
	PendingTime string `json:"pendingTime,omitempty"`
	// Referrer: Referrer URL of request.
	Referrer string `json:"referrer,omitempty"`
	// RequestId: Globally unique identifier for a request, which is based on the
	// request start time. Request IDs for requests which started later will
	// compare greater as strings than those for requests which started earlier.
	RequestId string `json:"requestId,omitempty"`
	// Resource: Contains the path and query portion of the URL that was requested.
	// For example, if the URL was "http://example.com/app?name=val", the resource
	// would be "/app?name=val". The fragment identifier, which is identified by
	// the # character, is not included.
	Resource string `json:"resource,omitempty"`
	// ResponseSize: Size in bytes sent back to client by request.
	ResponseSize int64 `json:"responseSize,omitempty,string"`
	// SourceReference: Source code for the application that handled this request.
	// There can be more than one source reference per deployed application if
	// source code is distributed among multiple repositories.
	SourceReference []*SourceReference `json:"sourceReference,omitempty"`
	// SpanId: Stackdriver Trace span identifier for this request.
	SpanId string `json:"spanId,omitempty"`
	// StartTime: Time when the request started.
	StartTime string `json:"startTime,omitempty"`
	// Status: HTTP response status code. Example: 200, 404.
	Status int64 `json:"status,omitempty"`
	// TaskName: Task name of the request, in the case of an offline request.
	TaskName string `json:"taskName,omitempty"`
	// TaskQueueName: Queue name of the request, in the case of an offline request.
	TaskQueueName string `json:"taskQueueName,omitempty"`
	// TraceId: Stackdriver Trace identifier for this request.
	TraceId string `json:"traceId,omitempty"`
	// TraceSampled: If true, the value in the 'trace_id' field was sampled for
	// storage in a trace backend.
	TraceSampled bool `json:"traceSampled,omitempty"`
	// UrlMapEntry: File or class that handled the request.
	UrlMapEntry string `json:"urlMapEntry,omitempty"`
	// UserAgent: User agent that made the request.
	UserAgent string `json:"userAgent,omitempty"`
	// VersionId: Version of the application that handled this request.
	VersionId string `json:"versionId,omitempty"`
	// WasLoadingRequest: Whether this was a loading request for the instance.
	WasLoadingRequest bool `json:"wasLoadingRequest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppEngineRelease") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppEngineRelease") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RequestLog) MarshalJSON() ([]byte, error) {
	type NoMethod RequestLog
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *RequestLog) UnmarshalJSON(data []byte) error {
	type NoMethod RequestLog
	var s1 struct {
		Cost gensupport.JSONFloat64 `json:"cost"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Cost = float64(s1.Cost)
	return nil
}

// SavedQuery: Describes a query that has been saved by a user.
type SavedQuery struct {
	// CreateTime: Output only. The timestamp when the saved query was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. A human readable description of the saved query.
	Description string `json:"description,omitempty"`
	// DisplayName: Required. The user specified title for the SavedQuery.
	DisplayName string `json:"displayName,omitempty"`
	// LoggingQuery: Logging query that can be executed in Logs Explorer or via
	// Logging API.
	LoggingQuery *LoggingQuery `json:"loggingQuery,omitempty"`
	// Name: Output only. Resource name of the saved query.In the format:
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]" For
	// a list of supported locations, see Supported Regions
	// (https://cloud.google.com/logging/docs/region-support#bucket-regions)After
	// the saved query is created, the location cannot be changed.If the user
	// doesn't provide a QUERY_ID, the system will generate an alphanumeric ID.
	Name string `json:"name,omitempty"`
	// OpsAnalyticsQuery: Analytics query that can be executed in Log Analytics.
	OpsAnalyticsQuery *OpsAnalyticsQuery `json:"opsAnalyticsQuery,omitempty"`
	// UpdateTime: Output only. The timestamp when the saved query was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Visibility: Required. The visibility status of this query, which determines
	// its ownership.
	//
	// Possible values:
	//   "VISIBILITY_UNSPECIFIED" - The saved query visibility is unspecified. A
	// CreateSavedQuery request with an unspecified visibility will be rejected.
	//   "PRIVATE" - The saved query is only visible to the user that created it.
	//   "SHARED" - The saved query is visible to anyone in the project.
	Visibility string `json:"visibility,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SavedQuery) MarshalJSON() ([]byte, error) {
	type NoMethod SavedQuery
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for SetIamPolicy method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the resource. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used:paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Settings: Describes the settings associated with a project, folder,
// organization, or billing account.
type Settings struct {
	// DefaultSinkConfig: Optional. Overrides the built-in configuration for
	// _Default sink.
	DefaultSinkConfig *DefaultSinkConfig `json:"defaultSinkConfig,omitempty"`
	// DisableDefaultSink: Optional. If set to true, the _Default sink in newly
	// created projects and folders will created in a disabled state. This can be
	// used to automatically disable log storage if there is already an aggregated
	// sink configured in the hierarchy. The _Default sink can be re-enabled
	// manually if needed.
	DisableDefaultSink bool `json:"disableDefaultSink,omitempty"`
	// KmsKeyName: Optional. The resource name for the configured Cloud KMS key.KMS
	// key name format:
	// "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KE
	// Y]" For
	// example:"projects/my-project/locations/us-central1/keyRings/my-ring/cryptoKey
	// s/my-key"To enable CMEK, set this field to a valid kms_key_name for which
	// the associated service account has the required
	// roles/cloudkms.cryptoKeyEncrypterDecrypter role assigned for the key.The
	// Cloud KMS key used by the Log Router can be updated by changing the
	// kms_key_name to a new valid key name.To disable CMEK for the Log Router, set
	// this field to an empty string.See Enabling CMEK for Log Router
	// (https://cloud.google.com/logging/docs/routing/managed-encryption) for more
	// information.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// KmsServiceAccountId: Output only. The service account that will be used by
	// the Log Router to access your Cloud KMS key.Before enabling CMEK, you must
	// first assign the role roles/cloudkms.cryptoKeyEncrypterDecrypter to the
	// service account that will be used to access your Cloud KMS key. Use
	// GetSettings to obtain the service account ID.See Enabling CMEK for Log
	// Router (https://cloud.google.com/logging/docs/routing/managed-encryption)
	// for more information.
	KmsServiceAccountId string `json:"kmsServiceAccountId,omitempty"`
	// LoggingServiceAccountId: Output only. The service account for the given
	// resource container, such as project or folder. Log sinks use this service
	// account as their writer_identity if no custom service account is provided in
	// the request when calling the create sink method.
	LoggingServiceAccountId string `json:"loggingServiceAccountId,omitempty"`
	// Name: Output only. The resource name of the settings.
	Name string `json:"name,omitempty"`
	// StorageLocation: Optional. The storage location for the _Default and
	// _Required log buckets of newly created projects and folders, unless the
	// storage location is explicitly provided.Example value: europe-west1.Note:
	// this setting does not affect the location of resources where a location is
	// explicitly provided when created, such as custom log buckets.
	StorageLocation string `json:"storageLocation,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DefaultSinkConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultSinkConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Settings) MarshalJSON() ([]byte, error) {
	type NoMethod Settings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SourceLocation: Specifies a location in a source code file.
type SourceLocation struct {
	// File: Source file name. Depending on the runtime environment, this might be
	// a simple name or a fully-qualified name.
	File string `json:"file,omitempty"`
	// FunctionName: Human-readable name of the function or method being invoked,
	// with optional context such as the class or package name. This information is
	// used in contexts such as the logs viewer, where a file and line number are
	// less meaningful. The format can vary by language. For example:
	// qual.if.ied.Class.method (Java), dir/package.func (Go), function (Python).
	FunctionName string `json:"functionName,omitempty"`
	// Line: Line within the source file.
	Line int64 `json:"line,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "File") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "File") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SourceLocation) MarshalJSON() ([]byte, error) {
	type NoMethod SourceLocation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SourceReference: A reference to a particular snapshot of the source tree
// used to build and deploy an application.
type SourceReference struct {
	// Repository: Optional. A URI string identifying the repository. Example:
	// "https://github.com/GoogleCloudPlatform/kubernetes.git"
	Repository string `json:"repository,omitempty"`
	// RevisionId: The canonical and persistent identifier of the deployed
	// revision. Example (git): "0035781c50ec7aa23385dc841529ce8a4b70db1b"
	RevisionId string `json:"revisionId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Repository") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Repository") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SourceReference) MarshalJSON() ([]byte, error) {
	type NoMethod SourceReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The Status type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each Status message contains three
// pieces of data: error code, error message, and error details.You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SummaryField: A field from the LogEntry that is added to the summary line
// (https://cloud.google.com/logging/docs/view/logs-explorer-interface#add-summary-fields)
// for a query in the Logs Explorer.
type SummaryField struct {
	// Field: Optional. The field from the LogEntry to include in the summary line,
	// for example resource.type or jsonPayload.name.
	Field string `json:"field,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SummaryField) MarshalJSON() ([]byte, error) {
	type NoMethod SummaryField
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SuppressionInfo: Information about entries that were omitted from the
// session.
type SuppressionInfo struct {
	// Reason: The reason that entries were omitted from the session.
	//
	// Possible values:
	//   "REASON_UNSPECIFIED" - Unexpected default.
	//   "RATE_LIMIT" - Indicates suppression occurred due to relevant entries
	// being received in excess of rate limits. For quotas and limits, see Logging
	// API quotas and limits (https://cloud.google.com/logging/quotas#api-limits).
	//   "NOT_CONSUMED" - Indicates suppression occurred due to the client not
	// consuming responses quickly enough.
	Reason string `json:"reason,omitempty"`
	// SuppressedCount: A lower bound on the count of entries omitted due to
	// reason.
	SuppressedCount int64 `json:"suppressedCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Reason") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Reason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SuppressionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SuppressionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TailLogEntriesRequest: The parameters to TailLogEntries.
type TailLogEntriesRequest struct {
	// BufferWindow: Optional. The amount of time to buffer log entries at the
	// server before being returned to prevent out of order results due to late
	// arriving log entries. Valid values are between 0-60000 milliseconds.
	// Defaults to 2000 milliseconds.
	BufferWindow string `json:"bufferWindow,omitempty"`
	// Filter: Optional. A filter that chooses which log entries to return. For
	// more information, see Logging query language
	// (https://{$universe.dns_names.final_documentation_domain}/logging/docs/view/logging-query-language).Only
	// log entries that match the filter are returned. An empty filter matches all
	// log entries in the resources listed in resource_names. Referencing a parent
	// resource that is not listed in resource_names will cause the filter to
	// return no results. The maximum length of a filter is 20,000 characters.
	Filter string `json:"filter,omitempty"`
	// ResourceNames: Required. Name of a parent resource from which to retrieve
	// log entries: projects/[PROJECT_ID] organizations/[ORGANIZATION_ID]
	// billingAccounts/[BILLING_ACCOUNT_ID] folders/[FOLDER_ID]May alternatively be
	// one or more views:
	// projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW
	// _ID]
	// organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/v
	// iews/[VIEW_ID]
	// billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_
	// ID]/views/[VIEW_ID]
	// folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_I
	// D]
	ResourceNames []string `json:"resourceNames,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BufferWindow") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BufferWindow") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TailLogEntriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TailLogEntriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TailLogEntriesResponse: Result returned from TailLogEntries.
type TailLogEntriesResponse struct {
	// Entries: A list of log entries. Each response in the stream will order
	// entries with increasing values of LogEntry.timestamp. Ordering is not
	// guaranteed between separate responses.
	Entries []*LogEntry `json:"entries,omitempty"`
	// SuppressionInfo: If entries that otherwise would have been included in the
	// session were not sent back to the client, counts of relevant entries omitted
	// from the session with the reason that they were not included. There will be
	// at most one of each reason per response. The counts represent the number of
	// suppressed entries since the last streamed response.
	SuppressionInfo []*SuppressionInfo `json:"suppressionInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TailLogEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TailLogEntriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for TestIamPermissions method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the resource. Permissions
	// with wildcards (such as * or storage.*) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for TestIamPermissions method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of TestPermissionsRequest.permissions that the caller
	// is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UndeleteBucketRequest: The parameters to UndeleteBucket.
type UndeleteBucketRequest struct {
}

// UpdateBucketRequest: The parameters to UpdateBucket.
type UpdateBucketRequest struct {
	// Bucket: Required. The updated bucket.
	Bucket *LogBucket `json:"bucket,omitempty"`
	// Name: Required. The full resource name of the bucket to update.
	// "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	// "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
	//
	// "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET
	// _ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" For
	// example:"projects/my-project/locations/global/buckets/my-bucket"
	Name string `json:"name,omitempty"`
	// UpdateMask: Required. Field mask that specifies the fields in bucket that
	// need an update. A bucket field will be overwritten if, and only if, it is in
	// the update mask. name and output only fields cannot be updated.For a
	// detailed FieldMask definition, see:
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
	// example: updateMask=retention_days
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateBucketRequest) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateBucketRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WriteLogEntriesRequest: The parameters to WriteLogEntries.
type WriteLogEntriesRequest struct {
	// DryRun: Optional. If true, the request should expect normal response, but
	// the entries won't be persisted nor exported. Useful for checking whether the
	// logging API endpoints are working properly before sending valuable data.
	DryRun bool `json:"dryRun,omitempty"`
	// Entries: Required. The log entries to send to Logging. The order of log
	// entries in this list does not matter. Values supplied in this method's
	// log_name, resource, and labels fields are copied into those log entries in
	// this list that do not include values for their corresponding fields. For
	// more information, see the LogEntry type.If the timestamp or insert_id fields
	// are missing in log entries, then this method supplies the current time or a
	// unique identifier, respectively. The supplied values are chosen so that,
	// among the log entries that did not supply their own values, the entries
	// earlier in the list will sort before the entries later in the list. See the
	// entries.list method.Log entries with timestamps that are more than the logs
	// retention period (https://cloud.google.com/logging/quotas) in the past or
	// more than 24 hours in the future will not be available when calling
	// entries.list. However, those log entries can still be exported with LogSinks
	// (https://cloud.google.com/logging/docs/api/tasks/exporting-logs).To improve
	// throughput and to avoid exceeding the quota limit
	// (https://cloud.google.com/logging/quotas) for calls to entries.write, you
	// should try to include several log entries in this list, rather than calling
	// this method for each individual log entry.
	Entries []*LogEntry `json:"entries,omitempty"`
	// Labels: Optional. Default labels that are added to the labels field of all
	// log entries in entries. If a log entry already has a label with the same key
	// as a label in this parameter, then the log entry's label is not changed. See
	// LogEntry.
	Labels map[string]string `json:"labels,omitempty"`
	// LogName: Optional. A default log resource name that is assigned to all log
	// entries in entries that do not specify a value for log_name:
	// projects/[PROJECT_ID]/logs/[LOG_ID]
	// organizations/[ORGANIZATION_ID]/logs/[LOG_ID]
	// billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]
	// folders/[FOLDER_ID]/logs/[LOG_ID][LOG_ID] must be URL-encoded. For example:
	// "projects/my-project-id/logs/syslog"
	// "organizations/123/logs/cloudaudit.googleapis.com%2Factivity" The permission
	// logging.logEntries.create is needed on each project, organization, billing
	// account, or folder that is receiving new log entries, whether the resource
	// is specified in logName or in an individual log entry.
	LogName string `json:"logName,omitempty"`
	// PartialSuccess: Optional. Whether a batch's valid entries should be written
	// even if some other entry failed due to a permanent error such as
	// INVALID_ARGUMENT or PERMISSION_DENIED. If any entry failed, then the
	// response status is the response status of one of the failed entries. The
	// response will include error details in
	// WriteLogEntriesPartialErrors.log_entry_errors keyed by the entries'
	// zero-based index in the entries. Failed requests for which no entries are
	// written will not include per-entry errors.
	PartialSuccess bool `json:"partialSuccess,omitempty"`
	// Resource: Optional. A default monitored resource object that is assigned to
	// all log entries in entries that do not specify a value for resource.
	// Example: { "type": "gce_instance", "labels": { "zone": "us-central1-a",
	// "instance_id": "00000000000000000000" }} See LogEntry.
	Resource *MonitoredResource `json:"resource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DryRun") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DryRun") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WriteLogEntriesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod WriteLogEntriesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WriteLogEntriesResponse: Result returned from WriteLogEntries.
type WriteLogEntriesResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

type BillingAccountsGetCmekSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetCmekSettings: Gets the Logging CMEK settings for the given resource.Note:
// CMEK for the Log Router can be configured for Google Cloud projects,
// folders, organizations, and billing accounts. Once configured for an
// organization, it applies to all projects and folders in the Google Cloud
// organization.See Enabling CMEK for Log Router
// (https://cloud.google.com/logging/docs/routing/managed-encryption) for more
// information.
//
//   - name: The resource for which to retrieve CMEK settings.
//     "projects/[PROJECT_ID]/cmekSettings"
//     "organizations/[ORGANIZATION_ID]/cmekSettings"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
//     "folders/[FOLDER_ID]/cmekSettings" For
//     example:"organizations/12345/cmekSettings"Note: CMEK for the Log Router
//     can be configured for Google Cloud projects, folders, organizations, and
//     billing accounts. Once configured for an organization, it applies to all
//     projects and folders in the Google Cloud organization.
func (r *BillingAccountsService) GetCmekSettings(name string) *BillingAccountsGetCmekSettingsCall {
	c := &BillingAccountsGetCmekSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsGetCmekSettingsCall) Fields(s ...googleapi.Field) *BillingAccountsGetCmekSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsGetCmekSettingsCall) IfNoneMatch(entityTag string) *BillingAccountsGetCmekSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsGetCmekSettingsCall) Context(ctx context.Context) *BillingAccountsGetCmekSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsGetCmekSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsGetCmekSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/cmekSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.getCmekSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.getCmekSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *CmekSettings.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsGetCmekSettingsCall) Do(opts ...googleapi.CallOption) (*CmekSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CmekSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.getCmekSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsGetSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSettings: Gets the settings for the given resource.Note: Settings can be
// retrieved for Google Cloud projects, folders, organizations, and billing
// accounts.See View default resource settings for Logging
// (https://cloud.google.com/logging/docs/default-settings#view-org-settings)
// for more information.
//
//   - name: The resource for which to retrieve settings.
//     "projects/[PROJECT_ID]/settings"
//     "organizations/[ORGANIZATION_ID]/settings"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/settings"
//     "folders/[FOLDER_ID]/settings" For
//     example:"organizations/12345/settings"Note: Settings can be retrieved for
//     Google Cloud projects, folders, organizations, and billing accounts.
func (r *BillingAccountsService) GetSettings(name string) *BillingAccountsGetSettingsCall {
	c := &BillingAccountsGetSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsGetSettingsCall) Fields(s ...googleapi.Field) *BillingAccountsGetSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsGetSettingsCall) IfNoneMatch(entityTag string) *BillingAccountsGetSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsGetSettingsCall) Context(ctx context.Context) *BillingAccountsGetSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsGetSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsGetSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.getSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.getSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Settings.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsGetSettingsCall) Do(opts ...googleapi.CallOption) (*Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.getSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsExclusionsCreateCall struct {
	s            *Service
	parent       string
	logexclusion *LogExclusion
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new exclusion in the _Default sink in a specified parent
// resource. Only log entries belonging to that resource can be excluded. You
// can have up to 10 exclusions in a resource.
//
//   - parent: The parent resource in which to create the exclusion:
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" For
//     examples:"projects/my-logging-project" "organizations/123456789".
func (r *BillingAccountsExclusionsService) Create(parent string, logexclusion *LogExclusion) *BillingAccountsExclusionsCreateCall {
	c := &BillingAccountsExclusionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logexclusion = logexclusion
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsExclusionsCreateCall) Fields(s ...googleapi.Field) *BillingAccountsExclusionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsExclusionsCreateCall) Context(ctx context.Context) *BillingAccountsExclusionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsExclusionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsExclusionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logexclusion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/exclusions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.exclusions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsExclusionsCreateCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsExclusionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an exclusion in the _Default sink.
//
//   - name: The resource name of an existing exclusion to delete:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *BillingAccountsExclusionsService) Delete(name string) *BillingAccountsExclusionsDeleteCall {
	c := &BillingAccountsExclusionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsExclusionsDeleteCall) Fields(s ...googleapi.Field) *BillingAccountsExclusionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsExclusionsDeleteCall) Context(ctx context.Context) *BillingAccountsExclusionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsExclusionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsExclusionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.exclusions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsExclusionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsExclusionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the description of an exclusion in the _Default sink.
//
//   - name: The resource name of an existing exclusion:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *BillingAccountsExclusionsService) Get(name string) *BillingAccountsExclusionsGetCall {
	c := &BillingAccountsExclusionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsExclusionsGetCall) Fields(s ...googleapi.Field) *BillingAccountsExclusionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsExclusionsGetCall) IfNoneMatch(entityTag string) *BillingAccountsExclusionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsExclusionsGetCall) Context(ctx context.Context) *BillingAccountsExclusionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsExclusionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsExclusionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.exclusions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsExclusionsGetCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsExclusionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the exclusions on the _Default sink in a parent resource.
//
//   - parent: The parent resource whose exclusions are to be listed.
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]".
func (r *BillingAccountsExclusionsService) List(parent string) *BillingAccountsExclusionsListCall {
	c := &BillingAccountsExclusionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *BillingAccountsExclusionsListCall) PageSize(pageSize int64) *BillingAccountsExclusionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *BillingAccountsExclusionsListCall) PageToken(pageToken string) *BillingAccountsExclusionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsExclusionsListCall) Fields(s ...googleapi.Field) *BillingAccountsExclusionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsExclusionsListCall) IfNoneMatch(entityTag string) *BillingAccountsExclusionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsExclusionsListCall) Context(ctx context.Context) *BillingAccountsExclusionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsExclusionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsExclusionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/exclusions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.exclusions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExclusionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsExclusionsListCall) Do(opts ...googleapi.CallOption) (*ListExclusionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExclusionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsExclusionsListCall) Pages(ctx context.Context, f func(*ListExclusionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsExclusionsPatchCall struct {
	s            *Service
	name         string
	logexclusion *LogExclusion
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Changes one or more properties of an existing exclusion in the
// _Default sink.
//
//   - name: The resource name of the exclusion to update:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *BillingAccountsExclusionsService) Patch(name string, logexclusion *LogExclusion) *BillingAccountsExclusionsPatchCall {
	c := &BillingAccountsExclusionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logexclusion = logexclusion
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A non-empty
// list of fields to change in the existing exclusion. New values for the
// fields are taken from the corresponding fields in the LogExclusion included
// in this request. Fields not mentioned in update_mask are not changed and are
// ignored in the request.For example, to change the filter and description of
// an exclusion, specify an update_mask of "filter,description".
func (c *BillingAccountsExclusionsPatchCall) UpdateMask(updateMask string) *BillingAccountsExclusionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsExclusionsPatchCall) Fields(s ...googleapi.Field) *BillingAccountsExclusionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsExclusionsPatchCall) Context(ctx context.Context) *BillingAccountsExclusionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsExclusionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsExclusionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logexclusion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.exclusions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsExclusionsPatchCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.exclusions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *BillingAccountsLocationsService) Get(name string) *BillingAccountsLocationsGetCall {
	c := &BillingAccountsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsGetCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsGetCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsGetCall) Context(ctx context.Context) *BillingAccountsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *BillingAccountsLocationsService) List(name string) *BillingAccountsLocationsListCall {
	c := &BillingAccountsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *BillingAccountsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *BillingAccountsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *BillingAccountsLocationsListCall) Filter(filter string) *BillingAccountsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *BillingAccountsLocationsListCall) PageSize(pageSize int64) *BillingAccountsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the next_page_token field in the response. Send that page token to
// receive the subsequent page.
func (c *BillingAccountsLocationsListCall) PageToken(pageToken string) *BillingAccountsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsListCall) Context(ctx context.Context) *BillingAccountsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsLocationsBucketsCreateCall struct {
	s          *Service
	parent     string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a log bucket that can be used to store log entries. After a
// bucket has been created, the bucket's location cannot be changed.
//
//   - parent: The resource in which to create the log bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global".
func (r *BillingAccountsLocationsBucketsService) Create(parent string, logbucket *LogBucket) *BillingAccountsLocationsBucketsCreateCall {
	c := &BillingAccountsLocationsBucketsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logbucket = logbucket
	return c
}

// BucketId sets the optional parameter "bucketId": Required. A client-assigned
// identifier such as "my-bucket". Identifiers are limited to 100 characters
// and can include only letters, digits, underscores, hyphens, and periods.
// Bucket identifiers must start with an alphanumeric character.
func (c *BillingAccountsLocationsBucketsCreateCall) BucketId(bucketId string) *BillingAccountsLocationsBucketsCreateCall {
	c.urlParams_.Set("bucketId", bucketId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsCreateCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsCreateCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsCreateCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsCreateAsyncCall struct {
	s          *Service
	parent     string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// CreateAsync: Creates a log bucket asynchronously that can be used to store
// log entries.After a bucket has been created, the bucket's location cannot be
// changed.
//
//   - parent: The resource in which to create the log bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global".
func (r *BillingAccountsLocationsBucketsService) CreateAsync(parent string, logbucket *LogBucket) *BillingAccountsLocationsBucketsCreateAsyncCall {
	c := &BillingAccountsLocationsBucketsCreateAsyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logbucket = logbucket
	return c
}

// BucketId sets the optional parameter "bucketId": Required. A client-assigned
// identifier such as "my-bucket". Identifiers are limited to 100 characters
// and can include only letters, digits, underscores, hyphens, and periods.
// Bucket identifiers must start with an alphanumeric character.
func (c *BillingAccountsLocationsBucketsCreateAsyncCall) BucketId(bucketId string) *BillingAccountsLocationsBucketsCreateAsyncCall {
	c.urlParams_.Set("bucketId", bucketId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsCreateAsyncCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsCreateAsyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsCreateAsyncCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsCreateAsyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsCreateAsyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsCreateAsyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets:createAsync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.createAsync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.createAsync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsCreateAsyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.createAsync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a log bucket.Changes the bucket's lifecycle_state to the
// DELETE_REQUESTED state. After 7 days, the bucket will be purged and all log
// entries in the bucket will be permanently deleted.
//
//   - name: The full resource name of the bucket to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *BillingAccountsLocationsBucketsService) Delete(name string) *BillingAccountsLocationsBucketsDeleteCall {
	c := &BillingAccountsLocationsBucketsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsDeleteCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsDeleteCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a log bucket.
//
//   - name: The resource name of the bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *BillingAccountsLocationsBucketsService) Get(name string) *BillingAccountsLocationsBucketsGetCall {
	c := &BillingAccountsLocationsBucketsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsGetCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsBucketsGetCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsBucketsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsGetCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsGetCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists log buckets.
//
//   - parent: The parent resource whose buckets are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Note: The locations portion
//     of the resource must be specified, but supplying the character - in place
//     of LOCATION_ID will return all buckets.
func (r *BillingAccountsLocationsBucketsService) List(parent string) *BillingAccountsLocationsBucketsListCall {
	c := &BillingAccountsLocationsBucketsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *BillingAccountsLocationsBucketsListCall) PageSize(pageSize int64) *BillingAccountsLocationsBucketsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *BillingAccountsLocationsBucketsListCall) PageToken(pageToken string) *BillingAccountsLocationsBucketsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsBucketsListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsBucketsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsListCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBucketsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsLocationsBucketsListCall) Do(opts ...googleapi.CallOption) (*ListBucketsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBucketsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsBucketsListCall) Pages(ctx context.Context, f func(*ListBucketsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsLocationsBucketsPatchCall struct {
	s          *Service
	name       string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a log bucket.If the bucket has a lifecycle_state of
// DELETE_REQUESTED, then FAILED_PRECONDITION will be returned.After a bucket
// has been created, the bucket's location cannot be changed.
//
//   - name: The full resource name of the bucket to update.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *BillingAccountsLocationsBucketsService) Patch(name string, logbucket *LogBucket) *BillingAccountsLocationsBucketsPatchCall {
	c := &BillingAccountsLocationsBucketsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logbucket = logbucket
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// that specifies the fields in bucket that need an update. A bucket field will
// be overwritten if, and only if, it is in the update mask. name and output
// only fields cannot be updated.For a detailed FieldMask definition, see:
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=retention_days
func (c *BillingAccountsLocationsBucketsPatchCall) UpdateMask(updateMask string) *BillingAccountsLocationsBucketsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsPatchCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsPatchCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsPatchCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsUndeleteCall struct {
	s                     *Service
	name                  string
	undeletebucketrequest *UndeleteBucketRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Undelete: Undeletes a log bucket. A bucket that has been deleted can be
// undeleted within the grace period of 7 days.
//
//   - name: The full resource name of the bucket to undelete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *BillingAccountsLocationsBucketsService) Undelete(name string, undeletebucketrequest *UndeleteBucketRequest) *BillingAccountsLocationsBucketsUndeleteCall {
	c := &BillingAccountsLocationsBucketsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.undeletebucketrequest = undeletebucketrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsUndeleteCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsUndeleteCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.undeletebucketrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.undelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.undelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsUndeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.undelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsUpdateAsyncCall struct {
	s          *Service
	name       string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateAsync: Updates a log bucket asynchronously.If the bucket has a
// lifecycle_state of DELETE_REQUESTED, then FAILED_PRECONDITION will be
// returned.After a bucket has been created, the bucket's location cannot be
// changed.
//
//   - name: The full resource name of the bucket to update.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *BillingAccountsLocationsBucketsService) UpdateAsync(name string, logbucket *LogBucket) *BillingAccountsLocationsBucketsUpdateAsyncCall {
	c := &BillingAccountsLocationsBucketsUpdateAsyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logbucket = logbucket
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// that specifies the fields in bucket that need an update. A bucket field will
// be overwritten if, and only if, it is in the update mask. name and output
// only fields cannot be updated.For a detailed FieldMask definition, see:
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=retention_days
func (c *BillingAccountsLocationsBucketsUpdateAsyncCall) UpdateMask(updateMask string) *BillingAccountsLocationsBucketsUpdateAsyncCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsUpdateAsyncCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsUpdateAsyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsUpdateAsyncCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsUpdateAsyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsUpdateAsyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsUpdateAsyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:updateAsync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.updateAsync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.updateAsync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsUpdateAsyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.updateAsync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsLinksCreateCall struct {
	s          *Service
	parent     string
	link       *Link
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Asynchronously creates a linked dataset in BigQuery which makes it
// possible to use BigQuery to read the logs stored in the log bucket. A log
// bucket may currently only contain one link.
//
//   - parent: The full resource name of the bucket to create a link for.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *BillingAccountsLocationsBucketsLinksService) Create(parent string, link *Link) *BillingAccountsLocationsBucketsLinksCreateCall {
	c := &BillingAccountsLocationsBucketsLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.link = link
	return c
}

// LinkId sets the optional parameter "linkId": Required. The ID to use for the
// link. The link_id can have up to 100 characters. A valid link_id must only
// have alphanumeric characters and underscores within it.
func (c *BillingAccountsLocationsBucketsLinksCreateCall) LinkId(linkId string) *BillingAccountsLocationsBucketsLinksCreateCall {
	c.urlParams_.Set("linkId", linkId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsLinksCreateCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsLinksCreateCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.link)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/links")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.links.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.links.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsLinksCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.links.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a link. This will also delete the corresponding BigQuery
// linked dataset.
//
//   - name: The full resource name of the link to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[L
//     INK_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]/links/[LINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]/links/[LINK_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
//     K_ID]".
func (r *BillingAccountsLocationsBucketsLinksService) Delete(name string) *BillingAccountsLocationsBucketsLinksDeleteCall {
	c := &BillingAccountsLocationsBucketsLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsLinksDeleteCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsLinksDeleteCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.links.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.links.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsLinksDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.links.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a link.
//
//   - name: The resource name of the link:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[L
//     INK_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]/links/[LINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]/links/[LINK_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
//     K_ID]".
func (r *BillingAccountsLocationsBucketsLinksService) Get(name string) *BillingAccountsLocationsBucketsLinksGetCall {
	c := &BillingAccountsLocationsBucketsLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsLinksGetCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsBucketsLinksGetCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsBucketsLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsLinksGetCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.links.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.links.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Link.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsLinksGetCall) Do(opts ...googleapi.CallOption) (*Link, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Link{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.links.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists links.
//
//   - parent: The parent resource whose links are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *BillingAccountsLocationsBucketsLinksService) List(parent string) *BillingAccountsLocationsBucketsLinksListCall {
	c := &BillingAccountsLocationsBucketsLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.
func (c *BillingAccountsLocationsBucketsLinksListCall) PageSize(pageSize int64) *BillingAccountsLocationsBucketsLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response.
func (c *BillingAccountsLocationsBucketsLinksListCall) PageToken(pageToken string) *BillingAccountsLocationsBucketsLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsLinksListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsBucketsLinksListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsBucketsLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsLinksListCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/links")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.links.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.links.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLinksResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsLocationsBucketsLinksListCall) Do(opts ...googleapi.CallOption) (*ListLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.links.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsBucketsLinksListCall) Pages(ctx context.Context, f func(*ListLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsLocationsBucketsViewsCreateCall struct {
	s          *Service
	parent     string
	logview    *LogView
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a view over log entries in a log bucket. A bucket may
// contain a maximum of 30 views.
//
//   - parent: The bucket in which to create the view
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *BillingAccountsLocationsBucketsViewsService) Create(parent string, logview *LogView) *BillingAccountsLocationsBucketsViewsCreateCall {
	c := &BillingAccountsLocationsBucketsViewsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logview = logview
	return c
}

// ViewId sets the optional parameter "viewId": Required. A client-assigned
// identifier such as "my-view". Identifiers are limited to 100 characters and
// can include only letters, digits, underscores, and hyphens.
func (c *BillingAccountsLocationsBucketsViewsCreateCall) ViewId(viewId string) *BillingAccountsLocationsBucketsViewsCreateCall {
	c.urlParams_.Set("viewId", viewId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsViewsCreateCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsViewsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsViewsCreateCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsViewsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsViewsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsViewsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.views.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsViewsCreateCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsViewsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a view on a log bucket. If an UNAVAILABLE error is returned,
// this indicates that system is not in a state where it can delete the view.
// If this occurs, please try again in a few minutes.
//
//   - name: The full resource name of the view to delete:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *BillingAccountsLocationsBucketsViewsService) Delete(name string) *BillingAccountsLocationsBucketsViewsDeleteCall {
	c := &BillingAccountsLocationsBucketsViewsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsViewsDeleteCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsViewsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsViewsDeleteCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsViewsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsViewsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsViewsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.views.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsViewsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsViewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a view on a log bucket.
//
//   - name: The resource name of the policy:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *BillingAccountsLocationsBucketsViewsService) Get(name string) *BillingAccountsLocationsBucketsViewsGetCall {
	c := &BillingAccountsLocationsBucketsViewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsViewsGetCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsViewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsBucketsViewsGetCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsBucketsViewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsViewsGetCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsViewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsViewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsViewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.views.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsViewsGetCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsViewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists views on a log bucket.
//
//   - parent: The bucket whose views are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *BillingAccountsLocationsBucketsViewsService) List(parent string) *BillingAccountsLocationsBucketsViewsListCall {
	c := &BillingAccountsLocationsBucketsViewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *BillingAccountsLocationsBucketsViewsListCall) PageSize(pageSize int64) *BillingAccountsLocationsBucketsViewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *BillingAccountsLocationsBucketsViewsListCall) PageToken(pageToken string) *BillingAccountsLocationsBucketsViewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsViewsListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsViewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsBucketsViewsListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsBucketsViewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsViewsListCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsViewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsViewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsViewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.views.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListViewsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsLocationsBucketsViewsListCall) Do(opts ...googleapi.CallOption) (*ListViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsBucketsViewsListCall) Pages(ctx context.Context, f func(*ListViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsLocationsBucketsViewsPatchCall struct {
	s          *Service
	name       string
	logview    *LogView
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a view on a log bucket. This method replaces the value of the
// filter field from the existing view with the corresponding value from the
// new view. If an UNAVAILABLE error is returned, this indicates that system is
// not in a state where it can update the view. If this occurs, please try
// again in a few minutes.
//
//   - name: The full resource name of the view to update
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *BillingAccountsLocationsBucketsViewsService) Patch(name string, logview *LogView) *BillingAccountsLocationsBucketsViewsPatchCall {
	c := &BillingAccountsLocationsBucketsViewsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logview = logview
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// specifies the fields in view that need an update. A field will be
// overwritten if, and only if, it is in the update mask. name and output only
// fields cannot be updated.For a detailed FieldMask definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=filter
func (c *BillingAccountsLocationsBucketsViewsPatchCall) UpdateMask(updateMask string) *BillingAccountsLocationsBucketsViewsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsViewsPatchCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsViewsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsViewsPatchCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsViewsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsViewsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsViewsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.views.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsBucketsViewsPatchCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsBucketsViewsLogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the logs in projects, organizations, folders, or billing
// accounts. Only logs that have entries are listed.
//
//   - parent: The resource name to list logs for: projects/[PROJECT_ID]
//     organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
//     folders/[FOLDER_ID].
func (r *BillingAccountsLocationsBucketsViewsLogsService) List(parent string) *BillingAccountsLocationsBucketsViewsLogsListCall {
	c := &BillingAccountsLocationsBucketsViewsLogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *BillingAccountsLocationsBucketsViewsLogsListCall) PageSize(pageSize int64) *BillingAccountsLocationsBucketsViewsLogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *BillingAccountsLocationsBucketsViewsLogsListCall) PageToken(pageToken string) *BillingAccountsLocationsBucketsViewsLogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ResourceNames sets the optional parameter "resourceNames": List of resource
// names to list logs for:
// projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW
// _ID]
// organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/v
// iews/[VIEW_ID]
// billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_
// ID]/views/[VIEW_ID]
// folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_I
// D]To support legacy queries, it could also be: projects/[PROJECT_ID]
// organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
// folders/[FOLDER_ID]The resource name in the parent field is added to this
// list.
func (c *BillingAccountsLocationsBucketsViewsLogsListCall) ResourceNames(resourceNames ...string) *BillingAccountsLocationsBucketsViewsLogsListCall {
	c.urlParams_.SetMulti("resourceNames", append([]string{}, resourceNames...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsBucketsViewsLogsListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsBucketsViewsLogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsBucketsViewsLogsListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsBucketsViewsLogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsBucketsViewsLogsListCall) Context(ctx context.Context) *BillingAccountsLocationsBucketsViewsLogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsBucketsViewsLogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsBucketsViewsLogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/logs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.logs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.buckets.views.logs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLogsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsLocationsBucketsViewsLogsListCall) Do(opts ...googleapi.CallOption) (*ListLogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.buckets.views.logs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsBucketsViewsLogsListCall) Pages(ctx context.Context, f func(*ListLogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// google.rpc.Code.UNIMPLEMENTED. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of 1, corresponding to
// Code.CANCELLED.
//
// - name: The name of the operation resource to be cancelled.
func (r *BillingAccountsLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *BillingAccountsLocationsOperationsCancelCall {
	c := &BillingAccountsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsOperationsCancelCall) Context(ctx context.Context) *BillingAccountsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *BillingAccountsLocationsOperationsService) Get(name string) *BillingAccountsLocationsOperationsGetCall {
	c := &BillingAccountsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsOperationsGetCall) Context(ctx context.Context) *BillingAccountsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns UNIMPLEMENTED.
//
// - name: The name of the operation's parent resource.
func (r *BillingAccountsLocationsOperationsService) List(name string) *BillingAccountsLocationsOperationsListCall {
	c := &BillingAccountsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *BillingAccountsLocationsOperationsListCall) Filter(filter string) *BillingAccountsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *BillingAccountsLocationsOperationsListCall) PageSize(pageSize int64) *BillingAccountsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *BillingAccountsLocationsOperationsListCall) PageToken(pageToken string) *BillingAccountsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to true, operations that are reachable are returned as normal, and
// those that are unreachable are returned in the
// ListOperationsResponse.unreachable field.This can only be true when reading
// across collections. For example, when parent is set to
// "projects/example/locations/-".This field is not supported by default and
// will result in an UNIMPLEMENTED error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *BillingAccountsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *BillingAccountsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsOperationsListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsOperationsListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsOperationsListCall) Context(ctx context.Context) *BillingAccountsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsLocationsRecentQueriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the RecentQueries that were created by the user making the
// request.
//
//   - parent: The resource to which the listed queries belong.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" For
//     example:projects/my-project/locations/us-central1Note: The location
//     portion of the resource must be specified, but supplying the character -
//     in place of LOCATION_ID will return all recent queries.
func (r *BillingAccountsLocationsRecentQueriesService) List(parent string) *BillingAccountsLocationsRecentQueriesListCall {
	c := &BillingAccountsLocationsRecentQueriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Specifies the type ("Logging"
// or "OpsAnalytics") of the recent queries to list. The only valid value for
// this field is one of the two allowable type function calls, which are the
// following: type("Logging") type("OpsAnalytics")
func (c *BillingAccountsLocationsRecentQueriesListCall) Filter(filter string) *BillingAccountsLocationsRecentQueriesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *BillingAccountsLocationsRecentQueriesListCall) PageSize(pageSize int64) *BillingAccountsLocationsRecentQueriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *BillingAccountsLocationsRecentQueriesListCall) PageToken(pageToken string) *BillingAccountsLocationsRecentQueriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsRecentQueriesListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsRecentQueriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsRecentQueriesListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsRecentQueriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsRecentQueriesListCall) Context(ctx context.Context) *BillingAccountsLocationsRecentQueriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsRecentQueriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsRecentQueriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/recentQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.recentQueries.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.recentQueries.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRecentQueriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BillingAccountsLocationsRecentQueriesListCall) Do(opts ...googleapi.CallOption) (*ListRecentQueriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRecentQueriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.recentQueries.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsRecentQueriesListCall) Pages(ctx context.Context, f func(*ListRecentQueriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsLocationsSavedQueriesCreateCall struct {
	s          *Service
	parent     string
	savedquery *SavedQuery
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new SavedQuery for the user making the request.
//
//   - parent: The parent resource in which to create the saved query:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" For example:
//     "projects/my-project/locations/global"
//     "organizations/123456789/locations/us-central1".
func (r *BillingAccountsLocationsSavedQueriesService) Create(parent string, savedquery *SavedQuery) *BillingAccountsLocationsSavedQueriesCreateCall {
	c := &BillingAccountsLocationsSavedQueriesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.savedquery = savedquery
	return c
}

// SavedQueryId sets the optional parameter "savedQueryId": The ID to use for
// the saved query, which will become the final component of the saved query's
// resource name.If the saved_query_id is not provided, the system will
// generate an alphanumeric ID.The saved_query_id is limited to 100 characters
// and can include only the following characters: upper and lower-case
// alphanumeric characters, underscores, hyphens, periods.First character has
// to be alphanumeric.
func (c *BillingAccountsLocationsSavedQueriesCreateCall) SavedQueryId(savedQueryId string) *BillingAccountsLocationsSavedQueriesCreateCall {
	c.urlParams_.Set("savedQueryId", savedQueryId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsSavedQueriesCreateCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsSavedQueriesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsSavedQueriesCreateCall) Context(ctx context.Context) *BillingAccountsLocationsSavedQueriesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsSavedQueriesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsSavedQueriesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.savedquery)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/savedQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.savedQueries.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *SavedQuery.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsSavedQueriesCreateCall) Do(opts ...googleapi.CallOption) (*SavedQuery, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SavedQuery{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsSavedQueriesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing SavedQuery that was created by the user making
// the request.
//
//   - name: The full resource name of the saved query to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/savedQueries/[QUER
//     Y_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/savedQueries/
//     [QUERY_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]" For
//     example:
//     "projects/my-project/locations/global/savedQueries/my-saved-query".
func (r *BillingAccountsLocationsSavedQueriesService) Delete(name string) *BillingAccountsLocationsSavedQueriesDeleteCall {
	c := &BillingAccountsLocationsSavedQueriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsSavedQueriesDeleteCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsSavedQueriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsSavedQueriesDeleteCall) Context(ctx context.Context) *BillingAccountsLocationsSavedQueriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsSavedQueriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsSavedQueriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.savedQueries.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsSavedQueriesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsSavedQueriesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns all data associated with the requested query.
//
//   - name: The resource name of the saved query.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/savedQueries/[QUER
//     Y_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/savedQueries/
//     [QUERY_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]" For
//     example:
//     "projects/my-project/locations/global/savedQueries/my-saved-query".
func (r *BillingAccountsLocationsSavedQueriesService) Get(name string) *BillingAccountsLocationsSavedQueriesGetCall {
	c := &BillingAccountsLocationsSavedQueriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsSavedQueriesGetCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsSavedQueriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsSavedQueriesGetCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsSavedQueriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsSavedQueriesGetCall) Context(ctx context.Context) *BillingAccountsLocationsSavedQueriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsSavedQueriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsSavedQueriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.savedQueries.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *SavedQuery.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsSavedQueriesGetCall) Do(opts ...googleapi.CallOption) (*SavedQuery, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SavedQuery{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLocationsSavedQueriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the SavedQueries that were created by the user making the
// request.
//
//   - parent: The resource to which the listed queries belong.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" For example:
//     "projects/my-project/locations/us-central1" Note: The locations portion of
//     the resource must be specified. To get a list of all saved queries, a
//     wildcard character - can be used for LOCATION_ID, for example:
//     "projects/my-project/locations/-".
func (r *BillingAccountsLocationsSavedQueriesService) List(parent string) *BillingAccountsLocationsSavedQueriesListCall {
	c := &BillingAccountsLocationsSavedQueriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Specifies the type ("Logging"
// or "OpsAnalytics") and the visibility (PRIVATE or SHARED) of the saved
// queries to list. If provided, the filter must contain either the type
// function or a visibility token, or both. If both are chosen, they can be
// placed in any order, but they must be joined by the AND operator or the
// empty character.The two supported type function calls are: type("Logging")
// type("OpsAnalytics")The two supported visibility tokens are: visibility =
// PRIVATE visibility = SHAREDFor example:type("Logging") AND visibility =
// PRIVATE visibility=SHARED type("OpsAnalytics") type("OpsAnalytics)"
// visibility = PRIVATE visibility = SHARED
func (c *BillingAccountsLocationsSavedQueriesListCall) Filter(filter string) *BillingAccountsLocationsSavedQueriesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *BillingAccountsLocationsSavedQueriesListCall) PageSize(pageSize int64) *BillingAccountsLocationsSavedQueriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *BillingAccountsLocationsSavedQueriesListCall) PageToken(pageToken string) *BillingAccountsLocationsSavedQueriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsSavedQueriesListCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsSavedQueriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLocationsSavedQueriesListCall) IfNoneMatch(entityTag string) *BillingAccountsLocationsSavedQueriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsSavedQueriesListCall) Context(ctx context.Context) *BillingAccountsLocationsSavedQueriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsSavedQueriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsSavedQueriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/savedQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.savedQueries.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSavedQueriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *BillingAccountsLocationsSavedQueriesListCall) Do(opts ...googleapi.CallOption) (*ListSavedQueriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSavedQueriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLocationsSavedQueriesListCall) Pages(ctx context.Context, f func(*ListSavedQueriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsLocationsSavedQueriesPatchCall struct {
	s          *Service
	name       string
	savedquery *SavedQuery
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an existing SavedQuery.
//
//   - name: Output only. Resource name of the saved query.In the format:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]"
//     For a list of supported locations, see Supported Regions
//     (https://cloud.google.com/logging/docs/region-support#bucket-regions)After
//     the saved query is created, the location cannot be changed.If the user
//     doesn't provide a QUERY_ID, the system will generate an alphanumeric ID.
func (r *BillingAccountsLocationsSavedQueriesService) Patch(name string, savedquery *SavedQuery) *BillingAccountsLocationsSavedQueriesPatchCall {
	c := &BillingAccountsLocationsSavedQueriesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.savedquery = savedquery
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A non-empty
// list of fields to change in the existing saved query. Fields are relative to
// the saved_query and new values for the fields are taken from the
// corresponding fields in the SavedQuery included in this request. Fields not
// mentioned in update_mask are not changed and are ignored in the request.To
// update all mutable fields, specify an update_mask of *.For example, to
// change the description and query filter text of a saved query, specify an
// update_mask of "description, query.filter".
func (c *BillingAccountsLocationsSavedQueriesPatchCall) UpdateMask(updateMask string) *BillingAccountsLocationsSavedQueriesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLocationsSavedQueriesPatchCall) Fields(s ...googleapi.Field) *BillingAccountsLocationsSavedQueriesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLocationsSavedQueriesPatchCall) Context(ctx context.Context) *BillingAccountsLocationsSavedQueriesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLocationsSavedQueriesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLocationsSavedQueriesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.savedquery)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.locations.savedQueries.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *SavedQuery.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLocationsSavedQueriesPatchCall) Do(opts ...googleapi.CallOption) (*SavedQuery, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SavedQuery{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.locations.savedQueries.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLogsDeleteCall struct {
	s          *Service
	logName    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes all the log entries in a log for the global _Default Log
// Bucket. The log reappears if it receives new entries. Log entries written
// shortly before the delete operation might not be deleted. Entries received
// after the delete operation with a timestamp before the operation will be
// deleted.
//
//   - logName: The resource name of the log to delete:
//     projects/[PROJECT_ID]/logs/[LOG_ID]
//     organizations/[ORGANIZATION_ID]/logs/[LOG_ID]
//     billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]
//     folders/[FOLDER_ID]/logs/[LOG_ID][LOG_ID] must be URL-encoded. For
//     example, "projects/my-project-id/logs/syslog",
//     "organizations/123/logs/cloudaudit.googleapis.com%2Factivity".For more
//     information about log names, see LogEntry.
func (r *BillingAccountsLogsService) Delete(logName string) *BillingAccountsLogsDeleteCall {
	c := &BillingAccountsLogsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.logName = logName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLogsDeleteCall) Fields(s ...googleapi.Field) *BillingAccountsLogsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLogsDeleteCall) Context(ctx context.Context) *BillingAccountsLogsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLogsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLogsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+logName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"logName": c.logName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.logs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.logs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsLogsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.logs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsLogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the logs in projects, organizations, folders, or billing
// accounts. Only logs that have entries are listed.
//
//   - parent: The resource name to list logs for: projects/[PROJECT_ID]
//     organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
//     folders/[FOLDER_ID].
func (r *BillingAccountsLogsService) List(parent string) *BillingAccountsLogsListCall {
	c := &BillingAccountsLogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *BillingAccountsLogsListCall) PageSize(pageSize int64) *BillingAccountsLogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *BillingAccountsLogsListCall) PageToken(pageToken string) *BillingAccountsLogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ResourceNames sets the optional parameter "resourceNames": List of resource
// names to list logs for:
// projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW
// _ID]
// organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/v
// iews/[VIEW_ID]
// billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_
// ID]/views/[VIEW_ID]
// folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_I
// D]To support legacy queries, it could also be: projects/[PROJECT_ID]
// organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
// folders/[FOLDER_ID]The resource name in the parent field is added to this
// list.
func (c *BillingAccountsLogsListCall) ResourceNames(resourceNames ...string) *BillingAccountsLogsListCall {
	c.urlParams_.SetMulti("resourceNames", append([]string{}, resourceNames...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsLogsListCall) Fields(s ...googleapi.Field) *BillingAccountsLogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsLogsListCall) IfNoneMatch(entityTag string) *BillingAccountsLogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsLogsListCall) Context(ctx context.Context) *BillingAccountsLogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsLogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsLogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/logs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.logs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.logs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLogsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsLogsListCall) Do(opts ...googleapi.CallOption) (*ListLogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.logs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsLogsListCall) Pages(ctx context.Context, f func(*ListLogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsSinksCreateCall struct {
	s          *Service
	parent     string
	logsink    *LogSink
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a sink that exports specified log entries to a destination.
// The export begins upon ingress, unless the sink's writer_identity is not
// permitted to write to the destination. A sink can export log entries only
// from the resource owning the sink.
//
//   - parent: The resource in which to create the sink: "projects/[PROJECT_ID]"
//     "organizations/[ORGANIZATION_ID]" "billingAccounts/[BILLING_ACCOUNT_ID]"
//     "folders/[FOLDER_ID]" For examples:"projects/my-project"
//     "organizations/123456789".
func (r *BillingAccountsSinksService) Create(parent string, logsink *LogSink) *BillingAccountsSinksCreateCall {
	c := &BillingAccountsSinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logsink = logsink
	return c
}

// CustomWriterIdentity sets the optional parameter "customWriterIdentity": The
// service account provided by the caller that will be used to write the log
// entries. The format must be serviceAccount:some@email. This field can only
// be specified when you are routing logs to a log bucket that is in a
// different project than the sink. When not specified, a Logging service
// account will automatically be generated.
func (c *BillingAccountsSinksCreateCall) CustomWriterIdentity(customWriterIdentity string) *BillingAccountsSinksCreateCall {
	c.urlParams_.Set("customWriterIdentity", customWriterIdentity)
	return c
}

// UniqueWriterIdentity sets the optional parameter "uniqueWriterIdentity":
// Determines the kind of IAM identity returned as writer_identity in the new
// sink. If this value is omitted or set to false, and if the sink's parent is
// a project, then the value returned as writer_identity is the same group or
// service account used by Cloud Logging before the addition of writer
// identities to this API. The sink's destination must be in the same project
// as the sink itself.If this field is set to true, or if the sink is owned by
// a non-project resource such as an organization, then the value of
// writer_identity will be a service agent
// (https://cloud.google.com/iam/docs/service-account-types#service-agents)
// used by the sinks with the same parent. For more information, see
// writer_identity in LogSink.
func (c *BillingAccountsSinksCreateCall) UniqueWriterIdentity(uniqueWriterIdentity bool) *BillingAccountsSinksCreateCall {
	c.urlParams_.Set("uniqueWriterIdentity", fmt.Sprint(uniqueWriterIdentity))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSinksCreateCall) Fields(s ...googleapi.Field) *BillingAccountsSinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSinksCreateCall) Context(ctx context.Context) *BillingAccountsSinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logsink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/sinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.sinks.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogSink.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSinksCreateCall) Do(opts ...googleapi.CallOption) (*LogSink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogSink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsSinksDeleteCall struct {
	s          *Service
	sinkNameid string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a sink. If the sink has a unique writer_identity, then that
// service account is also deleted.
//
//   - sinkName: The full resource name of the sink to delete, including the
//     parent resource and the sink identifier:
//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
//     "folders/[FOLDER_ID]/sinks/[SINK_ID]" For
//     example:"projects/my-project/sinks/my-sink".
func (r *BillingAccountsSinksService) Delete(sinkNameid string) *BillingAccountsSinksDeleteCall {
	c := &BillingAccountsSinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sinkNameid = sinkNameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSinksDeleteCall) Fields(s ...googleapi.Field) *BillingAccountsSinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSinksDeleteCall) Context(ctx context.Context) *BillingAccountsSinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+sinkName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sinkName": c.sinkNameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.sinks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSinksDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsSinksGetCall struct {
	s            *Service
	sinkName     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a sink.
//
//   - sinkName: The resource name of the sink:
//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
//     "folders/[FOLDER_ID]/sinks/[SINK_ID]" For
//     example:"projects/my-project/sinks/my-sink".
func (r *BillingAccountsSinksService) Get(sinkName string) *BillingAccountsSinksGetCall {
	c := &BillingAccountsSinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sinkName = sinkName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSinksGetCall) Fields(s ...googleapi.Field) *BillingAccountsSinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSinksGetCall) IfNoneMatch(entityTag string) *BillingAccountsSinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSinksGetCall) Context(ctx context.Context) *BillingAccountsSinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+sinkName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sinkName": c.sinkName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.sinks.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogSink.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSinksGetCall) Do(opts ...googleapi.CallOption) (*LogSink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogSink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsSinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists sinks.
//
//   - parent: The parent resource whose sinks are to be listed:
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]".
func (r *BillingAccountsSinksService) List(parent string) *BillingAccountsSinksListCall {
	c := &BillingAccountsSinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression to
// constrain the sinks returned. Today, this only supports the following
// strings: ” 'in_scope("ALL")', 'in_scope("ANCESTOR")',
// 'in_scope("DEFAULT")'.Description of scopes below. ALL: Includes all of the
// sinks which can be returned in any other scope. ANCESTOR: Includes
// intercepting sinks owned by ancestor resources. DEFAULT: Includes sinks
// owned by parent.When the empty string is provided, then the filter
// 'in_scope("DEFAULT")' is applied.
func (c *BillingAccountsSinksListCall) Filter(filter string) *BillingAccountsSinksListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *BillingAccountsSinksListCall) PageSize(pageSize int64) *BillingAccountsSinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *BillingAccountsSinksListCall) PageToken(pageToken string) *BillingAccountsSinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSinksListCall) Fields(s ...googleapi.Field) *BillingAccountsSinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BillingAccountsSinksListCall) IfNoneMatch(entityTag string) *BillingAccountsSinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSinksListCall) Context(ctx context.Context) *BillingAccountsSinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/sinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.sinks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSinksResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BillingAccountsSinksListCall) Do(opts ...googleapi.CallOption) (*ListSinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BillingAccountsSinksListCall) Pages(ctx context.Context, f func(*ListSinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BillingAccountsSinksPatchCall struct {
	s          *Service
	sinkNameid string
	logsink    *LogSink
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a sink. This method replaces the values of the destination
// and filter fields of the existing sink with the corresponding values from
// the new sink.The updated sink might also have a new writer_identity; see the
// unique_writer_identity field.
//
//   - sinkName: The full resource name of the sink to update, including the
//     parent resource and the sink identifier:
//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
//     "folders/[FOLDER_ID]/sinks/[SINK_ID]" For
//     example:"projects/my-project/sinks/my-sink".
func (r *BillingAccountsSinksService) Patch(sinkNameid string, logsink *LogSink) *BillingAccountsSinksPatchCall {
	c := &BillingAccountsSinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sinkNameid = sinkNameid
	c.logsink = logsink
	return c
}

// CustomWriterIdentity sets the optional parameter "customWriterIdentity": The
// service account provided by the caller that will be used to write the log
// entries. The format must be serviceAccount:some@email. This field can only
// be specified when you are routing logs to a log bucket that is in a
// different project than the sink. When not specified, a Logging service
// account will automatically be generated.
func (c *BillingAccountsSinksPatchCall) CustomWriterIdentity(customWriterIdentity string) *BillingAccountsSinksPatchCall {
	c.urlParams_.Set("customWriterIdentity", customWriterIdentity)
	return c
}

// UniqueWriterIdentity sets the optional parameter "uniqueWriterIdentity": See
// sinks.create for a description of this field. When updating a sink, the
// effect of this field on the value of writer_identity in the updated sink
// depends on both the old and new values of this field: If the old and new
// values of this field are both false or both true, then there is no change to
// the sink's writer_identity. If the old value is false and the new value is
// true, then writer_identity is changed to a service agent
// (https://cloud.google.com/iam/docs/service-account-types#service-agents)
// owned by Cloud Logging. It is an error if the old value is true and the new
// value is set to false or defaulted to false.
func (c *BillingAccountsSinksPatchCall) UniqueWriterIdentity(uniqueWriterIdentity bool) *BillingAccountsSinksPatchCall {
	c.urlParams_.Set("uniqueWriterIdentity", fmt.Sprint(uniqueWriterIdentity))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// specifies the fields in sink that need an update. A sink field will be
// overwritten if, and only if, it is in the update mask. name and output only
// fields cannot be updated.An empty updateMask is temporarily treated as using
// the following mask for backwards compatibility
// purposes:destination,filter,includeChildrenAt some point in the future,
// behavior will be removed and specifying an empty updateMask will be an
// error.For a detailed FieldMask definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=filter
func (c *BillingAccountsSinksPatchCall) UpdateMask(updateMask string) *BillingAccountsSinksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSinksPatchCall) Fields(s ...googleapi.Field) *BillingAccountsSinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSinksPatchCall) Context(ctx context.Context) *BillingAccountsSinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logsink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+sinkName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sinkName": c.sinkNameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.sinks.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogSink.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSinksPatchCall) Do(opts ...googleapi.CallOption) (*LogSink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogSink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BillingAccountsSinksUpdateCall struct {
	s          *Service
	sinkNameid string
	logsink    *LogSink
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a sink. This method replaces the values of the destination
// and filter fields of the existing sink with the corresponding values from
// the new sink.The updated sink might also have a new writer_identity; see the
// unique_writer_identity field.
//
//   - sinkName: The full resource name of the sink to update, including the
//     parent resource and the sink identifier:
//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
//     "folders/[FOLDER_ID]/sinks/[SINK_ID]" For
//     example:"projects/my-project/sinks/my-sink".
func (r *BillingAccountsSinksService) Update(sinkNameid string, logsink *LogSink) *BillingAccountsSinksUpdateCall {
	c := &BillingAccountsSinksUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sinkNameid = sinkNameid
	c.logsink = logsink
	return c
}

// CustomWriterIdentity sets the optional parameter "customWriterIdentity": The
// service account provided by the caller that will be used to write the log
// entries. The format must be serviceAccount:some@email. This field can only
// be specified when you are routing logs to a log bucket that is in a
// different project than the sink. When not specified, a Logging service
// account will automatically be generated.
func (c *BillingAccountsSinksUpdateCall) CustomWriterIdentity(customWriterIdentity string) *BillingAccountsSinksUpdateCall {
	c.urlParams_.Set("customWriterIdentity", customWriterIdentity)
	return c
}

// UniqueWriterIdentity sets the optional parameter "uniqueWriterIdentity": See
// sinks.create for a description of this field. When updating a sink, the
// effect of this field on the value of writer_identity in the updated sink
// depends on both the old and new values of this field: If the old and new
// values of this field are both false or both true, then there is no change to
// the sink's writer_identity. If the old value is false and the new value is
// true, then writer_identity is changed to a service agent
// (https://cloud.google.com/iam/docs/service-account-types#service-agents)
// owned by Cloud Logging. It is an error if the old value is true and the new
// value is set to false or defaulted to false.
func (c *BillingAccountsSinksUpdateCall) UniqueWriterIdentity(uniqueWriterIdentity bool) *BillingAccountsSinksUpdateCall {
	c.urlParams_.Set("uniqueWriterIdentity", fmt.Sprint(uniqueWriterIdentity))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// specifies the fields in sink that need an update. A sink field will be
// overwritten if, and only if, it is in the update mask. name and output only
// fields cannot be updated.An empty updateMask is temporarily treated as using
// the following mask for backwards compatibility
// purposes:destination,filter,includeChildrenAt some point in the future,
// behavior will be removed and specifying an empty updateMask will be an
// error.For a detailed FieldMask definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=filter
func (c *BillingAccountsSinksUpdateCall) UpdateMask(updateMask string) *BillingAccountsSinksUpdateCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BillingAccountsSinksUpdateCall) Fields(s ...googleapi.Field) *BillingAccountsSinksUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BillingAccountsSinksUpdateCall) Context(ctx context.Context) *BillingAccountsSinksUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BillingAccountsSinksUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BillingAccountsSinksUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logsink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+sinkName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sinkName": c.sinkNameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.billingAccounts.sinks.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogSink.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BillingAccountsSinksUpdateCall) Do(opts ...googleapi.CallOption) (*LogSink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogSink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.billingAccounts.sinks.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EntriesCopyCall struct {
	s                     *Service
	copylogentriesrequest *CopyLogEntriesRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Copy: Copies a set of log entries from a log bucket to a Cloud Storage
// bucket.
func (r *EntriesService) Copy(copylogentriesrequest *CopyLogEntriesRequest) *EntriesCopyCall {
	c := &EntriesCopyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.copylogentriesrequest = copylogentriesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EntriesCopyCall) Fields(s ...googleapi.Field) *EntriesCopyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EntriesCopyCall) Context(ctx context.Context) *EntriesCopyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EntriesCopyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EntriesCopyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.copylogentriesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/entries:copy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.entries.copy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.entries.copy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *EntriesCopyCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.entries.copy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EntriesListCall struct {
	s                     *Service
	listlogentriesrequest *ListLogEntriesRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// List: Lists log entries. Use this method to retrieve log entries that
// originated from a project/folder/organization/billing account. For ways to
// export log entries, see Exporting Logs
// (https://cloud.google.com/logging/docs/export).
func (r *EntriesService) List(listlogentriesrequest *ListLogEntriesRequest) *EntriesListCall {
	c := &EntriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.listlogentriesrequest = listlogentriesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EntriesListCall) Fields(s ...googleapi.Field) *EntriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EntriesListCall) Context(ctx context.Context) *EntriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EntriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EntriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.listlogentriesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/entries:list")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.entries.list", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.entries.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLogEntriesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EntriesListCall) Do(opts ...googleapi.CallOption) (*ListLogEntriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLogEntriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.entries.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *EntriesListCall) Pages(ctx context.Context, f func(*ListLogEntriesResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.listlogentriesrequest.PageToken = pt }(c.listlogentriesrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.listlogentriesrequest.PageToken = x.NextPageToken
	}
}

type EntriesTailCall struct {
	s                     *Service
	taillogentriesrequest *TailLogEntriesRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Tail: Streaming read of log entries as they are received. Until the stream
// is terminated, it will continue reading logs.
func (r *EntriesService) Tail(taillogentriesrequest *TailLogEntriesRequest) *EntriesTailCall {
	c := &EntriesTailCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.taillogentriesrequest = taillogentriesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EntriesTailCall) Fields(s ...googleapi.Field) *EntriesTailCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EntriesTailCall) Context(ctx context.Context) *EntriesTailCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EntriesTailCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EntriesTailCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.taillogentriesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/entries:tail")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.entries.tail", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.entries.tail" call.
// Any non-2xx status code is an error. Response headers are in either
// *TailLogEntriesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *EntriesTailCall) Do(opts ...googleapi.CallOption) (*TailLogEntriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TailLogEntriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.entries.tail", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type EntriesWriteCall struct {
	s                      *Service
	writelogentriesrequest *WriteLogEntriesRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Write: Writes log entries to Logging. This API method is the only way to
// send log entries to Logging. This method is used, directly or indirectly, by
// the Logging agent (fluentd) and all logging libraries configured to use
// Logging. A single request may contain log entries for a maximum of 1000
// different resource names (projects, organizations, billing accounts or
// folders), where the resource name for a log entry is determined from its
// logName field.
func (r *EntriesService) Write(writelogentriesrequest *WriteLogEntriesRequest) *EntriesWriteCall {
	c := &EntriesWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.writelogentriesrequest = writelogentriesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *EntriesWriteCall) Fields(s ...googleapi.Field) *EntriesWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *EntriesWriteCall) Context(ctx context.Context) *EntriesWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *EntriesWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *EntriesWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.writelogentriesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/entries:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.entries.write", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.entries.write" call.
// Any non-2xx status code is an error. Response headers are in either
// *WriteLogEntriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *EntriesWriteCall) Do(opts ...googleapi.CallOption) (*WriteLogEntriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WriteLogEntriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.entries.write", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ExclusionsCreateCall struct {
	s            *Service
	parent       string
	logexclusion *LogExclusion
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new exclusion in the _Default sink in a specified parent
// resource. Only log entries belonging to that resource can be excluded. You
// can have up to 10 exclusions in a resource.
//
//   - parent: The parent resource in which to create the exclusion:
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" For
//     examples:"projects/my-logging-project" "organizations/123456789".
func (r *ExclusionsService) Create(parent string, logexclusion *LogExclusion) *ExclusionsCreateCall {
	c := &ExclusionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logexclusion = logexclusion
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ExclusionsCreateCall) Fields(s ...googleapi.Field) *ExclusionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ExclusionsCreateCall) Context(ctx context.Context) *ExclusionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ExclusionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ExclusionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logexclusion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/exclusions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.exclusions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.exclusions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ExclusionsCreateCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.exclusions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ExclusionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an exclusion in the _Default sink.
//
//   - name: The resource name of an existing exclusion to delete:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *ExclusionsService) Delete(name string) *ExclusionsDeleteCall {
	c := &ExclusionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ExclusionsDeleteCall) Fields(s ...googleapi.Field) *ExclusionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ExclusionsDeleteCall) Context(ctx context.Context) *ExclusionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ExclusionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ExclusionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.exclusions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.exclusions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ExclusionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.exclusions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ExclusionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the description of an exclusion in the _Default sink.
//
//   - name: The resource name of an existing exclusion:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *ExclusionsService) Get(name string) *ExclusionsGetCall {
	c := &ExclusionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ExclusionsGetCall) Fields(s ...googleapi.Field) *ExclusionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ExclusionsGetCall) IfNoneMatch(entityTag string) *ExclusionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ExclusionsGetCall) Context(ctx context.Context) *ExclusionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ExclusionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ExclusionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.exclusions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.exclusions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ExclusionsGetCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.exclusions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ExclusionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the exclusions on the _Default sink in a parent resource.
//
//   - parent: The parent resource whose exclusions are to be listed.
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]".
func (r *ExclusionsService) List(parent string) *ExclusionsListCall {
	c := &ExclusionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *ExclusionsListCall) PageSize(pageSize int64) *ExclusionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *ExclusionsListCall) PageToken(pageToken string) *ExclusionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ExclusionsListCall) Fields(s ...googleapi.Field) *ExclusionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ExclusionsListCall) IfNoneMatch(entityTag string) *ExclusionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ExclusionsListCall) Context(ctx context.Context) *ExclusionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ExclusionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ExclusionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/exclusions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.exclusions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.exclusions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExclusionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ExclusionsListCall) Do(opts ...googleapi.CallOption) (*ListExclusionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExclusionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.exclusions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ExclusionsListCall) Pages(ctx context.Context, f func(*ListExclusionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ExclusionsPatchCall struct {
	s            *Service
	name         string
	logexclusion *LogExclusion
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Changes one or more properties of an existing exclusion in the
// _Default sink.
//
//   - name: The resource name of the exclusion to update:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *ExclusionsService) Patch(name string, logexclusion *LogExclusion) *ExclusionsPatchCall {
	c := &ExclusionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logexclusion = logexclusion
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A non-empty
// list of fields to change in the existing exclusion. New values for the
// fields are taken from the corresponding fields in the LogExclusion included
// in this request. Fields not mentioned in update_mask are not changed and are
// ignored in the request.For example, to change the filter and description of
// an exclusion, specify an update_mask of "filter,description".
func (c *ExclusionsPatchCall) UpdateMask(updateMask string) *ExclusionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ExclusionsPatchCall) Fields(s ...googleapi.Field) *ExclusionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ExclusionsPatchCall) Context(ctx context.Context) *ExclusionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ExclusionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ExclusionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logexclusion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.exclusions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.exclusions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ExclusionsPatchCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.exclusions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersGetCmekSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetCmekSettings: Gets the Logging CMEK settings for the given resource.Note:
// CMEK for the Log Router can be configured for Google Cloud projects,
// folders, organizations, and billing accounts. Once configured for an
// organization, it applies to all projects and folders in the Google Cloud
// organization.See Enabling CMEK for Log Router
// (https://cloud.google.com/logging/docs/routing/managed-encryption) for more
// information.
//
//   - name: The resource for which to retrieve CMEK settings.
//     "projects/[PROJECT_ID]/cmekSettings"
//     "organizations/[ORGANIZATION_ID]/cmekSettings"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
//     "folders/[FOLDER_ID]/cmekSettings" For
//     example:"organizations/12345/cmekSettings"Note: CMEK for the Log Router
//     can be configured for Google Cloud projects, folders, organizations, and
//     billing accounts. Once configured for an organization, it applies to all
//     projects and folders in the Google Cloud organization.
func (r *FoldersService) GetCmekSettings(name string) *FoldersGetCmekSettingsCall {
	c := &FoldersGetCmekSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersGetCmekSettingsCall) Fields(s ...googleapi.Field) *FoldersGetCmekSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersGetCmekSettingsCall) IfNoneMatch(entityTag string) *FoldersGetCmekSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersGetCmekSettingsCall) Context(ctx context.Context) *FoldersGetCmekSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersGetCmekSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersGetCmekSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/cmekSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.getCmekSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.getCmekSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *CmekSettings.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersGetCmekSettingsCall) Do(opts ...googleapi.CallOption) (*CmekSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CmekSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.getCmekSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersGetSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSettings: Gets the settings for the given resource.Note: Settings can be
// retrieved for Google Cloud projects, folders, organizations, and billing
// accounts.See View default resource settings for Logging
// (https://cloud.google.com/logging/docs/default-settings#view-org-settings)
// for more information.
//
//   - name: The resource for which to retrieve settings.
//     "projects/[PROJECT_ID]/settings"
//     "organizations/[ORGANIZATION_ID]/settings"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/settings"
//     "folders/[FOLDER_ID]/settings" For
//     example:"organizations/12345/settings"Note: Settings can be retrieved for
//     Google Cloud projects, folders, organizations, and billing accounts.
func (r *FoldersService) GetSettings(name string) *FoldersGetSettingsCall {
	c := &FoldersGetSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersGetSettingsCall) Fields(s ...googleapi.Field) *FoldersGetSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersGetSettingsCall) IfNoneMatch(entityTag string) *FoldersGetSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersGetSettingsCall) Context(ctx context.Context) *FoldersGetSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersGetSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersGetSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.getSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.getSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Settings.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersGetSettingsCall) Do(opts ...googleapi.CallOption) (*Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.getSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersUpdateSettingsCall struct {
	s          *Service
	name       string
	settings   *Settings
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateSettings: Updates the settings for the given resource. This method
// applies to all feature configurations for organization and
// folders.UpdateSettings fails when any of the following are true: The value
// of storage_location either isn't supported by Logging or violates the
// location OrgPolicy. The default_sink_config field is set, but it has an
// unspecified filter write mode. The value of kms_key_name is invalid. The
// associated service account doesn't have the required
// roles/cloudkms.cryptoKeyEncrypterDecrypter role assigned for the key. Access
// to the key is disabled.See Configure default settings for organizations and
// folders (https://cloud.google.com/logging/docs/default-settings) for more
// information.
//
//   - name: The resource name for the settings to update.
//     "organizations/[ORGANIZATION_ID]/settings" "folders/[FOLDER_ID]/settings"
//     For example:"organizations/12345/settings".
func (r *FoldersService) UpdateSettings(name string, settings *Settings) *FoldersUpdateSettingsCall {
	c := &FoldersUpdateSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.settings = settings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask identifying
// which fields from settings should be updated. A field will be overwritten if
// and only if it is in the update mask. Output only fields cannot be
// updated.See FieldMask for more information.For example:
// "updateMask=kmsKeyName"
func (c *FoldersUpdateSettingsCall) UpdateMask(updateMask string) *FoldersUpdateSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersUpdateSettingsCall) Fields(s ...googleapi.Field) *FoldersUpdateSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersUpdateSettingsCall) Context(ctx context.Context) *FoldersUpdateSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersUpdateSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersUpdateSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.settings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.updateSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.updateSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Settings.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersUpdateSettingsCall) Do(opts ...googleapi.CallOption) (*Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.updateSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersExclusionsCreateCall struct {
	s            *Service
	parent       string
	logexclusion *LogExclusion
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new exclusion in the _Default sink in a specified parent
// resource. Only log entries belonging to that resource can be excluded. You
// can have up to 10 exclusions in a resource.
//
//   - parent: The parent resource in which to create the exclusion:
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" For
//     examples:"projects/my-logging-project" "organizations/123456789".
func (r *FoldersExclusionsService) Create(parent string, logexclusion *LogExclusion) *FoldersExclusionsCreateCall {
	c := &FoldersExclusionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logexclusion = logexclusion
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersExclusionsCreateCall) Fields(s ...googleapi.Field) *FoldersExclusionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersExclusionsCreateCall) Context(ctx context.Context) *FoldersExclusionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersExclusionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersExclusionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logexclusion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/exclusions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.exclusions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.exclusions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersExclusionsCreateCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.exclusions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersExclusionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an exclusion in the _Default sink.
//
//   - name: The resource name of an existing exclusion to delete:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *FoldersExclusionsService) Delete(name string) *FoldersExclusionsDeleteCall {
	c := &FoldersExclusionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersExclusionsDeleteCall) Fields(s ...googleapi.Field) *FoldersExclusionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersExclusionsDeleteCall) Context(ctx context.Context) *FoldersExclusionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersExclusionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersExclusionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.exclusions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.exclusions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersExclusionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.exclusions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersExclusionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the description of an exclusion in the _Default sink.
//
//   - name: The resource name of an existing exclusion:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *FoldersExclusionsService) Get(name string) *FoldersExclusionsGetCall {
	c := &FoldersExclusionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersExclusionsGetCall) Fields(s ...googleapi.Field) *FoldersExclusionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersExclusionsGetCall) IfNoneMatch(entityTag string) *FoldersExclusionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersExclusionsGetCall) Context(ctx context.Context) *FoldersExclusionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersExclusionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersExclusionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.exclusions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.exclusions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersExclusionsGetCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.exclusions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersExclusionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the exclusions on the _Default sink in a parent resource.
//
//   - parent: The parent resource whose exclusions are to be listed.
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]".
func (r *FoldersExclusionsService) List(parent string) *FoldersExclusionsListCall {
	c := &FoldersExclusionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *FoldersExclusionsListCall) PageSize(pageSize int64) *FoldersExclusionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *FoldersExclusionsListCall) PageToken(pageToken string) *FoldersExclusionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersExclusionsListCall) Fields(s ...googleapi.Field) *FoldersExclusionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersExclusionsListCall) IfNoneMatch(entityTag string) *FoldersExclusionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersExclusionsListCall) Context(ctx context.Context) *FoldersExclusionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersExclusionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersExclusionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/exclusions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.exclusions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.exclusions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExclusionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersExclusionsListCall) Do(opts ...googleapi.CallOption) (*ListExclusionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExclusionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.exclusions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersExclusionsListCall) Pages(ctx context.Context, f func(*ListExclusionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersExclusionsPatchCall struct {
	s            *Service
	name         string
	logexclusion *LogExclusion
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Changes one or more properties of an existing exclusion in the
// _Default sink.
//
//   - name: The resource name of the exclusion to update:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *FoldersExclusionsService) Patch(name string, logexclusion *LogExclusion) *FoldersExclusionsPatchCall {
	c := &FoldersExclusionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logexclusion = logexclusion
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A non-empty
// list of fields to change in the existing exclusion. New values for the
// fields are taken from the corresponding fields in the LogExclusion included
// in this request. Fields not mentioned in update_mask are not changed and are
// ignored in the request.For example, to change the filter and description of
// an exclusion, specify an update_mask of "filter,description".
func (c *FoldersExclusionsPatchCall) UpdateMask(updateMask string) *FoldersExclusionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersExclusionsPatchCall) Fields(s ...googleapi.Field) *FoldersExclusionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersExclusionsPatchCall) Context(ctx context.Context) *FoldersExclusionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersExclusionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersExclusionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logexclusion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.exclusions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.exclusions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersExclusionsPatchCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.exclusions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *FoldersLocationsService) Get(name string) *FoldersLocationsGetCall {
	c := &FoldersLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsGetCall) Context(ctx context.Context) *FoldersLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *FoldersLocationsService) List(name string) *FoldersLocationsListCall {
	c := &FoldersLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *FoldersLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *FoldersLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *FoldersLocationsListCall) Filter(filter string) *FoldersLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *FoldersLocationsListCall) PageSize(pageSize int64) *FoldersLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the next_page_token field in the response. Send that page token to
// receive the subsequent page.
func (c *FoldersLocationsListCall) PageToken(pageToken string) *FoldersLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsListCall) Fields(s ...googleapi.Field) *FoldersLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsListCall) IfNoneMatch(entityTag string) *FoldersLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsListCall) Context(ctx context.Context) *FoldersLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsBucketsCreateCall struct {
	s          *Service
	parent     string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a log bucket that can be used to store log entries. After a
// bucket has been created, the bucket's location cannot be changed.
//
//   - parent: The resource in which to create the log bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global".
func (r *FoldersLocationsBucketsService) Create(parent string, logbucket *LogBucket) *FoldersLocationsBucketsCreateCall {
	c := &FoldersLocationsBucketsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logbucket = logbucket
	return c
}

// BucketId sets the optional parameter "bucketId": Required. A client-assigned
// identifier such as "my-bucket". Identifiers are limited to 100 characters
// and can include only letters, digits, underscores, hyphens, and periods.
// Bucket identifiers must start with an alphanumeric character.
func (c *FoldersLocationsBucketsCreateCall) BucketId(bucketId string) *FoldersLocationsBucketsCreateCall {
	c.urlParams_.Set("bucketId", bucketId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsCreateCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsCreateCall) Context(ctx context.Context) *FoldersLocationsBucketsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsCreateCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsCreateAsyncCall struct {
	s          *Service
	parent     string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// CreateAsync: Creates a log bucket asynchronously that can be used to store
// log entries.After a bucket has been created, the bucket's location cannot be
// changed.
//
//   - parent: The resource in which to create the log bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global".
func (r *FoldersLocationsBucketsService) CreateAsync(parent string, logbucket *LogBucket) *FoldersLocationsBucketsCreateAsyncCall {
	c := &FoldersLocationsBucketsCreateAsyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logbucket = logbucket
	return c
}

// BucketId sets the optional parameter "bucketId": Required. A client-assigned
// identifier such as "my-bucket". Identifiers are limited to 100 characters
// and can include only letters, digits, underscores, hyphens, and periods.
// Bucket identifiers must start with an alphanumeric character.
func (c *FoldersLocationsBucketsCreateAsyncCall) BucketId(bucketId string) *FoldersLocationsBucketsCreateAsyncCall {
	c.urlParams_.Set("bucketId", bucketId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsCreateAsyncCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsCreateAsyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsCreateAsyncCall) Context(ctx context.Context) *FoldersLocationsBucketsCreateAsyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsCreateAsyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsCreateAsyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets:createAsync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.createAsync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.createAsync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsCreateAsyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.createAsync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a log bucket.Changes the bucket's lifecycle_state to the
// DELETE_REQUESTED state. After 7 days, the bucket will be purged and all log
// entries in the bucket will be permanently deleted.
//
//   - name: The full resource name of the bucket to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *FoldersLocationsBucketsService) Delete(name string) *FoldersLocationsBucketsDeleteCall {
	c := &FoldersLocationsBucketsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsDeleteCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsDeleteCall) Context(ctx context.Context) *FoldersLocationsBucketsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a log bucket.
//
//   - name: The resource name of the bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *FoldersLocationsBucketsService) Get(name string) *FoldersLocationsBucketsGetCall {
	c := &FoldersLocationsBucketsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsBucketsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsBucketsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsGetCall) Context(ctx context.Context) *FoldersLocationsBucketsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsGetCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists log buckets.
//
//   - parent: The parent resource whose buckets are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Note: The locations portion
//     of the resource must be specified, but supplying the character - in place
//     of LOCATION_ID will return all buckets.
func (r *FoldersLocationsBucketsService) List(parent string) *FoldersLocationsBucketsListCall {
	c := &FoldersLocationsBucketsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *FoldersLocationsBucketsListCall) PageSize(pageSize int64) *FoldersLocationsBucketsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *FoldersLocationsBucketsListCall) PageToken(pageToken string) *FoldersLocationsBucketsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsListCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsBucketsListCall) IfNoneMatch(entityTag string) *FoldersLocationsBucketsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsListCall) Context(ctx context.Context) *FoldersLocationsBucketsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBucketsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLocationsBucketsListCall) Do(opts ...googleapi.CallOption) (*ListBucketsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBucketsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsBucketsListCall) Pages(ctx context.Context, f func(*ListBucketsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsBucketsPatchCall struct {
	s          *Service
	name       string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a log bucket.If the bucket has a lifecycle_state of
// DELETE_REQUESTED, then FAILED_PRECONDITION will be returned.After a bucket
// has been created, the bucket's location cannot be changed.
//
//   - name: The full resource name of the bucket to update.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *FoldersLocationsBucketsService) Patch(name string, logbucket *LogBucket) *FoldersLocationsBucketsPatchCall {
	c := &FoldersLocationsBucketsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logbucket = logbucket
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// that specifies the fields in bucket that need an update. A bucket field will
// be overwritten if, and only if, it is in the update mask. name and output
// only fields cannot be updated.For a detailed FieldMask definition, see:
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=retention_days
func (c *FoldersLocationsBucketsPatchCall) UpdateMask(updateMask string) *FoldersLocationsBucketsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsPatchCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsPatchCall) Context(ctx context.Context) *FoldersLocationsBucketsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsPatchCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsUndeleteCall struct {
	s                     *Service
	name                  string
	undeletebucketrequest *UndeleteBucketRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Undelete: Undeletes a log bucket. A bucket that has been deleted can be
// undeleted within the grace period of 7 days.
//
//   - name: The full resource name of the bucket to undelete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *FoldersLocationsBucketsService) Undelete(name string, undeletebucketrequest *UndeleteBucketRequest) *FoldersLocationsBucketsUndeleteCall {
	c := &FoldersLocationsBucketsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.undeletebucketrequest = undeletebucketrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsUndeleteCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsUndeleteCall) Context(ctx context.Context) *FoldersLocationsBucketsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.undeletebucketrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.undelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.undelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsUndeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.undelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsUpdateAsyncCall struct {
	s          *Service
	name       string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateAsync: Updates a log bucket asynchronously.If the bucket has a
// lifecycle_state of DELETE_REQUESTED, then FAILED_PRECONDITION will be
// returned.After a bucket has been created, the bucket's location cannot be
// changed.
//
//   - name: The full resource name of the bucket to update.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *FoldersLocationsBucketsService) UpdateAsync(name string, logbucket *LogBucket) *FoldersLocationsBucketsUpdateAsyncCall {
	c := &FoldersLocationsBucketsUpdateAsyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logbucket = logbucket
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// that specifies the fields in bucket that need an update. A bucket field will
// be overwritten if, and only if, it is in the update mask. name and output
// only fields cannot be updated.For a detailed FieldMask definition, see:
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=retention_days
func (c *FoldersLocationsBucketsUpdateAsyncCall) UpdateMask(updateMask string) *FoldersLocationsBucketsUpdateAsyncCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsUpdateAsyncCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsUpdateAsyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsUpdateAsyncCall) Context(ctx context.Context) *FoldersLocationsBucketsUpdateAsyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsUpdateAsyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsUpdateAsyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:updateAsync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.updateAsync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.updateAsync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsUpdateAsyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.updateAsync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsLinksCreateCall struct {
	s          *Service
	parent     string
	link       *Link
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Asynchronously creates a linked dataset in BigQuery which makes it
// possible to use BigQuery to read the logs stored in the log bucket. A log
// bucket may currently only contain one link.
//
//   - parent: The full resource name of the bucket to create a link for.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *FoldersLocationsBucketsLinksService) Create(parent string, link *Link) *FoldersLocationsBucketsLinksCreateCall {
	c := &FoldersLocationsBucketsLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.link = link
	return c
}

// LinkId sets the optional parameter "linkId": Required. The ID to use for the
// link. The link_id can have up to 100 characters. A valid link_id must only
// have alphanumeric characters and underscores within it.
func (c *FoldersLocationsBucketsLinksCreateCall) LinkId(linkId string) *FoldersLocationsBucketsLinksCreateCall {
	c.urlParams_.Set("linkId", linkId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsLinksCreateCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsLinksCreateCall) Context(ctx context.Context) *FoldersLocationsBucketsLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.link)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/links")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.links.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.links.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsLinksCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.links.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a link. This will also delete the corresponding BigQuery
// linked dataset.
//
//   - name: The full resource name of the link to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[L
//     INK_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]/links/[LINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]/links/[LINK_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
//     K_ID]".
func (r *FoldersLocationsBucketsLinksService) Delete(name string) *FoldersLocationsBucketsLinksDeleteCall {
	c := &FoldersLocationsBucketsLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsLinksDeleteCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsLinksDeleteCall) Context(ctx context.Context) *FoldersLocationsBucketsLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.links.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.links.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsLinksDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.links.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a link.
//
//   - name: The resource name of the link:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[L
//     INK_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]/links/[LINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]/links/[LINK_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
//     K_ID]".
func (r *FoldersLocationsBucketsLinksService) Get(name string) *FoldersLocationsBucketsLinksGetCall {
	c := &FoldersLocationsBucketsLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsLinksGetCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsBucketsLinksGetCall) IfNoneMatch(entityTag string) *FoldersLocationsBucketsLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsLinksGetCall) Context(ctx context.Context) *FoldersLocationsBucketsLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.links.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.links.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Link.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsLinksGetCall) Do(opts ...googleapi.CallOption) (*Link, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Link{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.links.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists links.
//
//   - parent: The parent resource whose links are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *FoldersLocationsBucketsLinksService) List(parent string) *FoldersLocationsBucketsLinksListCall {
	c := &FoldersLocationsBucketsLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.
func (c *FoldersLocationsBucketsLinksListCall) PageSize(pageSize int64) *FoldersLocationsBucketsLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response.
func (c *FoldersLocationsBucketsLinksListCall) PageToken(pageToken string) *FoldersLocationsBucketsLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsLinksListCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsBucketsLinksListCall) IfNoneMatch(entityTag string) *FoldersLocationsBucketsLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsLinksListCall) Context(ctx context.Context) *FoldersLocationsBucketsLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/links")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.links.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.links.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLinksResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLocationsBucketsLinksListCall) Do(opts ...googleapi.CallOption) (*ListLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.links.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsBucketsLinksListCall) Pages(ctx context.Context, f func(*ListLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsBucketsViewsCreateCall struct {
	s          *Service
	parent     string
	logview    *LogView
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a view over log entries in a log bucket. A bucket may
// contain a maximum of 30 views.
//
//   - parent: The bucket in which to create the view
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *FoldersLocationsBucketsViewsService) Create(parent string, logview *LogView) *FoldersLocationsBucketsViewsCreateCall {
	c := &FoldersLocationsBucketsViewsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logview = logview
	return c
}

// ViewId sets the optional parameter "viewId": Required. A client-assigned
// identifier such as "my-view". Identifiers are limited to 100 characters and
// can include only letters, digits, underscores, and hyphens.
func (c *FoldersLocationsBucketsViewsCreateCall) ViewId(viewId string) *FoldersLocationsBucketsViewsCreateCall {
	c.urlParams_.Set("viewId", viewId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsViewsCreateCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsViewsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsViewsCreateCall) Context(ctx context.Context) *FoldersLocationsBucketsViewsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsViewsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsViewsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.views.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsViewsCreateCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsViewsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a view on a log bucket. If an UNAVAILABLE error is returned,
// this indicates that system is not in a state where it can delete the view.
// If this occurs, please try again in a few minutes.
//
//   - name: The full resource name of the view to delete:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *FoldersLocationsBucketsViewsService) Delete(name string) *FoldersLocationsBucketsViewsDeleteCall {
	c := &FoldersLocationsBucketsViewsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsViewsDeleteCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsViewsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsViewsDeleteCall) Context(ctx context.Context) *FoldersLocationsBucketsViewsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsViewsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsViewsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.views.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsViewsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsViewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a view on a log bucket.
//
//   - name: The resource name of the policy:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *FoldersLocationsBucketsViewsService) Get(name string) *FoldersLocationsBucketsViewsGetCall {
	c := &FoldersLocationsBucketsViewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsViewsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsViewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsBucketsViewsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsBucketsViewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsViewsGetCall) Context(ctx context.Context) *FoldersLocationsBucketsViewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsViewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsViewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.views.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsViewsGetCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsViewsGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *FoldersLocationsBucketsViewsService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *FoldersLocationsBucketsViewsGetIamPolicyCall {
	c := &FoldersLocationsBucketsViewsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsViewsGetIamPolicyCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsViewsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsViewsGetIamPolicyCall) Context(ctx context.Context) *FoldersLocationsBucketsViewsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsViewsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsViewsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.views.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsViewsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsViewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists views on a log bucket.
//
//   - parent: The bucket whose views are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *FoldersLocationsBucketsViewsService) List(parent string) *FoldersLocationsBucketsViewsListCall {
	c := &FoldersLocationsBucketsViewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *FoldersLocationsBucketsViewsListCall) PageSize(pageSize int64) *FoldersLocationsBucketsViewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *FoldersLocationsBucketsViewsListCall) PageToken(pageToken string) *FoldersLocationsBucketsViewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsViewsListCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsViewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsBucketsViewsListCall) IfNoneMatch(entityTag string) *FoldersLocationsBucketsViewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsViewsListCall) Context(ctx context.Context) *FoldersLocationsBucketsViewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsViewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsViewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.views.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListViewsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLocationsBucketsViewsListCall) Do(opts ...googleapi.CallOption) (*ListViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsBucketsViewsListCall) Pages(ctx context.Context, f func(*ListViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsBucketsViewsPatchCall struct {
	s          *Service
	name       string
	logview    *LogView
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a view on a log bucket. This method replaces the value of the
// filter field from the existing view with the corresponding value from the
// new view. If an UNAVAILABLE error is returned, this indicates that system is
// not in a state where it can update the view. If this occurs, please try
// again in a few minutes.
//
//   - name: The full resource name of the view to update
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *FoldersLocationsBucketsViewsService) Patch(name string, logview *LogView) *FoldersLocationsBucketsViewsPatchCall {
	c := &FoldersLocationsBucketsViewsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logview = logview
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// specifies the fields in view that need an update. A field will be
// overwritten if, and only if, it is in the update mask. name and output only
// fields cannot be updated.For a detailed FieldMask definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=filter
func (c *FoldersLocationsBucketsViewsPatchCall) UpdateMask(updateMask string) *FoldersLocationsBucketsViewsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsViewsPatchCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsViewsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsViewsPatchCall) Context(ctx context.Context) *FoldersLocationsBucketsViewsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsViewsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsViewsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.views.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsViewsPatchCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsViewsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
// PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *FoldersLocationsBucketsViewsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *FoldersLocationsBucketsViewsSetIamPolicyCall {
	c := &FoldersLocationsBucketsViewsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsViewsSetIamPolicyCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsViewsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsViewsSetIamPolicyCall) Context(ctx context.Context) *FoldersLocationsBucketsViewsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsViewsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsViewsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.views.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsViewsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsViewsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *FoldersLocationsBucketsViewsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *FoldersLocationsBucketsViewsTestIamPermissionsCall {
	c := &FoldersLocationsBucketsViewsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsViewsTestIamPermissionsCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsViewsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsViewsTestIamPermissionsCall) Context(ctx context.Context) *FoldersLocationsBucketsViewsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsViewsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsViewsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.views.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsBucketsViewsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsBucketsViewsLogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the logs in projects, organizations, folders, or billing
// accounts. Only logs that have entries are listed.
//
//   - parent: The resource name to list logs for: projects/[PROJECT_ID]
//     organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
//     folders/[FOLDER_ID].
func (r *FoldersLocationsBucketsViewsLogsService) List(parent string) *FoldersLocationsBucketsViewsLogsListCall {
	c := &FoldersLocationsBucketsViewsLogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *FoldersLocationsBucketsViewsLogsListCall) PageSize(pageSize int64) *FoldersLocationsBucketsViewsLogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *FoldersLocationsBucketsViewsLogsListCall) PageToken(pageToken string) *FoldersLocationsBucketsViewsLogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ResourceNames sets the optional parameter "resourceNames": List of resource
// names to list logs for:
// projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW
// _ID]
// organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/v
// iews/[VIEW_ID]
// billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_
// ID]/views/[VIEW_ID]
// folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_I
// D]To support legacy queries, it could also be: projects/[PROJECT_ID]
// organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
// folders/[FOLDER_ID]The resource name in the parent field is added to this
// list.
func (c *FoldersLocationsBucketsViewsLogsListCall) ResourceNames(resourceNames ...string) *FoldersLocationsBucketsViewsLogsListCall {
	c.urlParams_.SetMulti("resourceNames", append([]string{}, resourceNames...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsBucketsViewsLogsListCall) Fields(s ...googleapi.Field) *FoldersLocationsBucketsViewsLogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsBucketsViewsLogsListCall) IfNoneMatch(entityTag string) *FoldersLocationsBucketsViewsLogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsBucketsViewsLogsListCall) Context(ctx context.Context) *FoldersLocationsBucketsViewsLogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsBucketsViewsLogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsBucketsViewsLogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/logs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.logs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.buckets.views.logs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLogsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLocationsBucketsViewsLogsListCall) Do(opts ...googleapi.CallOption) (*ListLogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.buckets.views.logs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsBucketsViewsLogsListCall) Pages(ctx context.Context, f func(*ListLogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsLogScopesCreateCall struct {
	s          *Service
	parent     string
	logscope   *LogScope
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a log scope.
//
//   - parent: The parent resource in which to create the log scope:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global".
func (r *FoldersLocationsLogScopesService) Create(parent string, logscope *LogScope) *FoldersLocationsLogScopesCreateCall {
	c := &FoldersLocationsLogScopesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logscope = logscope
	return c
}

// LogScopeId sets the optional parameter "logScopeId": Required. A
// client-assigned identifier such as "log-scope". Identifiers are limited to
// 100 characters and can include only letters, digits, underscores, hyphens,
// and periods. First character has to be alphanumeric.
func (c *FoldersLocationsLogScopesCreateCall) LogScopeId(logScopeId string) *FoldersLocationsLogScopesCreateCall {
	c.urlParams_.Set("logScopeId", logScopeId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsLogScopesCreateCall) Fields(s ...googleapi.Field) *FoldersLocationsLogScopesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsLogScopesCreateCall) Context(ctx context.Context) *FoldersLocationsLogScopesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsLogScopesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsLogScopesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logscope)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/logScopes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.logScopes.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogScope.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsLogScopesCreateCall) Do(opts ...googleapi.CallOption) (*LogScope, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogScope{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsLogScopesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a log scope.
//
//   - name: The resource name of the log scope to delete:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global/logScopes/my-log-scope".
func (r *FoldersLocationsLogScopesService) Delete(name string) *FoldersLocationsLogScopesDeleteCall {
	c := &FoldersLocationsLogScopesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsLogScopesDeleteCall) Fields(s ...googleapi.Field) *FoldersLocationsLogScopesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsLogScopesDeleteCall) Context(ctx context.Context) *FoldersLocationsLogScopesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsLogScopesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsLogScopesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.logScopes.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsLogScopesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsLogScopesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a log scope.
//
//   - name: The resource name of the log scope:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global/logScopes/my-log-scope".
func (r *FoldersLocationsLogScopesService) Get(name string) *FoldersLocationsLogScopesGetCall {
	c := &FoldersLocationsLogScopesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsLogScopesGetCall) Fields(s ...googleapi.Field) *FoldersLocationsLogScopesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsLogScopesGetCall) IfNoneMatch(entityTag string) *FoldersLocationsLogScopesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsLogScopesGetCall) Context(ctx context.Context) *FoldersLocationsLogScopesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsLogScopesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsLogScopesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.logScopes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogScope.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsLogScopesGetCall) Do(opts ...googleapi.CallOption) (*LogScope, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogScope{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsLogScopesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists log scopes.
//
//   - parent: The parent resource whose log scopes are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]".
func (r *FoldersLocationsLogScopesService) List(parent string) *FoldersLocationsLogScopesListCall {
	c := &FoldersLocationsLogScopesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *FoldersLocationsLogScopesListCall) PageSize(pageSize int64) *FoldersLocationsLogScopesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *FoldersLocationsLogScopesListCall) PageToken(pageToken string) *FoldersLocationsLogScopesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsLogScopesListCall) Fields(s ...googleapi.Field) *FoldersLocationsLogScopesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsLogScopesListCall) IfNoneMatch(entityTag string) *FoldersLocationsLogScopesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsLogScopesListCall) Context(ctx context.Context) *FoldersLocationsLogScopesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsLogScopesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsLogScopesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/logScopes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.logScopes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLogScopesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLocationsLogScopesListCall) Do(opts ...googleapi.CallOption) (*ListLogScopesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLogScopesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsLogScopesListCall) Pages(ctx context.Context, f func(*ListLogScopesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsLogScopesPatchCall struct {
	s          *Service
	name       string
	logscope   *LogScope
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a log scope.
//
//   - name: Output only. The resource name of the log scope.Log scopes are only
//     available in the global location. For
//     example:projects/my-project/locations/global/logScopes/my-log-scope.
func (r *FoldersLocationsLogScopesService) Patch(name string, logscope *LogScope) *FoldersLocationsLogScopesPatchCall {
	c := &FoldersLocationsLogScopesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logscope = logscope
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// specifies the fields in log_scope that need an update. A field will be
// overwritten if, and only if, it is in the update mask. name and output only
// fields cannot be updated.For a detailed FieldMask definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=description
func (c *FoldersLocationsLogScopesPatchCall) UpdateMask(updateMask string) *FoldersLocationsLogScopesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsLogScopesPatchCall) Fields(s ...googleapi.Field) *FoldersLocationsLogScopesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsLogScopesPatchCall) Context(ctx context.Context) *FoldersLocationsLogScopesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsLogScopesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsLogScopesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logscope)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.logScopes.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogScope.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsLogScopesPatchCall) Do(opts ...googleapi.CallOption) (*LogScope, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogScope{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.logScopes.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// google.rpc.Code.UNIMPLEMENTED. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of 1, corresponding to
// Code.CANCELLED.
//
// - name: The name of the operation resource to be cancelled.
func (r *FoldersLocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *FoldersLocationsOperationsCancelCall {
	c := &FoldersLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *FoldersLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsOperationsCancelCall) Context(ctx context.Context) *FoldersLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *FoldersLocationsOperationsService) Get(name string) *FoldersLocationsOperationsGetCall {
	c := &FoldersLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsOperationsGetCall) Fields(s ...googleapi.Field) *FoldersLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsOperationsGetCall) IfNoneMatch(entityTag string) *FoldersLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsOperationsGetCall) Context(ctx context.Context) *FoldersLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns UNIMPLEMENTED.
//
// - name: The name of the operation's parent resource.
func (r *FoldersLocationsOperationsService) List(name string) *FoldersLocationsOperationsListCall {
	c := &FoldersLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *FoldersLocationsOperationsListCall) Filter(filter string) *FoldersLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *FoldersLocationsOperationsListCall) PageSize(pageSize int64) *FoldersLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *FoldersLocationsOperationsListCall) PageToken(pageToken string) *FoldersLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to true, operations that are reachable are returned as normal, and
// those that are unreachable are returned in the
// ListOperationsResponse.unreachable field.This can only be true when reading
// across collections. For example, when parent is set to
// "projects/example/locations/-".This field is not supported by default and
// will result in an UNIMPLEMENTED error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *FoldersLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *FoldersLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsOperationsListCall) Fields(s ...googleapi.Field) *FoldersLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsOperationsListCall) IfNoneMatch(entityTag string) *FoldersLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsOperationsListCall) Context(ctx context.Context) *FoldersLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsRecentQueriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the RecentQueries that were created by the user making the
// request.
//
//   - parent: The resource to which the listed queries belong.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" For
//     example:projects/my-project/locations/us-central1Note: The location
//     portion of the resource must be specified, but supplying the character -
//     in place of LOCATION_ID will return all recent queries.
func (r *FoldersLocationsRecentQueriesService) List(parent string) *FoldersLocationsRecentQueriesListCall {
	c := &FoldersLocationsRecentQueriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Specifies the type ("Logging"
// or "OpsAnalytics") of the recent queries to list. The only valid value for
// this field is one of the two allowable type function calls, which are the
// following: type("Logging") type("OpsAnalytics")
func (c *FoldersLocationsRecentQueriesListCall) Filter(filter string) *FoldersLocationsRecentQueriesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *FoldersLocationsRecentQueriesListCall) PageSize(pageSize int64) *FoldersLocationsRecentQueriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *FoldersLocationsRecentQueriesListCall) PageToken(pageToken string) *FoldersLocationsRecentQueriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsRecentQueriesListCall) Fields(s ...googleapi.Field) *FoldersLocationsRecentQueriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsRecentQueriesListCall) IfNoneMatch(entityTag string) *FoldersLocationsRecentQueriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsRecentQueriesListCall) Context(ctx context.Context) *FoldersLocationsRecentQueriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsRecentQueriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsRecentQueriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/recentQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.recentQueries.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.recentQueries.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRecentQueriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsRecentQueriesListCall) Do(opts ...googleapi.CallOption) (*ListRecentQueriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRecentQueriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.recentQueries.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsRecentQueriesListCall) Pages(ctx context.Context, f func(*ListRecentQueriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsSavedQueriesCreateCall struct {
	s          *Service
	parent     string
	savedquery *SavedQuery
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new SavedQuery for the user making the request.
//
//   - parent: The parent resource in which to create the saved query:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" For example:
//     "projects/my-project/locations/global"
//     "organizations/123456789/locations/us-central1".
func (r *FoldersLocationsSavedQueriesService) Create(parent string, savedquery *SavedQuery) *FoldersLocationsSavedQueriesCreateCall {
	c := &FoldersLocationsSavedQueriesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.savedquery = savedquery
	return c
}

// SavedQueryId sets the optional parameter "savedQueryId": The ID to use for
// the saved query, which will become the final component of the saved query's
// resource name.If the saved_query_id is not provided, the system will
// generate an alphanumeric ID.The saved_query_id is limited to 100 characters
// and can include only the following characters: upper and lower-case
// alphanumeric characters, underscores, hyphens, periods.First character has
// to be alphanumeric.
func (c *FoldersLocationsSavedQueriesCreateCall) SavedQueryId(savedQueryId string) *FoldersLocationsSavedQueriesCreateCall {
	c.urlParams_.Set("savedQueryId", savedQueryId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsSavedQueriesCreateCall) Fields(s ...googleapi.Field) *FoldersLocationsSavedQueriesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsSavedQueriesCreateCall) Context(ctx context.Context) *FoldersLocationsSavedQueriesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsSavedQueriesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsSavedQueriesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.savedquery)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/savedQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.savedQueries.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *SavedQuery.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsSavedQueriesCreateCall) Do(opts ...googleapi.CallOption) (*SavedQuery, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SavedQuery{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsSavedQueriesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing SavedQuery that was created by the user making
// the request.
//
//   - name: The full resource name of the saved query to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/savedQueries/[QUER
//     Y_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/savedQueries/
//     [QUERY_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]" For
//     example:
//     "projects/my-project/locations/global/savedQueries/my-saved-query".
func (r *FoldersLocationsSavedQueriesService) Delete(name string) *FoldersLocationsSavedQueriesDeleteCall {
	c := &FoldersLocationsSavedQueriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsSavedQueriesDeleteCall) Fields(s ...googleapi.Field) *FoldersLocationsSavedQueriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsSavedQueriesDeleteCall) Context(ctx context.Context) *FoldersLocationsSavedQueriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsSavedQueriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsSavedQueriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.savedQueries.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsSavedQueriesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsSavedQueriesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns all data associated with the requested query.
//
//   - name: The resource name of the saved query.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/savedQueries/[QUER
//     Y_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/savedQueries/
//     [QUERY_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]" For
//     example:
//     "projects/my-project/locations/global/savedQueries/my-saved-query".
func (r *FoldersLocationsSavedQueriesService) Get(name string) *FoldersLocationsSavedQueriesGetCall {
	c := &FoldersLocationsSavedQueriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsSavedQueriesGetCall) Fields(s ...googleapi.Field) *FoldersLocationsSavedQueriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsSavedQueriesGetCall) IfNoneMatch(entityTag string) *FoldersLocationsSavedQueriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsSavedQueriesGetCall) Context(ctx context.Context) *FoldersLocationsSavedQueriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsSavedQueriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsSavedQueriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.savedQueries.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *SavedQuery.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsSavedQueriesGetCall) Do(opts ...googleapi.CallOption) (*SavedQuery, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SavedQuery{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLocationsSavedQueriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the SavedQueries that were created by the user making the
// request.
//
//   - parent: The resource to which the listed queries belong.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" For example:
//     "projects/my-project/locations/us-central1" Note: The locations portion of
//     the resource must be specified. To get a list of all saved queries, a
//     wildcard character - can be used for LOCATION_ID, for example:
//     "projects/my-project/locations/-".
func (r *FoldersLocationsSavedQueriesService) List(parent string) *FoldersLocationsSavedQueriesListCall {
	c := &FoldersLocationsSavedQueriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Specifies the type ("Logging"
// or "OpsAnalytics") and the visibility (PRIVATE or SHARED) of the saved
// queries to list. If provided, the filter must contain either the type
// function or a visibility token, or both. If both are chosen, they can be
// placed in any order, but they must be joined by the AND operator or the
// empty character.The two supported type function calls are: type("Logging")
// type("OpsAnalytics")The two supported visibility tokens are: visibility =
// PRIVATE visibility = SHAREDFor example:type("Logging") AND visibility =
// PRIVATE visibility=SHARED type("OpsAnalytics") type("OpsAnalytics)"
// visibility = PRIVATE visibility = SHARED
func (c *FoldersLocationsSavedQueriesListCall) Filter(filter string) *FoldersLocationsSavedQueriesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *FoldersLocationsSavedQueriesListCall) PageSize(pageSize int64) *FoldersLocationsSavedQueriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *FoldersLocationsSavedQueriesListCall) PageToken(pageToken string) *FoldersLocationsSavedQueriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsSavedQueriesListCall) Fields(s ...googleapi.Field) *FoldersLocationsSavedQueriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLocationsSavedQueriesListCall) IfNoneMatch(entityTag string) *FoldersLocationsSavedQueriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsSavedQueriesListCall) Context(ctx context.Context) *FoldersLocationsSavedQueriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsSavedQueriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsSavedQueriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/savedQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.savedQueries.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSavedQueriesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *FoldersLocationsSavedQueriesListCall) Do(opts ...googleapi.CallOption) (*ListSavedQueriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSavedQueriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLocationsSavedQueriesListCall) Pages(ctx context.Context, f func(*ListSavedQueriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersLocationsSavedQueriesPatchCall struct {
	s          *Service
	name       string
	savedquery *SavedQuery
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an existing SavedQuery.
//
//   - name: Output only. Resource name of the saved query.In the format:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/savedQueries/[QUERY_ID]"
//     For a list of supported locations, see Supported Regions
//     (https://cloud.google.com/logging/docs/region-support#bucket-regions)After
//     the saved query is created, the location cannot be changed.If the user
//     doesn't provide a QUERY_ID, the system will generate an alphanumeric ID.
func (r *FoldersLocationsSavedQueriesService) Patch(name string, savedquery *SavedQuery) *FoldersLocationsSavedQueriesPatchCall {
	c := &FoldersLocationsSavedQueriesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.savedquery = savedquery
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A non-empty
// list of fields to change in the existing saved query. Fields are relative to
// the saved_query and new values for the fields are taken from the
// corresponding fields in the SavedQuery included in this request. Fields not
// mentioned in update_mask are not changed and are ignored in the request.To
// update all mutable fields, specify an update_mask of *.For example, to
// change the description and query filter text of a saved query, specify an
// update_mask of "description, query.filter".
func (c *FoldersLocationsSavedQueriesPatchCall) UpdateMask(updateMask string) *FoldersLocationsSavedQueriesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLocationsSavedQueriesPatchCall) Fields(s ...googleapi.Field) *FoldersLocationsSavedQueriesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLocationsSavedQueriesPatchCall) Context(ctx context.Context) *FoldersLocationsSavedQueriesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLocationsSavedQueriesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLocationsSavedQueriesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.savedquery)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.locations.savedQueries.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *SavedQuery.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLocationsSavedQueriesPatchCall) Do(opts ...googleapi.CallOption) (*SavedQuery, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SavedQuery{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.locations.savedQueries.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLogsDeleteCall struct {
	s          *Service
	logName    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes all the log entries in a log for the global _Default Log
// Bucket. The log reappears if it receives new entries. Log entries written
// shortly before the delete operation might not be deleted. Entries received
// after the delete operation with a timestamp before the operation will be
// deleted.
//
//   - logName: The resource name of the log to delete:
//     projects/[PROJECT_ID]/logs/[LOG_ID]
//     organizations/[ORGANIZATION_ID]/logs/[LOG_ID]
//     billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]
//     folders/[FOLDER_ID]/logs/[LOG_ID][LOG_ID] must be URL-encoded. For
//     example, "projects/my-project-id/logs/syslog",
//     "organizations/123/logs/cloudaudit.googleapis.com%2Factivity".For more
//     information about log names, see LogEntry.
func (r *FoldersLogsService) Delete(logName string) *FoldersLogsDeleteCall {
	c := &FoldersLogsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.logName = logName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLogsDeleteCall) Fields(s ...googleapi.Field) *FoldersLogsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLogsDeleteCall) Context(ctx context.Context) *FoldersLogsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLogsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLogsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+logName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"logName": c.logName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.logs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.logs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersLogsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.logs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersLogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the logs in projects, organizations, folders, or billing
// accounts. Only logs that have entries are listed.
//
//   - parent: The resource name to list logs for: projects/[PROJECT_ID]
//     organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
//     folders/[FOLDER_ID].
func (r *FoldersLogsService) List(parent string) *FoldersLogsListCall {
	c := &FoldersLogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *FoldersLogsListCall) PageSize(pageSize int64) *FoldersLogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *FoldersLogsListCall) PageToken(pageToken string) *FoldersLogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ResourceNames sets the optional parameter "resourceNames": List of resource
// names to list logs for:
// projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW
// _ID]
// organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/v
// iews/[VIEW_ID]
// billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_
// ID]/views/[VIEW_ID]
// folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_I
// D]To support legacy queries, it could also be: projects/[PROJECT_ID]
// organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
// folders/[FOLDER_ID]The resource name in the parent field is added to this
// list.
func (c *FoldersLogsListCall) ResourceNames(resourceNames ...string) *FoldersLogsListCall {
	c.urlParams_.SetMulti("resourceNames", append([]string{}, resourceNames...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersLogsListCall) Fields(s ...googleapi.Field) *FoldersLogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersLogsListCall) IfNoneMatch(entityTag string) *FoldersLogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersLogsListCall) Context(ctx context.Context) *FoldersLogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersLogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersLogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/logs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.logs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.logs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLogsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersLogsListCall) Do(opts ...googleapi.CallOption) (*ListLogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.logs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersLogsListCall) Pages(ctx context.Context, f func(*ListLogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersSinksCreateCall struct {
	s          *Service
	parent     string
	logsink    *LogSink
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a sink that exports specified log entries to a destination.
// The export begins upon ingress, unless the sink's writer_identity is not
// permitted to write to the destination. A sink can export log entries only
// from the resource owning the sink.
//
//   - parent: The resource in which to create the sink: "projects/[PROJECT_ID]"
//     "organizations/[ORGANIZATION_ID]" "billingAccounts/[BILLING_ACCOUNT_ID]"
//     "folders/[FOLDER_ID]" For examples:"projects/my-project"
//     "organizations/123456789".
func (r *FoldersSinksService) Create(parent string, logsink *LogSink) *FoldersSinksCreateCall {
	c := &FoldersSinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logsink = logsink
	return c
}

// CustomWriterIdentity sets the optional parameter "customWriterIdentity": The
// service account provided by the caller that will be used to write the log
// entries. The format must be serviceAccount:some@email. This field can only
// be specified when you are routing logs to a log bucket that is in a
// different project than the sink. When not specified, a Logging service
// account will automatically be generated.
func (c *FoldersSinksCreateCall) CustomWriterIdentity(customWriterIdentity string) *FoldersSinksCreateCall {
	c.urlParams_.Set("customWriterIdentity", customWriterIdentity)
	return c
}

// UniqueWriterIdentity sets the optional parameter "uniqueWriterIdentity":
// Determines the kind of IAM identity returned as writer_identity in the new
// sink. If this value is omitted or set to false, and if the sink's parent is
// a project, then the value returned as writer_identity is the same group or
// service account used by Cloud Logging before the addition of writer
// identities to this API. The sink's destination must be in the same project
// as the sink itself.If this field is set to true, or if the sink is owned by
// a non-project resource such as an organization, then the value of
// writer_identity will be a service agent
// (https://cloud.google.com/iam/docs/service-account-types#service-agents)
// used by the sinks with the same parent. For more information, see
// writer_identity in LogSink.
func (c *FoldersSinksCreateCall) UniqueWriterIdentity(uniqueWriterIdentity bool) *FoldersSinksCreateCall {
	c.urlParams_.Set("uniqueWriterIdentity", fmt.Sprint(uniqueWriterIdentity))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersSinksCreateCall) Fields(s ...googleapi.Field) *FoldersSinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersSinksCreateCall) Context(ctx context.Context) *FoldersSinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersSinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logsink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/sinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.sinks.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.sinks.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogSink.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersSinksCreateCall) Do(opts ...googleapi.CallOption) (*LogSink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogSink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.sinks.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersSinksDeleteCall struct {
	s          *Service
	sinkNameid string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a sink. If the sink has a unique writer_identity, then that
// service account is also deleted.
//
//   - sinkName: The full resource name of the sink to delete, including the
//     parent resource and the sink identifier:
//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
//     "folders/[FOLDER_ID]/sinks/[SINK_ID]" For
//     example:"projects/my-project/sinks/my-sink".
func (r *FoldersSinksService) Delete(sinkNameid string) *FoldersSinksDeleteCall {
	c := &FoldersSinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sinkNameid = sinkNameid
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersSinksDeleteCall) Fields(s ...googleapi.Field) *FoldersSinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersSinksDeleteCall) Context(ctx context.Context) *FoldersSinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersSinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+sinkName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sinkName": c.sinkNameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.sinks.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.sinks.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersSinksDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.sinks.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersSinksGetCall struct {
	s            *Service
	sinkName     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a sink.
//
//   - sinkName: The resource name of the sink:
//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
//     "folders/[FOLDER_ID]/sinks/[SINK_ID]" For
//     example:"projects/my-project/sinks/my-sink".
func (r *FoldersSinksService) Get(sinkName string) *FoldersSinksGetCall {
	c := &FoldersSinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sinkName = sinkName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersSinksGetCall) Fields(s ...googleapi.Field) *FoldersSinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersSinksGetCall) IfNoneMatch(entityTag string) *FoldersSinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersSinksGetCall) Context(ctx context.Context) *FoldersSinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersSinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+sinkName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sinkName": c.sinkName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.sinks.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.sinks.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogSink.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersSinksGetCall) Do(opts ...googleapi.CallOption) (*LogSink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogSink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.sinks.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersSinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists sinks.
//
//   - parent: The parent resource whose sinks are to be listed:
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]".
func (r *FoldersSinksService) List(parent string) *FoldersSinksListCall {
	c := &FoldersSinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter expression to
// constrain the sinks returned. Today, this only supports the following
// strings: ” 'in_scope("ALL")', 'in_scope("ANCESTOR")',
// 'in_scope("DEFAULT")'.Description of scopes below. ALL: Includes all of the
// sinks which can be returned in any other scope. ANCESTOR: Includes
// intercepting sinks owned by ancestor resources. DEFAULT: Includes sinks
// owned by parent.When the empty string is provided, then the filter
// 'in_scope("DEFAULT")' is applied.
func (c *FoldersSinksListCall) Filter(filter string) *FoldersSinksListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *FoldersSinksListCall) PageSize(pageSize int64) *FoldersSinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *FoldersSinksListCall) PageToken(pageToken string) *FoldersSinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersSinksListCall) Fields(s ...googleapi.Field) *FoldersSinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FoldersSinksListCall) IfNoneMatch(entityTag string) *FoldersSinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersSinksListCall) Context(ctx context.Context) *FoldersSinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersSinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/sinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.sinks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.sinks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSinksResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FoldersSinksListCall) Do(opts ...googleapi.CallOption) (*ListSinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.sinks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *FoldersSinksListCall) Pages(ctx context.Context, f func(*ListSinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type FoldersSinksPatchCall struct {
	s          *Service
	sinkNameid string
	logsink    *LogSink
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a sink. This method replaces the values of the destination
// and filter fields of the existing sink with the corresponding values from
// the new sink.The updated sink might also have a new writer_identity; see the
// unique_writer_identity field.
//
//   - sinkName: The full resource name of the sink to update, including the
//     parent resource and the sink identifier:
//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
//     "folders/[FOLDER_ID]/sinks/[SINK_ID]" For
//     example:"projects/my-project/sinks/my-sink".
func (r *FoldersSinksService) Patch(sinkNameid string, logsink *LogSink) *FoldersSinksPatchCall {
	c := &FoldersSinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sinkNameid = sinkNameid
	c.logsink = logsink
	return c
}

// CustomWriterIdentity sets the optional parameter "customWriterIdentity": The
// service account provided by the caller that will be used to write the log
// entries. The format must be serviceAccount:some@email. This field can only
// be specified when you are routing logs to a log bucket that is in a
// different project than the sink. When not specified, a Logging service
// account will automatically be generated.
func (c *FoldersSinksPatchCall) CustomWriterIdentity(customWriterIdentity string) *FoldersSinksPatchCall {
	c.urlParams_.Set("customWriterIdentity", customWriterIdentity)
	return c
}

// UniqueWriterIdentity sets the optional parameter "uniqueWriterIdentity": See
// sinks.create for a description of this field. When updating a sink, the
// effect of this field on the value of writer_identity in the updated sink
// depends on both the old and new values of this field: If the old and new
// values of this field are both false or both true, then there is no change to
// the sink's writer_identity. If the old value is false and the new value is
// true, then writer_identity is changed to a service agent
// (https://cloud.google.com/iam/docs/service-account-types#service-agents)
// owned by Cloud Logging. It is an error if the old value is true and the new
// value is set to false or defaulted to false.
func (c *FoldersSinksPatchCall) UniqueWriterIdentity(uniqueWriterIdentity bool) *FoldersSinksPatchCall {
	c.urlParams_.Set("uniqueWriterIdentity", fmt.Sprint(uniqueWriterIdentity))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// specifies the fields in sink that need an update. A sink field will be
// overwritten if, and only if, it is in the update mask. name and output only
// fields cannot be updated.An empty updateMask is temporarily treated as using
// the following mask for backwards compatibility
// purposes:destination,filter,includeChildrenAt some point in the future,
// behavior will be removed and specifying an empty updateMask will be an
// error.For a detailed FieldMask definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=filter
func (c *FoldersSinksPatchCall) UpdateMask(updateMask string) *FoldersSinksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersSinksPatchCall) Fields(s ...googleapi.Field) *FoldersSinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersSinksPatchCall) Context(ctx context.Context) *FoldersSinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersSinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logsink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+sinkName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sinkName": c.sinkNameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.sinks.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.sinks.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogSink.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersSinksPatchCall) Do(opts ...googleapi.CallOption) (*LogSink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogSink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.sinks.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FoldersSinksUpdateCall struct {
	s          *Service
	sinkNameid string
	logsink    *LogSink
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a sink. This method replaces the values of the destination
// and filter fields of the existing sink with the corresponding values from
// the new sink.The updated sink might also have a new writer_identity; see the
// unique_writer_identity field.
//
//   - sinkName: The full resource name of the sink to update, including the
//     parent resource and the sink identifier:
//     "projects/[PROJECT_ID]/sinks/[SINK_ID]"
//     "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
//     "folders/[FOLDER_ID]/sinks/[SINK_ID]" For
//     example:"projects/my-project/sinks/my-sink".
func (r *FoldersSinksService) Update(sinkNameid string, logsink *LogSink) *FoldersSinksUpdateCall {
	c := &FoldersSinksUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.sinkNameid = sinkNameid
	c.logsink = logsink
	return c
}

// CustomWriterIdentity sets the optional parameter "customWriterIdentity": The
// service account provided by the caller that will be used to write the log
// entries. The format must be serviceAccount:some@email. This field can only
// be specified when you are routing logs to a log bucket that is in a
// different project than the sink. When not specified, a Logging service
// account will automatically be generated.
func (c *FoldersSinksUpdateCall) CustomWriterIdentity(customWriterIdentity string) *FoldersSinksUpdateCall {
	c.urlParams_.Set("customWriterIdentity", customWriterIdentity)
	return c
}

// UniqueWriterIdentity sets the optional parameter "uniqueWriterIdentity": See
// sinks.create for a description of this field. When updating a sink, the
// effect of this field on the value of writer_identity in the updated sink
// depends on both the old and new values of this field: If the old and new
// values of this field are both false or both true, then there is no change to
// the sink's writer_identity. If the old value is false and the new value is
// true, then writer_identity is changed to a service agent
// (https://cloud.google.com/iam/docs/service-account-types#service-agents)
// owned by Cloud Logging. It is an error if the old value is true and the new
// value is set to false or defaulted to false.
func (c *FoldersSinksUpdateCall) UniqueWriterIdentity(uniqueWriterIdentity bool) *FoldersSinksUpdateCall {
	c.urlParams_.Set("uniqueWriterIdentity", fmt.Sprint(uniqueWriterIdentity))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// specifies the fields in sink that need an update. A sink field will be
// overwritten if, and only if, it is in the update mask. name and output only
// fields cannot be updated.An empty updateMask is temporarily treated as using
// the following mask for backwards compatibility
// purposes:destination,filter,includeChildrenAt some point in the future,
// behavior will be removed and specifying an empty updateMask will be an
// error.For a detailed FieldMask definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=filter
func (c *FoldersSinksUpdateCall) UpdateMask(updateMask string) *FoldersSinksUpdateCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FoldersSinksUpdateCall) Fields(s ...googleapi.Field) *FoldersSinksUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FoldersSinksUpdateCall) Context(ctx context.Context) *FoldersSinksUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FoldersSinksUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FoldersSinksUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logsink)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+sinkName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"sinkName": c.sinkNameid,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.folders.sinks.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.folders.sinks.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogSink.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *FoldersSinksUpdateCall) Do(opts ...googleapi.CallOption) (*LogSink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogSink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.folders.sinks.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *LocationsService) Get(name string) *LocationsGetCall {
	c := &LocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsGetCall) Fields(s ...googleapi.Field) *LocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsGetCall) IfNoneMatch(entityTag string) *LocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsGetCall) Context(ctx context.Context) *LocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *LocationsService) List(name string) *LocationsListCall {
	c := &LocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *LocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *LocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *LocationsListCall) Filter(filter string) *LocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *LocationsListCall) PageSize(pageSize int64) *LocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the next_page_token field in the response. Send that page token to
// receive the subsequent page.
func (c *LocationsListCall) PageToken(pageToken string) *LocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsListCall) Fields(s ...googleapi.Field) *LocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsListCall) IfNoneMatch(entityTag string) *LocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsListCall) Context(ctx context.Context) *LocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *LocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *LocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type LocationsBucketsCreateCall struct {
	s          *Service
	parent     string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a log bucket that can be used to store log entries. After a
// bucket has been created, the bucket's location cannot be changed.
//
//   - parent: The resource in which to create the log bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global".
func (r *LocationsBucketsService) Create(parent string, logbucket *LogBucket) *LocationsBucketsCreateCall {
	c := &LocationsBucketsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logbucket = logbucket
	return c
}

// BucketId sets the optional parameter "bucketId": Required. A client-assigned
// identifier such as "my-bucket". Identifiers are limited to 100 characters
// and can include only letters, digits, underscores, hyphens, and periods.
// Bucket identifiers must start with an alphanumeric character.
func (c *LocationsBucketsCreateCall) BucketId(bucketId string) *LocationsBucketsCreateCall {
	c.urlParams_.Set("bucketId", bucketId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsCreateCall) Fields(s ...googleapi.Field) *LocationsBucketsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsCreateCall) Context(ctx context.Context) *LocationsBucketsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsCreateCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsCreateAsyncCall struct {
	s          *Service
	parent     string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// CreateAsync: Creates a log bucket asynchronously that can be used to store
// log entries.After a bucket has been created, the bucket's location cannot be
// changed.
//
//   - parent: The resource in which to create the log bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global".
func (r *LocationsBucketsService) CreateAsync(parent string, logbucket *LogBucket) *LocationsBucketsCreateAsyncCall {
	c := &LocationsBucketsCreateAsyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logbucket = logbucket
	return c
}

// BucketId sets the optional parameter "bucketId": Required. A client-assigned
// identifier such as "my-bucket". Identifiers are limited to 100 characters
// and can include only letters, digits, underscores, hyphens, and periods.
// Bucket identifiers must start with an alphanumeric character.
func (c *LocationsBucketsCreateAsyncCall) BucketId(bucketId string) *LocationsBucketsCreateAsyncCall {
	c.urlParams_.Set("bucketId", bucketId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsCreateAsyncCall) Fields(s ...googleapi.Field) *LocationsBucketsCreateAsyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsCreateAsyncCall) Context(ctx context.Context) *LocationsBucketsCreateAsyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsCreateAsyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsCreateAsyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets:createAsync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.createAsync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.createAsync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsCreateAsyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.createAsync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a log bucket.Changes the bucket's lifecycle_state to the
// DELETE_REQUESTED state. After 7 days, the bucket will be purged and all log
// entries in the bucket will be permanently deleted.
//
//   - name: The full resource name of the bucket to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *LocationsBucketsService) Delete(name string) *LocationsBucketsDeleteCall {
	c := &LocationsBucketsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsDeleteCall) Fields(s ...googleapi.Field) *LocationsBucketsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsDeleteCall) Context(ctx context.Context) *LocationsBucketsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a log bucket.
//
//   - name: The resource name of the bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *LocationsBucketsService) Get(name string) *LocationsBucketsGetCall {
	c := &LocationsBucketsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsGetCall) Fields(s ...googleapi.Field) *LocationsBucketsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsBucketsGetCall) IfNoneMatch(entityTag string) *LocationsBucketsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsGetCall) Context(ctx context.Context) *LocationsBucketsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsGetCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists log buckets.
//
//   - parent: The parent resource whose buckets are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Note: The locations portion
//     of the resource must be specified, but supplying the character - in place
//     of LOCATION_ID will return all buckets.
func (r *LocationsBucketsService) List(parent string) *LocationsBucketsListCall {
	c := &LocationsBucketsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *LocationsBucketsListCall) PageSize(pageSize int64) *LocationsBucketsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *LocationsBucketsListCall) PageToken(pageToken string) *LocationsBucketsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsListCall) Fields(s ...googleapi.Field) *LocationsBucketsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsBucketsListCall) IfNoneMatch(entityTag string) *LocationsBucketsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsListCall) Context(ctx context.Context) *LocationsBucketsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBucketsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *LocationsBucketsListCall) Do(opts ...googleapi.CallOption) (*ListBucketsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBucketsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *LocationsBucketsListCall) Pages(ctx context.Context, f func(*ListBucketsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type LocationsBucketsPatchCall struct {
	s          *Service
	name       string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a log bucket.If the bucket has a lifecycle_state of
// DELETE_REQUESTED, then FAILED_PRECONDITION will be returned.After a bucket
// has been created, the bucket's location cannot be changed.
//
//   - name: The full resource name of the bucket to update.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *LocationsBucketsService) Patch(name string, logbucket *LogBucket) *LocationsBucketsPatchCall {
	c := &LocationsBucketsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logbucket = logbucket
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// that specifies the fields in bucket that need an update. A bucket field will
// be overwritten if, and only if, it is in the update mask. name and output
// only fields cannot be updated.For a detailed FieldMask definition, see:
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=retention_days
func (c *LocationsBucketsPatchCall) UpdateMask(updateMask string) *LocationsBucketsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsPatchCall) Fields(s ...googleapi.Field) *LocationsBucketsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsPatchCall) Context(ctx context.Context) *LocationsBucketsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsPatchCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsUndeleteCall struct {
	s                     *Service
	name                  string
	undeletebucketrequest *UndeleteBucketRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Undelete: Undeletes a log bucket. A bucket that has been deleted can be
// undeleted within the grace period of 7 days.
//
//   - name: The full resource name of the bucket to undelete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *LocationsBucketsService) Undelete(name string, undeletebucketrequest *UndeleteBucketRequest) *LocationsBucketsUndeleteCall {
	c := &LocationsBucketsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.undeletebucketrequest = undeletebucketrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsUndeleteCall) Fields(s ...googleapi.Field) *LocationsBucketsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsUndeleteCall) Context(ctx context.Context) *LocationsBucketsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.undeletebucketrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.undelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.undelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsUndeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.undelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsUpdateAsyncCall struct {
	s          *Service
	name       string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateAsync: Updates a log bucket asynchronously.If the bucket has a
// lifecycle_state of DELETE_REQUESTED, then FAILED_PRECONDITION will be
// returned.After a bucket has been created, the bucket's location cannot be
// changed.
//
//   - name: The full resource name of the bucket to update.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *LocationsBucketsService) UpdateAsync(name string, logbucket *LogBucket) *LocationsBucketsUpdateAsyncCall {
	c := &LocationsBucketsUpdateAsyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logbucket = logbucket
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// that specifies the fields in bucket that need an update. A bucket field will
// be overwritten if, and only if, it is in the update mask. name and output
// only fields cannot be updated.For a detailed FieldMask definition, see:
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=retention_days
func (c *LocationsBucketsUpdateAsyncCall) UpdateMask(updateMask string) *LocationsBucketsUpdateAsyncCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsUpdateAsyncCall) Fields(s ...googleapi.Field) *LocationsBucketsUpdateAsyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsUpdateAsyncCall) Context(ctx context.Context) *LocationsBucketsUpdateAsyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsUpdateAsyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsUpdateAsyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:updateAsync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.updateAsync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.updateAsync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsUpdateAsyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.updateAsync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsLinksCreateCall struct {
	s          *Service
	parent     string
	link       *Link
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Asynchronously creates a linked dataset in BigQuery which makes it
// possible to use BigQuery to read the logs stored in the log bucket. A log
// bucket may currently only contain one link.
//
//   - parent: The full resource name of the bucket to create a link for.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *LocationsBucketsLinksService) Create(parent string, link *Link) *LocationsBucketsLinksCreateCall {
	c := &LocationsBucketsLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.link = link
	return c
}

// LinkId sets the optional parameter "linkId": Required. The ID to use for the
// link. The link_id can have up to 100 characters. A valid link_id must only
// have alphanumeric characters and underscores within it.
func (c *LocationsBucketsLinksCreateCall) LinkId(linkId string) *LocationsBucketsLinksCreateCall {
	c.urlParams_.Set("linkId", linkId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsLinksCreateCall) Fields(s ...googleapi.Field) *LocationsBucketsLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsLinksCreateCall) Context(ctx context.Context) *LocationsBucketsLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.link)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/links")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.links.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.links.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsLinksCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.links.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a link. This will also delete the corresponding BigQuery
// linked dataset.
//
//   - name: The full resource name of the link to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[L
//     INK_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]/links/[LINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]/links/[LINK_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
//     K_ID]".
func (r *LocationsBucketsLinksService) Delete(name string) *LocationsBucketsLinksDeleteCall {
	c := &LocationsBucketsLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsLinksDeleteCall) Fields(s ...googleapi.Field) *LocationsBucketsLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsLinksDeleteCall) Context(ctx context.Context) *LocationsBucketsLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.links.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.links.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsLinksDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.links.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a link.
//
//   - name: The resource name of the link:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[L
//     INK_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]/links/[LINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]/links/[LINK_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
//     K_ID]".
func (r *LocationsBucketsLinksService) Get(name string) *LocationsBucketsLinksGetCall {
	c := &LocationsBucketsLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsLinksGetCall) Fields(s ...googleapi.Field) *LocationsBucketsLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsBucketsLinksGetCall) IfNoneMatch(entityTag string) *LocationsBucketsLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsLinksGetCall) Context(ctx context.Context) *LocationsBucketsLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.links.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.links.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Link.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsLinksGetCall) Do(opts ...googleapi.CallOption) (*Link, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Link{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.links.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists links.
//
//   - parent: The parent resource whose links are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *LocationsBucketsLinksService) List(parent string) *LocationsBucketsLinksListCall {
	c := &LocationsBucketsLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.
func (c *LocationsBucketsLinksListCall) PageSize(pageSize int64) *LocationsBucketsLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response.
func (c *LocationsBucketsLinksListCall) PageToken(pageToken string) *LocationsBucketsLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsLinksListCall) Fields(s ...googleapi.Field) *LocationsBucketsLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsBucketsLinksListCall) IfNoneMatch(entityTag string) *LocationsBucketsLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsLinksListCall) Context(ctx context.Context) *LocationsBucketsLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/links")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.links.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.links.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLinksResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *LocationsBucketsLinksListCall) Do(opts ...googleapi.CallOption) (*ListLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.links.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *LocationsBucketsLinksListCall) Pages(ctx context.Context, f func(*ListLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type LocationsBucketsViewsCreateCall struct {
	s          *Service
	parent     string
	logview    *LogView
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a view over log entries in a log bucket. A bucket may
// contain a maximum of 30 views.
//
//   - parent: The bucket in which to create the view
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *LocationsBucketsViewsService) Create(parent string, logview *LogView) *LocationsBucketsViewsCreateCall {
	c := &LocationsBucketsViewsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logview = logview
	return c
}

// ViewId sets the optional parameter "viewId": Required. A client-assigned
// identifier such as "my-view". Identifiers are limited to 100 characters and
// can include only letters, digits, underscores, and hyphens.
func (c *LocationsBucketsViewsCreateCall) ViewId(viewId string) *LocationsBucketsViewsCreateCall {
	c.urlParams_.Set("viewId", viewId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsViewsCreateCall) Fields(s ...googleapi.Field) *LocationsBucketsViewsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsViewsCreateCall) Context(ctx context.Context) *LocationsBucketsViewsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsViewsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsViewsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.views.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsViewsCreateCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsViewsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a view on a log bucket. If an UNAVAILABLE error is returned,
// this indicates that system is not in a state where it can delete the view.
// If this occurs, please try again in a few minutes.
//
//   - name: The full resource name of the view to delete:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *LocationsBucketsViewsService) Delete(name string) *LocationsBucketsViewsDeleteCall {
	c := &LocationsBucketsViewsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsViewsDeleteCall) Fields(s ...googleapi.Field) *LocationsBucketsViewsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsViewsDeleteCall) Context(ctx context.Context) *LocationsBucketsViewsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsViewsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsViewsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.views.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsViewsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsViewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a view on a log bucket.
//
//   - name: The resource name of the policy:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *LocationsBucketsViewsService) Get(name string) *LocationsBucketsViewsGetCall {
	c := &LocationsBucketsViewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsViewsGetCall) Fields(s ...googleapi.Field) *LocationsBucketsViewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsBucketsViewsGetCall) IfNoneMatch(entityTag string) *LocationsBucketsViewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsViewsGetCall) Context(ctx context.Context) *LocationsBucketsViewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsViewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsViewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.views.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsViewsGetCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsViewsGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *LocationsBucketsViewsService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *LocationsBucketsViewsGetIamPolicyCall {
	c := &LocationsBucketsViewsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsViewsGetIamPolicyCall) Fields(s ...googleapi.Field) *LocationsBucketsViewsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsViewsGetIamPolicyCall) Context(ctx context.Context) *LocationsBucketsViewsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsViewsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsViewsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.views.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsViewsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsViewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists views on a log bucket.
//
//   - parent: The bucket whose views are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *LocationsBucketsViewsService) List(parent string) *LocationsBucketsViewsListCall {
	c := &LocationsBucketsViewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *LocationsBucketsViewsListCall) PageSize(pageSize int64) *LocationsBucketsViewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *LocationsBucketsViewsListCall) PageToken(pageToken string) *LocationsBucketsViewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsViewsListCall) Fields(s ...googleapi.Field) *LocationsBucketsViewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsBucketsViewsListCall) IfNoneMatch(entityTag string) *LocationsBucketsViewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsViewsListCall) Context(ctx context.Context) *LocationsBucketsViewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsViewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsViewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.views.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListViewsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *LocationsBucketsViewsListCall) Do(opts ...googleapi.CallOption) (*ListViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *LocationsBucketsViewsListCall) Pages(ctx context.Context, f func(*ListViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type LocationsBucketsViewsPatchCall struct {
	s          *Service
	name       string
	logview    *LogView
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a view on a log bucket. This method replaces the value of the
// filter field from the existing view with the corresponding value from the
// new view. If an UNAVAILABLE error is returned, this indicates that system is
// not in a state where it can update the view. If this occurs, please try
// again in a few minutes.
//
//   - name: The full resource name of the view to update
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *LocationsBucketsViewsService) Patch(name string, logview *LogView) *LocationsBucketsViewsPatchCall {
	c := &LocationsBucketsViewsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logview = logview
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// specifies the fields in view that need an update. A field will be
// overwritten if, and only if, it is in the update mask. name and output only
// fields cannot be updated.For a detailed FieldMask definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=filter
func (c *LocationsBucketsViewsPatchCall) UpdateMask(updateMask string) *LocationsBucketsViewsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsViewsPatchCall) Fields(s ...googleapi.Field) *LocationsBucketsViewsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsViewsPatchCall) Context(ctx context.Context) *LocationsBucketsViewsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsViewsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsViewsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.views.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsViewsPatchCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsViewsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
// PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *LocationsBucketsViewsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *LocationsBucketsViewsSetIamPolicyCall {
	c := &LocationsBucketsViewsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsViewsSetIamPolicyCall) Fields(s ...googleapi.Field) *LocationsBucketsViewsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsViewsSetIamPolicyCall) Context(ctx context.Context) *LocationsBucketsViewsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsViewsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsViewsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.views.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsBucketsViewsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsBucketsViewsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *LocationsBucketsViewsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *LocationsBucketsViewsTestIamPermissionsCall {
	c := &LocationsBucketsViewsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsBucketsViewsTestIamPermissionsCall) Fields(s ...googleapi.Field) *LocationsBucketsViewsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsBucketsViewsTestIamPermissionsCall) Context(ctx context.Context) *LocationsBucketsViewsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsBucketsViewsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsBucketsViewsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.buckets.views.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *LocationsBucketsViewsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.buckets.views.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsOperationsCancelCall struct {
	s                      *Service
	name                   string
	canceloperationrequest *CancelOperationRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// google.rpc.Code.UNIMPLEMENTED. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of 1, corresponding to
// Code.CANCELLED.
//
// - name: The name of the operation resource to be cancelled.
func (r *LocationsOperationsService) Cancel(name string, canceloperationrequest *CancelOperationRequest) *LocationsOperationsCancelCall {
	c := &LocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceloperationrequest = canceloperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsOperationsCancelCall) Fields(s ...googleapi.Field) *LocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsOperationsCancelCall) Context(ctx context.Context) *LocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.canceloperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.operations.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *LocationsOperationsService) Get(name string) *LocationsOperationsGetCall {
	c := &LocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsOperationsGetCall) Fields(s ...googleapi.Field) *LocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsOperationsGetCall) IfNoneMatch(entityTag string) *LocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsOperationsGetCall) Context(ctx context.Context) *LocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns UNIMPLEMENTED.
//
// - name: The name of the operation's parent resource.
func (r *LocationsOperationsService) List(name string) *LocationsOperationsListCall {
	c := &LocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *LocationsOperationsListCall) Filter(filter string) *LocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *LocationsOperationsListCall) PageSize(pageSize int64) *LocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *LocationsOperationsListCall) PageToken(pageToken string) *LocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to true, operations that are reachable are returned as normal, and
// those that are unreachable are returned in the
// ListOperationsResponse.unreachable field.This can only be true when reading
// across collections. For example, when parent is set to
// "projects/example/locations/-".This field is not supported by default and
// will result in an UNIMPLEMENTED error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *LocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *LocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LocationsOperationsListCall) Fields(s ...googleapi.Field) *LocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LocationsOperationsListCall) IfNoneMatch(entityTag string) *LocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LocationsOperationsListCall) Context(ctx context.Context) *LocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *LocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *LocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type LogsDeleteCall struct {
	s          *Service
	logName    string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes all the log entries in a log for the global _Default Log
// Bucket. The log reappears if it receives new entries. Log entries written
// shortly before the delete operation might not be deleted. Entries received
// after the delete operation with a timestamp before the operation will be
// deleted.
//
//   - logName: The resource name of the log to delete:
//     projects/[PROJECT_ID]/logs/[LOG_ID]
//     organizations/[ORGANIZATION_ID]/logs/[LOG_ID]
//     billingAccounts/[BILLING_ACCOUNT_ID]/logs/[LOG_ID]
//     folders/[FOLDER_ID]/logs/[LOG_ID][LOG_ID] must be URL-encoded. For
//     example, "projects/my-project-id/logs/syslog",
//     "organizations/123/logs/cloudaudit.googleapis.com%2Factivity".For more
//     information about log names, see LogEntry.
func (r *LogsService) Delete(logName string) *LogsDeleteCall {
	c := &LogsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.logName = logName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LogsDeleteCall) Fields(s ...googleapi.Field) *LogsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LogsDeleteCall) Context(ctx context.Context) *LogsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LogsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LogsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+logName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"logName": c.logName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.logs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.logs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *LogsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.logs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type LogsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the logs in projects, organizations, folders, or billing
// accounts. Only logs that have entries are listed.
//
//   - parent: The resource name to list logs for: projects/[PROJECT_ID]
//     organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
//     folders/[FOLDER_ID].
func (r *LogsService) List(parent string) *LogsListCall {
	c := &LogsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *LogsListCall) PageSize(pageSize int64) *LogsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *LogsListCall) PageToken(pageToken string) *LogsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ResourceNames sets the optional parameter "resourceNames": List of resource
// names to list logs for:
// projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW
// _ID]
// organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/v
// iews/[VIEW_ID]
// billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_
// ID]/views/[VIEW_ID]
// folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_I
// D]To support legacy queries, it could also be: projects/[PROJECT_ID]
// organizations/[ORGANIZATION_ID] billingAccounts/[BILLING_ACCOUNT_ID]
// folders/[FOLDER_ID]The resource name in the parent field is added to this
// list.
func (c *LogsListCall) ResourceNames(resourceNames ...string) *LogsListCall {
	c.urlParams_.SetMulti("resourceNames", append([]string{}, resourceNames...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *LogsListCall) Fields(s ...googleapi.Field) *LogsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *LogsListCall) IfNoneMatch(entityTag string) *LogsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *LogsListCall) Context(ctx context.Context) *LogsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *LogsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LogsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/logs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.logs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.logs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLogsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *LogsListCall) Do(opts ...googleapi.CallOption) (*ListLogsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLogsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.logs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *LogsListCall) Pages(ctx context.Context, f func(*ListLogsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type MonitoredResourceDescriptorsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the descriptors for monitored resource types used by Logging.
func (r *MonitoredResourceDescriptorsService) List() *MonitoredResourceDescriptorsListCall {
	c := &MonitoredResourceDescriptorsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *MonitoredResourceDescriptorsListCall) PageSize(pageSize int64) *MonitoredResourceDescriptorsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *MonitoredResourceDescriptorsListCall) PageToken(pageToken string) *MonitoredResourceDescriptorsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *MonitoredResourceDescriptorsListCall) Fields(s ...googleapi.Field) *MonitoredResourceDescriptorsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *MonitoredResourceDescriptorsListCall) IfNoneMatch(entityTag string) *MonitoredResourceDescriptorsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *MonitoredResourceDescriptorsListCall) Context(ctx context.Context) *MonitoredResourceDescriptorsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *MonitoredResourceDescriptorsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MonitoredResourceDescriptorsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/monitoredResourceDescriptors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.monitoredResourceDescriptors.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.monitoredResourceDescriptors.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListMonitoredResourceDescriptorsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MonitoredResourceDescriptorsListCall) Do(opts ...googleapi.CallOption) (*ListMonitoredResourceDescriptorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListMonitoredResourceDescriptorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.monitoredResourceDescriptors.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *MonitoredResourceDescriptorsListCall) Pages(ctx context.Context, f func(*ListMonitoredResourceDescriptorsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsGetCmekSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetCmekSettings: Gets the Logging CMEK settings for the given resource.Note:
// CMEK for the Log Router can be configured for Google Cloud projects,
// folders, organizations, and billing accounts. Once configured for an
// organization, it applies to all projects and folders in the Google Cloud
// organization.See Enabling CMEK for Log Router
// (https://cloud.google.com/logging/docs/routing/managed-encryption) for more
// information.
//
//   - name: The resource for which to retrieve CMEK settings.
//     "projects/[PROJECT_ID]/cmekSettings"
//     "organizations/[ORGANIZATION_ID]/cmekSettings"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
//     "folders/[FOLDER_ID]/cmekSettings" For
//     example:"organizations/12345/cmekSettings"Note: CMEK for the Log Router
//     can be configured for Google Cloud projects, folders, organizations, and
//     billing accounts. Once configured for an organization, it applies to all
//     projects and folders in the Google Cloud organization.
func (r *OrganizationsService) GetCmekSettings(name string) *OrganizationsGetCmekSettingsCall {
	c := &OrganizationsGetCmekSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsGetCmekSettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetCmekSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsGetCmekSettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetCmekSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsGetCmekSettingsCall) Context(ctx context.Context) *OrganizationsGetCmekSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsGetCmekSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetCmekSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/cmekSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.getCmekSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.getCmekSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *CmekSettings.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsGetCmekSettingsCall) Do(opts ...googleapi.CallOption) (*CmekSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CmekSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.getCmekSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsGetSettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSettings: Gets the settings for the given resource.Note: Settings can be
// retrieved for Google Cloud projects, folders, organizations, and billing
// accounts.See View default resource settings for Logging
// (https://cloud.google.com/logging/docs/default-settings#view-org-settings)
// for more information.
//
//   - name: The resource for which to retrieve settings.
//     "projects/[PROJECT_ID]/settings"
//     "organizations/[ORGANIZATION_ID]/settings"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/settings"
//     "folders/[FOLDER_ID]/settings" For
//     example:"organizations/12345/settings"Note: Settings can be retrieved for
//     Google Cloud projects, folders, organizations, and billing accounts.
func (r *OrganizationsService) GetSettings(name string) *OrganizationsGetSettingsCall {
	c := &OrganizationsGetSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsGetSettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsGetSettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetSettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsGetSettingsCall) Context(ctx context.Context) *OrganizationsGetSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsGetSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.getSettings", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.getSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Settings.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsGetSettingsCall) Do(opts ...googleapi.CallOption) (*Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.getSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsUpdateCmekSettingsCall struct {
	s            *Service
	name         string
	cmeksettings *CmekSettings
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// UpdateCmekSettings: Updates the Log Router CMEK settings for the given
// resource.Note: CMEK for the Log Router can currently only be configured for
// Google Cloud organizations. Once configured, it applies to all projects and
// folders in the Google Cloud organization.UpdateCmekSettings fails when any
// of the following are true: The value of kms_key_name is invalid. The
// associated service account doesn't have the required
// roles/cloudkms.cryptoKeyEncrypterDecrypter role assigned for the key. Access
// to the key is disabled.See Enabling CMEK for Log Router
// (https://cloud.google.com/logging/docs/routing/managed-encryption) for more
// information.
//
//   - name: The resource name for the CMEK settings to update.
//     "projects/[PROJECT_ID]/cmekSettings"
//     "organizations/[ORGANIZATION_ID]/cmekSettings"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
//     "folders/[FOLDER_ID]/cmekSettings" For
//     example:"organizations/12345/cmekSettings"Note: CMEK for the Log Router
//     can currently only be configured for Google Cloud organizations. Once
//     configured, it applies to all projects and folders in the Google Cloud
//     organization.
func (r *OrganizationsService) UpdateCmekSettings(name string, cmeksettings *CmekSettings) *OrganizationsUpdateCmekSettingsCall {
	c := &OrganizationsUpdateCmekSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cmeksettings = cmeksettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask identifying
// which fields from cmek_settings should be updated. A field will be
// overwritten if and only if it is in the update mask. Output only fields
// cannot be updated.See FieldMask for more information.For example:
// "updateMask=kmsKeyName"
func (c *OrganizationsUpdateCmekSettingsCall) UpdateMask(updateMask string) *OrganizationsUpdateCmekSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsUpdateCmekSettingsCall) Fields(s ...googleapi.Field) *OrganizationsUpdateCmekSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsUpdateCmekSettingsCall) Context(ctx context.Context) *OrganizationsUpdateCmekSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsUpdateCmekSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateCmekSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cmeksettings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/cmekSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.updateCmekSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.updateCmekSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *CmekSettings.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsUpdateCmekSettingsCall) Do(opts ...googleapi.CallOption) (*CmekSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CmekSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.updateCmekSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsUpdateSettingsCall struct {
	s          *Service
	name       string
	settings   *Settings
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateSettings: Updates the settings for the given resource. This method
// applies to all feature configurations for organization and
// folders.UpdateSettings fails when any of the following are true: The value
// of storage_location either isn't supported by Logging or violates the
// location OrgPolicy. The default_sink_config field is set, but it has an
// unspecified filter write mode. The value of kms_key_name is invalid. The
// associated service account doesn't have the required
// roles/cloudkms.cryptoKeyEncrypterDecrypter role assigned for the key. Access
// to the key is disabled.See Configure default settings for organizations and
// folders (https://cloud.google.com/logging/docs/default-settings) for more
// information.
//
//   - name: The resource name for the settings to update.
//     "organizations/[ORGANIZATION_ID]/settings" "folders/[FOLDER_ID]/settings"
//     For example:"organizations/12345/settings".
func (r *OrganizationsService) UpdateSettings(name string, settings *Settings) *OrganizationsUpdateSettingsCall {
	c := &OrganizationsUpdateSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.settings = settings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask identifying
// which fields from settings should be updated. A field will be overwritten if
// and only if it is in the update mask. Output only fields cannot be
// updated.See FieldMask for more information.For example:
// "updateMask=kmsKeyName"
func (c *OrganizationsUpdateSettingsCall) UpdateMask(updateMask string) *OrganizationsUpdateSettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsUpdateSettingsCall) Fields(s ...googleapi.Field) *OrganizationsUpdateSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsUpdateSettingsCall) Context(ctx context.Context) *OrganizationsUpdateSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsUpdateSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.settings)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/settings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.updateSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.updateSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *Settings.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsUpdateSettingsCall) Do(opts ...googleapi.CallOption) (*Settings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Settings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.updateSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsExclusionsCreateCall struct {
	s            *Service
	parent       string
	logexclusion *LogExclusion
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Create: Creates a new exclusion in the _Default sink in a specified parent
// resource. Only log entries belonging to that resource can be excluded. You
// can have up to 10 exclusions in a resource.
//
//   - parent: The parent resource in which to create the exclusion:
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]" For
//     examples:"projects/my-logging-project" "organizations/123456789".
func (r *OrganizationsExclusionsService) Create(parent string, logexclusion *LogExclusion) *OrganizationsExclusionsCreateCall {
	c := &OrganizationsExclusionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logexclusion = logexclusion
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsExclusionsCreateCall) Fields(s ...googleapi.Field) *OrganizationsExclusionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsExclusionsCreateCall) Context(ctx context.Context) *OrganizationsExclusionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsExclusionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsExclusionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logexclusion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/exclusions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.exclusions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsExclusionsCreateCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsExclusionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an exclusion in the _Default sink.
//
//   - name: The resource name of an existing exclusion to delete:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *OrganizationsExclusionsService) Delete(name string) *OrganizationsExclusionsDeleteCall {
	c := &OrganizationsExclusionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsExclusionsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsExclusionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsExclusionsDeleteCall) Context(ctx context.Context) *OrganizationsExclusionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsExclusionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsExclusionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.exclusions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsExclusionsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsExclusionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the description of an exclusion in the _Default sink.
//
//   - name: The resource name of an existing exclusion:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *OrganizationsExclusionsService) Get(name string) *OrganizationsExclusionsGetCall {
	c := &OrganizationsExclusionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsExclusionsGetCall) Fields(s ...googleapi.Field) *OrganizationsExclusionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsExclusionsGetCall) IfNoneMatch(entityTag string) *OrganizationsExclusionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsExclusionsGetCall) Context(ctx context.Context) *OrganizationsExclusionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsExclusionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsExclusionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.exclusions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsExclusionsGetCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsExclusionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the exclusions on the _Default sink in a parent resource.
//
//   - parent: The parent resource whose exclusions are to be listed.
//     "projects/[PROJECT_ID]" "organizations/[ORGANIZATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]" "folders/[FOLDER_ID]".
func (r *OrganizationsExclusionsService) List(parent string) *OrganizationsExclusionsListCall {
	c := &OrganizationsExclusionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *OrganizationsExclusionsListCall) PageSize(pageSize int64) *OrganizationsExclusionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *OrganizationsExclusionsListCall) PageToken(pageToken string) *OrganizationsExclusionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsExclusionsListCall) Fields(s ...googleapi.Field) *OrganizationsExclusionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsExclusionsListCall) IfNoneMatch(entityTag string) *OrganizationsExclusionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsExclusionsListCall) Context(ctx context.Context) *OrganizationsExclusionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsExclusionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsExclusionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/exclusions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.exclusions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExclusionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsExclusionsListCall) Do(opts ...googleapi.CallOption) (*ListExclusionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExclusionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsExclusionsListCall) Pages(ctx context.Context, f func(*ListExclusionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsExclusionsPatchCall struct {
	s            *Service
	name         string
	logexclusion *LogExclusion
	urlParams_   gensupport.URLParams
	ctx_         context.Context
	header_      http.Header
}

// Patch: Changes one or more properties of an existing exclusion in the
// _Default sink.
//
//   - name: The resource name of the exclusion to update:
//     "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
//     "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
//     "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]" For
//     example:"projects/my-project/exclusions/my-exclusion".
func (r *OrganizationsExclusionsService) Patch(name string, logexclusion *LogExclusion) *OrganizationsExclusionsPatchCall {
	c := &OrganizationsExclusionsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logexclusion = logexclusion
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. A non-empty
// list of fields to change in the existing exclusion. New values for the
// fields are taken from the corresponding fields in the LogExclusion included
// in this request. Fields not mentioned in update_mask are not changed and are
// ignored in the request.For example, to change the filter and description of
// an exclusion, specify an update_mask of "filter,description".
func (c *OrganizationsExclusionsPatchCall) UpdateMask(updateMask string) *OrganizationsExclusionsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsExclusionsPatchCall) Fields(s ...googleapi.Field) *OrganizationsExclusionsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsExclusionsPatchCall) Context(ctx context.Context) *OrganizationsExclusionsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsExclusionsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsExclusionsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logexclusion)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.exclusions.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogExclusion.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsExclusionsPatchCall) Do(opts ...googleapi.CallOption) (*LogExclusion, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogExclusion{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.exclusions.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *OrganizationsLocationsService) Get(name string) *OrganizationsLocationsGetCall {
	c := &OrganizationsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsGetCall) Context(ctx context.Context) *OrganizationsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Location.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsGetCall) Do(opts ...googleapi.CallOption) (*Location, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Location{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *OrganizationsLocationsService) List(name string) *OrganizationsLocationsListCall {
	c := &OrganizationsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *OrganizationsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *OrganizationsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *OrganizationsLocationsListCall) Filter(filter string) *OrganizationsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *OrganizationsLocationsListCall) PageSize(pageSize int64) *OrganizationsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the next_page_token field in the response. Send that page token to
// receive the subsequent page.
func (c *OrganizationsLocationsListCall) PageToken(pageToken string) *OrganizationsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsListCall) Context(ctx context.Context) *OrganizationsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsBucketsCreateCall struct {
	s          *Service
	parent     string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a log bucket that can be used to store log entries. After a
// bucket has been created, the bucket's location cannot be changed.
//
//   - parent: The resource in which to create the log bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global".
func (r *OrganizationsLocationsBucketsService) Create(parent string, logbucket *LogBucket) *OrganizationsLocationsBucketsCreateCall {
	c := &OrganizationsLocationsBucketsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logbucket = logbucket
	return c
}

// BucketId sets the optional parameter "bucketId": Required. A client-assigned
// identifier such as "my-bucket". Identifiers are limited to 100 characters
// and can include only letters, digits, underscores, hyphens, and periods.
// Bucket identifiers must start with an alphanumeric character.
func (c *OrganizationsLocationsBucketsCreateCall) BucketId(bucketId string) *OrganizationsLocationsBucketsCreateCall {
	c.urlParams_.Set("bucketId", bucketId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsCreateCall) Context(ctx context.Context) *OrganizationsLocationsBucketsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsCreateCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsCreateAsyncCall struct {
	s          *Service
	parent     string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// CreateAsync: Creates a log bucket asynchronously that can be used to store
// log entries.After a bucket has been created, the bucket's location cannot be
// changed.
//
//   - parent: The resource in which to create the log bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]" For
//     example:"projects/my-project/locations/global".
func (r *OrganizationsLocationsBucketsService) CreateAsync(parent string, logbucket *LogBucket) *OrganizationsLocationsBucketsCreateAsyncCall {
	c := &OrganizationsLocationsBucketsCreateAsyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logbucket = logbucket
	return c
}

// BucketId sets the optional parameter "bucketId": Required. A client-assigned
// identifier such as "my-bucket". Identifiers are limited to 100 characters
// and can include only letters, digits, underscores, hyphens, and periods.
// Bucket identifiers must start with an alphanumeric character.
func (c *OrganizationsLocationsBucketsCreateAsyncCall) BucketId(bucketId string) *OrganizationsLocationsBucketsCreateAsyncCall {
	c.urlParams_.Set("bucketId", bucketId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsCreateAsyncCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsCreateAsyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsCreateAsyncCall) Context(ctx context.Context) *OrganizationsLocationsBucketsCreateAsyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsCreateAsyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsCreateAsyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets:createAsync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.createAsync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.createAsync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsCreateAsyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.createAsync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a log bucket.Changes the bucket's lifecycle_state to the
// DELETE_REQUESTED state. After 7 days, the bucket will be purged and all log
// entries in the bucket will be permanently deleted.
//
//   - name: The full resource name of the bucket to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *OrganizationsLocationsBucketsService) Delete(name string) *OrganizationsLocationsBucketsDeleteCall {
	c := &OrganizationsLocationsBucketsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsBucketsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a log bucket.
//
//   - name: The resource name of the bucket:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *OrganizationsLocationsBucketsService) Get(name string) *OrganizationsLocationsBucketsGetCall {
	c := &OrganizationsLocationsBucketsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsBucketsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsBucketsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsGetCall) Context(ctx context.Context) *OrganizationsLocationsBucketsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsGetCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists log buckets.
//
//   - parent: The parent resource whose buckets are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]" Note: The locations portion
//     of the resource must be specified, but supplying the character - in place
//     of LOCATION_ID will return all buckets.
func (r *OrganizationsLocationsBucketsService) List(parent string) *OrganizationsLocationsBucketsListCall {
	c := &OrganizationsLocationsBucketsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request. Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *OrganizationsLocationsBucketsListCall) PageSize(pageSize int64) *OrganizationsLocationsBucketsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *OrganizationsLocationsBucketsListCall) PageToken(pageToken string) *OrganizationsLocationsBucketsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsBucketsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsBucketsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsListCall) Context(ctx context.Context) *OrganizationsLocationsBucketsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/buckets")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBucketsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsBucketsListCall) Do(opts ...googleapi.CallOption) (*ListBucketsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBucketsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsBucketsListCall) Pages(ctx context.Context, f func(*ListBucketsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsBucketsPatchCall struct {
	s          *Service
	name       string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a log bucket.If the bucket has a lifecycle_state of
// DELETE_REQUESTED, then FAILED_PRECONDITION will be returned.After a bucket
// has been created, the bucket's location cannot be changed.
//
//   - name: The full resource name of the bucket to update.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *OrganizationsLocationsBucketsService) Patch(name string, logbucket *LogBucket) *OrganizationsLocationsBucketsPatchCall {
	c := &OrganizationsLocationsBucketsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logbucket = logbucket
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// that specifies the fields in bucket that need an update. A bucket field will
// be overwritten if, and only if, it is in the update mask. name and output
// only fields cannot be updated.For a detailed FieldMask definition, see:
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=retention_days
func (c *OrganizationsLocationsBucketsPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsBucketsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsPatchCall) Context(ctx context.Context) *OrganizationsLocationsBucketsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogBucket.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsPatchCall) Do(opts ...googleapi.CallOption) (*LogBucket, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogBucket{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsUndeleteCall struct {
	s                     *Service
	name                  string
	undeletebucketrequest *UndeleteBucketRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Undelete: Undeletes a log bucket. A bucket that has been deleted can be
// undeleted within the grace period of 7 days.
//
//   - name: The full resource name of the bucket to undelete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *OrganizationsLocationsBucketsService) Undelete(name string, undeletebucketrequest *UndeleteBucketRequest) *OrganizationsLocationsBucketsUndeleteCall {
	c := &OrganizationsLocationsBucketsUndeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.undeletebucketrequest = undeletebucketrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsUndeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsUndeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsUndeleteCall) Context(ctx context.Context) *OrganizationsLocationsBucketsUndeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsUndeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsUndeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.undeletebucketrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:undelete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.undelete", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.undelete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsUndeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.undelete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsUpdateAsyncCall struct {
	s          *Service
	name       string
	logbucket  *LogBucket
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateAsync: Updates a log bucket asynchronously.If the bucket has a
// lifecycle_state of DELETE_REQUESTED, then FAILED_PRECONDITION will be
// returned.After a bucket has been created, the bucket's location cannot be
// changed.
//
//   - name: The full resource name of the bucket to update.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     For example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *OrganizationsLocationsBucketsService) UpdateAsync(name string, logbucket *LogBucket) *OrganizationsLocationsBucketsUpdateAsyncCall {
	c := &OrganizationsLocationsBucketsUpdateAsyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logbucket = logbucket
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Field mask
// that specifies the fields in bucket that need an update. A bucket field will
// be overwritten if, and only if, it is in the update mask. name and output
// only fields cannot be updated.For a detailed FieldMask definition, see:
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=retention_days
func (c *OrganizationsLocationsBucketsUpdateAsyncCall) UpdateMask(updateMask string) *OrganizationsLocationsBucketsUpdateAsyncCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsUpdateAsyncCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsUpdateAsyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsUpdateAsyncCall) Context(ctx context.Context) *OrganizationsLocationsBucketsUpdateAsyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsUpdateAsyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsUpdateAsyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logbucket)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:updateAsync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.updateAsync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.updateAsync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsUpdateAsyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.updateAsync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsLinksCreateCall struct {
	s          *Service
	parent     string
	link       *Link
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Asynchronously creates a linked dataset in BigQuery which makes it
// possible to use BigQuery to read the logs stored in the log bucket. A log
// bucket may currently only contain one link.
//
//   - parent: The full resource name of the bucket to create a link for.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *OrganizationsLocationsBucketsLinksService) Create(parent string, link *Link) *OrganizationsLocationsBucketsLinksCreateCall {
	c := &OrganizationsLocationsBucketsLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.link = link
	return c
}

// LinkId sets the optional parameter "linkId": Required. The ID to use for the
// link. The link_id can have up to 100 characters. A valid link_id must only
// have alphanumeric characters and underscores within it.
func (c *OrganizationsLocationsBucketsLinksCreateCall) LinkId(linkId string) *OrganizationsLocationsBucketsLinksCreateCall {
	c.urlParams_.Set("linkId", linkId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsLinksCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsLinksCreateCall) Context(ctx context.Context) *OrganizationsLocationsBucketsLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.link)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/links")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.links.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.links.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsLinksCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.links.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a link. This will also delete the corresponding BigQuery
// linked dataset.
//
//   - name: The full resource name of the link to delete.
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[L
//     INK_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]/links/[LINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]/links/[LINK_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
//     K_ID]".
func (r *OrganizationsLocationsBucketsLinksService) Delete(name string) *OrganizationsLocationsBucketsLinksDeleteCall {
	c := &OrganizationsLocationsBucketsLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsLinksDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsLinksDeleteCall) Context(ctx context.Context) *OrganizationsLocationsBucketsLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.links.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.links.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsLinksDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.links.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a link.
//
//   - name: The resource name of the link:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[L
//     INK_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]/links/[LINK_ID]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]/links/[LINK_ID]"
//     "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/links/[LIN
//     K_ID]".
func (r *OrganizationsLocationsBucketsLinksService) Get(name string) *OrganizationsLocationsBucketsLinksGetCall {
	c := &OrganizationsLocationsBucketsLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsLinksGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsBucketsLinksGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsBucketsLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsLinksGetCall) Context(ctx context.Context) *OrganizationsLocationsBucketsLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.links.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.links.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Link.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsLinksGetCall) Do(opts ...googleapi.CallOption) (*Link, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Link{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.links.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists links.
//
//   - parent: The parent resource whose links are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
//     "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID
//     ]"
//     "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCK
//     ET_ID]" "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *OrganizationsLocationsBucketsLinksService) List(parent string) *OrganizationsLocationsBucketsLinksListCall {
	c := &OrganizationsLocationsBucketsLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.
func (c *OrganizationsLocationsBucketsLinksListCall) PageSize(pageSize int64) *OrganizationsLocationsBucketsLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response.
func (c *OrganizationsLocationsBucketsLinksListCall) PageToken(pageToken string) *OrganizationsLocationsBucketsLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsLinksListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsBucketsLinksListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsBucketsLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsLinksListCall) Context(ctx context.Context) *OrganizationsLocationsBucketsLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/links")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.links.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.links.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLinksResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsBucketsLinksListCall) Do(opts ...googleapi.CallOption) (*ListLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.links.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsBucketsLinksListCall) Pages(ctx context.Context, f func(*ListLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsBucketsViewsCreateCall struct {
	s          *Service
	parent     string
	logview    *LogView
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a view over log entries in a log bucket. A bucket may
// contain a maximum of 30 views.
//
//   - parent: The bucket in which to create the view
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket".
func (r *OrganizationsLocationsBucketsViewsService) Create(parent string, logview *LogView) *OrganizationsLocationsBucketsViewsCreateCall {
	c := &OrganizationsLocationsBucketsViewsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.logview = logview
	return c
}

// ViewId sets the optional parameter "viewId": Required. A client-assigned
// identifier such as "my-view". Identifiers are limited to 100 characters and
// can include only letters, digits, underscores, and hyphens.
func (c *OrganizationsLocationsBucketsViewsCreateCall) ViewId(viewId string) *OrganizationsLocationsBucketsViewsCreateCall {
	c.urlParams_.Set("viewId", viewId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsViewsCreateCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsViewsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsViewsCreateCall) Context(ctx context.Context) *OrganizationsLocationsBucketsViewsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsViewsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsViewsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.views.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsViewsCreateCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsViewsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a view on a log bucket. If an UNAVAILABLE error is returned,
// this indicates that system is not in a state where it can delete the view.
// If this occurs, please try again in a few minutes.
//
//   - name: The full resource name of the view to delete:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *OrganizationsLocationsBucketsViewsService) Delete(name string) *OrganizationsLocationsBucketsViewsDeleteCall {
	c := &OrganizationsLocationsBucketsViewsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsViewsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsViewsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsViewsDeleteCall) Context(ctx context.Context) *OrganizationsLocationsBucketsViewsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsViewsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsViewsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.views.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsViewsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsViewsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a view on a log bucket.
//
//   - name: The resource name of the policy:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *OrganizationsLocationsBucketsViewsService) Get(name string) *OrganizationsLocationsBucketsViewsGetCall {
	c := &OrganizationsLocationsBucketsViewsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsViewsGetCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsViewsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsBucketsViewsGetCall) IfNoneMatch(entityTag string) *OrganizationsLocationsBucketsViewsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsViewsGetCall) Context(ctx context.Context) *OrganizationsLocationsBucketsViewsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsViewsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsViewsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.views.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsViewsGetCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsViewsGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *OrganizationsLocationsBucketsViewsService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *OrganizationsLocationsBucketsViewsGetIamPolicyCall {
	c := &OrganizationsLocationsBucketsViewsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsViewsGetIamPolicyCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsViewsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsViewsGetIamPolicyCall) Context(ctx context.Context) *OrganizationsLocationsBucketsViewsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsViewsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsViewsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.views.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsViewsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsViewsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists views on a log bucket.
//
//   - parent: The bucket whose views are to be listed:
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]".
func (r *OrganizationsLocationsBucketsViewsService) List(parent string) *OrganizationsLocationsBucketsViewsListCall {
	c := &OrganizationsLocationsBucketsViewsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return from this request.Non-positive values are ignored. The
// presence of nextPageToken in the response indicates that more results might
// be available.
func (c *OrganizationsLocationsBucketsViewsListCall) PageSize(pageSize int64) *OrganizationsLocationsBucketsViewsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If present, then retrieve
// the next batch of results from the preceding call to this method. pageToken
// must be the value of nextPageToken from the previous response. The values of
// other method parameters should be identical to those in the previous call.
func (c *OrganizationsLocationsBucketsViewsListCall) PageToken(pageToken string) *OrganizationsLocationsBucketsViewsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsViewsListCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsViewsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsLocationsBucketsViewsListCall) IfNoneMatch(entityTag string) *OrganizationsLocationsBucketsViewsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsViewsListCall) Context(ctx context.Context) *OrganizationsLocationsBucketsViewsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsViewsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsViewsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/views")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.views.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListViewsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsLocationsBucketsViewsListCall) Do(opts ...googleapi.CallOption) (*ListViewsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListViewsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsLocationsBucketsViewsListCall) Pages(ctx context.Context, f func(*ListViewsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type OrganizationsLocationsBucketsViewsPatchCall struct {
	s          *Service
	name       string
	logview    *LogView
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a view on a log bucket. This method replaces the value of the
// filter field from the existing view with the corresponding value from the
// new view. If an UNAVAILABLE error is returned, this indicates that system is
// not in a state where it can update the view. If this occurs, please try
// again in a few minutes.
//
//   - name: The full resource name of the view to update
//     "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[V
//     IEW_ID]" For
//     example:"projects/my-project/locations/global/buckets/my-bucket/views/my-vi
//     ew".
func (r *OrganizationsLocationsBucketsViewsService) Patch(name string, logview *LogView) *OrganizationsLocationsBucketsViewsPatchCall {
	c := &OrganizationsLocationsBucketsViewsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.logview = logview
	return c
}

// UpdateMask sets the optional parameter "updateMask": Field mask that
// specifies the fields in view that need an update. A field will be
// overwritten if, and only if, it is in the update mask. name and output only
// fields cannot be updated.For a detailed FieldMask definition, see
// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMaskFor
// example: updateMask=filter
func (c *OrganizationsLocationsBucketsViewsPatchCall) UpdateMask(updateMask string) *OrganizationsLocationsBucketsViewsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsViewsPatchCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsViewsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsViewsPatchCall) Context(ctx context.Context) *OrganizationsLocationsBucketsViewsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsViewsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsViewsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.logview)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.views.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *LogView.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsViewsPatchCall) Do(opts ...googleapi.CallOption) (*LogView, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &LogView{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsViewsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
// PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *OrganizationsLocationsBucketsViewsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *OrganizationsLocationsBucketsViewsSetIamPolicyCall {
	c := &OrganizationsLocationsBucketsViewsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsViewsSetIamPolicyCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsViewsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsViewsSetIamPolicyCall) Context(ctx context.Context) *OrganizationsLocationsBucketsViewsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsViewsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsViewsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "logging.organizations.locations.buckets.views.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsLocationsBucketsViewsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "logging.organizations.locations.buckets.views.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OrganizationsLocationsBucketsViewsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *OrganizationsLocationsBucketsViewsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *OrganizationsLocationsBucketsViewsTestIamPermissionsCall {
	c := &OrganizationsLocationsBucketsViewsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsLocationsBucketsViewsTestIamPermissionsCall) Fields(s ...googleapi.Field) *OrganizationsLocationsBucketsViewsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsLocationsBucketsViewsTestIamPermissionsCall) Context(ctx context.Context) *OrganizationsLocationsBucketsViewsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsLocationsBucketsViewsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsLocationsBucketsViewsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermiss