// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/run/v2/worker_pool_revision_template.proto

package runpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// WorkerPoolRevisionTemplate describes the data a worker pool revision should
// have when created from a template.
type WorkerPoolRevisionTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique name for the revision. If this field is omitted, it
	// will be automatically generated based on the WorkerPool name.
	Revision string `protobuf:"bytes,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// Optional. Unstructured key value map that can be used to organize and
	// categorize objects. User-provided labels are shared with Google's billing
	// system, so they can be used to filter, or break down billing charges by
	// team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels.
	//
	// Cloud Run API v2 does not support labels with `run.googleapis.com`,
	// `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
	// namespaces, and they will be rejected. All system labels in v1 now have a
	// corresponding field in v2 WorkerPoolRevisionTemplate.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Unstructured key value map that may be set by external tools to
	// store and arbitrary metadata. They are not queryable and should be
	// preserved when modifying objects.
	//
	// Cloud Run API v2 does not support annotations with `run.googleapis.com`,
	// `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev`
	// namespaces, and they will be rejected. All system annotations in v1 now
	// have a corresponding field in v2 WorkerPoolRevisionTemplate.
	//
	// This field follows Kubernetes annotations' namespacing, limits, and
	// rules.
	Annotations map[string]string `protobuf:"bytes,3,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. VPC Access configuration to use for this Revision. For more
	// information, visit
	// https://cloud.google.com/run/docs/configuring/connecting-vpc.
	VpcAccess *VpcAccess `protobuf:"bytes,4,opt,name=vpc_access,json=vpcAccess,proto3" json:"vpc_access,omitempty"`
	// Optional. Email address of the IAM service account associated with the
	// revision of the service. The service account represents the identity of the
	// running revision, and determines what permissions the revision has. If not
	// provided, the revision will use the project's default service account.
	ServiceAccount string `protobuf:"bytes,5,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Holds list of the containers that defines the unit of execution for this
	// Revision.
	Containers []*Container `protobuf:"bytes,6,rep,name=containers,proto3" json:"containers,omitempty"`
	// Optional. A list of Volumes to make available to containers.
	Volumes []*Volume `protobuf:"bytes,7,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// A reference to a customer managed encryption key (CMEK) to use to encrypt
	// this container image. For more information, go to
	// https://cloud.google.com/run/docs/securing/using-cmek
	EncryptionKey string `protobuf:"bytes,8,opt,name=encryption_key,json=encryptionKey,proto3" json:"encryption_key,omitempty"`
	// Optional. Enables service mesh connectivity.
	ServiceMesh *ServiceMesh `protobuf:"bytes,9,opt,name=service_mesh,json=serviceMesh,proto3" json:"service_mesh,omitempty"`
	// Optional. The action to take if the encryption key is revoked.
	EncryptionKeyRevocationAction EncryptionKeyRevocationAction `protobuf:"varint,10,opt,name=encryption_key_revocation_action,json=encryptionKeyRevocationAction,proto3,enum=google.cloud.run.v2.EncryptionKeyRevocationAction" json:"encryption_key_revocation_action,omitempty"`
	// Optional. If encryption_key_revocation_action is SHUTDOWN, the duration
	// before shutting down all instances. The minimum increment is 1 hour.
	EncryptionKeyShutdownDuration *durationpb.Duration `protobuf:"bytes,11,opt,name=encryption_key_shutdown_duration,json=encryptionKeyShutdownDuration,proto3" json:"encryption_key_shutdown_duration,omitempty"`
	// Optional. The node selector for the revision template.
	NodeSelector *NodeSelector `protobuf:"bytes,13,opt,name=node_selector,json=nodeSelector,proto3" json:"node_selector,omitempty"`
	// Optional. True if GPU zonal redundancy is disabled on this worker pool.
	GpuZonalRedundancyDisabled *bool `protobuf:"varint,16,opt,name=gpu_zonal_redundancy_disabled,json=gpuZonalRedundancyDisabled,proto3,oneof" json:"gpu_zonal_redundancy_disabled,omitempty"`
}

func (x *WorkerPoolRevisionTemplate) Reset() {
	*x = WorkerPoolRevisionTemplate{}
	mi := &file_google_cloud_run_v2_worker_pool_revision_template_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkerPoolRevisionTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerPoolRevisionTemplate) ProtoMessage() {}

func (x *WorkerPoolRevisionTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_run_v2_worker_pool_revision_template_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerPoolRevisionTemplate.ProtoReflect.Descriptor instead.
func (*WorkerPoolRevisionTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDescGZIP(), []int{0}
}

func (x *WorkerPoolRevisionTemplate) GetRevision() string {
	if x != nil {
		return x.Revision
	}
	return ""
}

func (x *WorkerPoolRevisionTemplate) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *WorkerPoolRevisionTemplate) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *WorkerPoolRevisionTemplate) GetVpcAccess() *VpcAccess {
	if x != nil {
		return x.VpcAccess
	}
	return nil
}

func (x *WorkerPoolRevisionTemplate) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *WorkerPoolRevisionTemplate) GetContainers() []*Container {
	if x != nil {
		return x.Containers
	}
	return nil
}

func (x *WorkerPoolRevisionTemplate) GetVolumes() []*Volume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

func (x *WorkerPoolRevisionTemplate) GetEncryptionKey() string {
	if x != nil {
		return x.EncryptionKey
	}
	return ""
}

func (x *WorkerPoolRevisionTemplate) GetServiceMesh() *ServiceMesh {
	if x != nil {
		return x.ServiceMesh
	}
	return nil
}

func (x *WorkerPoolRevisionTemplate) GetEncryptionKeyRevocationAction() EncryptionKeyRevocationAction {
	if x != nil {
		return x.EncryptionKeyRevocationAction
	}
	return EncryptionKeyRevocationAction_ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED
}

func (x *WorkerPoolRevisionTemplate) GetEncryptionKeyShutdownDuration() *durationpb.Duration {
	if x != nil {
		return x.EncryptionKeyShutdownDuration
	}
	return nil
}

func (x *WorkerPoolRevisionTemplate) GetNodeSelector() *NodeSelector {
	if x != nil {
		return x.NodeSelector
	}
	return nil
}

func (x *WorkerPoolRevisionTemplate) GetGpuZonalRedundancyDisabled() bool {
	if x != nil && x.GpuZonalRedundancyDisabled != nil {
		return *x.GpuZonalRedundancyDisabled
	}
	return false
}

var File_google_cloud_run_v2_worker_pool_revision_template_proto protoreflect.FileDescriptor

var file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x75, 0x6e, 0x2f, 0x76, 0x32, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x75, 0x6e, 0x2f, 0x76, 0x32, 0x2f,
	0x6b, 0x38, 0x73, 0x2e, 0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x75, 0x6e, 0x2f,
	0x76, 0x32, 0x2f, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xca, 0x09, 0x0a, 0x1a, 0x57, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x3f, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x1d, 0x0a, 0x1b, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x67, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x6f,
	0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x42, 0x0a, 0x0a, 0x76,
	0x70, 0x63, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x70, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x76, 0x70, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12,
	0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3e, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x3a, 0x0a,
	0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0e, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x48, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x68, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75,
	0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x73, 0x68,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65,
	0x73, 0x68, 0x12, 0x80, 0x01, 0x0a, 0x20, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e,
	0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65,
	0x79, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x20, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e,
	0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x1d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x53, 0x68,
	0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b,
	0x0a, 0x0d, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32, 0x2e, 0x4e, 0x6f, 0x64, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6e,
	0x6f, 0x64, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x4b, 0x0a, 0x1d, 0x67,
	0x70, 0x75, 0x5f, 0x7a, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61,
	0x6e, 0x63, 0x79, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x1a, 0x67, 0x70, 0x75, 0x5a, 0x6f,
	0x6e, 0x61, 0x6c, 0x52, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x44, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x7a, 0x6f, 0x6e, 0x61,
	0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x79, 0x5f, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x42, 0x67, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x2e, 0x76, 0x32,
	0x42, 0x1f, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x72, 0x75, 0x6e, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x2f, 0x72, 0x75, 0x6e, 0x70, 0x62, 0x3b, 0x72, 0x75, 0x6e, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDescOnce sync.Once
	file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDescData = file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDesc
)

func file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDescGZIP() []byte {
	file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDescOnce.Do(func() {
		file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDescData)
	})
	return file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDescData
}

var file_google_cloud_run_v2_worker_pool_revision_template_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_cloud_run_v2_worker_pool_revision_template_proto_goTypes = []any{
	(*WorkerPoolRevisionTemplate)(nil), // 0: google.cloud.run.v2.WorkerPoolRevisionTemplate
	nil,                                // 1: google.cloud.run.v2.WorkerPoolRevisionTemplate.LabelsEntry
	nil,                                // 2: google.cloud.run.v2.WorkerPoolRevisionTemplate.AnnotationsEntry
	(*VpcAccess)(nil),                  // 3: google.cloud.run.v2.VpcAccess
	(*Container)(nil),                  // 4: google.cloud.run.v2.Container
	(*Volume)(nil),                     // 5: google.cloud.run.v2.Volume
	(*ServiceMesh)(nil),                // 6: google.cloud.run.v2.ServiceMesh
	(EncryptionKeyRevocationAction)(0), // 7: google.cloud.run.v2.EncryptionKeyRevocationAction
	(*durationpb.Duration)(nil),        // 8: google.protobuf.Duration
	(*NodeSelector)(nil),               // 9: google.cloud.run.v2.NodeSelector
}
var file_google_cloud_run_v2_worker_pool_revision_template_proto_depIdxs = []int32{
	1, // 0: google.cloud.run.v2.WorkerPoolRevisionTemplate.labels:type_name -> google.cloud.run.v2.WorkerPoolRevisionTemplate.LabelsEntry
	2, // 1: google.cloud.run.v2.WorkerPoolRevisionTemplate.annotations:type_name -> google.cloud.run.v2.WorkerPoolRevisionTemplate.AnnotationsEntry
	3, // 2: google.cloud.run.v2.WorkerPoolRevisionTemplate.vpc_access:type_name -> google.cloud.run.v2.VpcAccess
	4, // 3: google.cloud.run.v2.WorkerPoolRevisionTemplate.containers:type_name -> google.cloud.run.v2.Container
	5, // 4: google.cloud.run.v2.WorkerPoolRevisionTemplate.volumes:type_name -> google.cloud.run.v2.Volume
	6, // 5: google.cloud.run.v2.WorkerPoolRevisionTemplate.service_mesh:type_name -> google.cloud.run.v2.ServiceMesh
	7, // 6: google.cloud.run.v2.WorkerPoolRevisionTemplate.encryption_key_revocation_action:type_name -> google.cloud.run.v2.EncryptionKeyRevocationAction
	8, // 7: google.cloud.run.v2.WorkerPoolRevisionTemplate.encryption_key_shutdown_duration:type_name -> google.protobuf.Duration
	9, // 8: google.cloud.run.v2.WorkerPoolRevisionTemplate.node_selector:type_name -> google.cloud.run.v2.NodeSelector
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_run_v2_worker_pool_revision_template_proto_init() }
func file_google_cloud_run_v2_worker_pool_revision_template_proto_init() {
	if File_google_cloud_run_v2_worker_pool_revision_template_proto != nil {
		return
	}
	file_google_cloud_run_v2_k8s_min_proto_init()
	file_google_cloud_run_v2_vendor_settings_proto_init()
	file_google_cloud_run_v2_worker_pool_revision_template_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_run_v2_worker_pool_revision_template_proto_goTypes,
		DependencyIndexes: file_google_cloud_run_v2_worker_pool_revision_template_proto_depIdxs,
		MessageInfos:      file_google_cloud_run_v2_worker_pool_revision_template_proto_msgTypes,
	}.Build()
	File_google_cloud_run_v2_worker_pool_revision_template_proto = out.File
	file_google_cloud_run_v2_worker_pool_revision_template_proto_rawDesc = nil
	file_google_cloud_run_v2_worker_pool_revision_template_proto_goTypes = nil
	file_google_cloud_run_v2_worker_pool_revision_template_proto_depIdxs = nil
}
