//go:build vtprotobuf
// +build vtprotobuf

// Code generated by protoc-gen-go-vtproto. DO NOT EDIT.
// source: envoy/extensions/http/cache/file_system_http_cache/v3/file_system_http_cache.proto

package file_system_http_cachev3

import (
	binary "encoding/binary"
	protohelpers "github.com/planetscale/vtprotobuf/protohelpers"
	durationpb "github.com/planetscale/vtprotobuf/types/known/durationpb"
	wrapperspb "github.com/planetscale/vtprotobuf/types/known/wrapperspb"
	proto "google.golang.org/protobuf/proto"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	math "math"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

func (m *FileSystemHttpCacheConfig) MarshalVTStrict() (dAtA []byte, err error) {
	if m == nil {
		return nil, nil
	}
	size := m.SizeVT()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBufferVTStrict(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FileSystemHttpCacheConfig) MarshalToVTStrict(dAtA []byte) (int, error) {
	size := m.SizeVT()
	return m.MarshalToSizedBufferVTStrict(dAtA[:size])
}

func (m *FileSystemHttpCacheConfig) MarshalToSizedBufferVTStrict(dAtA []byte) (int, error) {
	if m == nil {
		return 0, nil
	}
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.unknownFields != nil {
		i -= len(m.unknownFields)
		copy(dAtA[i:], m.unknownFields)
	}
	if m.CreateCachePath {
		i--
		if m.CreateCachePath {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.MinEvictionPeriod != nil {
		size, err := (*durationpb.Duration)(m.MinEvictionPeriod).MarshalToSizedBufferVTStrict(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = protohelpers.EncodeVarint(dAtA, i, uint64(size))
		i--
		dAtA[i] = 0x4a
	}
	if m.MaxEvictionPeriod != nil {
		size, err := (*durationpb.Duration)(m.MaxEvictionPeriod).MarshalToSizedBufferVTStrict(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = protohelpers.EncodeVarint(dAtA, i, uint64(size))
		i--
		dAtA[i] = 0x42
	}
	if m.EvictFraction != 0 {
		i -= 4
		binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.EvictFraction))))
		i--
		dAtA[i] = 0x3d
	}
	if m.CacheSubdivisions != 0 {
		i = protohelpers.EncodeVarint(dAtA, i, uint64(m.CacheSubdivisions))
		i--
		dAtA[i] = 0x30
	}
	if m.MaxCacheEntryCount != nil {
		size, err := (*wrapperspb.UInt64Value)(m.MaxCacheEntryCount).MarshalToSizedBufferVTStrict(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = protohelpers.EncodeVarint(dAtA, i, uint64(size))
		i--
		dAtA[i] = 0x2a
	}
	if m.MaxIndividualCacheEntrySizeBytes != nil {
		size, err := (*wrapperspb.UInt64Value)(m.MaxIndividualCacheEntrySizeBytes).MarshalToSizedBufferVTStrict(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = protohelpers.EncodeVarint(dAtA, i, uint64(size))
		i--
		dAtA[i] = 0x22
	}
	if m.MaxCacheSizeBytes != nil {
		size, err := (*wrapperspb.UInt64Value)(m.MaxCacheSizeBytes).MarshalToSizedBufferVTStrict(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = protohelpers.EncodeVarint(dAtA, i, uint64(size))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.CachePath) > 0 {
		i -= len(m.CachePath)
		copy(dAtA[i:], m.CachePath)
		i = protohelpers.EncodeVarint(dAtA, i, uint64(len(m.CachePath)))
		i--
		dAtA[i] = 0x12
	}
	if m.ManagerConfig != nil {
		if vtmsg, ok := interface{}(m.ManagerConfig).(interface {
			MarshalToSizedBufferVTStrict([]byte) (int, error)
		}); ok {
			size, err := vtmsg.MarshalToSizedBufferVTStrict(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = protohelpers.EncodeVarint(dAtA, i, uint64(size))
		} else {
			encoded, err := proto.Marshal(m.ManagerConfig)
			if err != nil {
				return 0, err
			}
			i -= len(encoded)
			copy(dAtA[i:], encoded)
			i = protohelpers.EncodeVarint(dAtA, i, uint64(len(encoded)))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FileSystemHttpCacheConfig) SizeVT() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ManagerConfig != nil {
		if size, ok := interface{}(m.ManagerConfig).(interface {
			SizeVT() int
		}); ok {
			l = size.SizeVT()
		} else {
			l = proto.Size(m.ManagerConfig)
		}
		n += 1 + l + protohelpers.SizeOfVarint(uint64(l))
	}
	l = len(m.CachePath)
	if l > 0 {
		n += 1 + l + protohelpers.SizeOfVarint(uint64(l))
	}
	if m.MaxCacheSizeBytes != nil {
		l = (*wrapperspb.UInt64Value)(m.MaxCacheSizeBytes).SizeVT()
		n += 1 + l + protohelpers.SizeOfVarint(uint64(l))
	}
	if m.MaxIndividualCacheEntrySizeBytes != nil {
		l = (*wrapperspb.UInt64Value)(m.MaxIndividualCacheEntrySizeBytes).SizeVT()
		n += 1 + l + protohelpers.SizeOfVarint(uint64(l))
	}
	if m.MaxCacheEntryCount != nil {
		l = (*wrapperspb.UInt64Value)(m.MaxCacheEntryCount).SizeVT()
		n += 1 + l + protohelpers.SizeOfVarint(uint64(l))
	}
	if m.CacheSubdivisions != 0 {
		n += 1 + protohelpers.SizeOfVarint(uint64(m.CacheSubdivisions))
	}
	if m.EvictFraction != 0 {
		n += 5
	}
	if m.MaxEvictionPeriod != nil {
		l = (*durationpb.Duration)(m.MaxEvictionPeriod).SizeVT()
		n += 1 + l + protohelpers.SizeOfVarint(uint64(l))
	}
	if m.MinEvictionPeriod != nil {
		l = (*durationpb.Duration)(m.MinEvictionPeriod).SizeVT()
		n += 1 + l + protohelpers.SizeOfVarint(uint64(l))
	}
	if m.CreateCachePath {
		n += 2
	}
	n += len(m.unknownFields)
	return n
}
