// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/osconfig/v1alpha/inventory.proto

package osconfigpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The view for inventory objects.
type InventoryView int32

const (
	// The default value.
	// The API defaults to the BASIC view.
	InventoryView_INVENTORY_VIEW_UNSPECIFIED InventoryView = 0
	// Returns the basic inventory information that includes `os_info`.
	InventoryView_BASIC InventoryView = 1
	// Returns all fields.
	InventoryView_FULL InventoryView = 2
)

// Enum value maps for InventoryView.
var (
	InventoryView_name = map[int32]string{
		0: "INVENTORY_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
	}
	InventoryView_value = map[string]int32{
		"INVENTORY_VIEW_UNSPECIFIED": 0,
		"BASIC":                      1,
		"FULL":                       2,
	}
)

func (x InventoryView) Enum() *InventoryView {
	p := new(InventoryView)
	*p = x
	return p
}

func (x InventoryView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InventoryView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_enumTypes[0].Descriptor()
}

func (InventoryView) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1alpha_inventory_proto_enumTypes[0]
}

func (x InventoryView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InventoryView.Descriptor instead.
func (InventoryView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0}
}

// The origin of a specific inventory item.
type Inventory_Item_OriginType int32

const (
	// Invalid. An origin type must be specified.
	Inventory_Item_ORIGIN_TYPE_UNSPECIFIED Inventory_Item_OriginType = 0
	// This inventory item was discovered as the result of the agent
	// reporting inventory via the reporting API.
	Inventory_Item_INVENTORY_REPORT Inventory_Item_OriginType = 1
)

// Enum value maps for Inventory_Item_OriginType.
var (
	Inventory_Item_OriginType_name = map[int32]string{
		0: "ORIGIN_TYPE_UNSPECIFIED",
		1: "INVENTORY_REPORT",
	}
	Inventory_Item_OriginType_value = map[string]int32{
		"ORIGIN_TYPE_UNSPECIFIED": 0,
		"INVENTORY_REPORT":        1,
	}
)

func (x Inventory_Item_OriginType) Enum() *Inventory_Item_OriginType {
	p := new(Inventory_Item_OriginType)
	*p = x
	return p
}

func (x Inventory_Item_OriginType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Inventory_Item_OriginType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_enumTypes[1].Descriptor()
}

func (Inventory_Item_OriginType) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1alpha_inventory_proto_enumTypes[1]
}

func (x Inventory_Item_OriginType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Inventory_Item_OriginType.Descriptor instead.
func (Inventory_Item_OriginType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 1, 0}
}

// The different types of inventory that are tracked on a VM.
type Inventory_Item_Type int32

const (
	// Invalid. An type must be specified.
	Inventory_Item_TYPE_UNSPECIFIED Inventory_Item_Type = 0
	// This represents a package that is installed on the VM.
	Inventory_Item_INSTALLED_PACKAGE Inventory_Item_Type = 1
	// This represents an update that is available for a package.
	Inventory_Item_AVAILABLE_PACKAGE Inventory_Item_Type = 2
)

// Enum value maps for Inventory_Item_Type.
var (
	Inventory_Item_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "INSTALLED_PACKAGE",
		2: "AVAILABLE_PACKAGE",
	}
	Inventory_Item_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":  0,
		"INSTALLED_PACKAGE": 1,
		"AVAILABLE_PACKAGE": 2,
	}
)

func (x Inventory_Item_Type) Enum() *Inventory_Item_Type {
	p := new(Inventory_Item_Type)
	*p = x
	return p
}

func (x Inventory_Item_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Inventory_Item_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_enumTypes[2].Descriptor()
}

func (Inventory_Item_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1alpha_inventory_proto_enumTypes[2]
}

func (x Inventory_Item_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Inventory_Item_Type.Descriptor instead.
func (Inventory_Item_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 1, 1}
}

// This API resource represents the available inventory data for a
// Compute Engine virtual machine (VM) instance at a given point in time.
//
// You can use this API resource to determine the inventory data of your VM.
//
// For more information, see [Information provided by OS inventory
// management](https://cloud.google.com/compute/docs/instances/os-inventory-management#data-collected).
type Inventory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The `Inventory` API resource name.
	//
	// Format:
	// `projects/{project_number}/locations/{location}/instances/{instance_id}/inventory`
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Base level operating system information for the VM.
	OsInfo *Inventory_OsInfo `protobuf:"bytes,1,opt,name=os_info,json=osInfo,proto3" json:"os_info,omitempty"`
	// Output only. Inventory items related to the VM keyed by an opaque unique identifier for
	// each inventory item. The identifier is unique to each distinct and
	// addressable inventory item and will change, when there is a new package
	// version.
	Items map[string]*Inventory_Item `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Timestamp of the last reported inventory for the VM.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Inventory) Reset() {
	*x = Inventory{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory) ProtoMessage() {}

func (x *Inventory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory.ProtoReflect.Descriptor instead.
func (*Inventory) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0}
}

func (x *Inventory) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Inventory) GetOsInfo() *Inventory_OsInfo {
	if x != nil {
		return x.OsInfo
	}
	return nil
}

func (x *Inventory) GetItems() map[string]*Inventory_Item {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *Inventory) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A request message for getting inventory data for the specified VM.
type GetInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. API resource name for inventory resource.
	//
	// Format:
	// `projects/{project}/locations/{location}/instances/{instance}/inventory`
	//
	// For `{project}`, either `project-number` or `project-id` can be provided.
	// For `{instance}`, either Compute Engine  `instance-id` or `instance-name`
	// can be provided.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Inventory view indicating what information should be included in the
	// inventory resource. If unspecified, the default view is BASIC.
	View InventoryView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.osconfig.v1alpha.InventoryView" json:"view,omitempty"`
}

func (x *GetInventoryRequest) Reset() {
	*x = GetInventoryRequest{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInventoryRequest) ProtoMessage() {}

func (x *GetInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInventoryRequest.ProtoReflect.Descriptor instead.
func (*GetInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{1}
}

func (x *GetInventoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetInventoryRequest) GetView() InventoryView {
	if x != nil {
		return x.View
	}
	return InventoryView_INVENTORY_VIEW_UNSPECIFIED
}

// A request message for listing inventory data for all VMs in the specified
// location.
type ListInventoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name.
	//
	// Format: `projects/{project}/locations/{location}/instances/-`
	//
	// For `{project}`, either `project-number` or `project-id` can be provided.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Inventory view indicating what information should be included in the
	// inventory resource. If unspecified, the default view is BASIC.
	View InventoryView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.osconfig.v1alpha.InventoryView" json:"view,omitempty"`
	// The maximum number of results to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to
	// `ListInventories` that indicates where this listing
	// should continue from.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// If provided, this field specifies the criteria that must be met by a
	// `Inventory` API resource to be included in the response.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListInventoriesRequest) Reset() {
	*x = ListInventoriesRequest{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInventoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInventoriesRequest) ProtoMessage() {}

func (x *ListInventoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInventoriesRequest.ProtoReflect.Descriptor instead.
func (*ListInventoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{2}
}

func (x *ListInventoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInventoriesRequest) GetView() InventoryView {
	if x != nil {
		return x.View
	}
	return InventoryView_INVENTORY_VIEW_UNSPECIFIED
}

func (x *ListInventoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInventoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInventoriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// A response message for listing inventory data for all VMs in a specified
// location.
type ListInventoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of inventory objects.
	Inventories []*Inventory `protobuf:"bytes,1,rep,name=inventories,proto3" json:"inventories,omitempty"`
	// The pagination token to retrieve the next page of inventory objects.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListInventoriesResponse) Reset() {
	*x = ListInventoriesResponse{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInventoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInventoriesResponse) ProtoMessage() {}

func (x *ListInventoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInventoriesResponse.ProtoReflect.Descriptor instead.
func (*ListInventoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{3}
}

func (x *ListInventoriesResponse) GetInventories() []*Inventory {
	if x != nil {
		return x.Inventories
	}
	return nil
}

func (x *ListInventoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Operating system information for the VM.
type Inventory_OsInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The VM hostname.
	Hostname string `protobuf:"bytes,9,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// The operating system long name.
	// For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
	// Datacenter'.
	LongName string `protobuf:"bytes,2,opt,name=long_name,json=longName,proto3" json:"long_name,omitempty"`
	// The operating system short name.
	// For example, 'windows' or 'debian'.
	ShortName string `protobuf:"bytes,3,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// The version of the operating system.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// The system architecture of the operating system.
	Architecture string `protobuf:"bytes,5,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// The kernel version of the operating system.
	KernelVersion string `protobuf:"bytes,6,opt,name=kernel_version,json=kernelVersion,proto3" json:"kernel_version,omitempty"`
	// The kernel release of the operating system.
	KernelRelease string `protobuf:"bytes,7,opt,name=kernel_release,json=kernelRelease,proto3" json:"kernel_release,omitempty"`
	// The current version of the OS Config agent running on the VM.
	OsconfigAgentVersion string `protobuf:"bytes,8,opt,name=osconfig_agent_version,json=osconfigAgentVersion,proto3" json:"osconfig_agent_version,omitempty"`
}

func (x *Inventory_OsInfo) Reset() {
	*x = Inventory_OsInfo{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory_OsInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_OsInfo) ProtoMessage() {}

func (x *Inventory_OsInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_OsInfo.ProtoReflect.Descriptor instead.
func (*Inventory_OsInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Inventory_OsInfo) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *Inventory_OsInfo) GetLongName() string {
	if x != nil {
		return x.LongName
	}
	return ""
}

func (x *Inventory_OsInfo) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *Inventory_OsInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Inventory_OsInfo) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *Inventory_OsInfo) GetKernelVersion() string {
	if x != nil {
		return x.KernelVersion
	}
	return ""
}

func (x *Inventory_OsInfo) GetKernelRelease() string {
	if x != nil {
		return x.KernelRelease
	}
	return ""
}

func (x *Inventory_OsInfo) GetOsconfigAgentVersion() string {
	if x != nil {
		return x.OsconfigAgentVersion
	}
	return ""
}

// A single piece of inventory on a VM.
type Inventory_Item struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for this item, unique across items for this VM.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The origin of this inventory item.
	OriginType Inventory_Item_OriginType `protobuf:"varint,2,opt,name=origin_type,json=originType,proto3,enum=google.cloud.osconfig.v1alpha.Inventory_Item_OriginType" json:"origin_type,omitempty"`
	// When this inventory item was first detected.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// When this inventory item was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The specific type of inventory, correlating to its specific details.
	Type Inventory_Item_Type `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.osconfig.v1alpha.Inventory_Item_Type" json:"type,omitempty"`
	// Specific details of this inventory item based on its type.
	//
	// Types that are assignable to Details:
	//
	//	*Inventory_Item_InstalledPackage
	//	*Inventory_Item_AvailablePackage
	Details isInventory_Item_Details `protobuf_oneof:"details"`
}

func (x *Inventory_Item) Reset() {
	*x = Inventory_Item{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory_Item) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_Item) ProtoMessage() {}

func (x *Inventory_Item) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_Item.ProtoReflect.Descriptor instead.
func (*Inventory_Item) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Inventory_Item) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Inventory_Item) GetOriginType() Inventory_Item_OriginType {
	if x != nil {
		return x.OriginType
	}
	return Inventory_Item_ORIGIN_TYPE_UNSPECIFIED
}

func (x *Inventory_Item) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Inventory_Item) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Inventory_Item) GetType() Inventory_Item_Type {
	if x != nil {
		return x.Type
	}
	return Inventory_Item_TYPE_UNSPECIFIED
}

func (m *Inventory_Item) GetDetails() isInventory_Item_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *Inventory_Item) GetInstalledPackage() *Inventory_SoftwarePackage {
	if x, ok := x.GetDetails().(*Inventory_Item_InstalledPackage); ok {
		return x.InstalledPackage
	}
	return nil
}

func (x *Inventory_Item) GetAvailablePackage() *Inventory_SoftwarePackage {
	if x, ok := x.GetDetails().(*Inventory_Item_AvailablePackage); ok {
		return x.AvailablePackage
	}
	return nil
}

type isInventory_Item_Details interface {
	isInventory_Item_Details()
}

type Inventory_Item_InstalledPackage struct {
	// Software package present on the VM instance.
	InstalledPackage *Inventory_SoftwarePackage `protobuf:"bytes,6,opt,name=installed_package,json=installedPackage,proto3,oneof"`
}

type Inventory_Item_AvailablePackage struct {
	// Software package available to be installed on the VM instance.
	AvailablePackage *Inventory_SoftwarePackage `protobuf:"bytes,7,opt,name=available_package,json=availablePackage,proto3,oneof"`
}

func (*Inventory_Item_InstalledPackage) isInventory_Item_Details() {}

func (*Inventory_Item_AvailablePackage) isInventory_Item_Details() {}

// Software package information of the operating system.
type Inventory_SoftwarePackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the different types of software packages.
	//
	// Types that are assignable to Details:
	//
	//	*Inventory_SoftwarePackage_YumPackage
	//	*Inventory_SoftwarePackage_AptPackage
	//	*Inventory_SoftwarePackage_ZypperPackage
	//	*Inventory_SoftwarePackage_GoogetPackage
	//	*Inventory_SoftwarePackage_ZypperPatch
	//	*Inventory_SoftwarePackage_WuaPackage
	//	*Inventory_SoftwarePackage_QfePackage
	//	*Inventory_SoftwarePackage_CosPackage
	//	*Inventory_SoftwarePackage_WindowsApplication
	Details isInventory_SoftwarePackage_Details `protobuf_oneof:"details"`
}

func (x *Inventory_SoftwarePackage) Reset() {
	*x = Inventory_SoftwarePackage{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory_SoftwarePackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_SoftwarePackage) ProtoMessage() {}

func (x *Inventory_SoftwarePackage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_SoftwarePackage.ProtoReflect.Descriptor instead.
func (*Inventory_SoftwarePackage) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 2}
}

func (m *Inventory_SoftwarePackage) GetDetails() isInventory_SoftwarePackage_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetYumPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_YumPackage); ok {
		return x.YumPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetAptPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_AptPackage); ok {
		return x.AptPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetZypperPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_ZypperPackage); ok {
		return x.ZypperPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetGoogetPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_GoogetPackage); ok {
		return x.GoogetPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetZypperPatch() *Inventory_ZypperPatch {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_ZypperPatch); ok {
		return x.ZypperPatch
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetWuaPackage() *Inventory_WindowsUpdatePackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_WuaPackage); ok {
		return x.WuaPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetQfePackage() *Inventory_WindowsQuickFixEngineeringPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_QfePackage); ok {
		return x.QfePackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetCosPackage() *Inventory_VersionedPackage {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_CosPackage); ok {
		return x.CosPackage
	}
	return nil
}

func (x *Inventory_SoftwarePackage) GetWindowsApplication() *Inventory_WindowsApplication {
	if x, ok := x.GetDetails().(*Inventory_SoftwarePackage_WindowsApplication); ok {
		return x.WindowsApplication
	}
	return nil
}

type isInventory_SoftwarePackage_Details interface {
	isInventory_SoftwarePackage_Details()
}

type Inventory_SoftwarePackage_YumPackage struct {
	// Yum package info.
	// For details about the yum package manager, see
	// https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/6/html/deployment_guide/ch-yum.
	YumPackage *Inventory_VersionedPackage `protobuf:"bytes,1,opt,name=yum_package,json=yumPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_AptPackage struct {
	// Details of an APT package.
	// For details about the apt package manager, see
	// https://wiki.debian.org/Apt.
	AptPackage *Inventory_VersionedPackage `protobuf:"bytes,2,opt,name=apt_package,json=aptPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_ZypperPackage struct {
	// Details of a Zypper package.
	// For details about the Zypper package manager, see
	// https://en.opensuse.org/SDB:Zypper_manual.
	ZypperPackage *Inventory_VersionedPackage `protobuf:"bytes,3,opt,name=zypper_package,json=zypperPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_GoogetPackage struct {
	// Details of a Googet package.
	//
	//	For details about the googet package manager, see
	//	https://github.com/google/googet.
	GoogetPackage *Inventory_VersionedPackage `protobuf:"bytes,4,opt,name=googet_package,json=googetPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_ZypperPatch struct {
	// Details of a Zypper patch.
	// For details about the Zypper package manager, see
	// https://en.opensuse.org/SDB:Zypper_manual.
	ZypperPatch *Inventory_ZypperPatch `protobuf:"bytes,5,opt,name=zypper_patch,json=zypperPatch,proto3,oneof"`
}

type Inventory_SoftwarePackage_WuaPackage struct {
	// Details of a Windows Update package.
	// See https://docs.microsoft.com/en-us/windows/win32/api/_wua/ for
	// information about Windows Update.
	WuaPackage *Inventory_WindowsUpdatePackage `protobuf:"bytes,6,opt,name=wua_package,json=wuaPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_QfePackage struct {
	// Details of a Windows Quick Fix engineering package.
	// See
	// https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
	// for info in Windows Quick Fix Engineering.
	QfePackage *Inventory_WindowsQuickFixEngineeringPackage `protobuf:"bytes,7,opt,name=qfe_package,json=qfePackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_CosPackage struct {
	// Details of a COS package.
	CosPackage *Inventory_VersionedPackage `protobuf:"bytes,8,opt,name=cos_package,json=cosPackage,proto3,oneof"`
}

type Inventory_SoftwarePackage_WindowsApplication struct {
	// Details of Windows Application.
	WindowsApplication *Inventory_WindowsApplication `protobuf:"bytes,9,opt,name=windows_application,json=windowsApplication,proto3,oneof"`
}

func (*Inventory_SoftwarePackage_YumPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_AptPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_ZypperPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_GoogetPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_ZypperPatch) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_WuaPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_QfePackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_CosPackage) isInventory_SoftwarePackage_Details() {}

func (*Inventory_SoftwarePackage_WindowsApplication) isInventory_SoftwarePackage_Details() {}

// Information related to the a standard versioned package.  This includes
// package info for APT, Yum, Zypper, and Googet package managers.
type Inventory_VersionedPackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the package.
	PackageName string `protobuf:"bytes,4,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	// The system architecture this package is intended for.
	Architecture string `protobuf:"bytes,2,opt,name=architecture,proto3" json:"architecture,omitempty"`
	// The version of the package.
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *Inventory_VersionedPackage) Reset() {
	*x = Inventory_VersionedPackage{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory_VersionedPackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_VersionedPackage) ProtoMessage() {}

func (x *Inventory_VersionedPackage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_VersionedPackage.ProtoReflect.Descriptor instead.
func (*Inventory_VersionedPackage) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Inventory_VersionedPackage) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *Inventory_VersionedPackage) GetArchitecture() string {
	if x != nil {
		return x.Architecture
	}
	return ""
}

func (x *Inventory_VersionedPackage) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Details related to a Zypper Patch.
type Inventory_ZypperPatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the patch.
	PatchName string `protobuf:"bytes,5,opt,name=patch_name,json=patchName,proto3" json:"patch_name,omitempty"`
	// The category of the patch.
	Category string `protobuf:"bytes,2,opt,name=category,proto3" json:"category,omitempty"`
	// The severity specified for this patch
	Severity string `protobuf:"bytes,3,opt,name=severity,proto3" json:"severity,omitempty"`
	// Any summary information provided about this patch.
	Summary string `protobuf:"bytes,4,opt,name=summary,proto3" json:"summary,omitempty"`
}

func (x *Inventory_ZypperPatch) Reset() {
	*x = Inventory_ZypperPatch{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory_ZypperPatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_ZypperPatch) ProtoMessage() {}

func (x *Inventory_ZypperPatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_ZypperPatch.ProtoReflect.Descriptor instead.
func (*Inventory_ZypperPatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Inventory_ZypperPatch) GetPatchName() string {
	if x != nil {
		return x.PatchName
	}
	return ""
}

func (x *Inventory_ZypperPatch) GetCategory() string {
	if x != nil {
		return x.Category
	}
	return ""
}

func (x *Inventory_ZypperPatch) GetSeverity() string {
	if x != nil {
		return x.Severity
	}
	return ""
}

func (x *Inventory_ZypperPatch) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

// Details related to a Windows Update package.
// Field data and names are taken from Windows Update API IUpdate Interface:
// https://docs.microsoft.com/en-us/windows/win32/api/_wua/
// Descriptive fields like title, and description are localized based on
// the locale of the VM being updated.
type Inventory_WindowsUpdatePackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The localized title of the update package.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// The localized description of the update package.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The categories that are associated with this update package.
	Categories []*Inventory_WindowsUpdatePackage_WindowsUpdateCategory `protobuf:"bytes,3,rep,name=categories,proto3" json:"categories,omitempty"`
	// A collection of Microsoft Knowledge Base article IDs that are associated
	// with the update package.
	KbArticleIds []string `protobuf:"bytes,4,rep,name=kb_article_ids,json=kbArticleIds,proto3" json:"kb_article_ids,omitempty"`
	// A hyperlink to the language-specific support information for the update.
	SupportUrl string `protobuf:"bytes,11,opt,name=support_url,json=supportUrl,proto3" json:"support_url,omitempty"`
	// A collection of URLs that provide more information about the update
	// package.
	MoreInfoUrls []string `protobuf:"bytes,5,rep,name=more_info_urls,json=moreInfoUrls,proto3" json:"more_info_urls,omitempty"`
	// Gets the identifier of an update package.  Stays the same across
	// revisions.
	UpdateId string `protobuf:"bytes,6,opt,name=update_id,json=updateId,proto3" json:"update_id,omitempty"`
	// The revision number of this update package.
	RevisionNumber int32 `protobuf:"varint,7,opt,name=revision_number,json=revisionNumber,proto3" json:"revision_number,omitempty"`
	// The last published date of the update, in (UTC) date and time.
	LastDeploymentChangeTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=last_deployment_change_time,json=lastDeploymentChangeTime,proto3" json:"last_deployment_change_time,omitempty"`
}

func (x *Inventory_WindowsUpdatePackage) Reset() {
	*x = Inventory_WindowsUpdatePackage{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory_WindowsUpdatePackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_WindowsUpdatePackage) ProtoMessage() {}

func (x *Inventory_WindowsUpdatePackage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_WindowsUpdatePackage.ProtoReflect.Descriptor instead.
func (*Inventory_WindowsUpdatePackage) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Inventory_WindowsUpdatePackage) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage) GetCategories() []*Inventory_WindowsUpdatePackage_WindowsUpdateCategory {
	if x != nil {
		return x.Categories
	}
	return nil
}

func (x *Inventory_WindowsUpdatePackage) GetKbArticleIds() []string {
	if x != nil {
		return x.KbArticleIds
	}
	return nil
}

func (x *Inventory_WindowsUpdatePackage) GetSupportUrl() string {
	if x != nil {
		return x.SupportUrl
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage) GetMoreInfoUrls() []string {
	if x != nil {
		return x.MoreInfoUrls
	}
	return nil
}

func (x *Inventory_WindowsUpdatePackage) GetUpdateId() string {
	if x != nil {
		return x.UpdateId
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage) GetRevisionNumber() int32 {
	if x != nil {
		return x.RevisionNumber
	}
	return 0
}

func (x *Inventory_WindowsUpdatePackage) GetLastDeploymentChangeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastDeploymentChangeTime
	}
	return nil
}

// Information related to a Quick Fix Engineering package.
// Fields are taken from Windows QuickFixEngineering Interface and match
// the source names:
// https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-quickfixengineering
type Inventory_WindowsQuickFixEngineeringPackage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A short textual description of the QFE update.
	Caption string `protobuf:"bytes,1,opt,name=caption,proto3" json:"caption,omitempty"`
	// A textual description of the QFE update.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Unique identifier associated with a particular QFE update.
	HotFixId string `protobuf:"bytes,3,opt,name=hot_fix_id,json=hotFixId,proto3" json:"hot_fix_id,omitempty"`
	// Date that the QFE update was installed.  Mapped from installed_on field.
	InstallTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=install_time,json=installTime,proto3" json:"install_time,omitempty"`
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) Reset() {
	*x = Inventory_WindowsQuickFixEngineeringPackage{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_WindowsQuickFixEngineeringPackage) ProtoMessage() {}

func (x *Inventory_WindowsQuickFixEngineeringPackage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_WindowsQuickFixEngineeringPackage.ProtoReflect.Descriptor instead.
func (*Inventory_WindowsQuickFixEngineeringPackage) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) GetCaption() string {
	if x != nil {
		return x.Caption
	}
	return ""
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) GetHotFixId() string {
	if x != nil {
		return x.HotFixId
	}
	return ""
}

func (x *Inventory_WindowsQuickFixEngineeringPackage) GetInstallTime() *timestamppb.Timestamp {
	if x != nil {
		return x.InstallTime
	}
	return nil
}

// Contains information about a Windows application that is retrieved from the
// Windows Registry. For more information about these fields, see:
// https://docs.microsoft.com/en-us/windows/win32/msi/uninstall-registry-key
type Inventory_WindowsApplication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the application or product.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The version of the product or application in string format.
	DisplayVersion string `protobuf:"bytes,2,opt,name=display_version,json=displayVersion,proto3" json:"display_version,omitempty"`
	// The name of the manufacturer for the product or application.
	Publisher string `protobuf:"bytes,3,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// The last time this product received service. The value of this property
	// is replaced each time a patch is applied or removed from the product or
	// the command-line option is used to repair the product.
	InstallDate *date.Date `protobuf:"bytes,4,opt,name=install_date,json=installDate,proto3" json:"install_date,omitempty"`
	// The internet address for technical support.
	HelpLink string `protobuf:"bytes,5,opt,name=help_link,json=helpLink,proto3" json:"help_link,omitempty"`
}

func (x *Inventory_WindowsApplication) Reset() {
	*x = Inventory_WindowsApplication{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory_WindowsApplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_WindowsApplication) ProtoMessage() {}

func (x *Inventory_WindowsApplication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_WindowsApplication.ProtoReflect.Descriptor instead.
func (*Inventory_WindowsApplication) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Inventory_WindowsApplication) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Inventory_WindowsApplication) GetDisplayVersion() string {
	if x != nil {
		return x.DisplayVersion
	}
	return ""
}

func (x *Inventory_WindowsApplication) GetPublisher() string {
	if x != nil {
		return x.Publisher
	}
	return ""
}

func (x *Inventory_WindowsApplication) GetInstallDate() *date.Date {
	if x != nil {
		return x.InstallDate
	}
	return nil
}

func (x *Inventory_WindowsApplication) GetHelpLink() string {
	if x != nil {
		return x.HelpLink
	}
	return ""
}

// Categories specified by the Windows Update.
type Inventory_WindowsUpdatePackage_WindowsUpdateCategory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of the windows update category.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The name of the windows update category.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) Reset() {
	*x = Inventory_WindowsUpdatePackage_WindowsUpdateCategory{}
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Inventory_WindowsUpdatePackage_WindowsUpdateCategory) ProtoMessage() {}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Inventory_WindowsUpdatePackage_WindowsUpdateCategory.ProtoReflect.Descriptor instead.
func (*Inventory_WindowsUpdatePackage_WindowsUpdateCategory) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP(), []int{0, 5, 0}
}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Inventory_WindowsUpdatePackage_WindowsUpdateCategory) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_osconfig_v1alpha_inventory_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_v1alpha_inventory_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xd9, 0x1b, 0x0a, 0x09, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x07, 0x6f, 0x73,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x4f, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x6f, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4e, 0x0a, 0x05, 0x69, 0x74, 0x65,
	0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x79, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xa2, 0x02, 0x0a, 0x06,
	0x4f, 0x73, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x6e, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6b, 0x65, 0x72,
	0x6e, 0x65, 0x6c, 0x52, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x1a, 0x9d, 0x05, 0x0a, 0x04, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x59, 0x0a, 0x0b, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x4f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46,
	0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x49, 0x74, 0x65, 0x6d, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x67, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x53, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x10, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12,
	0x67, 0x0a, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x2e, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x10, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x22, 0x3f, 0x0a, 0x0a, 0x4f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x4f, 0x52, 0x49, 0x47, 0x49, 0x4e,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x4e, 0x56, 0x45, 0x4e, 0x54, 0x4f, 0x52, 0x59,
	0x5f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x01, 0x22, 0x4a, 0x0a, 0x04, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x53, 0x54, 0x41,
	0x4c, 0x4c, 0x45, 0x44, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41, 0x47, 0x45, 0x10, 0x01, 0x12, 0x15,
	0x0a, 0x11, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x50, 0x41, 0x43, 0x4b,
	0x41, 0x47, 0x45, 0x10, 0x02, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x1a, 0x9a, 0x07, 0x0a, 0x0f, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x5c, 0x0a, 0x0b, 0x79, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x79, 0x75, 0x6d, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x12, 0x5c, 0x0a, 0x0b, 0x61, 0x70, 0x74, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x79, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x70, 0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x12, 0x62, 0x0a, 0x0e, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x79, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x62, 0x0a, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x65, 0x74, 0x5f, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x65,
	0x74, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x59, 0x0a, 0x0c, 0x7a, 0x79, 0x70, 0x70,
	0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x48, 0x00, 0x52, 0x0b, 0x7a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x60, 0x0a, 0x0b, 0x77, 0x75, 0x61, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f,
	0x72, 0x79, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x77, 0x75, 0x61, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x6d, 0x0a, 0x0b, 0x71, 0x66, 0x65, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x51, 0x75, 0x69, 0x63,
	0x6b, 0x46, 0x69, 0x78, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x71, 0x66, 0x65, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x5c, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x5f, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x73, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x12, 0x6e, 0x0a, 0x13, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x12,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x73, 0x0a,
	0x10, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x1a, 0x7e, 0x0a, 0x0b, 0x5a, 0x79, 0x70, 0x70, 0x65, 0x72, 0x50, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x74, 0x63, 0x68, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x1a, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x1a, 0x0a, 0x08,
	0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x1a, 0x8e, 0x04, 0x0a, 0x14, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x0a, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x79, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0e, 0x6b, 0x62, 0x5f, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0c, 0x6b, 0x62, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x49, 0x64, 0x73, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x55, 0x72, 0x6c, 0x12,
	0x24, 0x0a, 0x0e, 0x6d, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x75, 0x72, 0x6c,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x6f, 0x72, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x59, 0x0a, 0x1b, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x18, 0x6c, 0x61,
	0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x3b, 0x0a, 0x15, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x1a, 0xbc, 0x01, 0x0a, 0x21, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x51,
	0x75, 0x69, 0x63, 0x6b, 0x46, 0x69, 0x78, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x61, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x61, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x0a, 0x68, 0x6f, 0x74, 0x5f, 0x66, 0x69, 0x78,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x74, 0x46, 0x69,
	0x78, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x54, 0x69,
	0x6d, 0x65, 0x1a, 0xd1, 0x01, 0x0a, 0x12, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x12, 0x34, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x64,
	0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x44, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x65, 0x6c,
	0x70, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x65,
	0x6c, 0x70, 0x4c, 0x69, 0x6e, 0x6b, 0x1a, 0x67, 0x0a, 0x0a, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x43, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x2e,
	0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x21, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x46, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x22,
	0x96, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x56, 0x69,
	0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xef, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8d, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0b, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0b, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a, 0x44, 0x0a, 0x0d, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1e, 0x0a, 0x1a, 0x49,
	0x4e, 0x56, 0x45, 0x4e, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42,
	0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02,
	0x42, 0xd4, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0b, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x50, 0x01, 0x5a, 0x3d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x70, 0x62, 0x3b, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x31, 0x41,
	0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5c, 0x56, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x3a,
	0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescData = file_google_cloud_osconfig_v1alpha_inventory_proto_rawDesc
)

func file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescData)
	})
	return file_google_cloud_osconfig_v1alpha_inventory_proto_rawDescData
}

var file_google_cloud_osconfig_v1alpha_inventory_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_osconfig_v1alpha_inventory_proto_goTypes = []any{
	(InventoryView)(0),                                           // 0: google.cloud.osconfig.v1alpha.InventoryView
	(Inventory_Item_OriginType)(0),                               // 1: google.cloud.osconfig.v1alpha.Inventory.Item.OriginType
	(Inventory_Item_Type)(0),                                     // 2: google.cloud.osconfig.v1alpha.Inventory.Item.Type
	(*Inventory)(nil),                                            // 3: google.cloud.osconfig.v1alpha.Inventory
	(*GetInventoryRequest)(nil),                                  // 4: google.cloud.osconfig.v1alpha.GetInventoryRequest
	(*ListInventoriesRequest)(nil),                               // 5: google.cloud.osconfig.v1alpha.ListInventoriesRequest
	(*ListInventoriesResponse)(nil),                              // 6: google.cloud.osconfig.v1alpha.ListInventoriesResponse
	(*Inventory_OsInfo)(nil),                                     // 7: google.cloud.osconfig.v1alpha.Inventory.OsInfo
	(*Inventory_Item)(nil),                                       // 8: google.cloud.osconfig.v1alpha.Inventory.Item
	(*Inventory_SoftwarePackage)(nil),                            // 9: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage
	(*Inventory_VersionedPackage)(nil),                           // 10: google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
	(*Inventory_ZypperPatch)(nil),                                // 11: google.cloud.osconfig.v1alpha.Inventory.ZypperPatch
	(*Inventory_WindowsUpdatePackage)(nil),                       // 12: google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
	(*Inventory_WindowsQuickFixEngineeringPackage)(nil),          // 13: google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
	(*Inventory_WindowsApplication)(nil),                         // 14: google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
	nil,                                                          // 15: google.cloud.osconfig.v1alpha.Inventory.ItemsEntry
	(*Inventory_WindowsUpdatePackage_WindowsUpdateCategory)(nil), // 16: google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
	(*timestamppb.Timestamp)(nil),                                // 17: google.protobuf.Timestamp
	(*date.Date)(nil),                                            // 18: google.type.Date
}
var file_google_cloud_osconfig_v1alpha_inventory_proto_depIdxs = []int32{
	7,  // 0: google.cloud.osconfig.v1alpha.Inventory.os_info:type_name -> google.cloud.osconfig.v1alpha.Inventory.OsInfo
	15, // 1: google.cloud.osconfig.v1alpha.Inventory.items:type_name -> google.cloud.osconfig.v1alpha.Inventory.ItemsEntry
	17, // 2: google.cloud.osconfig.v1alpha.Inventory.update_time:type_name -> google.protobuf.Timestamp
	0,  // 3: google.cloud.osconfig.v1alpha.GetInventoryRequest.view:type_name -> google.cloud.osconfig.v1alpha.InventoryView
	0,  // 4: google.cloud.osconfig.v1alpha.ListInventoriesRequest.view:type_name -> google.cloud.osconfig.v1alpha.InventoryView
	3,  // 5: google.cloud.osconfig.v1alpha.ListInventoriesResponse.inventories:type_name -> google.cloud.osconfig.v1alpha.Inventory
	1,  // 6: google.cloud.osconfig.v1alpha.Inventory.Item.origin_type:type_name -> google.cloud.osconfig.v1alpha.Inventory.Item.OriginType
	17, // 7: google.cloud.osconfig.v1alpha.Inventory.Item.create_time:type_name -> google.protobuf.Timestamp
	17, // 8: google.cloud.osconfig.v1alpha.Inventory.Item.update_time:type_name -> google.protobuf.Timestamp
	2,  // 9: google.cloud.osconfig.v1alpha.Inventory.Item.type:type_name -> google.cloud.osconfig.v1alpha.Inventory.Item.Type
	9,  // 10: google.cloud.osconfig.v1alpha.Inventory.Item.installed_package:type_name -> google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage
	9,  // 11: google.cloud.osconfig.v1alpha.Inventory.Item.available_package:type_name -> google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage
	10, // 12: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.yum_package:type_name -> google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
	10, // 13: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.apt_package:type_name -> google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
	10, // 14: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.zypper_package:type_name -> google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
	10, // 15: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.googet_package:type_name -> google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
	11, // 16: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.zypper_patch:type_name -> google.cloud.osconfig.v1alpha.Inventory.ZypperPatch
	12, // 17: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.wua_package:type_name -> google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage
	13, // 18: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.qfe_package:type_name -> google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage
	10, // 19: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.cos_package:type_name -> google.cloud.osconfig.v1alpha.Inventory.VersionedPackage
	14, // 20: google.cloud.osconfig.v1alpha.Inventory.SoftwarePackage.windows_application:type_name -> google.cloud.osconfig.v1alpha.Inventory.WindowsApplication
	16, // 21: google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.categories:type_name -> google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.WindowsUpdateCategory
	17, // 22: google.cloud.osconfig.v1alpha.Inventory.WindowsUpdatePackage.last_deployment_change_time:type_name -> google.protobuf.Timestamp
	17, // 23: google.cloud.osconfig.v1alpha.Inventory.WindowsQuickFixEngineeringPackage.install_time:type_name -> google.protobuf.Timestamp
	18, // 24: google.cloud.osconfig.v1alpha.Inventory.WindowsApplication.install_date:type_name -> google.type.Date
	8,  // 25: google.cloud.osconfig.v1alpha.Inventory.ItemsEntry.value:type_name -> google.cloud.osconfig.v1alpha.Inventory.Item
	26, // [26:26] is the sub-list for method output_type
	26, // [26:26] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_v1alpha_inventory_proto_init() }
func file_google_cloud_osconfig_v1alpha_inventory_proto_init() {
	if File_google_cloud_osconfig_v1alpha_inventory_proto != nil {
		return
	}
	file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[5].OneofWrappers = []any{
		(*Inventory_Item_InstalledPackage)(nil),
		(*Inventory_Item_AvailablePackage)(nil),
	}
	file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes[6].OneofWrappers = []any{
		(*Inventory_SoftwarePackage_YumPackage)(nil),
		(*Inventory_SoftwarePackage_AptPackage)(nil),
		(*Inventory_SoftwarePackage_ZypperPackage)(nil),
		(*Inventory_SoftwarePackage_GoogetPackage)(nil),
		(*Inventory_SoftwarePackage_ZypperPatch)(nil),
		(*Inventory_SoftwarePackage_WuaPackage)(nil),
		(*Inventory_SoftwarePackage_QfePackage)(nil),
		(*Inventory_SoftwarePackage_CosPackage)(nil),
		(*Inventory_SoftwarePackage_WindowsApplication)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_v1alpha_inventory_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_v1alpha_inventory_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_v1alpha_inventory_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_v1alpha_inventory_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_v1alpha_inventory_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_v1alpha_inventory_proto = out.File
	file_google_cloud_osconfig_v1alpha_inventory_proto_rawDesc = nil
	file_google_cloud_osconfig_v1alpha_inventory_proto_goTypes = nil
	file_google_cloud_osconfig_v1alpha_inventory_proto_depIdxs = nil
}
