// Copyright 2026 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/kms/v1/hsm_management.proto

package kmspb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The set of states of a
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
type SingleTenantHsmInstance_State int32

const (
	// Not specified.
	SingleTenantHsmInstance_STATE_UNSPECIFIED SingleTenantHsmInstance_State = 0
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] is
	// being created.
	SingleTenantHsmInstance_CREATING SingleTenantHsmInstance_State = 1
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] is
	// waiting for 2FA keys to be registered. This can be done by calling
	// [CreateSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.CreateSingleTenantHsmInstanceProposal]
	// with the [RegisterTwoFactorAuthKeys][] operation.
	SingleTenantHsmInstance_PENDING_TWO_FACTOR_AUTH_REGISTRATION SingleTenantHsmInstance_State = 2
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] is
	// ready to use. A
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// must be in the
	// [ACTIVE][google.cloud.kms.v1.SingleTenantHsmInstance.State.ACTIVE] state
	// for all [CryptoKeys][google.cloud.kms.v1.CryptoKey] created within the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] to
	// be usable.
	SingleTenantHsmInstance_ACTIVE SingleTenantHsmInstance_State = 3
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] is
	// being disabled.
	SingleTenantHsmInstance_DISABLING SingleTenantHsmInstance_State = 4
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] is
	// disabled.
	SingleTenantHsmInstance_DISABLED SingleTenantHsmInstance_State = 5
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] is
	// being deleted. Requests to the instance will be rejected in this state.
	SingleTenantHsmInstance_DELETING SingleTenantHsmInstance_State = 6
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// has been deleted.
	SingleTenantHsmInstance_DELETED SingleTenantHsmInstance_State = 7
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// has failed and can not be recovered or used.
	SingleTenantHsmInstance_FAILED SingleTenantHsmInstance_State = 8
)

// Enum value maps for SingleTenantHsmInstance_State.
var (
	SingleTenantHsmInstance_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "PENDING_TWO_FACTOR_AUTH_REGISTRATION",
		3: "ACTIVE",
		4: "DISABLING",
		5: "DISABLED",
		6: "DELETING",
		7: "DELETED",
		8: "FAILED",
	}
	SingleTenantHsmInstance_State_value = map[string]int32{
		"STATE_UNSPECIFIED":                    0,
		"CREATING":                             1,
		"PENDING_TWO_FACTOR_AUTH_REGISTRATION": 2,
		"ACTIVE":                               3,
		"DISABLING":                            4,
		"DISABLED":                             5,
		"DELETING":                             6,
		"DELETED":                              7,
		"FAILED":                               8,
	}
)

func (x SingleTenantHsmInstance_State) Enum() *SingleTenantHsmInstance_State {
	p := new(SingleTenantHsmInstance_State)
	*p = x
	return p
}

func (x SingleTenantHsmInstance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SingleTenantHsmInstance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_hsm_management_proto_enumTypes[0].Descriptor()
}

func (SingleTenantHsmInstance_State) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_hsm_management_proto_enumTypes[0]
}

func (x SingleTenantHsmInstance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SingleTenantHsmInstance_State.Descriptor instead.
func (SingleTenantHsmInstance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{0, 0}
}

// The set of states of a
// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
type SingleTenantHsmInstanceProposal_State int32

const (
	// Not specified.
	SingleTenantHsmInstanceProposal_STATE_UNSPECIFIED SingleTenantHsmInstanceProposal_State = 0
	// The
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// is being created.
	SingleTenantHsmInstanceProposal_CREATING SingleTenantHsmInstanceProposal_State = 1
	// The
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// is pending approval.
	SingleTenantHsmInstanceProposal_PENDING SingleTenantHsmInstanceProposal_State = 2
	// The
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// has been approved.
	SingleTenantHsmInstanceProposal_APPROVED SingleTenantHsmInstanceProposal_State = 3
	// The
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// is being executed.
	SingleTenantHsmInstanceProposal_RUNNING SingleTenantHsmInstanceProposal_State = 4
	// The
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// has been executed successfully.
	SingleTenantHsmInstanceProposal_SUCCEEDED SingleTenantHsmInstanceProposal_State = 5
	// The
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// has failed.
	SingleTenantHsmInstanceProposal_FAILED SingleTenantHsmInstanceProposal_State = 6
	// The
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// has been deleted and will be purged after the purge_time.
	SingleTenantHsmInstanceProposal_DELETED SingleTenantHsmInstanceProposal_State = 7
)

// Enum value maps for SingleTenantHsmInstanceProposal_State.
var (
	SingleTenantHsmInstanceProposal_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "PENDING",
		3: "APPROVED",
		4: "RUNNING",
		5: "SUCCEEDED",
		6: "FAILED",
		7: "DELETED",
	}
	SingleTenantHsmInstanceProposal_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"PENDING":           2,
		"APPROVED":          3,
		"RUNNING":           4,
		"SUCCEEDED":         5,
		"FAILED":            6,
		"DELETED":           7,
	}
)

func (x SingleTenantHsmInstanceProposal_State) Enum() *SingleTenantHsmInstanceProposal_State {
	p := new(SingleTenantHsmInstanceProposal_State)
	*p = x
	return p
}

func (x SingleTenantHsmInstanceProposal_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SingleTenantHsmInstanceProposal_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_kms_v1_hsm_management_proto_enumTypes[1].Descriptor()
}

func (SingleTenantHsmInstanceProposal_State) Type() protoreflect.EnumType {
	return &file_google_cloud_kms_v1_hsm_management_proto_enumTypes[1]
}

func (x SingleTenantHsmInstanceProposal_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_State.Descriptor instead.
func (SingleTenantHsmInstanceProposal_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 0}
}

// A [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
// represents a single-tenant HSM instance. It can be used for creating
// [CryptoKeys][google.cloud.kms.v1.CryptoKey] with a
// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] of
// [HSM_SINGLE_TENANT][CryptoKeyVersion.ProtectionLevel.HSM_SINGLE_TENANT], as
// well as performing cryptographic operations using keys created within the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
type SingleTenantHsmInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name for this
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] in
	// the format `projects/*/locations/*/singleTenantHsmInstances/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] was
	// created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The state of the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	State SingleTenantHsmInstance_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.kms.v1.SingleTenantHsmInstance_State" json:"state,omitempty"`
	// Required. The quorum auth configuration for the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	QuorumAuth *SingleTenantHsmInstance_QuorumAuth `protobuf:"bytes,4,opt,name=quorum_auth,json=quorumAuth,proto3" json:"quorum_auth,omitempty"`
	// Output only. The time at which the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] was
	// deleted.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. The system-defined duration that an instance can remain
	// unrefreshed until it is automatically disabled. This will have a value of
	// 120 days.
	UnrefreshedDurationUntilDisable *durationpb.Duration `protobuf:"bytes,6,opt,name=unrefreshed_duration_until_disable,json=unrefreshedDurationUntilDisable,proto3" json:"unrefreshed_duration_until_disable,omitempty"`
	// Output only. The time at which the instance will be automatically disabled
	// if not refreshed. This field is updated upon creation and after each
	// successful refresh operation and enable. A
	// [RefreshSingleTenantHsmInstance][] operation must be made via a
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// before this time otherwise the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] will
	// become disabled.
	DisableTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=disable_time,json=disableTime,proto3" json:"disable_time,omitempty"`
}

func (x *SingleTenantHsmInstance) Reset() {
	*x = SingleTenantHsmInstance{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstance) ProtoMessage() {}

func (x *SingleTenantHsmInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstance.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{0}
}

func (x *SingleTenantHsmInstance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SingleTenantHsmInstance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *SingleTenantHsmInstance) GetState() SingleTenantHsmInstance_State {
	if x != nil {
		return x.State
	}
	return SingleTenantHsmInstance_STATE_UNSPECIFIED
}

func (x *SingleTenantHsmInstance) GetQuorumAuth() *SingleTenantHsmInstance_QuorumAuth {
	if x != nil {
		return x.QuorumAuth
	}
	return nil
}

func (x *SingleTenantHsmInstance) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *SingleTenantHsmInstance) GetUnrefreshedDurationUntilDisable() *durationpb.Duration {
	if x != nil {
		return x.UnrefreshedDurationUntilDisable
	}
	return nil
}

func (x *SingleTenantHsmInstance) GetDisableTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DisableTime
	}
	return nil
}

// A
// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
// represents a proposal to perform an operation on a
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
type SingleTenantHsmInstanceProposal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name for this
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] in
	// the format `projects/*/locations/*/singleTenantHsmInstances/*/proposals/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The state of the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	State SingleTenantHsmInstanceProposal_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.kms.v1.SingleTenantHsmInstanceProposal_State" json:"state,omitempty"`
	// Output only. The root cause of the most recent failure. Only present if
	// [state][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.state] is
	// [FAILED][SingleTenantHsmInstanceProposal.FAILED].
	FailureReason string `protobuf:"bytes,4,opt,name=failure_reason,json=failureReason,proto3" json:"failure_reason,omitempty"`
	// The approval parameters for the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	// The type of parameters is determined by the operation being proposed.
	//
	// Types that are assignable to ApprovalParameters:
	//
	//	*SingleTenantHsmInstanceProposal_QuorumParameters_
	//	*SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters_
	ApprovalParameters isSingleTenantHsmInstanceProposal_ApprovalParameters `protobuf_oneof:"approval_parameters"`
	// The expiration of the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	// If not set, the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// will expire in 1 day. The maximum expire time is 7 days. The minimum expire
	// time is 5 minutes.
	//
	// Types that are assignable to Expiration:
	//
	//	*SingleTenantHsmInstanceProposal_ExpireTime
	//	*SingleTenantHsmInstanceProposal_Ttl
	Expiration isSingleTenantHsmInstanceProposal_Expiration `protobuf_oneof:"expiration"`
	// Output only. The time at which the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// was deleted.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,15,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. The time at which the soft-deleted
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// will be permanently purged. This field is only populated
	// when the state is DELETED and will be set a time after expiration of the
	// proposal, i.e. >= expire_time or (create_time + ttl).
	PurgeTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=purge_time,json=purgeTime,proto3" json:"purge_time,omitempty"`
	// The operation to perform on the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	//
	// Types that are assignable to Operation:
	//
	//	*SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys_
	//	*SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance_
	//	*SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance_
	//	*SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance_
	//	*SingleTenantHsmInstanceProposal_AddQuorumMember_
	//	*SingleTenantHsmInstanceProposal_RemoveQuorumMember_
	//	*SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance_
	Operation isSingleTenantHsmInstanceProposal_Operation `protobuf_oneof:"operation"`
}

func (x *SingleTenantHsmInstanceProposal) Reset() {
	*x = SingleTenantHsmInstanceProposal{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1}
}

func (x *SingleTenantHsmInstanceProposal) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SingleTenantHsmInstanceProposal) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetState() SingleTenantHsmInstanceProposal_State {
	if x != nil {
		return x.State
	}
	return SingleTenantHsmInstanceProposal_STATE_UNSPECIFIED
}

func (x *SingleTenantHsmInstanceProposal) GetFailureReason() string {
	if x != nil {
		return x.FailureReason
	}
	return ""
}

func (m *SingleTenantHsmInstanceProposal) GetApprovalParameters() isSingleTenantHsmInstanceProposal_ApprovalParameters {
	if m != nil {
		return m.ApprovalParameters
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetQuorumParameters() *SingleTenantHsmInstanceProposal_QuorumParameters {
	if x, ok := x.GetApprovalParameters().(*SingleTenantHsmInstanceProposal_QuorumParameters_); ok {
		return x.QuorumParameters
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetRequiredActionQuorumParameters() *SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters {
	if x, ok := x.GetApprovalParameters().(*SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters_); ok {
		return x.RequiredActionQuorumParameters
	}
	return nil
}

func (m *SingleTenantHsmInstanceProposal) GetExpiration() isSingleTenantHsmInstanceProposal_Expiration {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetExpireTime() *timestamppb.Timestamp {
	if x, ok := x.GetExpiration().(*SingleTenantHsmInstanceProposal_ExpireTime); ok {
		return x.ExpireTime
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetTtl() *durationpb.Duration {
	if x, ok := x.GetExpiration().(*SingleTenantHsmInstanceProposal_Ttl); ok {
		return x.Ttl
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetPurgeTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PurgeTime
	}
	return nil
}

func (m *SingleTenantHsmInstanceProposal) GetOperation() isSingleTenantHsmInstanceProposal_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetRegisterTwoFactorAuthKeys() *SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys {
	if x, ok := x.GetOperation().(*SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys_); ok {
		return x.RegisterTwoFactorAuthKeys
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetDisableSingleTenantHsmInstance() *SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance {
	if x, ok := x.GetOperation().(*SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance_); ok {
		return x.DisableSingleTenantHsmInstance
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetEnableSingleTenantHsmInstance() *SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance {
	if x, ok := x.GetOperation().(*SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance_); ok {
		return x.EnableSingleTenantHsmInstance
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetDeleteSingleTenantHsmInstance() *SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance {
	if x, ok := x.GetOperation().(*SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance_); ok {
		return x.DeleteSingleTenantHsmInstance
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetAddQuorumMember() *SingleTenantHsmInstanceProposal_AddQuorumMember {
	if x, ok := x.GetOperation().(*SingleTenantHsmInstanceProposal_AddQuorumMember_); ok {
		return x.AddQuorumMember
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetRemoveQuorumMember() *SingleTenantHsmInstanceProposal_RemoveQuorumMember {
	if x, ok := x.GetOperation().(*SingleTenantHsmInstanceProposal_RemoveQuorumMember_); ok {
		return x.RemoveQuorumMember
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal) GetRefreshSingleTenantHsmInstance() *SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance {
	if x, ok := x.GetOperation().(*SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance_); ok {
		return x.RefreshSingleTenantHsmInstance
	}
	return nil
}

type isSingleTenantHsmInstanceProposal_ApprovalParameters interface {
	isSingleTenantHsmInstanceProposal_ApprovalParameters()
}

type SingleTenantHsmInstanceProposal_QuorumParameters_ struct {
	// Output only. The quorum approval parameters for the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	QuorumParameters *SingleTenantHsmInstanceProposal_QuorumParameters `protobuf:"bytes,5,opt,name=quorum_parameters,json=quorumParameters,proto3,oneof"`
}

type SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters_ struct {
	// Output only. Parameters for an approval of a
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// that has both required challenges and a quorum.
	RequiredActionQuorumParameters *SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters `protobuf:"bytes,14,opt,name=required_action_quorum_parameters,json=requiredActionQuorumParameters,proto3,oneof"`
}

func (*SingleTenantHsmInstanceProposal_QuorumParameters_) isSingleTenantHsmInstanceProposal_ApprovalParameters() {
}

func (*SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters_) isSingleTenantHsmInstanceProposal_ApprovalParameters() {
}

type isSingleTenantHsmInstanceProposal_Expiration interface {
	isSingleTenantHsmInstanceProposal_Expiration()
}

type SingleTenantHsmInstanceProposal_ExpireTime struct {
	// The time at which the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// will expire if not approved and executed.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=expire_time,json=expireTime,proto3,oneof"`
}

type SingleTenantHsmInstanceProposal_Ttl struct {
	// Input only. The TTL for the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	// Proposals will expire after this duration.
	Ttl *durationpb.Duration `protobuf:"bytes,7,opt,name=ttl,proto3,oneof"`
}

func (*SingleTenantHsmInstanceProposal_ExpireTime) isSingleTenantHsmInstanceProposal_Expiration() {}

func (*SingleTenantHsmInstanceProposal_Ttl) isSingleTenantHsmInstanceProposal_Expiration() {}

type isSingleTenantHsmInstanceProposal_Operation interface {
	isSingleTenantHsmInstanceProposal_Operation()
}

type SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys_ struct {
	// Register 2FA keys for the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	// This operation requires all N Challenges to be signed by 2FA keys. The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// must be in the
	// [PENDING_TWO_FACTOR_AUTH_REGISTRATION][google.cloud.kms.v1.SingleTenantHsmInstance.State.PENDING_TWO_FACTOR_AUTH_REGISTRATION]
	// state to perform this operation.
	RegisterTwoFactorAuthKeys *SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys `protobuf:"bytes,8,opt,name=register_two_factor_auth_keys,json=registerTwoFactorAuthKeys,proto3,oneof"`
}

type SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance_ struct {
	// Disable the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// must be in the
	// [ACTIVE][google.cloud.kms.v1.SingleTenantHsmInstance.State.ACTIVE] state
	// to perform this operation.
	DisableSingleTenantHsmInstance *SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance `protobuf:"bytes,9,opt,name=disable_single_tenant_hsm_instance,json=disableSingleTenantHsmInstance,proto3,oneof"`
}

type SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance_ struct {
	// Enable the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	// The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// must be in the
	// [DISABLED][google.cloud.kms.v1.SingleTenantHsmInstance.State.DISABLED]
	// state to perform this operation.
	EnableSingleTenantHsmInstance *SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance `protobuf:"bytes,10,opt,name=enable_single_tenant_hsm_instance,json=enableSingleTenantHsmInstance,proto3,oneof"`
}

type SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance_ struct {
	// Delete the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	// Deleting a
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// will make all [CryptoKeys][google.cloud.kms.v1.CryptoKey] attached to the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// unusable. The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// must be in the
	// [DISABLED][google.cloud.kms.v1.SingleTenantHsmInstance.State.DISABLED] or
	// [PENDING_TWO_FACTOR_AUTH_REGISTRATION][google.cloud.kms.v1.SingleTenantHsmInstance.State.PENDING_TWO_FACTOR_AUTH_REGISTRATION]
	// state to perform this operation.
	DeleteSingleTenantHsmInstance *SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance `protobuf:"bytes,11,opt,name=delete_single_tenant_hsm_instance,json=deleteSingleTenantHsmInstance,proto3,oneof"`
}

type SingleTenantHsmInstanceProposal_AddQuorumMember_ struct {
	// Add a quorum member to the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	// This will increase the
	// [total_approver_count][google.cloud.kms.v1.SingleTenantHsmInstance.QuorumAuth.total_approver_count]
	// by 1. The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// must be in the
	// [ACTIVE][google.cloud.kms.v1.SingleTenantHsmInstance.State.ACTIVE] state
	// to perform this operation.
	AddQuorumMember *SingleTenantHsmInstanceProposal_AddQuorumMember `protobuf:"bytes,12,opt,name=add_quorum_member,json=addQuorumMember,proto3,oneof"`
}

type SingleTenantHsmInstanceProposal_RemoveQuorumMember_ struct {
	// Remove a quorum member from the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	// This will reduce
	// [total_approver_count][google.cloud.kms.v1.SingleTenantHsmInstance.QuorumAuth.total_approver_count]
	// by 1. The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// must be in the
	// [ACTIVE][google.cloud.kms.v1.SingleTenantHsmInstance.State.ACTIVE] state
	// to perform this operation.
	RemoveQuorumMember *SingleTenantHsmInstanceProposal_RemoveQuorumMember `protobuf:"bytes,13,opt,name=remove_quorum_member,json=removeQuorumMember,proto3,oneof"`
}

type SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance_ struct {
	// Refreshes the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	// This operation must be performed periodically to keep the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// active. This operation must be performed before
	// [unrefreshed_duration_until_disable][google.cloud.kms.v1.SingleTenantHsmInstance.unrefreshed_duration_until_disable]
	// has passed. The
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// must be in the
	// [ACTIVE][google.cloud.kms.v1.SingleTenantHsmInstance.State.ACTIVE] state
	// to perform this operation.
	RefreshSingleTenantHsmInstance *SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance `protobuf:"bytes,17,opt,name=refresh_single_tenant_hsm_instance,json=refreshSingleTenantHsmInstance,proto3,oneof"`
}

func (*SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys_) isSingleTenantHsmInstanceProposal_Operation() {
}

func (*SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance_) isSingleTenantHsmInstanceProposal_Operation() {
}

func (*SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance_) isSingleTenantHsmInstanceProposal_Operation() {
}

func (*SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance_) isSingleTenantHsmInstanceProposal_Operation() {
}

func (*SingleTenantHsmInstanceProposal_AddQuorumMember_) isSingleTenantHsmInstanceProposal_Operation() {
}

func (*SingleTenantHsmInstanceProposal_RemoveQuorumMember_) isSingleTenantHsmInstanceProposal_Operation() {
}

func (*SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance_) isSingleTenantHsmInstanceProposal_Operation() {
}

// A challenge to be signed by a 2FA key.
type Challenge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The challenge to be signed by the 2FA key indicated by the
	// public key.
	Challenge []byte `protobuf:"bytes,1,opt,name=challenge,proto3" json:"challenge,omitempty"`
	// Output only. The public key associated with the 2FA key that should sign
	// the challenge.
	PublicKeyPem string `protobuf:"bytes,2,opt,name=public_key_pem,json=publicKeyPem,proto3" json:"public_key_pem,omitempty"`
}

func (x *Challenge) Reset() {
	*x = Challenge{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Challenge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Challenge) ProtoMessage() {}

func (x *Challenge) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Challenge.ProtoReflect.Descriptor instead.
func (*Challenge) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{2}
}

func (x *Challenge) GetChallenge() []byte {
	if x != nil {
		return x.Challenge
	}
	return nil
}

func (x *Challenge) GetPublicKeyPem() string {
	if x != nil {
		return x.PublicKeyPem
	}
	return ""
}

// A reply to a challenge signed by a 2FA key.
type ChallengeReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The signed challenge associated with the 2FA key.
	// The signature must be RSASSA-PKCS1 v1.5 with a SHA256 digest.
	SignedChallenge []byte `protobuf:"bytes,1,opt,name=signed_challenge,json=signedChallenge,proto3" json:"signed_challenge,omitempty"`
	// Required. The public key associated with the 2FA key.
	PublicKeyPem string `protobuf:"bytes,2,opt,name=public_key_pem,json=publicKeyPem,proto3" json:"public_key_pem,omitempty"`
}

func (x *ChallengeReply) Reset() {
	*x = ChallengeReply{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChallengeReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChallengeReply) ProtoMessage() {}

func (x *ChallengeReply) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChallengeReply.ProtoReflect.Descriptor instead.
func (*ChallengeReply) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{3}
}

func (x *ChallengeReply) GetSignedChallenge() []byte {
	if x != nil {
		return x.SignedChallenge
	}
	return nil
}

func (x *ChallengeReply) GetPublicKeyPem() string {
	if x != nil {
		return x.PublicKeyPem
	}
	return ""
}

// Request message for
// [HsmManagement.ListSingleTenantHsmInstances][google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstances].
type ListSingleTenantHsmInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location associated with the
	// [SingleTenantHsmInstances][google.cloud.kms.v1.SingleTenantHsmInstance] to
	// list, in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Optional limit on the number of
	// [SingleTenantHsmInstances][google.cloud.kms.v1.SingleTenantHsmInstance] to
	// include in the response. Further
	// [SingleTenantHsmInstances][google.cloud.kms.v1.SingleTenantHsmInstance] can
	// subsequently be
	// obtained by including the
	// [ListSingleTenantHsmInstancesResponse.next_page_token][google.cloud.kms.v1.ListSingleTenantHsmInstancesResponse.next_page_token]
	// in a subsequent request. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Optional pagination token, returned earlier via
	// [ListSingleTenantHsmInstancesResponse.next_page_token][google.cloud.kms.v1.ListSingleTenantHsmInstancesResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Only include resources that match the filter in the response. For
	// more information, see
	// [Sorting and filtering list
	// results](https://cloud.google.com/kms/docs/sorting-and-filtering).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify how the results should be sorted. If not specified, the
	// results will be sorted in the default order.  For more information, see
	// [Sorting and filtering list
	// results](https://cloud.google.com/kms/docs/sorting-and-filtering).
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. If set to true,
	// [HsmManagement.ListSingleTenantHsmInstances][google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstances]
	// will also return
	// [SingleTenantHsmInstances][google.cloud.kms.v1.SingleTenantHsmInstance] in
	// DELETED state.
	ShowDeleted bool `protobuf:"varint,6,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListSingleTenantHsmInstancesRequest) Reset() {
	*x = ListSingleTenantHsmInstancesRequest{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSingleTenantHsmInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSingleTenantHsmInstancesRequest) ProtoMessage() {}

func (x *ListSingleTenantHsmInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSingleTenantHsmInstancesRequest.ProtoReflect.Descriptor instead.
func (*ListSingleTenantHsmInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{4}
}

func (x *ListSingleTenantHsmInstancesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSingleTenantHsmInstancesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSingleTenantHsmInstancesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSingleTenantHsmInstancesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSingleTenantHsmInstancesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListSingleTenantHsmInstancesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for
// [HsmManagement.ListSingleTenantHsmInstances][google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstances].
type ListSingleTenantHsmInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of
	// [SingleTenantHsmInstances][google.cloud.kms.v1.SingleTenantHsmInstance].
	SingleTenantHsmInstances []*SingleTenantHsmInstance `protobuf:"bytes,1,rep,name=single_tenant_hsm_instances,json=singleTenantHsmInstances,proto3" json:"single_tenant_hsm_instances,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListSingleTenantHsmInstancesRequest.page_token][google.cloud.kms.v1.ListSingleTenantHsmInstancesRequest.page_token]
	// to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of
	// [SingleTenantHsmInstances][google.cloud.kms.v1.SingleTenantHsmInstance]
	// that matched the query.
	//
	// This field is not populated if
	// [ListSingleTenantHsmInstancesRequest.filter][google.cloud.kms.v1.ListSingleTenantHsmInstancesRequest.filter]
	// is applied.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListSingleTenantHsmInstancesResponse) Reset() {
	*x = ListSingleTenantHsmInstancesResponse{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSingleTenantHsmInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSingleTenantHsmInstancesResponse) ProtoMessage() {}

func (x *ListSingleTenantHsmInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSingleTenantHsmInstancesResponse.ProtoReflect.Descriptor instead.
func (*ListSingleTenantHsmInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{5}
}

func (x *ListSingleTenantHsmInstancesResponse) GetSingleTenantHsmInstances() []*SingleTenantHsmInstance {
	if x != nil {
		return x.SingleTenantHsmInstances
	}
	return nil
}

func (x *ListSingleTenantHsmInstancesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSingleTenantHsmInstancesResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for
// [HsmManagement.GetSingleTenantHsmInstance][google.cloud.kms.v1.HsmManagement.GetSingleTenantHsmInstance].
type GetSingleTenantHsmInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [name][google.cloud.kms.v1.SingleTenantHsmInstance.name] of
	// the [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSingleTenantHsmInstanceRequest) Reset() {
	*x = GetSingleTenantHsmInstanceRequest{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSingleTenantHsmInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSingleTenantHsmInstanceRequest) ProtoMessage() {}

func (x *GetSingleTenantHsmInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSingleTenantHsmInstanceRequest.ProtoReflect.Descriptor instead.
func (*GetSingleTenantHsmInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{6}
}

func (x *GetSingleTenantHsmInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [HsmManagement.CreateSingleTenantHsmInstance][google.cloud.kms.v1.HsmManagement.CreateSingleTenantHsmInstance].
type CreateSingleTenantHsmInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location associated with the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance], in
	// the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. It must be unique within a location and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`.
	SingleTenantHsmInstanceId string `protobuf:"bytes,2,opt,name=single_tenant_hsm_instance_id,json=singleTenantHsmInstanceId,proto3" json:"single_tenant_hsm_instance_id,omitempty"`
	// Required. An
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] with
	// initial field values.
	SingleTenantHsmInstance *SingleTenantHsmInstance `protobuf:"bytes,3,opt,name=single_tenant_hsm_instance,json=singleTenantHsmInstance,proto3" json:"single_tenant_hsm_instance,omitempty"`
}

func (x *CreateSingleTenantHsmInstanceRequest) Reset() {
	*x = CreateSingleTenantHsmInstanceRequest{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSingleTenantHsmInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSingleTenantHsmInstanceRequest) ProtoMessage() {}

func (x *CreateSingleTenantHsmInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSingleTenantHsmInstanceRequest.ProtoReflect.Descriptor instead.
func (*CreateSingleTenantHsmInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{7}
}

func (x *CreateSingleTenantHsmInstanceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSingleTenantHsmInstanceRequest) GetSingleTenantHsmInstanceId() string {
	if x != nil {
		return x.SingleTenantHsmInstanceId
	}
	return ""
}

func (x *CreateSingleTenantHsmInstanceRequest) GetSingleTenantHsmInstance() *SingleTenantHsmInstance {
	if x != nil {
		return x.SingleTenantHsmInstance
	}
	return nil
}

// Metadata message for
// [CreateSingleTenantHsmInstance][google.cloud.kms.v1.HsmManagement.CreateSingleTenantHsmInstance]
// long-running operation response.
type CreateSingleTenantHsmInstanceMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateSingleTenantHsmInstanceMetadata) Reset() {
	*x = CreateSingleTenantHsmInstanceMetadata{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSingleTenantHsmInstanceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSingleTenantHsmInstanceMetadata) ProtoMessage() {}

func (x *CreateSingleTenantHsmInstanceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSingleTenantHsmInstanceMetadata.ProtoReflect.Descriptor instead.
func (*CreateSingleTenantHsmInstanceMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{8}
}

// Request message for
// [HsmManagement.CreateSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.CreateSingleTenantHsmInstanceProposal].
type CreateSingleTenantHsmInstanceProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [name][google.cloud.kms.v1.SingleTenantHsmInstance.name] of
	// the [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
	// associated with the
	// [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. It must be unique within a location and match the regular
	// expression `[a-zA-Z0-9_-]{1,63}`.
	SingleTenantHsmInstanceProposalId string `protobuf:"bytes,2,opt,name=single_tenant_hsm_instance_proposal_id,json=singleTenantHsmInstanceProposalId,proto3" json:"single_tenant_hsm_instance_proposal_id,omitempty"`
	// Required. The
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// to create.
	SingleTenantHsmInstanceProposal *SingleTenantHsmInstanceProposal `protobuf:"bytes,3,opt,name=single_tenant_hsm_instance_proposal,json=singleTenantHsmInstanceProposal,proto3" json:"single_tenant_hsm_instance_proposal,omitempty"`
}

func (x *CreateSingleTenantHsmInstanceProposalRequest) Reset() {
	*x = CreateSingleTenantHsmInstanceProposalRequest{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSingleTenantHsmInstanceProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSingleTenantHsmInstanceProposalRequest) ProtoMessage() {}

func (x *CreateSingleTenantHsmInstanceProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSingleTenantHsmInstanceProposalRequest.ProtoReflect.Descriptor instead.
func (*CreateSingleTenantHsmInstanceProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{9}
}

func (x *CreateSingleTenantHsmInstanceProposalRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSingleTenantHsmInstanceProposalRequest) GetSingleTenantHsmInstanceProposalId() string {
	if x != nil {
		return x.SingleTenantHsmInstanceProposalId
	}
	return ""
}

func (x *CreateSingleTenantHsmInstanceProposalRequest) GetSingleTenantHsmInstanceProposal() *SingleTenantHsmInstanceProposal {
	if x != nil {
		return x.SingleTenantHsmInstanceProposal
	}
	return nil
}

// Metadata message for
// [CreateSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.CreateSingleTenantHsmInstanceProposal]
// long-running operation response.
type CreateSingleTenantHsmInstanceProposalMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateSingleTenantHsmInstanceProposalMetadata) Reset() {
	*x = CreateSingleTenantHsmInstanceProposalMetadata{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSingleTenantHsmInstanceProposalMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSingleTenantHsmInstanceProposalMetadata) ProtoMessage() {}

func (x *CreateSingleTenantHsmInstanceProposalMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSingleTenantHsmInstanceProposalMetadata.ProtoReflect.Descriptor instead.
func (*CreateSingleTenantHsmInstanceProposalMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{10}
}

// Request message for
// [HsmManagement.GetSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.GetSingleTenantHsmInstanceProposal].
type GetSingleTenantHsmInstanceProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The
	// [name][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.name] of the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSingleTenantHsmInstanceProposalRequest) Reset() {
	*x = GetSingleTenantHsmInstanceProposalRequest{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSingleTenantHsmInstanceProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSingleTenantHsmInstanceProposalRequest) ProtoMessage() {}

func (x *GetSingleTenantHsmInstanceProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSingleTenantHsmInstanceProposalRequest.ProtoReflect.Descriptor instead.
func (*GetSingleTenantHsmInstanceProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{11}
}

func (x *GetSingleTenantHsmInstanceProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [HsmManagement.ApproveSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.ApproveSingleTenantHsmInstanceProposal].
type ApproveSingleTenantHsmInstanceProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The
	// [name][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.name] of the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// to approve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The approval payload. The type of approval payload must correspond to the
	// type of approval_parameters in the proposal.
	//
	// Types that are assignable to ApprovalPayload:
	//
	//	*ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply_
	//	*ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply_
	ApprovalPayload isApproveSingleTenantHsmInstanceProposalRequest_ApprovalPayload `protobuf_oneof:"approval_payload"`
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest) Reset() {
	*x = ApproveSingleTenantHsmInstanceProposalRequest{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveSingleTenantHsmInstanceProposalRequest) ProtoMessage() {}

func (x *ApproveSingleTenantHsmInstanceProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveSingleTenantHsmInstanceProposalRequest.ProtoReflect.Descriptor instead.
func (*ApproveSingleTenantHsmInstanceProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{12}
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *ApproveSingleTenantHsmInstanceProposalRequest) GetApprovalPayload() isApproveSingleTenantHsmInstanceProposalRequest_ApprovalPayload {
	if m != nil {
		return m.ApprovalPayload
	}
	return nil
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest) GetQuorumReply() *ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply {
	if x, ok := x.GetApprovalPayload().(*ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply_); ok {
		return x.QuorumReply
	}
	return nil
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest) GetRequiredActionQuorumReply() *ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply {
	if x, ok := x.GetApprovalPayload().(*ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply_); ok {
		return x.RequiredActionQuorumReply
	}
	return nil
}

type isApproveSingleTenantHsmInstanceProposalRequest_ApprovalPayload interface {
	isApproveSingleTenantHsmInstanceProposalRequest_ApprovalPayload()
}

type ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply_ struct {
	// Required. The reply to
	// [QuorumParameters][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.QuorumParameters]
	// for approving the proposal.
	QuorumReply *ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply `protobuf:"bytes,2,opt,name=quorum_reply,json=quorumReply,proto3,oneof"`
}

type ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply_ struct {
	// Required. The reply to
	// [RequiredActionQuorumParameters][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RequiredActionQuorumParameters]
	// for approving the proposal.
	RequiredActionQuorumReply *ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply `protobuf:"bytes,3,opt,name=required_action_quorum_reply,json=requiredActionQuorumReply,proto3,oneof"`
}

func (*ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply_) isApproveSingleTenantHsmInstanceProposalRequest_ApprovalPayload() {
}

func (*ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply_) isApproveSingleTenantHsmInstanceProposalRequest_ApprovalPayload() {
}

// Response message for
// [HsmManagement.ApproveSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.ApproveSingleTenantHsmInstanceProposal].
type ApproveSingleTenantHsmInstanceProposalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ApproveSingleTenantHsmInstanceProposalResponse) Reset() {
	*x = ApproveSingleTenantHsmInstanceProposalResponse{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApproveSingleTenantHsmInstanceProposalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveSingleTenantHsmInstanceProposalResponse) ProtoMessage() {}

func (x *ApproveSingleTenantHsmInstanceProposalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveSingleTenantHsmInstanceProposalResponse.ProtoReflect.Descriptor instead.
func (*ApproveSingleTenantHsmInstanceProposalResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{13}
}

// Request message for
// [HsmManagement.ExecuteSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.ExecuteSingleTenantHsmInstanceProposal].
type ExecuteSingleTenantHsmInstanceProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The
	// [name][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.name] of the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// to execute.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ExecuteSingleTenantHsmInstanceProposalRequest) Reset() {
	*x = ExecuteSingleTenantHsmInstanceProposalRequest{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecuteSingleTenantHsmInstanceProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteSingleTenantHsmInstanceProposalRequest) ProtoMessage() {}

func (x *ExecuteSingleTenantHsmInstanceProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteSingleTenantHsmInstanceProposalRequest.ProtoReflect.Descriptor instead.
func (*ExecuteSingleTenantHsmInstanceProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{14}
}

func (x *ExecuteSingleTenantHsmInstanceProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for
// [HsmManagement.ExecuteSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.ExecuteSingleTenantHsmInstanceProposal].
type ExecuteSingleTenantHsmInstanceProposalResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExecuteSingleTenantHsmInstanceProposalResponse) Reset() {
	*x = ExecuteSingleTenantHsmInstanceProposalResponse{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecuteSingleTenantHsmInstanceProposalResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteSingleTenantHsmInstanceProposalResponse) ProtoMessage() {}

func (x *ExecuteSingleTenantHsmInstanceProposalResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteSingleTenantHsmInstanceProposalResponse.ProtoReflect.Descriptor instead.
func (*ExecuteSingleTenantHsmInstanceProposalResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{15}
}

// Metadata message for
// [ExecuteSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.ExecuteSingleTenantHsmInstanceProposal]
// long-running operation response.
type ExecuteSingleTenantHsmInstanceProposalMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExecuteSingleTenantHsmInstanceProposalMetadata) Reset() {
	*x = ExecuteSingleTenantHsmInstanceProposalMetadata{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecuteSingleTenantHsmInstanceProposalMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteSingleTenantHsmInstanceProposalMetadata) ProtoMessage() {}

func (x *ExecuteSingleTenantHsmInstanceProposalMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteSingleTenantHsmInstanceProposalMetadata.ProtoReflect.Descriptor instead.
func (*ExecuteSingleTenantHsmInstanceProposalMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{16}
}

// Request message for
// [HsmManagement.ListSingleTenantHsmInstanceProposals][google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstanceProposals].
type ListSingleTenantHsmInstanceProposalsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the single tenant HSM instance associated
	// with the
	// [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// to list, in the format `projects/*/locations/*/singleTenantHsmInstances/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Optional limit on the number of
	// [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// to include in the response. Further
	// [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// can subsequently be obtained by including the
	// [ListSingleTenantHsmInstanceProposalsResponse.next_page_token][google.cloud.kms.v1.ListSingleTenantHsmInstanceProposalsResponse.next_page_token]
	// in a subsequent request. If unspecified, the server will pick an
	// appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Optional pagination token, returned earlier via
	// [ListSingleTenantHsmInstanceProposalsResponse.next_page_token][google.cloud.kms.v1.ListSingleTenantHsmInstanceProposalsResponse.next_page_token].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Only include resources that match the filter in the response. For
	// more information, see
	// [Sorting and filtering list
	// results](https://cloud.google.com/kms/docs/sorting-and-filtering).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specify how the results should be sorted. If not specified, the
	// results will be sorted in the default order.  For more information, see
	// [Sorting and filtering list
	// results](https://cloud.google.com/kms/docs/sorting-and-filtering).
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. If set to true,
	// [HsmManagement.ListSingleTenantHsmInstanceProposals][google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstanceProposals]
	// will also return
	// [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// in DELETED state.
	ShowDeleted bool `protobuf:"varint,6,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListSingleTenantHsmInstanceProposalsRequest) Reset() {
	*x = ListSingleTenantHsmInstanceProposalsRequest{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSingleTenantHsmInstanceProposalsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSingleTenantHsmInstanceProposalsRequest) ProtoMessage() {}

func (x *ListSingleTenantHsmInstanceProposalsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSingleTenantHsmInstanceProposalsRequest.ProtoReflect.Descriptor instead.
func (*ListSingleTenantHsmInstanceProposalsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{17}
}

func (x *ListSingleTenantHsmInstanceProposalsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSingleTenantHsmInstanceProposalsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSingleTenantHsmInstanceProposalsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSingleTenantHsmInstanceProposalsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSingleTenantHsmInstanceProposalsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListSingleTenantHsmInstanceProposalsRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for
// [HsmManagement.ListSingleTenantHsmInstanceProposals][google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstanceProposals].
type ListSingleTenantHsmInstanceProposalsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of
	// [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
	SingleTenantHsmInstanceProposals []*SingleTenantHsmInstanceProposal `protobuf:"bytes,1,rep,name=single_tenant_hsm_instance_proposals,json=singleTenantHsmInstanceProposals,proto3" json:"single_tenant_hsm_instance_proposals,omitempty"`
	// A token to retrieve next page of results. Pass this value in
	// [ListSingleTenantHsmInstanceProposalsRequest.page_token][google.cloud.kms.v1.ListSingleTenantHsmInstanceProposalsRequest.page_token]
	// to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of
	// [SingleTenantHsmInstanceProposals][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// that matched the query.
	//
	// This field is not populated if
	// [ListSingleTenantHsmInstanceProposalsRequest.filter][google.cloud.kms.v1.ListSingleTenantHsmInstanceProposalsRequest.filter]
	// is applied.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
}

func (x *ListSingleTenantHsmInstanceProposalsResponse) Reset() {
	*x = ListSingleTenantHsmInstanceProposalsResponse{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSingleTenantHsmInstanceProposalsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSingleTenantHsmInstanceProposalsResponse) ProtoMessage() {}

func (x *ListSingleTenantHsmInstanceProposalsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSingleTenantHsmInstanceProposalsResponse.ProtoReflect.Descriptor instead.
func (*ListSingleTenantHsmInstanceProposalsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{18}
}

func (x *ListSingleTenantHsmInstanceProposalsResponse) GetSingleTenantHsmInstanceProposals() []*SingleTenantHsmInstanceProposal {
	if x != nil {
		return x.SingleTenantHsmInstanceProposals
	}
	return nil
}

func (x *ListSingleTenantHsmInstanceProposalsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSingleTenantHsmInstanceProposalsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

// Request message for
// [HsmManagement.DeleteSingleTenantHsmInstanceProposal][google.cloud.kms.v1.HsmManagement.DeleteSingleTenantHsmInstanceProposal].
type DeleteSingleTenantHsmInstanceProposalRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The
	// [name][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.name] of the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSingleTenantHsmInstanceProposalRequest) Reset() {
	*x = DeleteSingleTenantHsmInstanceProposalRequest{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSingleTenantHsmInstanceProposalRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSingleTenantHsmInstanceProposalRequest) ProtoMessage() {}

func (x *DeleteSingleTenantHsmInstanceProposalRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSingleTenantHsmInstanceProposalRequest.ProtoReflect.Descriptor instead.
func (*DeleteSingleTenantHsmInstanceProposalRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteSingleTenantHsmInstanceProposalRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Configuration for M of N quorum auth.
type SingleTenantHsmInstance_QuorumAuth struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The total number of approvers. This is the N value used
	// for M of N quorum auth. Must be greater than or equal to 3 and less than
	// or equal to 16.
	TotalApproverCount int32 `protobuf:"varint,1,opt,name=total_approver_count,json=totalApproverCount,proto3" json:"total_approver_count,omitempty"`
	// Output only. The required numbers of approvers. The M value used for M of
	// N quorum auth. Must be greater than or equal to 2 and less than or equal
	// to
	// [total_approver_count][google.cloud.kms.v1.SingleTenantHsmInstance.QuorumAuth.total_approver_count]
	// - 1.
	RequiredApproverCount int32 `protobuf:"varint,2,opt,name=required_approver_count,json=requiredApproverCount,proto3" json:"required_approver_count,omitempty"`
	// Output only. The public keys associated with the 2FA keys for M of N
	// quorum auth.
	TwoFactorPublicKeyPems []string `protobuf:"bytes,3,rep,name=two_factor_public_key_pems,json=twoFactorPublicKeyPems,proto3" json:"two_factor_public_key_pems,omitempty"`
}

func (x *SingleTenantHsmInstance_QuorumAuth) Reset() {
	*x = SingleTenantHsmInstance_QuorumAuth{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstance_QuorumAuth) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstance_QuorumAuth) ProtoMessage() {}

func (x *SingleTenantHsmInstance_QuorumAuth) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstance_QuorumAuth.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstance_QuorumAuth) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SingleTenantHsmInstance_QuorumAuth) GetTotalApproverCount() int32 {
	if x != nil {
		return x.TotalApproverCount
	}
	return 0
}

func (x *SingleTenantHsmInstance_QuorumAuth) GetRequiredApproverCount() int32 {
	if x != nil {
		return x.RequiredApproverCount
	}
	return 0
}

func (x *SingleTenantHsmInstance_QuorumAuth) GetTwoFactorPublicKeyPems() []string {
	if x != nil {
		return x.TwoFactorPublicKeyPems
	}
	return nil
}

// Parameters of quorum approval for the
// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal].
type SingleTenantHsmInstanceProposal_QuorumParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The required numbers of approvers. This is the M value used
	// for M of N quorum auth. It is less than the number of public keys.
	RequiredApproverCount int32 `protobuf:"varint,1,opt,name=required_approver_count,json=requiredApproverCount,proto3" json:"required_approver_count,omitempty"`
	// Output only. The challenges to be signed by 2FA keys for quorum auth. M
	// of N of these challenges are required to be signed to approve the
	// operation.
	Challenges []*Challenge `protobuf:"bytes,2,rep,name=challenges,proto3" json:"challenges,omitempty"`
	// Output only. The public keys associated with the 2FA keys that have
	// already approved the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// by signing the challenge.
	ApprovedTwoFactorPublicKeyPems []string `protobuf:"bytes,3,rep,name=approved_two_factor_public_key_pems,json=approvedTwoFactorPublicKeyPems,proto3" json:"approved_two_factor_public_key_pems,omitempty"`
}

func (x *SingleTenantHsmInstanceProposal_QuorumParameters) Reset() {
	*x = SingleTenantHsmInstanceProposal_QuorumParameters{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal_QuorumParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal_QuorumParameters) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal_QuorumParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_QuorumParameters.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal_QuorumParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 0}
}

func (x *SingleTenantHsmInstanceProposal_QuorumParameters) GetRequiredApproverCount() int32 {
	if x != nil {
		return x.RequiredApproverCount
	}
	return 0
}

func (x *SingleTenantHsmInstanceProposal_QuorumParameters) GetChallenges() []*Challenge {
	if x != nil {
		return x.Challenges
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal_QuorumParameters) GetApprovedTwoFactorPublicKeyPems() []string {
	if x != nil {
		return x.ApprovedTwoFactorPublicKeyPems
	}
	return nil
}

// Parameters for an approval that has both required challenges and a
// quorum.
type SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A list of specific challenges that must be signed.
	// For some operations, this will contain a single challenge.
	RequiredChallenges []*Challenge `protobuf:"bytes,1,rep,name=required_challenges,json=requiredChallenges,proto3" json:"required_challenges,omitempty"`
	// Output only. The required number of quorum approvers. This is the M value
	// used for M of N quorum auth. It is less than the number of public keys.
	RequiredApproverCount int32 `protobuf:"varint,2,opt,name=required_approver_count,json=requiredApproverCount,proto3" json:"required_approver_count,omitempty"`
	// Output only. The challenges to be signed by 2FA keys for quorum auth. M
	// of N of these challenges are required to be signed to approve the
	// operation.
	QuorumChallenges []*Challenge `protobuf:"bytes,3,rep,name=quorum_challenges,json=quorumChallenges,proto3" json:"quorum_challenges,omitempty"`
	// Output only. The public keys associated with the 2FA keys that have
	// already approved the
	// [SingleTenantHsmInstanceProposal][google.cloud.kms.v1.SingleTenantHsmInstanceProposal]
	// by signing the challenge.
	ApprovedTwoFactorPublicKeyPems []string `protobuf:"bytes,4,rep,name=approved_two_factor_public_key_pems,json=approvedTwoFactorPublicKeyPems,proto3" json:"approved_two_factor_public_key_pems,omitempty"`
}

func (x *SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters) Reset() {
	*x = SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 1}
}

func (x *SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters) GetRequiredChallenges() []*Challenge {
	if x != nil {
		return x.RequiredChallenges
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters) GetRequiredApproverCount() int32 {
	if x != nil {
		return x.RequiredApproverCount
	}
	return 0
}

func (x *SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters) GetQuorumChallenges() []*Challenge {
	if x != nil {
		return x.QuorumChallenges
	}
	return nil
}

func (x *SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters) GetApprovedTwoFactorPublicKeyPems() []string {
	if x != nil {
		return x.ApprovedTwoFactorPublicKeyPems
	}
	return nil
}

// Register 2FA keys for the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
// This operation requires all Challenges to be signed by 2FA keys. The
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] must
// be in the
// [PENDING_TWO_FACTOR_AUTH_REGISTRATION][google.cloud.kms.v1.SingleTenantHsmInstance.State.PENDING_TWO_FACTOR_AUTH_REGISTRATION]
// state to perform this operation.
type SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The required numbers of approvers to set for the
	// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
	// This is the M value used for M of N quorum auth. Must be greater than or
	// equal to 2 and less than or equal to
	// [total_approver_count][google.cloud.kms.v1.SingleTenantHsmInstance.QuorumAuth.total_approver_count]
	// - 1.
	RequiredApproverCount int32 `protobuf:"varint,1,opt,name=required_approver_count,json=requiredApproverCount,proto3" json:"required_approver_count,omitempty"`
	// Required. The public keys associated with the 2FA keys for M of N quorum
	// auth. Public keys must be associated with RSA 2048 keys.
	TwoFactorPublicKeyPems []string `protobuf:"bytes,2,rep,name=two_factor_public_key_pems,json=twoFactorPublicKeyPems,proto3" json:"two_factor_public_key_pems,omitempty"`
}

func (x *SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys) Reset() {
	*x = SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 2}
}

func (x *SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys) GetRequiredApproverCount() int32 {
	if x != nil {
		return x.RequiredApproverCount
	}
	return 0
}

func (x *SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys) GetTwoFactorPublicKeyPems() []string {
	if x != nil {
		return x.TwoFactorPublicKeyPems
	}
	return nil
}

// Disable the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]. The
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] must
// be in the
// [ACTIVE][google.cloud.kms.v1.SingleTenantHsmInstance.State.ACTIVE] state to
// perform this operation.
type SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance) Reset() {
	*x = SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 3}
}

// Enable the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]. The
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] must
// be in the
// [DISABLED][google.cloud.kms.v1.SingleTenantHsmInstance.State.DISABLED]
// state to perform this operation.
type SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance) Reset() {
	*x = SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 4}
}

// Delete the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
// Deleting a
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] will
// make all [CryptoKeys][google.cloud.kms.v1.CryptoKey] attached to the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
// unusable. The
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] must
// not be in the
// [DELETING][google.cloud.kms.v1.SingleTenantHsmInstance.State.DELETING] or
// [DELETED][google.cloud.kms.v1.SingleTenantHsmInstance.State.DELETED] state
// to perform this operation.
type SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance) Reset() {
	*x = SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 5}
}

// Add a quorum member to the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
// This will increase the
// [total_approver_count][google.cloud.kms.v1.SingleTenantHsmInstance.QuorumAuth.total_approver_count]
// by 1. The
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] must
// be in the
// [ACTIVE][google.cloud.kms.v1.SingleTenantHsmInstance.State.ACTIVE] state to
// perform this operation.
type SingleTenantHsmInstanceProposal_AddQuorumMember struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The public key associated with the 2FA key for the new quorum
	// member to add. Public keys must be associated with RSA 2048 keys.
	TwoFactorPublicKeyPem string `protobuf:"bytes,1,opt,name=two_factor_public_key_pem,json=twoFactorPublicKeyPem,proto3" json:"two_factor_public_key_pem,omitempty"`
}

func (x *SingleTenantHsmInstanceProposal_AddQuorumMember) Reset() {
	*x = SingleTenantHsmInstanceProposal_AddQuorumMember{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal_AddQuorumMember) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal_AddQuorumMember) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal_AddQuorumMember) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_AddQuorumMember.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal_AddQuorumMember) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 6}
}

func (x *SingleTenantHsmInstanceProposal_AddQuorumMember) GetTwoFactorPublicKeyPem() string {
	if x != nil {
		return x.TwoFactorPublicKeyPem
	}
	return ""
}

// Remove a quorum member from the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
// This will reduce
// [total_approver_count][google.cloud.kms.v1.SingleTenantHsmInstance.QuorumAuth.total_approver_count]
// by 1. The
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] must
// be in the
// [ACTIVE][google.cloud.kms.v1.SingleTenantHsmInstance.State.ACTIVE] state to
// perform this operation.
type SingleTenantHsmInstanceProposal_RemoveQuorumMember struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The public key associated with the 2FA key for the quorum
	// member to remove. Public keys must be associated with RSA 2048 keys.
	TwoFactorPublicKeyPem string `protobuf:"bytes,1,opt,name=two_factor_public_key_pem,json=twoFactorPublicKeyPem,proto3" json:"two_factor_public_key_pem,omitempty"`
}

func (x *SingleTenantHsmInstanceProposal_RemoveQuorumMember) Reset() {
	*x = SingleTenantHsmInstanceProposal_RemoveQuorumMember{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal_RemoveQuorumMember) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal_RemoveQuorumMember) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal_RemoveQuorumMember) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_RemoveQuorumMember.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal_RemoveQuorumMember) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 7}
}

func (x *SingleTenantHsmInstanceProposal_RemoveQuorumMember) GetTwoFactorPublicKeyPem() string {
	if x != nil {
		return x.TwoFactorPublicKeyPem
	}
	return ""
}

// Refreshes the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance].
// This operation must be performed periodically to keep the
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance]
// active. This operation must be performed before
// [unrefreshed_duration_until_disable][google.cloud.kms.v1.SingleTenantHsmInstance.unrefreshed_duration_until_disable]
// has passed. The
// [SingleTenantHsmInstance][google.cloud.kms.v1.SingleTenantHsmInstance] must
// be in the
// [ACTIVE][google.cloud.kms.v1.SingleTenantHsmInstance.State.ACTIVE] state to
// perform this operation.
type SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance) Reset() {
	*x = SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance) ProtoMessage() {}

func (x *SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance.ProtoReflect.Descriptor instead.
func (*SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{1, 8}
}

// The reply to
// [QuorumParameters][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.QuorumParameters]
// for approving the proposal.
type ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The challenge replies to approve the proposal. Challenge
	// replies can be sent across multiple requests. The proposal will be
	// approved when
	// [required_approver_count][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.QuorumParameters.required_approver_count]
	// challenge replies are provided.
	ChallengeReplies []*ChallengeReply `protobuf:"bytes,1,rep,name=challenge_replies,json=challengeReplies,proto3" json:"challenge_replies,omitempty"`
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply) Reset() {
	*x = ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply) ProtoMessage() {}

func (x *ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply.ProtoReflect.Descriptor instead.
func (*ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{12, 0}
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply) GetChallengeReplies() []*ChallengeReply {
	if x != nil {
		return x.ChallengeReplies
	}
	return nil
}

// The reply to
// [RequiredActionQuorumParameters][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RequiredActionQuorumParameters]
// for approving the proposal.
type ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. All required challenges must be signed for the proposal to be
	// approved. These can be sent across multiple requests.
	RequiredChallengeReplies []*ChallengeReply `protobuf:"bytes,1,rep,name=required_challenge_replies,json=requiredChallengeReplies,proto3" json:"required_challenge_replies,omitempty"`
	// Required. Quorum members' signed challenge replies. These can be provided
	// across multiple requests. The proposal will be approved when
	// [required_approver_count][google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RequiredActionQuorumParameters.required_approver_count]
	// quorum_challenge_replies are provided and when all
	// required_challenge_replies are provided.
	QuorumChallengeReplies []*ChallengeReply `protobuf:"bytes,2,rep,name=quorum_challenge_replies,json=quorumChallengeReplies,proto3" json:"quorum_challenge_replies,omitempty"`
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply) Reset() {
	*x = ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply{}
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply) ProtoMessage() {}

func (x *ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_kms_v1_hsm_management_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply.ProtoReflect.Descriptor instead.
func (*ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply) Descriptor() ([]byte, []int) {
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP(), []int{12, 1}
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply) GetRequiredChallengeReplies() []*ChallengeReply {
	if x != nil {
		return x.RequiredChallengeReplies
	}
	return nil
}

func (x *ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply) GetQuorumChallengeReplies() []*ChallengeReply {
	if x != nil {
		return x.QuorumChallengeReplies
	}
	return nil
}

var File_google_cloud_kms_v1_hsm_management_proto protoreflect.FileDescriptor

var file_google_cloud_kms_v1_hsm_management_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6b,
	0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x68, 0x73, 0x6d, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcc, 0x08, 0x0a, 0x17, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5d, 0x0a, 0x0b, 0x71,
	0x75, 0x6f, 0x72, 0x75, 0x6d, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x51,
	0x75, 0x6f, 0x72, 0x75, 0x6d, 0x41, 0x75, 0x74, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x41, 0x75, 0x74, 0x68, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x22,
	0x75, 0x6e, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1f, 0x75, 0x6e, 0x72, 0x65, 0x66, 0x72,
	0x65, 0x73, 0x68, 0x65, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x6e, 0x74,
	0x69, 0x6c, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xc1, 0x01,
	0x0a, 0x0a, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x41, 0x75, 0x74, 0x68, 0x12, 0x35, 0x0a, 0x14,
	0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x17, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x3f, 0x0a, 0x1a, 0x74, 0x77, 0x6f, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x65, 0x6d, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x74, 0x77, 0x6f, 0x46, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x50, 0x65, 0x6d,
	0x73, 0x22, 0xa6, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x28, 0x0a, 0x24, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x57, 0x4f, 0x5f,
	0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x52, 0x45, 0x47, 0x49,
	0x53, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c,
	0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45,
	0x44, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x06, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0a,
	0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x08, 0x3a, 0xc7, 0x01, 0xea, 0x41, 0xc3,
	0x01, 0x0a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x5d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x7d, 0x2a, 0x18, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48,
	0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x32, 0x17, 0x73, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x22, 0xda, 0x19, 0x0a, 0x1f, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x66, 0x61,
	0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x79, 0x0a, 0x11, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x10, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0xa5, 0x01, 0x0a, 0x21, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1e, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3d, 0x0a, 0x0b, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x01, 0x52, 0x0a, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x03, 0x74, 0x74, 0x6c, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x01, 0x52, 0x03, 0x74, 0x74, 0x6c, 0x12, 0x40, 0x0a, 0x0b,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e,
	0x0a, 0x0a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x75, 0x72, 0x67, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x92,
	0x01, 0x0a, 0x1d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x77, 0x6f, 0x5f,
	0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6b, 0x65, 0x79, 0x73,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x65, 0x72, 0x54, 0x77, 0x6f, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x41, 0x75,
	0x74, 0x68, 0x4b, 0x65, 0x79, 0x73, 0x48, 0x02, 0x52, 0x19, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x54, 0x77, 0x6f, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x41, 0x75, 0x74, 0x68, 0x4b,
	0x65, 0x79, 0x73, 0x12, 0xa1, 0x01, 0x0a, 0x22, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73,
	0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x02, 0x52, 0x1e, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x9e, 0x01, 0x0a, 0x21, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x02, 0x52, 0x1d, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x9e, 0x01, 0x0a, 0x21, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x02, 0x52, 0x1d, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x72, 0x0a, 0x11, 0x61, 0x64, 0x64,
	0x5f, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x5f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x41, 0x64, 0x64, 0x51, 0x75,
	0x6f, 0x72, 0x75, 0x6d, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x48, 0x02, 0x52, 0x0f, 0x61, 0x64,
	0x64, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x7b, 0x0a,
	0x14, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x5f, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x48, 0x02, 0x52, 0x12, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x51, 0x75,
	0x6f, 0x72, 0x75, 0x6d, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0xa1, 0x01, 0x0a, 0x22, 0x72,
	0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2e, 0x52, 0x65,
	0x66, 0x72, 0x65, 0x73, 0x68, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e,
	0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x02, 0x52, 0x1e,
	0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0xe6,
	0x01, 0x0a, 0x10, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x17, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f,
	0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x43, 0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x23, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x64, 0x5f, 0x74, 0x77, 0x6f, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x65, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1e, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x64, 0x54, 0x77, 0x6f, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x4b, 0x65, 0x79, 0x50, 0x65, 0x6d, 0x73, 0x1a, 0xd7, 0x02, 0x0a, 0x1e, 0x52, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x54, 0x0a, 0x13, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68,
	0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x3b, 0x0a, 0x17, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x50, 0x0a,
	0x11, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x5f, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x71,
	0x75, 0x6f, 0x72, 0x75, 0x6d, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x73, 0x12,
	0x50, 0x0a, 0x23, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x74, 0x77, 0x6f, 0x5f,
	0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x70, 0x65, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1e, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x54, 0x77, 0x6f, 0x46, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x50, 0x65, 0x6d,
	0x73, 0x1a, 0x99, 0x01, 0x0a, 0x19, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x54, 0x77,
	0x6f, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x41, 0x75, 0x74, 0x68, 0x4b, 0x65, 0x79, 0x73, 0x12,
	0x3b, 0x0a, 0x17, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x41,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x1a,
	0x74, 0x77, 0x6f, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x65, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x16, 0x74, 0x77, 0x6f, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x50, 0x65, 0x6d, 0x73, 0x1a, 0x20, 0x0a,
	0x1e, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x1a,
	0x1f, 0x0a, 0x1d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x1a, 0x1f, 0x0a, 0x1d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x1a, 0x50, 0x0a, 0x0f, 0x41, 0x64, 0x64, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x19, 0x74, 0x77, 0x6f, 0x5f, 0x66, 0x61, 0x63, 0x74,
	0x6f, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x65,
	0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x74, 0x77,
	0x6f, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79,
	0x50, 0x65, 0x6d, 0x1a, 0x53, 0x0a, 0x12, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x51, 0x75, 0x6f,
	0x72, 0x75, 0x6d, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x3d, 0x0a, 0x19, 0x74, 0x77, 0x6f,
	0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x70, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x15, 0x74, 0x77, 0x6f, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x4b, 0x65, 0x79, 0x50, 0x65, 0x6d, 0x1a, 0x20, 0x0a, 0x1e, 0x52, 0x65, 0x66, 0x72,
	0x65, 0x73, 0x68, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48,
	0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x7c, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x04,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x05, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x07, 0x3a, 0xf4, 0x01, 0xea, 0x41, 0xf0, 0x01, 0x0a,
	0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x72, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x7d, 0x2a, 0x20, 0x73, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x32, 0x1f,
	0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x42,
	0x15, 0x0a, 0x13, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x0c, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x59, 0x0a, 0x09, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x12, 0x21,
	0x0a, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67,
	0x65, 0x12, 0x29, 0x0a, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x70, 0x65, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x50, 0x65, 0x6d, 0x22, 0x6b, 0x0a, 0x0e,
	0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x2e,
	0x0a, 0x10, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x12, 0x29,
	0x0a, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x70, 0x65, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x4b, 0x65, 0x79, 0x50, 0x65, 0x6d, 0x22, 0x93, 0x02, 0x0a, 0x23, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22,
	0xda, 0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6b, 0x0a, 0x1b, 0x73, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x18, 0x73, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a,
	0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x70, 0x0a, 0x21,
	0x47, 0x65, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48,
	0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0,
	0x02, 0x0a, 0x24, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x1d, 0x73, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x6e, 0x0a, 0x1a, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x22, 0x27, 0x0a, 0x25, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xe1, 0x02, 0x0a, 0x2c, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e,
	0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x26,
	0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73,
	0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x21, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48,
	0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73,
	0x61, 0x6c, 0x49, 0x64, 0x12, 0x87, 0x01, 0x0a, 0x23, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1f, 0x73,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x2f,
	0x0a, 0x2d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0x80, 0x01, 0x0a, 0x29, 0x47, 0x65, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x39, 0x0a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x89, 0x06, 0x0a, 0x2d, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x53, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x78, 0x0a, 0x0c, 0x71, 0x75, 0x6f,
	0x72, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0b, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x52, 0x65,
	0x70, 0x6c, 0x79, 0x12, 0xa4, 0x01, 0x0a, 0x1c, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x5f, 0x72,
	0x65, 0x70, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x6f,
	0x72, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52,
	0x19, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x51,
	0x75, 0x6f, 0x72, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x1a, 0x64, 0x0a, 0x0b, 0x51, 0x75,
	0x6f, 0x72, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x55, 0x0a, 0x11, 0x63, 0x68, 0x61,
	0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73,
	0x1a, 0xe7, 0x01, 0x0a, 0x19, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x51, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x66,
	0x0a, 0x1a, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x68, 0x61, 0x6c, 0x6c,
	0x65, 0x6e, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e,
	0x67, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x12, 0x62, 0x0a, 0x18, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d,
	0x5f, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x16, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x43, 0x68, 0x61, 0x6c, 0x6c, 0x65,
	0x6e, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x61, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x30,
	0x0a, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x84, 0x01, 0x0a, 0x2d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b,
	0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x30, 0x0a, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x30, 0x0a, 0x2e, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa9, 0x02, 0x0a, 0x2b,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x26, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x68, 0x6f, 0x77,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0xfc, 0x01, 0x0a, 0x2c, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x84, 0x01, 0x0a, 0x24, 0x73, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x20, 0x73,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x2c, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x39, 0x0a, 0x37, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xa3, 0x15, 0x0a,
	0x0d, 0x48, 0x73, 0x6d, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xe2,
	0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0xcf, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xe5, 0x01, 0xca, 0x41, 0x40, 0x0a, 0x17, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x25, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x3f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68,
	0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2c, 0x73, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a,
	0x1a, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68,
	0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x3c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xa8, 0x03, 0x0a, 0x25, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9c, 0x02, 0xca, 0x41, 0x50, 0x0a, 0x1f, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x2d, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x51, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x2c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x6f, 0x3a, 0x23, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x68, 0x73, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x73, 0x12, 0xa2, 0x02, 0x0a, 0x26, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76,
	0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6f, 0xda, 0x41, 0x11, 0x6e, 0x61, 0x6d,
	0x65, 0x2c, 0x71, 0x75, 0x6f, 0x72, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x12, 0xd3, 0x02, 0x0a, 0x26, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e,
	0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc5, 0x01, 0xca, 0x41, 0x60, 0x0a, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x70, 0x6f, 0x73, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x6f,
	0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x12,
	0xf3, 0x01, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72,
	0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e,
	0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x22, 0x57, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x12, 0x48, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
	0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x02, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69,
	0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x12, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x69, 0x6e, 0x67, 0x6c,
	0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x59, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x4a, 0x12, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x12, 0xdb,
	0x01, 0x0a, 0x25, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e,
	0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70,
	0x6f, 0x73, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x57, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4a, 0x2a, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x54, 0x65, 0x6e, 0x61, 0x6e,
	0x74, 0x48, 0x73, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x74, 0xca, 0x41,
	0x17, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x57, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a,
	0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b,
	0x6d, 0x73, 0x42, 0x86, 0x01, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6b, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x12,
	0x48, 0x73, 0x6d, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6b, 0x6d, 0x73, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x6b, 0x6d, 0x73, 0x70, 0x62, 0x3b, 0x6b, 0x6d, 0x73, 0x70, 0x62, 0xaa,
	0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4b,
	0x6d, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4b, 0x6d, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_kms_v1_hsm_management_proto_rawDescOnce sync.Once
	file_google_cloud_kms_v1_hsm_management_proto_rawDescData = file_google_cloud_kms_v1_hsm_management_proto_rawDesc
)

func file_google_cloud_kms_v1_hsm_management_proto_rawDescGZIP() []byte {
	file_google_cloud_kms_v1_hsm_management_proto_rawDescOnce.Do(func() {
		file_google_cloud_kms_v1_hsm_management_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_kms_v1_hsm_management_proto_rawDescData)
	})
	return file_google_cloud_kms_v1_hsm_management_proto_rawDescData
}

var file_google_cloud_kms_v1_hsm_management_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_kms_v1_hsm_management_proto_msgTypes = make([]protoimpl.MessageInfo, 32)
var file_google_cloud_kms_v1_hsm_management_proto_goTypes = []any{
	(SingleTenantHsmInstance_State)(0),                                              // 0: google.cloud.kms.v1.SingleTenantHsmInstance.State
	(SingleTenantHsmInstanceProposal_State)(0),                                      // 1: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.State
	(*SingleTenantHsmInstance)(nil),                                                 // 2: google.cloud.kms.v1.SingleTenantHsmInstance
	(*SingleTenantHsmInstanceProposal)(nil),                                         // 3: google.cloud.kms.v1.SingleTenantHsmInstanceProposal
	(*Challenge)(nil),                                                               // 4: google.cloud.kms.v1.Challenge
	(*ChallengeReply)(nil),                                                          // 5: google.cloud.kms.v1.ChallengeReply
	(*ListSingleTenantHsmInstancesRequest)(nil),                                     // 6: google.cloud.kms.v1.ListSingleTenantHsmInstancesRequest
	(*ListSingleTenantHsmInstancesResponse)(nil),                                    // 7: google.cloud.kms.v1.ListSingleTenantHsmInstancesResponse
	(*GetSingleTenantHsmInstanceRequest)(nil),                                       // 8: google.cloud.kms.v1.GetSingleTenantHsmInstanceRequest
	(*CreateSingleTenantHsmInstanceRequest)(nil),                                    // 9: google.cloud.kms.v1.CreateSingleTenantHsmInstanceRequest
	(*CreateSingleTenantHsmInstanceMetadata)(nil),                                   // 10: google.cloud.kms.v1.CreateSingleTenantHsmInstanceMetadata
	(*CreateSingleTenantHsmInstanceProposalRequest)(nil),                            // 11: google.cloud.kms.v1.CreateSingleTenantHsmInstanceProposalRequest
	(*CreateSingleTenantHsmInstanceProposalMetadata)(nil),                           // 12: google.cloud.kms.v1.CreateSingleTenantHsmInstanceProposalMetadata
	(*GetSingleTenantHsmInstanceProposalRequest)(nil),                               // 13: google.cloud.kms.v1.GetSingleTenantHsmInstanceProposalRequest
	(*ApproveSingleTenantHsmInstanceProposalRequest)(nil),                           // 14: google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest
	(*ApproveSingleTenantHsmInstanceProposalResponse)(nil),                          // 15: google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalResponse
	(*ExecuteSingleTenantHsmInstanceProposalRequest)(nil),                           // 16: google.cloud.kms.v1.ExecuteSingleTenantHsmInstanceProposalRequest
	(*ExecuteSingleTenantHsmInstanceProposalResponse)(nil),                          // 17: google.cloud.kms.v1.ExecuteSingleTenantHsmInstanceProposalResponse
	(*ExecuteSingleTenantHsmInstanceProposalMetadata)(nil),                          // 18: google.cloud.kms.v1.ExecuteSingleTenantHsmInstanceProposalMetadata
	(*ListSingleTenantHsmInstanceProposalsRequest)(nil),                             // 19: google.cloud.kms.v1.ListSingleTenantHsmInstanceProposalsRequest
	(*ListSingleTenantHsmInstanceProposalsResponse)(nil),                            // 20: google.cloud.kms.v1.ListSingleTenantHsmInstanceProposalsResponse
	(*DeleteSingleTenantHsmInstanceProposalRequest)(nil),                            // 21: google.cloud.kms.v1.DeleteSingleTenantHsmInstanceProposalRequest
	(*SingleTenantHsmInstance_QuorumAuth)(nil),                                      // 22: google.cloud.kms.v1.SingleTenantHsmInstance.QuorumAuth
	(*SingleTenantHsmInstanceProposal_QuorumParameters)(nil),                        // 23: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.QuorumParameters
	(*SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters)(nil),          // 24: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RequiredActionQuorumParameters
	(*SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys)(nil),               // 25: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RegisterTwoFactorAuthKeys
	(*SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance)(nil),          // 26: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.DisableSingleTenantHsmInstance
	(*SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance)(nil),           // 27: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.EnableSingleTenantHsmInstance
	(*SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance)(nil),           // 28: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.DeleteSingleTenantHsmInstance
	(*SingleTenantHsmInstanceProposal_AddQuorumMember)(nil),                         // 29: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.AddQuorumMember
	(*SingleTenantHsmInstanceProposal_RemoveQuorumMember)(nil),                      // 30: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RemoveQuorumMember
	(*SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance)(nil),          // 31: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RefreshSingleTenantHsmInstance
	(*ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply)(nil),               // 32: google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest.QuorumReply
	(*ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply)(nil), // 33: google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest.RequiredActionQuorumReply
	(*timestamppb.Timestamp)(nil),                                                   // 34: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                                                     // 35: google.protobuf.Duration
	(*longrunningpb.Operation)(nil),                                                 // 36: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                                           // 37: google.protobuf.Empty
}
var file_google_cloud_kms_v1_hsm_management_proto_depIdxs = []int32{
	34, // 0: google.cloud.kms.v1.SingleTenantHsmInstance.create_time:type_name -> google.protobuf.Timestamp
	0,  // 1: google.cloud.kms.v1.SingleTenantHsmInstance.state:type_name -> google.cloud.kms.v1.SingleTenantHsmInstance.State
	22, // 2: google.cloud.kms.v1.SingleTenantHsmInstance.quorum_auth:type_name -> google.cloud.kms.v1.SingleTenantHsmInstance.QuorumAuth
	34, // 3: google.cloud.kms.v1.SingleTenantHsmInstance.delete_time:type_name -> google.protobuf.Timestamp
	35, // 4: google.cloud.kms.v1.SingleTenantHsmInstance.unrefreshed_duration_until_disable:type_name -> google.protobuf.Duration
	34, // 5: google.cloud.kms.v1.SingleTenantHsmInstance.disable_time:type_name -> google.protobuf.Timestamp
	34, // 6: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.create_time:type_name -> google.protobuf.Timestamp
	1,  // 7: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.state:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.State
	23, // 8: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.quorum_parameters:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.QuorumParameters
	24, // 9: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.required_action_quorum_parameters:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RequiredActionQuorumParameters
	34, // 10: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.expire_time:type_name -> google.protobuf.Timestamp
	35, // 11: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.ttl:type_name -> google.protobuf.Duration
	34, // 12: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.delete_time:type_name -> google.protobuf.Timestamp
	34, // 13: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.purge_time:type_name -> google.protobuf.Timestamp
	25, // 14: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.register_two_factor_auth_keys:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RegisterTwoFactorAuthKeys
	26, // 15: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.disable_single_tenant_hsm_instance:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.DisableSingleTenantHsmInstance
	27, // 16: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.enable_single_tenant_hsm_instance:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.EnableSingleTenantHsmInstance
	28, // 17: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.delete_single_tenant_hsm_instance:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.DeleteSingleTenantHsmInstance
	29, // 18: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.add_quorum_member:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.AddQuorumMember
	30, // 19: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.remove_quorum_member:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RemoveQuorumMember
	31, // 20: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.refresh_single_tenant_hsm_instance:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RefreshSingleTenantHsmInstance
	2,  // 21: google.cloud.kms.v1.ListSingleTenantHsmInstancesResponse.single_tenant_hsm_instances:type_name -> google.cloud.kms.v1.SingleTenantHsmInstance
	2,  // 22: google.cloud.kms.v1.CreateSingleTenantHsmInstanceRequest.single_tenant_hsm_instance:type_name -> google.cloud.kms.v1.SingleTenantHsmInstance
	3,  // 23: google.cloud.kms.v1.CreateSingleTenantHsmInstanceProposalRequest.single_tenant_hsm_instance_proposal:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal
	32, // 24: google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest.quorum_reply:type_name -> google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest.QuorumReply
	33, // 25: google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest.required_action_quorum_reply:type_name -> google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest.RequiredActionQuorumReply
	3,  // 26: google.cloud.kms.v1.ListSingleTenantHsmInstanceProposalsResponse.single_tenant_hsm_instance_proposals:type_name -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal
	4,  // 27: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.QuorumParameters.challenges:type_name -> google.cloud.kms.v1.Challenge
	4,  // 28: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RequiredActionQuorumParameters.required_challenges:type_name -> google.cloud.kms.v1.Challenge
	4,  // 29: google.cloud.kms.v1.SingleTenantHsmInstanceProposal.RequiredActionQuorumParameters.quorum_challenges:type_name -> google.cloud.kms.v1.Challenge
	5,  // 30: google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest.QuorumReply.challenge_replies:type_name -> google.cloud.kms.v1.ChallengeReply
	5,  // 31: google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest.RequiredActionQuorumReply.required_challenge_replies:type_name -> google.cloud.kms.v1.ChallengeReply
	5,  // 32: google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest.RequiredActionQuorumReply.quorum_challenge_replies:type_name -> google.cloud.kms.v1.ChallengeReply
	6,  // 33: google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstances:input_type -> google.cloud.kms.v1.ListSingleTenantHsmInstancesRequest
	8,  // 34: google.cloud.kms.v1.HsmManagement.GetSingleTenantHsmInstance:input_type -> google.cloud.kms.v1.GetSingleTenantHsmInstanceRequest
	9,  // 35: google.cloud.kms.v1.HsmManagement.CreateSingleTenantHsmInstance:input_type -> google.cloud.kms.v1.CreateSingleTenantHsmInstanceRequest
	11, // 36: google.cloud.kms.v1.HsmManagement.CreateSingleTenantHsmInstanceProposal:input_type -> google.cloud.kms.v1.CreateSingleTenantHsmInstanceProposalRequest
	14, // 37: google.cloud.kms.v1.HsmManagement.ApproveSingleTenantHsmInstanceProposal:input_type -> google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalRequest
	16, // 38: google.cloud.kms.v1.HsmManagement.ExecuteSingleTenantHsmInstanceProposal:input_type -> google.cloud.kms.v1.ExecuteSingleTenantHsmInstanceProposalRequest
	13, // 39: google.cloud.kms.v1.HsmManagement.GetSingleTenantHsmInstanceProposal:input_type -> google.cloud.kms.v1.GetSingleTenantHsmInstanceProposalRequest
	19, // 40: google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstanceProposals:input_type -> google.cloud.kms.v1.ListSingleTenantHsmInstanceProposalsRequest
	21, // 41: google.cloud.kms.v1.HsmManagement.DeleteSingleTenantHsmInstanceProposal:input_type -> google.cloud.kms.v1.DeleteSingleTenantHsmInstanceProposalRequest
	7,  // 42: google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstances:output_type -> google.cloud.kms.v1.ListSingleTenantHsmInstancesResponse
	2,  // 43: google.cloud.kms.v1.HsmManagement.GetSingleTenantHsmInstance:output_type -> google.cloud.kms.v1.SingleTenantHsmInstance
	36, // 44: google.cloud.kms.v1.HsmManagement.CreateSingleTenantHsmInstance:output_type -> google.longrunning.Operation
	36, // 45: google.cloud.kms.v1.HsmManagement.CreateSingleTenantHsmInstanceProposal:output_type -> google.longrunning.Operation
	15, // 46: google.cloud.kms.v1.HsmManagement.ApproveSingleTenantHsmInstanceProposal:output_type -> google.cloud.kms.v1.ApproveSingleTenantHsmInstanceProposalResponse
	36, // 47: google.cloud.kms.v1.HsmManagement.ExecuteSingleTenantHsmInstanceProposal:output_type -> google.longrunning.Operation
	3,  // 48: google.cloud.kms.v1.HsmManagement.GetSingleTenantHsmInstanceProposal:output_type -> google.cloud.kms.v1.SingleTenantHsmInstanceProposal
	20, // 49: google.cloud.kms.v1.HsmManagement.ListSingleTenantHsmInstanceProposals:output_type -> google.cloud.kms.v1.ListSingleTenantHsmInstanceProposalsResponse
	37, // 50: google.cloud.kms.v1.HsmManagement.DeleteSingleTenantHsmInstanceProposal:output_type -> google.protobuf.Empty
	42, // [42:51] is the sub-list for method output_type
	33, // [33:42] is the sub-list for method input_type
	33, // [33:33] is the sub-list for extension type_name
	33, // [33:33] is the sub-list for extension extendee
	0,  // [0:33] is the sub-list for field type_name
}

func init() { file_google_cloud_kms_v1_hsm_management_proto_init() }
func file_google_cloud_kms_v1_hsm_management_proto_init() {
	if File_google_cloud_kms_v1_hsm_management_proto != nil {
		return
	}
	file_google_cloud_kms_v1_hsm_management_proto_msgTypes[1].OneofWrappers = []any{
		(*SingleTenantHsmInstanceProposal_QuorumParameters_)(nil),
		(*SingleTenantHsmInstanceProposal_RequiredActionQuorumParameters_)(nil),
		(*SingleTenantHsmInstanceProposal_ExpireTime)(nil),
		(*SingleTenantHsmInstanceProposal_Ttl)(nil),
		(*SingleTenantHsmInstanceProposal_RegisterTwoFactorAuthKeys_)(nil),
		(*SingleTenantHsmInstanceProposal_DisableSingleTenantHsmInstance_)(nil),
		(*SingleTenantHsmInstanceProposal_EnableSingleTenantHsmInstance_)(nil),
		(*SingleTenantHsmInstanceProposal_DeleteSingleTenantHsmInstance_)(nil),
		(*SingleTenantHsmInstanceProposal_AddQuorumMember_)(nil),
		(*SingleTenantHsmInstanceProposal_RemoveQuorumMember_)(nil),
		(*SingleTenantHsmInstanceProposal_RefreshSingleTenantHsmInstance_)(nil),
	}
	file_google_cloud_kms_v1_hsm_management_proto_msgTypes[12].OneofWrappers = []any{
		(*ApproveSingleTenantHsmInstanceProposalRequest_QuorumReply_)(nil),
		(*ApproveSingleTenantHsmInstanceProposalRequest_RequiredActionQuorumReply_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_kms_v1_hsm_management_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   32,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_kms_v1_hsm_management_proto_goTypes,
		DependencyIndexes: file_google_cloud_kms_v1_hsm_management_proto_depIdxs,
		EnumInfos:         file_google_cloud_kms_v1_hsm_management_proto_enumTypes,
		MessageInfos:      file_google_cloud_kms_v1_hsm_management_proto_msgTypes,
	}.Build()
	File_google_cloud_kms_v1_hsm_management_proto = out.File
	file_google_cloud_kms_v1_hsm_management_proto_rawDesc = nil
	file_google_cloud_kms_v1_hsm_management_proto_goTypes = nil
	file_google_cloud_kms_v1_hsm_management_proto_depIdxs = nil
}
