// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package datalayer

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

type ProblemT struct {
	Type string
	Title string
	Status int32
	Detail string
	Instance string
	MainDiagnosisCode string
	DetailedDiagnosisCode string
	DynamicDescription string
	Severity Severity
	Links []string
	Entity string
	MoreInfo []byte
	Cause []*ProblemT
}

func (t *ProblemT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	typeOffset := builder.CreateString(t.Type)
	titleOffset := builder.CreateString(t.Title)
	detailOffset := builder.CreateString(t.Detail)
	instanceOffset := builder.CreateString(t.Instance)
	mainDiagnosisCodeOffset := builder.CreateString(t.MainDiagnosisCode)
	detailedDiagnosisCodeOffset := builder.CreateString(t.DetailedDiagnosisCode)
	dynamicDescriptionOffset := builder.CreateString(t.DynamicDescription)
	linksOffset := flatbuffers.UOffsetT(0)
	if t.Links != nil {
		linksLength := len(t.Links)
		linksOffsets := make([]flatbuffers.UOffsetT, linksLength)
		for j := 0; j < linksLength; j++ {
			linksOffsets[j] = builder.CreateString(t.Links[j])
		}
		ProblemStartLinksVector(builder, linksLength)
		for j := linksLength - 1; j >= 0; j-- {
			builder.PrependUOffsetT(linksOffsets[j])
		}
		linksOffset = builder.EndVector(linksLength)
	}
	entityOffset := builder.CreateString(t.Entity)
	moreInfoOffset := flatbuffers.UOffsetT(0)
	if t.MoreInfo != nil {
		moreInfoOffset = builder.CreateByteString(t.MoreInfo)
	}
	causeOffset := flatbuffers.UOffsetT(0)
	if t.Cause != nil {
		causeLength := len(t.Cause)
		causeOffsets := make([]flatbuffers.UOffsetT, causeLength)
		for j := 0; j < causeLength; j++ {
			causeOffsets[j] = t.Cause[j].Pack(builder)
		}
		ProblemStartCauseVector(builder, causeLength)
		for j := causeLength - 1; j >= 0; j-- {
			builder.PrependUOffsetT(causeOffsets[j])
		}
		causeOffset = builder.EndVector(causeLength)
	}
	ProblemStart(builder)
	ProblemAddType(builder, typeOffset)
	ProblemAddTitle(builder, titleOffset)
	ProblemAddStatus(builder, t.Status)
	ProblemAddDetail(builder, detailOffset)
	ProblemAddInstance(builder, instanceOffset)
	ProblemAddMainDiagnosisCode(builder, mainDiagnosisCodeOffset)
	ProblemAddDetailedDiagnosisCode(builder, detailedDiagnosisCodeOffset)
	ProblemAddDynamicDescription(builder, dynamicDescriptionOffset)
	ProblemAddSeverity(builder, t.Severity)
	ProblemAddLinks(builder, linksOffset)
	ProblemAddEntity(builder, entityOffset)
	ProblemAddMoreInfo(builder, moreInfoOffset)
	ProblemAddCause(builder, causeOffset)
	return ProblemEnd(builder)
}

func (rcv *Problem) UnPackTo(t *ProblemT) {
	t.Type = string(rcv.Type())
	t.Title = string(rcv.Title())
	t.Status = rcv.Status()
	t.Detail = string(rcv.Detail())
	t.Instance = string(rcv.Instance())
	t.MainDiagnosisCode = string(rcv.MainDiagnosisCode())
	t.DetailedDiagnosisCode = string(rcv.DetailedDiagnosisCode())
	t.DynamicDescription = string(rcv.DynamicDescription())
	t.Severity = rcv.Severity()
	linksLength := rcv.LinksLength()
	t.Links = make([]string, linksLength)
	for j := 0; j < linksLength; j++ {
		t.Links[j] = string(rcv.Links(j))
	}
	t.Entity = string(rcv.Entity())
	t.MoreInfo = rcv.MoreInfoBytes()
	causeLength := rcv.CauseLength()
	t.Cause = make([]*ProblemT, causeLength)
	for j := 0; j < causeLength; j++ {
		x := Problem{}
		rcv.Cause(&x, j)
		t.Cause[j] = x.UnPack()
	}
}

func (rcv *Problem) UnPack() *ProblemT {
	if rcv == nil { return nil }
	t := &ProblemT{}
	rcv.UnPackTo(t)
	return t
}

type Problem struct {
	_tab flatbuffers.Table
}

func GetRootAsProblem(buf []byte, offset flatbuffers.UOffsetT) *Problem {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Problem{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsProblem(buf []byte, offset flatbuffers.UOffsetT) *Problem {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Problem{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Problem) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Problem) Table() flatbuffers.Table {
	return rcv._tab
}

/// A URI reference [RFC3986] that identifies the problem type. 
/// This specification encourages that, when dereferenced, 
/// it provide human-readable documentation for the problem type 
/// (e.g., using HTML [W3C.REC-html5-20141028]). When this member 
/// is not present, its value is assumed to be "about:blank".
func (rcv *Problem) Type() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// A URI reference [RFC3986] that identifies the problem type. 
/// This specification encourages that, when dereferenced, 
/// it provide human-readable documentation for the problem type 
/// (e.g., using HTML [W3C.REC-html5-20141028]). When this member 
/// is not present, its value is assumed to be "about:blank".
/// A short, human-readable summary of the problem type. 
/// It SHOULD NOT change from occurrence to occurrence of the problem, 
/// except for purposes of localization (e.g., using proactive content 
/// negotiation; see [RFC7231], Section 3.4).
func (rcv *Problem) Title() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// A short, human-readable summary of the problem type. 
/// It SHOULD NOT change from occurrence to occurrence of the problem, 
/// except for purposes of localization (e.g., using proactive content 
/// negotiation; see [RFC7231], Section 3.4).
/// The HTTP status code ([RFC7231], Section 6) generated by the origin server for this occurrence of the problem.
/// This will be added by the webserver - so you don't have to fill this field.
func (rcv *Problem) Status() int32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.GetInt32(o + rcv._tab.Pos)
	}
	return 0
}

/// The HTTP status code ([RFC7231], Section 6) generated by the origin server for this occurrence of the problem.
/// This will be added by the webserver - so you don't have to fill this field.
func (rcv *Problem) MutateStatus(n int32) bool {
	return rcv._tab.MutateInt32Slot(8, n)
}

/// A human-readable explanation specific to this occurrence of the problem.
func (rcv *Problem) Detail() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// A human-readable explanation specific to this occurrence of the problem.
/// A URI reference that identifies the specific occurrence of the problem. It may or may not yield further information if dereferenced.
func (rcv *Problem) Instance() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// A URI reference that identifies the specific occurrence of the problem. It may or may not yield further information if dereferenced.
/// The main diagnosis code was/is issued by the system that caused the problem.
/// This code can be used to track down the root cause and source of the error.
/// It can be used to search in the documentation for a solution.
/// It SHOULD NOT change from occurrence to occurrence of the same problem.
/// example: 080F0100
func (rcv *Problem) MainDiagnosisCode() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// The main diagnosis code was/is issued by the system that caused the problem.
/// This code can be used to track down the root cause and source of the error.
/// It can be used to search in the documentation for a solution.
/// It SHOULD NOT change from occurrence to occurrence of the same problem.
/// example: 080F0100
/// The detailed diagnosis code issued by the system that caused the problem.
/// This code can be used to track down the detailed cause and source of the error.
/// It can be used to search in the documentation for a solution.
/// The detailed diagnosis code gives additional information about the cause of the error.
/// It SHOULD NOT change from occurrence to occurrence of the same problem.
/// example: 00666001
func (rcv *Problem) DetailedDiagnosisCode() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// The detailed diagnosis code issued by the system that caused the problem.
/// This code can be used to track down the detailed cause and source of the error.
/// It can be used to search in the documentation for a solution.
/// The detailed diagnosis code gives additional information about the cause of the error.
/// It SHOULD NOT change from occurrence to occurrence of the same problem.
/// example: 00666001
/// A dynamic description gives detailed information about the occurrence of a problem.
/// It can change between different occurrences of the same error.
/// example: value = -4.5
func (rcv *Problem) DynamicDescription() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// A dynamic description gives detailed information about the occurrence of a problem.
/// It can change between different occurrences of the same error.
/// example: value = -4.5
/// Severity of a problem as defined RFC5424 of the Syslog standard, see https://tools.ietf.org/html/rfc5424'
func (rcv *Problem) Severity() Severity {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(20))
	if o != 0 {
		return Severity(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 0
}

/// Severity of a problem as defined RFC5424 of the Syslog standard, see https://tools.ietf.org/html/rfc5424'
func (rcv *Problem) MutateSeverity(n Severity) bool {
	return rcv._tab.MutateInt8Slot(20, int8(n))
}

/// Collection of links to fix the problem. E.g. links to online user manual, to an online community (using tags) or a developer chat (e.g. Slack).
func (rcv *Problem) Links(j int) []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(22))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.ByteVector(a + flatbuffers.UOffsetT(j*4))
	}
	return nil
}

func (rcv *Problem) LinksLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(22))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

/// Collection of links to fix the problem. E.g. links to online user manual, to an online community (using tags) or a developer chat (e.g. Slack).
/// Resource or entity which causes the problem
func (rcv *Problem) Entity() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(24))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Resource or entity which causes the problem
/// More information about the problem (key/value pair)
func (rcv *Problem) MoreInfo(j int) byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(26))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetByte(a + flatbuffers.UOffsetT(j*1))
	}
	return 0
}

func (rcv *Problem) MoreInfoLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(26))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *Problem) MoreInfoBytes() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(26))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// More information about the problem (key/value pair)
func (rcv *Problem) MutateMoreInfo(j int, n byte) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(26))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateByte(a+flatbuffers.UOffsetT(j*1), n)
	}
	return false
}

/// Cause of the problem
func (rcv *Problem) Cause(obj *Problem, j int) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(28))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		return true
	}
	return false
}

func (rcv *Problem) CauseLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(28))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

/// Cause of the problem
func ProblemStart(builder *flatbuffers.Builder) {
	builder.StartObject(13)
}
func ProblemAddType(builder *flatbuffers.Builder, type_ flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(type_), 0)
}
func ProblemAddTitle(builder *flatbuffers.Builder, title flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(title), 0)
}
func ProblemAddStatus(builder *flatbuffers.Builder, status int32) {
	builder.PrependInt32Slot(2, status, 0)
}
func ProblemAddDetail(builder *flatbuffers.Builder, detail flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(detail), 0)
}
func ProblemAddInstance(builder *flatbuffers.Builder, instance flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(instance), 0)
}
func ProblemAddMainDiagnosisCode(builder *flatbuffers.Builder, mainDiagnosisCode flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(mainDiagnosisCode), 0)
}
func ProblemAddDetailedDiagnosisCode(builder *flatbuffers.Builder, detailedDiagnosisCode flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(6, flatbuffers.UOffsetT(detailedDiagnosisCode), 0)
}
func ProblemAddDynamicDescription(builder *flatbuffers.Builder, dynamicDescription flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(7, flatbuffers.UOffsetT(dynamicDescription), 0)
}
func ProblemAddSeverity(builder *flatbuffers.Builder, severity Severity) {
	builder.PrependInt8Slot(8, int8(severity), 0)
}
func ProblemAddLinks(builder *flatbuffers.Builder, links flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(9, flatbuffers.UOffsetT(links), 0)
}
func ProblemStartLinksVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func ProblemAddEntity(builder *flatbuffers.Builder, entity flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(10, flatbuffers.UOffsetT(entity), 0)
}
func ProblemAddMoreInfo(builder *flatbuffers.Builder, moreInfo flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(11, flatbuffers.UOffsetT(moreInfo), 0)
}
func ProblemStartMoreInfoVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(1, numElems, 1)
}
func ProblemAddCause(builder *flatbuffers.Builder, cause flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(12, flatbuffers.UOffsetT(cause), 0)
}
func ProblemStartCauseVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func ProblemEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
