// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package client

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

type ClientConfigurationT struct {
	Name string
	EndpointUrl string
	SessionConfiguration *SessionConfigurationT
	TimeoutConfiguration *TimeoutConfigurationT
	Persistent bool
}

func (t *ClientConfigurationT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	nameOffset := builder.CreateString(t.Name)
	endpointUrlOffset := builder.CreateString(t.EndpointUrl)
	sessionConfigurationOffset := t.SessionConfiguration.Pack(builder)
	timeoutConfigurationOffset := t.TimeoutConfiguration.Pack(builder)
	ClientConfigurationStart(builder)
	ClientConfigurationAddName(builder, nameOffset)
	ClientConfigurationAddEndpointUrl(builder, endpointUrlOffset)
	ClientConfigurationAddSessionConfiguration(builder, sessionConfigurationOffset)
	ClientConfigurationAddTimeoutConfiguration(builder, timeoutConfigurationOffset)
	ClientConfigurationAddPersistent(builder, t.Persistent)
	return ClientConfigurationEnd(builder)
}

func (rcv *ClientConfiguration) UnPackTo(t *ClientConfigurationT) {
	t.Name = string(rcv.Name())
	t.EndpointUrl = string(rcv.EndpointUrl())
	t.SessionConfiguration = rcv.SessionConfiguration(nil).UnPack()
	t.TimeoutConfiguration = rcv.TimeoutConfiguration(nil).UnPack()
	t.Persistent = rcv.Persistent()
}

func (rcv *ClientConfiguration) UnPack() *ClientConfigurationT {
	if rcv == nil { return nil }
	t := &ClientConfigurationT{}
	rcv.UnPackTo(t)
	return t
}

type ClientConfiguration struct {
	_tab flatbuffers.Table
}

func GetRootAsClientConfiguration(buf []byte, offset flatbuffers.UOffsetT) *ClientConfiguration {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &ClientConfiguration{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsClientConfiguration(buf []byte, offset flatbuffers.UOffsetT) *ClientConfiguration {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &ClientConfiguration{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *ClientConfiguration) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *ClientConfiguration) Table() flatbuffers.Table {
	return rcv._tab
}

/// Unique clientname (required)
func (rcv *ClientConfiguration) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Unique clientname (required)
/// Endpoint-url of the OPC UA Server to which the client should connect to (required)
func (rcv *ClientConfiguration) EndpointUrl() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Endpoint-url of the OPC UA Server to which the client should connect to (required)
/// Session configuration for the client instance
func (rcv *ClientConfiguration) SessionConfiguration(obj *SessionConfiguration) *SessionConfiguration {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SessionConfiguration)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// Session configuration for the client instance
/// Timeout configuration for the client instance
func (rcv *ClientConfiguration) TimeoutConfiguration(obj *TimeoutConfiguration) *TimeoutConfiguration {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(TimeoutConfiguration)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// Timeout configuration for the client instance
/// Determines whether configuration data of the client data is persisted and loaded upon the next start of the app or the control
func (rcv *ClientConfiguration) Persistent() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

/// Determines whether configuration data of the client data is persisted and loaded upon the next start of the app or the control
func (rcv *ClientConfiguration) MutatePersistent(n bool) bool {
	return rcv._tab.MutateBoolSlot(12, n)
}

func ClientConfigurationStart(builder *flatbuffers.Builder) {
	builder.StartObject(5)
}
func ClientConfigurationAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func ClientConfigurationAddEndpointUrl(builder *flatbuffers.Builder, endpointUrl flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(endpointUrl), 0)
}
func ClientConfigurationAddSessionConfiguration(builder *flatbuffers.Builder, sessionConfiguration flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(sessionConfiguration), 0)
}
func ClientConfigurationAddTimeoutConfiguration(builder *flatbuffers.Builder, timeoutConfiguration flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(timeoutConfiguration), 0)
}
func ClientConfigurationAddPersistent(builder *flatbuffers.Builder, persistent bool) {
	builder.PrependBoolSlot(4, persistent, false)
}
func ClientConfigurationEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
