// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package fbs

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

/// Callable configurations of a callable factory
type CallableConfigurationT struct {
	Alias string
	Sync *SyncPointsT
	Arguments []string
	Watchdog CallableWdgConfig
	Task *TaskSpecsT
}

func (t *CallableConfigurationT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	aliasOffset := builder.CreateString(t.Alias)
	syncOffset := t.Sync.Pack(builder)
	argumentsOffset := flatbuffers.UOffsetT(0)
	if t.Arguments != nil {
		argumentsLength := len(t.Arguments)
		argumentsOffsets := make([]flatbuffers.UOffsetT, argumentsLength)
		for j := 0; j < argumentsLength; j++ {
			argumentsOffsets[j] = builder.CreateString(t.Arguments[j])
		}
		CallableConfigurationStartArgumentsVector(builder, argumentsLength)
		for j := argumentsLength - 1; j >= 0; j-- {
			builder.PrependUOffsetT(argumentsOffsets[j])
		}
		argumentsOffset = builder.EndVector(argumentsLength)
	}
	taskOffset := t.Task.Pack(builder)
	CallableConfigurationStart(builder)
	CallableConfigurationAddAlias(builder, aliasOffset)
	CallableConfigurationAddSync(builder, syncOffset)
	CallableConfigurationAddArguments(builder, argumentsOffset)
	CallableConfigurationAddWatchdog(builder, t.Watchdog)
	CallableConfigurationAddTask(builder, taskOffset)
	return CallableConfigurationEnd(builder)
}

func (rcv *CallableConfiguration) UnPackTo(t *CallableConfigurationT) {
	t.Alias = string(rcv.Alias())
	t.Sync = rcv.Sync(nil).UnPack()
	argumentsLength := rcv.ArgumentsLength()
	t.Arguments = make([]string, argumentsLength)
	for j := 0; j < argumentsLength; j++ {
		t.Arguments[j] = string(rcv.Arguments(j))
	}
	t.Watchdog = rcv.Watchdog()
	t.Task = rcv.Task(nil).UnPack()
}

func (rcv *CallableConfiguration) UnPack() *CallableConfigurationT {
	if rcv == nil { return nil }
	t := &CallableConfigurationT{}
	rcv.UnPackTo(t)
	return t
}

type CallableConfiguration struct {
	_tab flatbuffers.Table
}

func GetRootAsCallableConfiguration(buf []byte, offset flatbuffers.UOffsetT) *CallableConfiguration {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &CallableConfiguration{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsCallableConfiguration(buf []byte, offset flatbuffers.UOffsetT) *CallableConfiguration {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &CallableConfiguration{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *CallableConfiguration) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *CallableConfiguration) Table() flatbuffers.Table {
	return rcv._tab
}

/// Alias of callable, human readable replacement of callable ID, any alphanumeric character [a-zA-Z_][a-zA-Z0-9-._]+
func (rcv *CallableConfiguration) Alias() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Alias of callable, human readable replacement of callable ID, any alphanumeric character [a-zA-Z_][a-zA-Z0-9-._]+
/// Synchronization points to specify the call sequence
func (rcv *CallableConfiguration) Sync(obj *SyncPoints) *SyncPoints {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SyncPoints)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// Synchronization points to specify the call sequence
/// List of arguments to create the callable, for further information see application description of the callable factory
func (rcv *CallableConfiguration) Arguments(j int) []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.ByteVector(a + flatbuffers.UOffsetT(j*4))
	}
	return nil
}

func (rcv *CallableConfiguration) ArgumentsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

/// List of arguments to create the callable, for further information see application description of the callable factory
/// Requirement of the callable that a watchdog is present
func (rcv *CallableConfiguration) Watchdog() CallableWdgConfig {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return CallableWdgConfig(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 3
}

/// Requirement of the callable that a watchdog is present
func (rcv *CallableConfiguration) MutateWatchdog(n CallableWdgConfig) bool {
	return rcv._tab.MutateInt8Slot(10, int8(n))
}

/// Task specifications to defined callable environment
func (rcv *CallableConfiguration) Task(obj *TaskSpecs) *TaskSpecs {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(TaskSpecs)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// Task specifications to defined callable environment
func CallableConfigurationStart(builder *flatbuffers.Builder) {
	builder.StartObject(5)
}
func CallableConfigurationAddAlias(builder *flatbuffers.Builder, alias flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(alias), 0)
}
func CallableConfigurationAddSync(builder *flatbuffers.Builder, sync flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(sync), 0)
}
func CallableConfigurationAddArguments(builder *flatbuffers.Builder, arguments flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(arguments), 0)
}
func CallableConfigurationStartArgumentsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func CallableConfigurationAddWatchdog(builder *flatbuffers.Builder, watchdog CallableWdgConfig) {
	builder.PrependInt8Slot(3, int8(watchdog), 3)
}
func CallableConfigurationAddTask(builder *flatbuffers.Builder, task flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(task), 0)
}
func CallableConfigurationEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
