// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package fbtypes

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

/// parameters and data of the active command
type KinCmdValuesT struct {
	TargetPos []float64
	Lim *DynamicLimitsStateT
	CoordSys string
	CmdId uint64
	Src *CmdSourceT
}

func (t *KinCmdValuesT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	targetPosOffset := flatbuffers.UOffsetT(0)
	if t.TargetPos != nil {
		targetPosLength := len(t.TargetPos)
		KinCmdValuesStartTargetPosVector(builder, targetPosLength)
		for j := targetPosLength - 1; j >= 0; j-- {
			builder.PrependFloat64(t.TargetPos[j])
		}
		targetPosOffset = builder.EndVector(targetPosLength)
	}
	limOffset := t.Lim.Pack(builder)
	coordSysOffset := builder.CreateString(t.CoordSys)
	srcOffset := t.Src.Pack(builder)
	KinCmdValuesStart(builder)
	KinCmdValuesAddTargetPos(builder, targetPosOffset)
	KinCmdValuesAddLim(builder, limOffset)
	KinCmdValuesAddCoordSys(builder, coordSysOffset)
	KinCmdValuesAddCmdId(builder, t.CmdId)
	KinCmdValuesAddSrc(builder, srcOffset)
	return KinCmdValuesEnd(builder)
}

func (rcv *KinCmdValues) UnPackTo(t *KinCmdValuesT) {
	targetPosLength := rcv.TargetPosLength()
	t.TargetPos = make([]float64, targetPosLength)
	for j := 0; j < targetPosLength; j++ {
		t.TargetPos[j] = rcv.TargetPos(j)
	}
	t.Lim = rcv.Lim(nil).UnPack()
	t.CoordSys = string(rcv.CoordSys())
	t.CmdId = rcv.CmdId()
	t.Src = rcv.Src(nil).UnPack()
}

func (rcv *KinCmdValues) UnPack() *KinCmdValuesT {
	if rcv == nil { return nil }
	t := &KinCmdValuesT{}
	rcv.UnPackTo(t)
	return t
}

type KinCmdValues struct {
	_tab flatbuffers.Table
}

func GetRootAsKinCmdValues(buf []byte, offset flatbuffers.UOffsetT) *KinCmdValues {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &KinCmdValues{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsKinCmdValues(buf []byte, offset flatbuffers.UOffsetT) *KinCmdValues {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &KinCmdValues{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *KinCmdValues) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *KinCmdValues) Table() flatbuffers.Table {
	return rcv._tab
}

/// commanded target position as vector
func (rcv *KinCmdValues) TargetPos(j int) float64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetFloat64(a + flatbuffers.UOffsetT(j*8))
	}
	return 0
}

func (rcv *KinCmdValues) TargetPosLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

/// commanded target position as vector
func (rcv *KinCmdValues) MutateTargetPos(j int, n float64) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateFloat64(a+flatbuffers.UOffsetT(j*8), n)
	}
	return false
}

/// dynamic limits for the motion of this command
func (rcv *KinCmdValues) Lim(obj *DynamicLimitsState) *DynamicLimitsState {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(DynamicLimitsState)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// dynamic limits for the motion of this command
/// coordinate system of the target position
func (rcv *KinCmdValues) CoordSys() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// coordinate system of the target position
/// command ID of the active command
func (rcv *KinCmdValues) CmdId() uint64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.GetUint64(o + rcv._tab.Pos)
	}
	return 0
}

/// command ID of the active command
func (rcv *KinCmdValues) MutateCmdId(n uint64) bool {
	return rcv._tab.MutateUint64Slot(10, n)
}

/// command source (by which interface was this command inserted into the system (e.g. "PLC"))
func (rcv *KinCmdValues) Src(obj *CmdSource) *CmdSource {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(CmdSource)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// command source (by which interface was this command inserted into the system (e.g. "PLC"))
func KinCmdValuesStart(builder *flatbuffers.Builder) {
	builder.StartObject(5)
}
func KinCmdValuesAddTargetPos(builder *flatbuffers.Builder, targetPos flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(targetPos), 0)
}
func KinCmdValuesStartTargetPosVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(8, numElems, 8)
}
func KinCmdValuesAddLim(builder *flatbuffers.Builder, lim flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(lim), 0)
}
func KinCmdValuesAddCoordSys(builder *flatbuffers.Builder, coordSys flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(coordSys), 0)
}
func KinCmdValuesAddCmdId(builder *flatbuffers.Builder, cmdId uint64) {
	builder.PrependUint64Slot(3, cmdId, 0)
}
func KinCmdValuesAddSrc(builder *flatbuffers.Builder, src flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(src), 0)
}
func KinCmdValuesEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
