/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/rbac/v1"
	rbacv1 "k8s.io/client-go/applyconfigurations/rbac/v1"
	gentype "k8s.io/client-go/gentype"
	typedrbacv1 "k8s.io/client-go/kubernetes/typed/rbac/v1"
)

// fakeRoles implements RoleInterface
type fakeRoles struct {
	*gentype.FakeClientWithListAndApply[*v1.Role, *v1.RoleList, *rbacv1.RoleApplyConfiguration]
	Fake *FakeRbacV1
}

func newFakeRoles(fake *FakeRbacV1, namespace string) typedrbacv1.RoleInterface {
	return &fakeRoles{
		gentype.NewFakeClientWithListAndApply[*v1.Role, *v1.RoleList, *rbacv1.RoleApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("roles"),
			v1.SchemeGroupVersion.WithKind("Role"),
			func() *v1.Role { return &v1.Role{} },
			func() *v1.RoleList { return &v1.RoleList{} },
			func(dst, src *v1.RoleList) { dst.ListMeta = src.ListMeta },
			func(list *v1.RoleList) []*v1.Role { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.RoleList, items []*v1.Role) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
