package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBlockchainInfo invokes the baas.DescribeBlockchainInfo API synchronously
// api document: https://help.aliyun.com/api/baas/describeblockchaininfo.html
func (client *Client) DescribeBlockchainInfo(request *DescribeBlockchainInfoRequest) (response *DescribeBlockchainInfoResponse, err error) {
	response = CreateDescribeBlockchainInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBlockchainInfoWithChan invokes the baas.DescribeBlockchainInfo API asynchronously
// api document: https://help.aliyun.com/api/baas/describeblockchaininfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBlockchainInfoWithChan(request *DescribeBlockchainInfoRequest) (<-chan *DescribeBlockchainInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeBlockchainInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBlockchainInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBlockchainInfoWithCallback invokes the baas.DescribeBlockchainInfo API asynchronously
// api document: https://help.aliyun.com/api/baas/describeblockchaininfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBlockchainInfoWithCallback(request *DescribeBlockchainInfoRequest, callback func(response *DescribeBlockchainInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBlockchainInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeBlockchainInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBlockchainInfoRequest is the request struct for api DescribeBlockchainInfo
type DescribeBlockchainInfoRequest struct {
	*requests.RpcRequest
	Bizid string `position:"Body" name:"Bizid"`
}

// DescribeBlockchainInfoResponse is the response struct for api DescribeBlockchainInfo
type DescribeBlockchainInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeBlockchainInfoRequest creates a request to invoke DescribeBlockchainInfo API
func CreateDescribeBlockchainInfoRequest() (request *DescribeBlockchainInfoRequest) {
	request = &DescribeBlockchainInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeBlockchainInfo", "", "")
	return
}

// CreateDescribeBlockchainInfoResponse creates a response to parse from DescribeBlockchainInfo response
func CreateDescribeBlockchainInfoResponse() (response *DescribeBlockchainInfoResponse) {
	response = &DescribeBlockchainInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
