package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMaterials invokes the cloudauth.GetMaterials API synchronously
// api document: https://help.aliyun.com/api/cloudauth/getmaterials.html
func (client *Client) GetMaterials(request *GetMaterialsRequest) (response *GetMaterialsResponse, err error) {
	response = CreateGetMaterialsResponse()
	err = client.DoAction(request, response)
	return
}

// GetMaterialsWithChan invokes the cloudauth.GetMaterials API asynchronously
// api document: https://help.aliyun.com/api/cloudauth/getmaterials.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMaterialsWithChan(request *GetMaterialsRequest) (<-chan *GetMaterialsResponse, <-chan error) {
	responseChan := make(chan *GetMaterialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMaterials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMaterialsWithCallback invokes the cloudauth.GetMaterials API asynchronously
// api document: https://help.aliyun.com/api/cloudauth/getmaterials.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMaterialsWithCallback(request *GetMaterialsRequest, callback func(response *GetMaterialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMaterialsResponse
		var err error
		defer close(result)
		response, err = client.GetMaterials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMaterialsRequest is the request struct for api GetMaterials
type GetMaterialsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Biz             string           `position:"Query" name:"Biz"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	TicketId        string           `position:"Query" name:"TicketId"`
}

// GetMaterialsResponse is the response struct for api GetMaterials
type GetMaterialsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetMaterialsRequest creates a request to invoke GetMaterials API
func CreateGetMaterialsRequest() (request *GetMaterialsRequest) {
	request = &GetMaterialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2018-09-16", "GetMaterials", "CloudAuth", "openAPI")
	return
}

// CreateGetMaterialsResponse creates a response to parse from GetMaterials response
func CreateGetMaterialsResponse() (response *GetMaterialsResponse) {
	response = &GetMaterialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
