package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyMonitoringTemplate invokes the cms.ApplyMonitoringTemplate API synchronously
// api document: https://help.aliyun.com/api/cms/applymonitoringtemplate.html
func (client *Client) ApplyMonitoringTemplate(request *ApplyMonitoringTemplateRequest) (response *ApplyMonitoringTemplateResponse, err error) {
	response = CreateApplyMonitoringTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyMonitoringTemplateWithChan invokes the cms.ApplyMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/applymonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyMonitoringTemplateWithChan(request *ApplyMonitoringTemplateRequest) (<-chan *ApplyMonitoringTemplateResponse, <-chan error) {
	responseChan := make(chan *ApplyMonitoringTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyMonitoringTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyMonitoringTemplateWithCallback invokes the cms.ApplyMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/applymonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyMonitoringTemplateWithCallback(request *ApplyMonitoringTemplateRequest, callback func(response *ApplyMonitoringTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyMonitoringTemplateResponse
		var err error
		defer close(result)
		response, err = client.ApplyMonitoringTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyMonitoringTemplateRequest is the request struct for api ApplyMonitoringTemplate
type ApplyMonitoringTemplateRequest struct {
	*requests.RpcRequest
	EnableStartTime requests.Integer `position:"Query" name:"EnableStartTime"`
	ApplyMode       string           `position:"Query" name:"ApplyMode"`
	Webhook         string           `position:"Query" name:"Webhook"`
	TemplateIds     string           `position:"Query" name:"TemplateIds"`
	EnableEndTime   requests.Integer `position:"Query" name:"EnableEndTime"`
	GroupId         requests.Integer `position:"Query" name:"GroupId"`
	NotifyLevel     requests.Integer `position:"Query" name:"NotifyLevel"`
	SilenceTime     requests.Integer `position:"Query" name:"SilenceTime"`
}

// ApplyMonitoringTemplateResponse is the response struct for api ApplyMonitoringTemplate
type ApplyMonitoringTemplateResponse struct {
	*responses.BaseResponse
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	Success      bool     `json:"Success" xml:"Success"`
	ErrorCode    int      `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string   `json:"ErrorMessage" xml:"ErrorMessage"`
	Resource     Resource `json:"Resource" xml:"Resource"`
}

// CreateApplyMonitoringTemplateRequest creates a request to invoke ApplyMonitoringTemplate API
func CreateApplyMonitoringTemplateRequest() (request *ApplyMonitoringTemplateRequest) {
	request = &ApplyMonitoringTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "ApplyMonitoringTemplate", "cms", "openAPI")
	return
}

// CreateApplyMonitoringTemplateResponse creates a response to parse from ApplyMonitoringTemplate response
func CreateApplyMonitoringTemplateResponse() (response *ApplyMonitoringTemplateResponse) {
	response = &ApplyMonitoringTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
