package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMetricMeta invokes the cms.QueryMetricMeta API synchronously
// api document: https://help.aliyun.com/api/cms/querymetricmeta.html
func (client *Client) QueryMetricMeta(request *QueryMetricMetaRequest) (response *QueryMetricMetaResponse, err error) {
	response = CreateQueryMetricMetaResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMetricMetaWithChan invokes the cms.QueryMetricMeta API asynchronously
// api document: https://help.aliyun.com/api/cms/querymetricmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMetricMetaWithChan(request *QueryMetricMetaRequest) (<-chan *QueryMetricMetaResponse, <-chan error) {
	responseChan := make(chan *QueryMetricMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMetricMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMetricMetaWithCallback invokes the cms.QueryMetricMeta API asynchronously
// api document: https://help.aliyun.com/api/cms/querymetricmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMetricMetaWithCallback(request *QueryMetricMetaRequest, callback func(response *QueryMetricMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMetricMetaResponse
		var err error
		defer close(result)
		response, err = client.QueryMetricMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMetricMetaRequest is the request struct for api QueryMetricMeta
type QueryMetricMetaRequest struct {
	*requests.RpcRequest
	Metric     string           `position:"Query" name:"Metric"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Project    string           `position:"Query" name:"Project"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Labels     string           `position:"Query" name:"Labels"`
}

// QueryMetricMetaResponse is the response struct for api QueryMetricMeta
type QueryMetricMetaResponse struct {
	*responses.BaseResponse
	RequestId    string                     `json:"RequestId" xml:"RequestId"`
	Success      bool                       `json:"Success" xml:"Success"`
	ErrorCode    string                     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                     `json:"ErrorMessage" xml:"ErrorMessage"`
	Resources    ResourcesInQueryMetricMeta `json:"Resources" xml:"Resources"`
}

// CreateQueryMetricMetaRequest creates a request to invoke QueryMetricMeta API
func CreateQueryMetricMetaRequest() (request *QueryMetricMetaRequest) {
	request = &QueryMetricMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QueryMetricMeta", "cms", "openAPI")
	return
}

// CreateQueryMetricMetaResponse creates a response to parse from QueryMetricMeta response
func CreateQueryMetricMetaResponse() (response *QueryMetricMetaResponse) {
	response = &QueryMetricMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
