package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryStaticsResponseTime invokes the cms.QueryStaticsResponseTime API synchronously
// api document: https://help.aliyun.com/api/cms/querystaticsresponsetime.html
func (client *Client) QueryStaticsResponseTime(request *QueryStaticsResponseTimeRequest) (response *QueryStaticsResponseTimeResponse, err error) {
	response = CreateQueryStaticsResponseTimeResponse()
	err = client.DoAction(request, response)
	return
}

// QueryStaticsResponseTimeWithChan invokes the cms.QueryStaticsResponseTime API asynchronously
// api document: https://help.aliyun.com/api/cms/querystaticsresponsetime.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryStaticsResponseTimeWithChan(request *QueryStaticsResponseTimeRequest) (<-chan *QueryStaticsResponseTimeResponse, <-chan error) {
	responseChan := make(chan *QueryStaticsResponseTimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryStaticsResponseTime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryStaticsResponseTimeWithCallback invokes the cms.QueryStaticsResponseTime API asynchronously
// api document: https://help.aliyun.com/api/cms/querystaticsresponsetime.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryStaticsResponseTimeWithCallback(request *QueryStaticsResponseTimeRequest, callback func(response *QueryStaticsResponseTimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryStaticsResponseTimeResponse
		var err error
		defer close(result)
		response, err = client.QueryStaticsResponseTime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryStaticsResponseTimeRequest is the request struct for api QueryStaticsResponseTime
type QueryStaticsResponseTimeRequest struct {
	*requests.RpcRequest
	TimeRange string `position:"Query" name:"TimeRange"`
	TaskId    string `position:"Query" name:"TaskId"`
}

// QueryStaticsResponseTimeResponse is the response struct for api QueryStaticsResponseTime
type QueryStaticsResponseTimeResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateQueryStaticsResponseTimeRequest creates a request to invoke QueryStaticsResponseTime API
func CreateQueryStaticsResponseTimeRequest() (request *QueryStaticsResponseTimeRequest) {
	request = &QueryStaticsResponseTimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QueryStaticsResponseTime", "cms", "openAPI")
	return
}

// CreateQueryStaticsResponseTimeResponse creates a response to parse from QueryStaticsResponseTime response
func CreateQueryStaticsResponseTimeResponse() (response *QueryStaticsResponseTimeResponse) {
	response = &QueryStaticsResponseTimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
