package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateMonitoringTemplate invokes the cms.UpdateMonitoringTemplate API synchronously
// api document: https://help.aliyun.com/api/cms/updatemonitoringtemplate.html
func (client *Client) UpdateMonitoringTemplate(request *UpdateMonitoringTemplateRequest) (response *UpdateMonitoringTemplateResponse, err error) {
	response = CreateUpdateMonitoringTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateMonitoringTemplateWithChan invokes the cms.UpdateMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/updatemonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateMonitoringTemplateWithChan(request *UpdateMonitoringTemplateRequest) (<-chan *UpdateMonitoringTemplateResponse, <-chan error) {
	responseChan := make(chan *UpdateMonitoringTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateMonitoringTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateMonitoringTemplateWithCallback invokes the cms.UpdateMonitoringTemplate API asynchronously
// api document: https://help.aliyun.com/api/cms/updatemonitoringtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateMonitoringTemplateWithCallback(request *UpdateMonitoringTemplateRequest, callback func(response *UpdateMonitoringTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateMonitoringTemplateResponse
		var err error
		defer close(result)
		response, err = client.UpdateMonitoringTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateMonitoringTemplateRequest is the request struct for api UpdateMonitoringTemplate
type UpdateMonitoringTemplateRequest struct {
	*requests.RpcRequest
	EventRuleTemplatesJson string           `position:"Query" name:"EventRuleTemplatesJson"`
	Name                   string           `position:"Query" name:"Name"`
	RestVersion            requests.Integer `position:"Query" name:"RestVersion"`
	Description            string           `position:"Query" name:"Description"`
	Id                     requests.Integer `position:"Query" name:"Id"`
	AlertTemplatesJson     string           `position:"Query" name:"AlertTemplatesJson"`
}

// UpdateMonitoringTemplateResponse is the response struct for api UpdateMonitoringTemplate
type UpdateMonitoringTemplateResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateMonitoringTemplateRequest creates a request to invoke UpdateMonitoringTemplate API
func CreateUpdateMonitoringTemplateRequest() (request *UpdateMonitoringTemplateRequest) {
	request = &UpdateMonitoringTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "UpdateMonitoringTemplate", "cms", "openAPI")
	return
}

// CreateUpdateMonitoringTemplateResponse creates a response to parse from UpdateMonitoringTemplate response
func CreateUpdateMonitoringTemplateResponse() (response *UpdateMonitoringTemplateResponse) {
	response = &UpdateMonitoringTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
