package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryApplicationStatus invokes the edas.QueryApplicationStatus API synchronously
// api document: https://help.aliyun.com/api/edas/queryapplicationstatus.html
func (client *Client) QueryApplicationStatus(request *QueryApplicationStatusRequest) (response *QueryApplicationStatusResponse, err error) {
	response = CreateQueryApplicationStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryApplicationStatusWithChan invokes the edas.QueryApplicationStatus API asynchronously
// api document: https://help.aliyun.com/api/edas/queryapplicationstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryApplicationStatusWithChan(request *QueryApplicationStatusRequest) (<-chan *QueryApplicationStatusResponse, <-chan error) {
	responseChan := make(chan *QueryApplicationStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryApplicationStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryApplicationStatusWithCallback invokes the edas.QueryApplicationStatus API asynchronously
// api document: https://help.aliyun.com/api/edas/queryapplicationstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryApplicationStatusWithCallback(request *QueryApplicationStatusRequest, callback func(response *QueryApplicationStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryApplicationStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryApplicationStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryApplicationStatusRequest is the request struct for api QueryApplicationStatus
type QueryApplicationStatusRequest struct {
	*requests.RoaRequest
	AppId string `position:"Query" name:"AppId"`
}

// QueryApplicationStatusResponse is the response struct for api QueryApplicationStatus
type QueryApplicationStatusResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	AppInfo   AppInfo `json:"AppInfo" xml:"AppInfo"`
}

// CreateQueryApplicationStatusRequest creates a request to invoke QueryApplicationStatus API
func CreateQueryApplicationStatusRequest() (request *QueryApplicationStatusRequest) {
	request = &QueryApplicationStatusRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "QueryApplicationStatus", "/pop/v5/app/app_status", "", "")
	request.Method = requests.GET
	return
}

// CreateQueryApplicationStatusResponse creates a response to parse from QueryApplicationStatus response
func CreateQueryApplicationStatusResponse() (response *QueryApplicationStatusResponse) {
	response = &QueryApplicationStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
