package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserPassword invokes the emr.CreateUserPassword API synchronously
// api document: https://help.aliyun.com/api/emr/createuserpassword.html
func (client *Client) CreateUserPassword(request *CreateUserPasswordRequest) (response *CreateUserPasswordResponse, err error) {
	response = CreateCreateUserPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserPasswordWithChan invokes the emr.CreateUserPassword API asynchronously
// api document: https://help.aliyun.com/api/emr/createuserpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUserPasswordWithChan(request *CreateUserPasswordRequest) (<-chan *CreateUserPasswordResponse, <-chan error) {
	responseChan := make(chan *CreateUserPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserPasswordWithCallback invokes the emr.CreateUserPassword API asynchronously
// api document: https://help.aliyun.com/api/emr/createuserpassword.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUserPasswordWithCallback(request *CreateUserPasswordRequest, callback func(response *CreateUserPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserPasswordResponse
		var err error
		defer close(result)
		response, err = client.CreateUserPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserPasswordRequest is the request struct for api CreateUserPassword
type CreateUserPasswordRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer              `position:"Query" name:"ResourceOwnerId"`
	Password        string                        `position:"Query" name:"Password"`
	ClusterId       string                        `position:"Query" name:"ClusterId"`
	UserInfo        *[]CreateUserPasswordUserInfo `position:"Query" name:"UserInfo"  type:"Repeated"`
}

// CreateUserPasswordUserInfo is a repeated param struct in CreateUserPasswordRequest
type CreateUserPasswordUserInfo struct {
	Type      string `name:"Type"`
	GroupName string `name:"GroupName"`
	UserId    string `name:"UserId"`
	UserName  string `name:"UserName"`
}

// CreateUserPasswordResponse is the response struct for api CreateUserPassword
type CreateUserPasswordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateUserPasswordRequest creates a request to invoke CreateUserPassword API
func CreateCreateUserPasswordRequest() (request *CreateUserPasswordRequest) {
	request = &CreateUserPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CreateUserPassword", "emr", "openAPI")
	return
}

// CreateCreateUserPasswordResponse creates a response to parse from CreateUserPassword response
func CreateCreateUserPasswordResponse() (response *CreateUserPasswordResponse) {
	response = &CreateUserPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
