package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VoiceAsyncScan invokes the green.VoiceAsyncScan API synchronously
// api document: https://help.aliyun.com/api/green/voiceasyncscan.html
func (client *Client) VoiceAsyncScan(request *VoiceAsyncScanRequest) (response *VoiceAsyncScanResponse, err error) {
	response = CreateVoiceAsyncScanResponse()
	err = client.DoAction(request, response)
	return
}

// VoiceAsyncScanWithChan invokes the green.VoiceAsyncScan API asynchronously
// api document: https://help.aliyun.com/api/green/voiceasyncscan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VoiceAsyncScanWithChan(request *VoiceAsyncScanRequest) (<-chan *VoiceAsyncScanResponse, <-chan error) {
	responseChan := make(chan *VoiceAsyncScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VoiceAsyncScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VoiceAsyncScanWithCallback invokes the green.VoiceAsyncScan API asynchronously
// api document: https://help.aliyun.com/api/green/voiceasyncscan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) VoiceAsyncScanWithCallback(request *VoiceAsyncScanRequest, callback func(response *VoiceAsyncScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VoiceAsyncScanResponse
		var err error
		defer close(result)
		response, err = client.VoiceAsyncScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VoiceAsyncScanRequest is the request struct for api VoiceAsyncScan
type VoiceAsyncScanRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VoiceAsyncScanResponse is the response struct for api VoiceAsyncScan
type VoiceAsyncScanResponse struct {
	*responses.BaseResponse
}

// CreateVoiceAsyncScanRequest creates a request to invoke VoiceAsyncScan API
func CreateVoiceAsyncScanRequest() (request *VoiceAsyncScanRequest) {
	request = &VoiceAsyncScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VoiceAsyncScan", "/green/voice/asyncscan", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVoiceAsyncScanResponse creates a response to parse from VoiceAsyncScan response
func CreateVoiceAsyncScanResponse() (response *VoiceAsyncScanResponse) {
	response = &VoiceAsyncScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
