package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveSpecificConfig invokes the live.DeleteLiveSpecificConfig API synchronously
// api document: https://help.aliyun.com/api/live/deletelivespecificconfig.html
func (client *Client) DeleteLiveSpecificConfig(request *DeleteLiveSpecificConfigRequest) (response *DeleteLiveSpecificConfigResponse, err error) {
	response = CreateDeleteLiveSpecificConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveSpecificConfigWithChan invokes the live.DeleteLiveSpecificConfig API asynchronously
// api document: https://help.aliyun.com/api/live/deletelivespecificconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveSpecificConfigWithChan(request *DeleteLiveSpecificConfigRequest) (<-chan *DeleteLiveSpecificConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveSpecificConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveSpecificConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveSpecificConfigWithCallback invokes the live.DeleteLiveSpecificConfig API asynchronously
// api document: https://help.aliyun.com/api/live/deletelivespecificconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLiveSpecificConfigWithCallback(request *DeleteLiveSpecificConfigRequest, callback func(response *DeleteLiveSpecificConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveSpecificConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveSpecificConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveSpecificConfigRequest is the request struct for api DeleteLiveSpecificConfig
type DeleteLiveSpecificConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	ConfigId      string           `position:"Query" name:"ConfigId"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteLiveSpecificConfigResponse is the response struct for api DeleteLiveSpecificConfig
type DeleteLiveSpecificConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveSpecificConfigRequest creates a request to invoke DeleteLiveSpecificConfig API
func CreateDeleteLiveSpecificConfigRequest() (request *DeleteLiveSpecificConfigRequest) {
	request = &DeleteLiveSpecificConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveSpecificConfig", "live", "openAPI")
	return
}

// CreateDeleteLiveSpecificConfigResponse creates a response to parse from DeleteLiveSpecificConfig response
func CreateDeleteLiveSpecificConfigResponse() (response *DeleteLiveSpecificConfigResponse) {
	response = &DeleteLiveSpecificConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
