package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSmartAccessGatewayHa invokes the smartag.DescribeSmartAccessGatewayHa API synchronously
// api document: https://help.aliyun.com/api/smartag/describesmartaccessgatewayha.html
func (client *Client) DescribeSmartAccessGatewayHa(request *DescribeSmartAccessGatewayHaRequest) (response *DescribeSmartAccessGatewayHaResponse, err error) {
	response = CreateDescribeSmartAccessGatewayHaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSmartAccessGatewayHaWithChan invokes the smartag.DescribeSmartAccessGatewayHa API asynchronously
// api document: https://help.aliyun.com/api/smartag/describesmartaccessgatewayha.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSmartAccessGatewayHaWithChan(request *DescribeSmartAccessGatewayHaRequest) (<-chan *DescribeSmartAccessGatewayHaResponse, <-chan error) {
	responseChan := make(chan *DescribeSmartAccessGatewayHaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSmartAccessGatewayHa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSmartAccessGatewayHaWithCallback invokes the smartag.DescribeSmartAccessGatewayHa API asynchronously
// api document: https://help.aliyun.com/api/smartag/describesmartaccessgatewayha.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSmartAccessGatewayHaWithCallback(request *DescribeSmartAccessGatewayHaRequest, callback func(response *DescribeSmartAccessGatewayHaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSmartAccessGatewayHaResponse
		var err error
		defer close(result)
		response, err = client.DescribeSmartAccessGatewayHa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSmartAccessGatewayHaRequest is the request struct for api DescribeSmartAccessGatewayHa
type DescribeSmartAccessGatewayHaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeSmartAccessGatewayHaResponse is the response struct for api DescribeSmartAccessGatewayHa
type DescribeSmartAccessGatewayHaResponse struct {
	*responses.BaseResponse
	RequestId              string `json:"RequestId" xml:"RequestId"`
	DeviceLevelBackupState string `json:"DeviceLevelBackupState" xml:"DeviceLevelBackupState"`
	DeviceLevelBackupType  string `json:"DeviceLevelBackupType" xml:"DeviceLevelBackupType"`
	MainDeviceId           string `json:"MainDeviceId" xml:"MainDeviceId"`
	BackupDeviceId         string `json:"BackupDeviceId" xml:"BackupDeviceId"`
	LinkLevelBackupState   string `json:"LinkLevelBackupState" xml:"LinkLevelBackupState"`
	LinkLevelBackupType    string `json:"LinkLevelBackupType" xml:"LinkLevelBackupType"`
	MainLinkId             string `json:"MainLinkId" xml:"MainLinkId"`
	BackupLinkId           string `json:"BackupLinkId" xml:"BackupLinkId"`
	SmartAGId              string `json:"SmartAGId" xml:"SmartAGId"`
	MainLinkState          string `json:"MainLinkState" xml:"MainLinkState"`
	BackupLinkState        string `json:"BackupLinkState" xml:"BackupLinkState"`
}

// CreateDescribeSmartAccessGatewayHaRequest creates a request to invoke DescribeSmartAccessGatewayHa API
func CreateDescribeSmartAccessGatewayHaRequest() (request *DescribeSmartAccessGatewayHaRequest) {
	request = &DescribeSmartAccessGatewayHaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSmartAccessGatewayHa", "smartag", "openAPI")
	return
}

// CreateDescribeSmartAccessGatewayHaResponse creates a response to parse from DescribeSmartAccessGatewayHa response
func CreateDescribeSmartAccessGatewayHaResponse() (response *DescribeSmartAccessGatewayHaResponse) {
	response = &DescribeSmartAccessGatewayHaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
