package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySmartAccessGateway invokes the smartag.ModifySmartAccessGateway API synchronously
// api document: https://help.aliyun.com/api/smartag/modifysmartaccessgateway.html
func (client *Client) ModifySmartAccessGateway(request *ModifySmartAccessGatewayRequest) (response *ModifySmartAccessGatewayResponse, err error) {
	response = CreateModifySmartAccessGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySmartAccessGatewayWithChan invokes the smartag.ModifySmartAccessGateway API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifysmartaccessgateway.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySmartAccessGatewayWithChan(request *ModifySmartAccessGatewayRequest) (<-chan *ModifySmartAccessGatewayResponse, <-chan error) {
	responseChan := make(chan *ModifySmartAccessGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySmartAccessGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySmartAccessGatewayWithCallback invokes the smartag.ModifySmartAccessGateway API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifysmartaccessgateway.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySmartAccessGatewayWithCallback(request *ModifySmartAccessGatewayRequest, callback func(response *ModifySmartAccessGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySmartAccessGatewayResponse
		var err error
		defer close(result)
		response, err = client.ModifySmartAccessGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySmartAccessGatewayRequest is the request struct for api ModifySmartAccessGateway
type ModifySmartAccessGatewayRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	City                  string           `position:"Query" name:"City"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	Name                  string           `position:"Query" name:"Name"`
	CidrBlock             string           `position:"Query" name:"CidrBlock"`
	SmartAGId             string           `position:"Query" name:"SmartAGId"`
	Description           string           `position:"Query" name:"Description"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	SecurityLockThreshold requests.Integer `position:"Query" name:"SecurityLockThreshold"`
}

// ModifySmartAccessGatewayResponse is the response struct for api ModifySmartAccessGateway
type ModifySmartAccessGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySmartAccessGatewayRequest creates a request to invoke ModifySmartAccessGateway API
func CreateModifySmartAccessGatewayRequest() (request *ModifySmartAccessGatewayRequest) {
	request = &ModifySmartAccessGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySmartAccessGateway", "smartag", "openAPI")
	return
}

// CreateModifySmartAccessGatewayResponse creates a response to parse from ModifySmartAccessGateway response
func CreateModifySmartAccessGatewayResponse() (response *ModifySmartAccessGatewayResponse) {
	response = &ModifySmartAccessGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
