package ubsms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// NotifyUserBusinessCommand invokes the ubsms.NotifyUserBusinessCommand API synchronously
// api document: https://help.aliyun.com/api/ubsms/notifyuserbusinesscommand.html
func (client *Client) NotifyUserBusinessCommand(request *NotifyUserBusinessCommandRequest) (response *NotifyUserBusinessCommandResponse, err error) {
	response = CreateNotifyUserBusinessCommandResponse()
	err = client.DoAction(request, response)
	return
}

// NotifyUserBusinessCommandWithChan invokes the ubsms.NotifyUserBusinessCommand API asynchronously
// api document: https://help.aliyun.com/api/ubsms/notifyuserbusinesscommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) NotifyUserBusinessCommandWithChan(request *NotifyUserBusinessCommandRequest) (<-chan *NotifyUserBusinessCommandResponse, <-chan error) {
	responseChan := make(chan *NotifyUserBusinessCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.NotifyUserBusinessCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// NotifyUserBusinessCommandWithCallback invokes the ubsms.NotifyUserBusinessCommand API asynchronously
// api document: https://help.aliyun.com/api/ubsms/notifyuserbusinesscommand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) NotifyUserBusinessCommandWithCallback(request *NotifyUserBusinessCommandRequest, callback func(response *NotifyUserBusinessCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *NotifyUserBusinessCommandResponse
		var err error
		defer close(result)
		response, err = client.NotifyUserBusinessCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// NotifyUserBusinessCommandRequest is the request struct for api NotifyUserBusinessCommand
type NotifyUserBusinessCommandRequest struct {
	*requests.RpcRequest
	Uid         string `position:"Query" name:"Uid"`
	Password    string `position:"Query" name:"Password"`
	InstanceId  string `position:"Query" name:"InstanceId"`
	ServiceCode string `position:"Query" name:"ServiceCode"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Cmd         string `position:"Query" name:"Cmd"`
	Region      string `position:"Query" name:"Region"`
}

// NotifyUserBusinessCommandResponse is the response struct for api NotifyUserBusinessCommand
type NotifyUserBusinessCommandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateNotifyUserBusinessCommandRequest creates a request to invoke NotifyUserBusinessCommand API
func CreateNotifyUserBusinessCommandRequest() (request *NotifyUserBusinessCommandRequest) {
	request = &NotifyUserBusinessCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ubsms", "2015-06-23", "NotifyUserBusinessCommand", "ubsms", "openAPI")
	return
}

// CreateNotifyUserBusinessCommandResponse creates a response to parse from NotifyUserBusinessCommand response
func CreateNotifyUserBusinessCommandResponse() (response *NotifyUserBusinessCommandResponse) {
	response = &NotifyUserBusinessCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
