package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyIpv6GatewaySpec invokes the vpc.ModifyIpv6GatewaySpec API synchronously
// api document: https://help.aliyun.com/api/vpc/modifyipv6gatewayspec.html
func (client *Client) ModifyIpv6GatewaySpec(request *ModifyIpv6GatewaySpecRequest) (response *ModifyIpv6GatewaySpecResponse, err error) {
	response = CreateModifyIpv6GatewaySpecResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyIpv6GatewaySpecWithChan invokes the vpc.ModifyIpv6GatewaySpec API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyipv6gatewayspec.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIpv6GatewaySpecWithChan(request *ModifyIpv6GatewaySpecRequest) (<-chan *ModifyIpv6GatewaySpecResponse, <-chan error) {
	responseChan := make(chan *ModifyIpv6GatewaySpecResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyIpv6GatewaySpec(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyIpv6GatewaySpecWithCallback invokes the vpc.ModifyIpv6GatewaySpec API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyipv6gatewayspec.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIpv6GatewaySpecWithCallback(request *ModifyIpv6GatewaySpecRequest, callback func(response *ModifyIpv6GatewaySpecResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyIpv6GatewaySpecResponse
		var err error
		defer close(result)
		response, err = client.ModifyIpv6GatewaySpec(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyIpv6GatewaySpecRequest is the request struct for api ModifyIpv6GatewaySpec
type ModifyIpv6GatewaySpecRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Spec                 string           `position:"Query" name:"Spec"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Ipv6GatewayId        string           `position:"Query" name:"Ipv6GatewayId"`
}

// ModifyIpv6GatewaySpecResponse is the response struct for api ModifyIpv6GatewaySpec
type ModifyIpv6GatewaySpecResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyIpv6GatewaySpecRequest creates a request to invoke ModifyIpv6GatewaySpec API
func CreateModifyIpv6GatewaySpecRequest() (request *ModifyIpv6GatewaySpecRequest) {
	request = &ModifyIpv6GatewaySpecRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyIpv6GatewaySpec", "vpc", "openAPI")
	return
}

// CreateModifyIpv6GatewaySpecResponse creates a response to parse from ModifyIpv6GatewaySpec response
func CreateModifyIpv6GatewaySpecResponse() (response *ModifyIpv6GatewaySpecResponse) {
	response = &ModifyIpv6GatewaySpecResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
