package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTrail invokes the actiontrail.UpdateTrail API synchronously
// api document: https://help.aliyun.com/api/actiontrail/updatetrail.html
func (client *Client) UpdateTrail(request *UpdateTrailRequest) (response *UpdateTrailResponse, err error) {
	response = CreateUpdateTrailResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTrailWithChan invokes the actiontrail.UpdateTrail API asynchronously
// api document: https://help.aliyun.com/api/actiontrail/updatetrail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTrailWithChan(request *UpdateTrailRequest) (<-chan *UpdateTrailResponse, <-chan error) {
	responseChan := make(chan *UpdateTrailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTrail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTrailWithCallback invokes the actiontrail.UpdateTrail API asynchronously
// api document: https://help.aliyun.com/api/actiontrail/updatetrail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateTrailWithCallback(request *UpdateTrailRequest, callback func(response *UpdateTrailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTrailResponse
		var err error
		defer close(result)
		response, err = client.UpdateTrail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTrailRequest is the request struct for api UpdateTrail
type UpdateTrailRequest struct {
	*requests.RpcRequest
	SlsProjectArn   string `position:"Query" name:"SlsProjectArn"`
	SlsWriteRoleArn string `position:"Query" name:"SlsWriteRoleArn"`
	RoleName        string `position:"Query" name:"RoleName"`
	Name            string `position:"Query" name:"Name"`
	OssBucketName   string `position:"Query" name:"OssBucketName"`
	OssKeyPrefix    string `position:"Query" name:"OssKeyPrefix"`
	EventRW         string `position:"Query" name:"EventRW"`
}

// UpdateTrailResponse is the response struct for api UpdateTrail
type UpdateTrailResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Param           string `json:"Param" xml:"Param"`
	Result          string `json:"Result" xml:"Result"`
	Name            string `json:"Name" xml:"Name"`
	HomeRegion      string `json:"HomeRegion" xml:"HomeRegion"`
	OssBucketName   string `json:"OssBucketName" xml:"OssBucketName"`
	OssKeyPrefix    string `json:"OssKeyPrefix" xml:"OssKeyPrefix"`
	RoleName        string `json:"RoleName" xml:"RoleName"`
	SlsProjectArn   string `json:"SlsProjectArn" xml:"SlsProjectArn"`
	SlsWriteRoleArn string `json:"SlsWriteRoleArn" xml:"SlsWriteRoleArn"`
	EventRW         string `json:"EventRW" xml:"EventRW"`
}

// CreateUpdateTrailRequest creates a request to invoke UpdateTrail API
func CreateUpdateTrailRequest() (request *UpdateTrailRequest) {
	request = &UpdateTrailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2017-12-04", "UpdateTrail", "actiontrail", "openAPI")
	return
}

// CreateUpdateTrailResponse creates a response to parse from UpdateTrail response
func CreateUpdateTrailResponse() (response *UpdateTrailResponse) {
	response = &UpdateTrailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
