package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEcosphere invokes the baas.CreateEcosphere API synchronously
// api document: https://help.aliyun.com/api/baas/createecosphere.html
func (client *Client) CreateEcosphere(request *CreateEcosphereRequest) (response *CreateEcosphereResponse, err error) {
	response = CreateCreateEcosphereResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEcosphereWithChan invokes the baas.CreateEcosphere API asynchronously
// api document: https://help.aliyun.com/api/baas/createecosphere.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateEcosphereWithChan(request *CreateEcosphereRequest) (<-chan *CreateEcosphereResponse, <-chan error) {
	responseChan := make(chan *CreateEcosphereResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEcosphere(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEcosphereWithCallback invokes the baas.CreateEcosphere API asynchronously
// api document: https://help.aliyun.com/api/baas/createecosphere.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateEcosphereWithCallback(request *CreateEcosphereRequest, callback func(response *CreateEcosphereResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEcosphereResponse
		var err error
		defer close(result)
		response, err = client.CreateEcosphere(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEcosphereRequest is the request struct for api CreateEcosphere
type CreateEcosphereRequest struct {
	*requests.RpcRequest
	OrderersCount  requests.Integer               `position:"Body" name:"OrderersCount"`
	ConsortiumName string                         `position:"Body" name:"ConsortiumName"`
	SpecName       string                         `position:"Body" name:"SpecName"`
	Organization   *[]CreateEcosphereOrganization `position:"Body" name:"Organization"  type:"Repeated"`
	ZoneId         string                         `position:"Body" name:"ZoneId"`
	OrdererType    string                         `position:"Body" name:"OrdererType"`
	Description    string                         `position:"Body" name:"Description"`
	OrdererDomain  string                         `position:"Body" name:"OrdererDomain"`
	Location       string                         `position:"Body" name:"Location"`
	PeersCount     requests.Integer               `position:"Body" name:"PeersCount"`
	ChannelPolicy  string                         `position:"Body" name:"ChannelPolicy"`
}

// CreateEcosphereOrganization is a repeated param struct in CreateEcosphereRequest
type CreateEcosphereOrganization struct {
	Domain      string `name:"Domain"`
	Name        string `name:"Name"`
	Description string `name:"Description"`
}

// CreateEcosphereResponse is the response struct for api CreateEcosphere
type CreateEcosphereResponse struct {
	*responses.BaseResponse
	RequestId    string                  `json:"RequestId" xml:"RequestId"`
	Success      bool                    `json:"Success" xml:"Success"`
	ErrorCode    int                     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                  `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       ResultInCreateEcosphere `json:"Result" xml:"Result"`
}

// CreateCreateEcosphereRequest creates a request to invoke CreateEcosphere API
func CreateCreateEcosphereRequest() (request *CreateEcosphereRequest) {
	request = &CreateEcosphereRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "CreateEcosphere", "", "")
	return
}

// CreateCreateEcosphereResponse creates a response to parse from CreateEcosphere response
func CreateCreateEcosphereResponse() (response *CreateEcosphereResponse) {
	response = &CreateEcosphereResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
