package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsortiumDeletable invokes the baas.DescribeConsortiumDeletable API synchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumdeletable.html
func (client *Client) DescribeConsortiumDeletable(request *DescribeConsortiumDeletableRequest) (response *DescribeConsortiumDeletableResponse, err error) {
	response = CreateDescribeConsortiumDeletableResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsortiumDeletableWithChan invokes the baas.DescribeConsortiumDeletable API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumdeletable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumDeletableWithChan(request *DescribeConsortiumDeletableRequest) (<-chan *DescribeConsortiumDeletableResponse, <-chan error) {
	responseChan := make(chan *DescribeConsortiumDeletableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsortiumDeletable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsortiumDeletableWithCallback invokes the baas.DescribeConsortiumDeletable API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumdeletable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumDeletableWithCallback(request *DescribeConsortiumDeletableRequest, callback func(response *DescribeConsortiumDeletableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsortiumDeletableResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsortiumDeletable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsortiumDeletableRequest is the request struct for api DescribeConsortiumDeletable
type DescribeConsortiumDeletableRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Query" name:"ConsortiumId"`
}

// DescribeConsortiumDeletableResponse is the response struct for api DescribeConsortiumDeletable
type DescribeConsortiumDeletableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeConsortiumDeletableRequest creates a request to invoke DescribeConsortiumDeletable API
func CreateDescribeConsortiumDeletableRequest() (request *DescribeConsortiumDeletableRequest) {
	request = &DescribeConsortiumDeletableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeConsortiumDeletable", "", "")
	return
}

// CreateDescribeConsortiumDeletableResponse creates a response to parse from DescribeConsortiumDeletable response
func CreateDescribeConsortiumDeletableResponse() (response *DescribeConsortiumDeletableResponse) {
	response = &DescribeConsortiumDeletableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
