package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsortiumOrderers invokes the baas.DescribeConsortiumOrderers API synchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumorderers.html
func (client *Client) DescribeConsortiumOrderers(request *DescribeConsortiumOrderersRequest) (response *DescribeConsortiumOrderersResponse, err error) {
	response = CreateDescribeConsortiumOrderersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsortiumOrderersWithChan invokes the baas.DescribeConsortiumOrderers API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumorderers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumOrderersWithChan(request *DescribeConsortiumOrderersRequest) (<-chan *DescribeConsortiumOrderersResponse, <-chan error) {
	responseChan := make(chan *DescribeConsortiumOrderersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsortiumOrderers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsortiumOrderersWithCallback invokes the baas.DescribeConsortiumOrderers API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiumorderers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumOrderersWithCallback(request *DescribeConsortiumOrderersRequest, callback func(response *DescribeConsortiumOrderersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsortiumOrderersResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsortiumOrderers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsortiumOrderersRequest is the request struct for api DescribeConsortiumOrderers
type DescribeConsortiumOrderersRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Body" name:"ConsortiumId"`
}

// DescribeConsortiumOrderersResponse is the response struct for api DescribeConsortiumOrderers
type DescribeConsortiumOrderersResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	ErrorCode int       `json:"ErrorCode" xml:"ErrorCode"`
	Result    []Orderer `json:"Result" xml:"Result"`
}

// CreateDescribeConsortiumOrderersRequest creates a request to invoke DescribeConsortiumOrderers API
func CreateDescribeConsortiumOrderersRequest() (request *DescribeConsortiumOrderersRequest) {
	request = &DescribeConsortiumOrderersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeConsortiumOrderers", "", "")
	return
}

// CreateDescribeConsortiumOrderersResponse creates a response to parse from DescribeConsortiumOrderers response
func CreateDescribeConsortiumOrderersResponse() (response *DescribeConsortiumOrderersResponse) {
	response = &DescribeConsortiumOrderersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
