package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadSignedData invokes the baas.DownloadSignedData API synchronously
// api document: https://help.aliyun.com/api/baas/downloadsigneddata.html
func (client *Client) DownloadSignedData(request *DownloadSignedDataRequest) (response *DownloadSignedDataResponse, err error) {
	response = CreateDownloadSignedDataResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadSignedDataWithChan invokes the baas.DownloadSignedData API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadsigneddata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadSignedDataWithChan(request *DownloadSignedDataRequest) (<-chan *DownloadSignedDataResponse, <-chan error) {
	responseChan := make(chan *DownloadSignedDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadSignedData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadSignedDataWithCallback invokes the baas.DownloadSignedData API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadsigneddata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadSignedDataWithCallback(request *DownloadSignedDataRequest, callback func(response *DownloadSignedDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadSignedDataResponse
		var err error
		defer close(result)
		response, err = client.DownloadSignedData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadSignedDataRequest is the request struct for api DownloadSignedData
type DownloadSignedDataRequest struct {
	*requests.RpcRequest
	Path  string `position:"Body" name:"Path"`
	Bizid string `position:"Body" name:"Bizid"`
}

// DownloadSignedDataResponse is the response struct for api DownloadSignedData
type DownloadSignedDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDownloadSignedDataRequest creates a request to invoke DownloadSignedData API
func CreateDownloadSignedDataRequest() (request *DownloadSignedDataRequest) {
	request = &DownloadSignedDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DownloadSignedData", "", "")
	return
}

// CreateDownloadSignedDataResponse creates a response to parse from DownloadSignedData response
func CreateDownloadSignedDataResponse() (response *DownloadSignedDataResponse) {
	response = &DownloadSignedDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
