package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBlockchainInfo invokes the baas.GetBlockchainInfo API synchronously
// api document: https://help.aliyun.com/api/baas/getblockchaininfo.html
func (client *Client) GetBlockchainInfo(request *GetBlockchainInfoRequest) (response *GetBlockchainInfoResponse, err error) {
	response = CreateGetBlockchainInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetBlockchainInfoWithChan invokes the baas.GetBlockchainInfo API asynchronously
// api document: https://help.aliyun.com/api/baas/getblockchaininfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBlockchainInfoWithChan(request *GetBlockchainInfoRequest) (<-chan *GetBlockchainInfoResponse, <-chan error) {
	responseChan := make(chan *GetBlockchainInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBlockchainInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBlockchainInfoWithCallback invokes the baas.GetBlockchainInfo API asynchronously
// api document: https://help.aliyun.com/api/baas/getblockchaininfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBlockchainInfoWithCallback(request *GetBlockchainInfoRequest, callback func(response *GetBlockchainInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBlockchainInfoResponse
		var err error
		defer close(result)
		response, err = client.GetBlockchainInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBlockchainInfoRequest is the request struct for api GetBlockchainInfo
type GetBlockchainInfoRequest struct {
	*requests.RpcRequest
	Bizid string `position:"Body" name:"Bizid"`
}

// GetBlockchainInfoResponse is the response struct for api GetBlockchainInfo
type GetBlockchainInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetBlockchainInfoRequest creates a request to invoke GetBlockchainInfo API
func CreateGetBlockchainInfoRequest() (request *GetBlockchainInfoRequest) {
	request = &GetBlockchainInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "GetBlockchainInfo", "", "")
	return
}

// CreateGetBlockchainInfoResponse creates a response to parse from GetBlockchainInfo response
func CreateGetBlockchainInfoResponse() (response *GetBlockchainInfoResponse) {
	response = &GetBlockchainInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
