package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTransaction invokes the baas.QueryTransaction API synchronously
// api document: https://help.aliyun.com/api/baas/querytransaction.html
func (client *Client) QueryTransaction(request *QueryTransactionRequest) (response *QueryTransactionResponse, err error) {
	response = CreateQueryTransactionResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTransactionWithChan invokes the baas.QueryTransaction API asynchronously
// api document: https://help.aliyun.com/api/baas/querytransaction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTransactionWithChan(request *QueryTransactionRequest) (<-chan *QueryTransactionResponse, <-chan error) {
	responseChan := make(chan *QueryTransactionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTransaction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTransactionWithCallback invokes the baas.QueryTransaction API asynchronously
// api document: https://help.aliyun.com/api/baas/querytransaction.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTransactionWithCallback(request *QueryTransactionRequest, callback func(response *QueryTransactionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTransactionResponse
		var err error
		defer close(result)
		response, err = client.QueryTransaction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTransactionRequest is the request struct for api QueryTransaction
type QueryTransactionRequest struct {
	*requests.RpcRequest
	Bizid string `position:"Body" name:"Bizid"`
	Hash  string `position:"Body" name:"Hash"`
}

// QueryTransactionResponse is the response struct for api QueryTransaction
type QueryTransactionResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Result    ResultInQueryTransaction `json:"Result" xml:"Result"`
}

// CreateQueryTransactionRequest creates a request to invoke QueryTransaction API
func CreateQueryTransactionRequest() (request *QueryTransactionRequest) {
	request = &QueryTransactionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "QueryTransaction", "", "")
	return
}

// CreateQueryTransactionResponse creates a response to parse from QueryTransaction response
func CreateQueryTransactionResponse() (response *QueryTransactionResponse) {
	response = &QueryTransactionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
