package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCenBandwidthPackages invokes the cbn.DescribeCenBandwidthPackages API synchronously
// api document: https://help.aliyun.com/api/cbn/describecenbandwidthpackages.html
func (client *Client) DescribeCenBandwidthPackages(request *DescribeCenBandwidthPackagesRequest) (response *DescribeCenBandwidthPackagesResponse, err error) {
	response = CreateDescribeCenBandwidthPackagesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCenBandwidthPackagesWithChan invokes the cbn.DescribeCenBandwidthPackages API asynchronously
// api document: https://help.aliyun.com/api/cbn/describecenbandwidthpackages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCenBandwidthPackagesWithChan(request *DescribeCenBandwidthPackagesRequest) (<-chan *DescribeCenBandwidthPackagesResponse, <-chan error) {
	responseChan := make(chan *DescribeCenBandwidthPackagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCenBandwidthPackages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCenBandwidthPackagesWithCallback invokes the cbn.DescribeCenBandwidthPackages API asynchronously
// api document: https://help.aliyun.com/api/cbn/describecenbandwidthpackages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCenBandwidthPackagesWithCallback(request *DescribeCenBandwidthPackagesRequest, callback func(response *DescribeCenBandwidthPackagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCenBandwidthPackagesResponse
		var err error
		defer close(result)
		response, err = client.DescribeCenBandwidthPackages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCenBandwidthPackagesRequest is the request struct for api DescribeCenBandwidthPackages
type DescribeCenBandwidthPackagesRequest struct {
	*requests.RpcRequest
	Filter               *[]DescribeCenBandwidthPackagesFilter `position:"Query" name:"Filter"  type:"Repeated"`
	ResourceOwnerId      requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string                                `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                                `position:"Query" name:"OwnerAccount"`
	PageSize             requests.Integer                      `position:"Query" name:"PageSize"`
	OwnerId              requests.Integer                      `position:"Query" name:"OwnerId"`
	PageNumber           requests.Integer                      `position:"Query" name:"PageNumber"`
	IsOrKey              requests.Boolean                      `position:"Query" name:"IsOrKey"`
}

// DescribeCenBandwidthPackagesFilter is a repeated param struct in DescribeCenBandwidthPackagesRequest
type DescribeCenBandwidthPackagesFilter struct {
	Value *[]string `name:"Value" type:"Repeated"`
	Key   string    `name:"Key"`
}

// DescribeCenBandwidthPackagesResponse is the response struct for api DescribeCenBandwidthPackages
type DescribeCenBandwidthPackagesResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	TotalCount           int                  `json:"TotalCount" xml:"TotalCount"`
	PageNumber           int                  `json:"PageNumber" xml:"PageNumber"`
	PageSize             int                  `json:"PageSize" xml:"PageSize"`
	CenBandwidthPackages CenBandwidthPackages `json:"CenBandwidthPackages" xml:"CenBandwidthPackages"`
}

// CreateDescribeCenBandwidthPackagesRequest creates a request to invoke DescribeCenBandwidthPackages API
func CreateDescribeCenBandwidthPackagesRequest() (request *DescribeCenBandwidthPackagesRequest) {
	request = &DescribeCenBandwidthPackagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeCenBandwidthPackages", "cbn", "openAPI")
	return
}

// CreateDescribeCenBandwidthPackagesResponse creates a response to parse from DescribeCenBandwidthPackages response
func CreateDescribeCenBandwidthPackagesResponse() (response *DescribeCenBandwidthPackagesResponse) {
	response = &DescribeCenBandwidthPackagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
