package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSpecificConfig invokes the cdn.DeleteSpecificConfig API synchronously
// api document: https://help.aliyun.com/api/cdn/deletespecificconfig.html
func (client *Client) DeleteSpecificConfig(request *DeleteSpecificConfigRequest) (response *DeleteSpecificConfigResponse, err error) {
	response = CreateDeleteSpecificConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSpecificConfigWithChan invokes the cdn.DeleteSpecificConfig API asynchronously
// api document: https://help.aliyun.com/api/cdn/deletespecificconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSpecificConfigWithChan(request *DeleteSpecificConfigRequest) (<-chan *DeleteSpecificConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteSpecificConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSpecificConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSpecificConfigWithCallback invokes the cdn.DeleteSpecificConfig API asynchronously
// api document: https://help.aliyun.com/api/cdn/deletespecificconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteSpecificConfigWithCallback(request *DeleteSpecificConfigRequest, callback func(response *DeleteSpecificConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSpecificConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteSpecificConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSpecificConfigRequest is the request struct for api DeleteSpecificConfig
type DeleteSpecificConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	ConfigId      string           `position:"Query" name:"ConfigId"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteSpecificConfigResponse is the response struct for api DeleteSpecificConfig
type DeleteSpecificConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSpecificConfigRequest creates a request to invoke DeleteSpecificConfig API
func CreateDeleteSpecificConfigRequest() (request *DeleteSpecificConfigRequest) {
	request = &DeleteSpecificConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DeleteSpecificConfig", "", "")
	return
}

// CreateDeleteSpecificConfigResponse creates a response to parse from DeleteSpecificConfig response
func CreateDeleteSpecificConfigResponse() (response *DeleteSpecificConfigResponse) {
	response = &DeleteSpecificConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
