package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApiGroups invokes the cloudapi.DescribeApiGroups API synchronously
// api document: https://help.aliyun.com/api/cloudapi/describeapigroups.html
func (client *Client) DescribeApiGroups(request *DescribeApiGroupsRequest) (response *DescribeApiGroupsResponse, err error) {
	response = CreateDescribeApiGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApiGroupsWithChan invokes the cloudapi.DescribeApiGroups API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/describeapigroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeApiGroupsWithChan(request *DescribeApiGroupsRequest) (<-chan *DescribeApiGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeApiGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApiGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApiGroupsWithCallback invokes the cloudapi.DescribeApiGroups API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/describeapigroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeApiGroupsWithCallback(request *DescribeApiGroupsRequest, callback func(response *DescribeApiGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApiGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeApiGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApiGroupsRequest is the request struct for api DescribeApiGroups
type DescribeApiGroupsRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	GroupId       string           `position:"Query" name:"GroupId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	GroupName     string           `position:"Query" name:"GroupName"`
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeApiGroupsResponse is the response struct for api DescribeApiGroups
type DescribeApiGroupsResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	TotalCount         int                `json:"TotalCount" xml:"TotalCount"`
	PageSize           int                `json:"PageSize" xml:"PageSize"`
	PageNumber         int                `json:"PageNumber" xml:"PageNumber"`
	ApiGroupAttributes ApiGroupAttributes `json:"ApiGroupAttributes" xml:"ApiGroupAttributes"`
}

// CreateDescribeApiGroupsRequest creates a request to invoke DescribeApiGroups API
func CreateDescribeApiGroupsRequest() (request *DescribeApiGroupsRequest) {
	request = &DescribeApiGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeApiGroups", "apigateway", "openAPI")
	return
}

// CreateDescribeApiGroupsResponse creates a response to parse from DescribeApiGroups response
func CreateDescribeApiGroupsResponse() (response *DescribeApiGroupsResponse) {
	response = &DescribeApiGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
