package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindEslDevice invokes the cloudesl.BindEslDevice API synchronously
// api document: https://help.aliyun.com/api/cloudesl/bindesldevice.html
func (client *Client) BindEslDevice(request *BindEslDeviceRequest) (response *BindEslDeviceResponse, err error) {
	response = CreateBindEslDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BindEslDeviceWithChan invokes the cloudesl.BindEslDevice API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/bindesldevice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindEslDeviceWithChan(request *BindEslDeviceRequest) (<-chan *BindEslDeviceResponse, <-chan error) {
	responseChan := make(chan *BindEslDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindEslDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindEslDeviceWithCallback invokes the cloudesl.BindEslDevice API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/bindesldevice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindEslDeviceWithCallback(request *BindEslDeviceRequest, callback func(response *BindEslDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindEslDeviceResponse
		var err error
		defer close(result)
		response, err = client.BindEslDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindEslDeviceRequest is the request struct for api BindEslDevice
type BindEslDeviceRequest struct {
	*requests.RpcRequest
	EslBarCode  string `position:"Query" name:"EslBarCode"`
	StoreId     string `position:"Query" name:"StoreId"`
	ItemBarCode string `position:"Query" name:"ItemBarCode"`
}

// BindEslDeviceResponse is the response struct for api BindEslDevice
type BindEslDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateBindEslDeviceRequest creates a request to invoke BindEslDevice API
func CreateBindEslDeviceRequest() (request *BindEslDeviceRequest) {
	request = &BindEslDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2018-08-01", "BindEslDevice", "", "")
	return
}

// CreateBindEslDeviceResponse creates a response to parse from BindEslDevice response
func CreateBindEslDeviceResponse() (response *BindEslDeviceResponse) {
	response = &BindEslDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
