package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEventRule invokes the cms.DeleteEventRule API synchronously
// api document: https://help.aliyun.com/api/cms/deleteeventrule.html
func (client *Client) DeleteEventRule(request *DeleteEventRuleRequest) (response *DeleteEventRuleResponse, err error) {
	response = CreateDeleteEventRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEventRuleWithChan invokes the cms.DeleteEventRule API asynchronously
// api document: https://help.aliyun.com/api/cms/deleteeventrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEventRuleWithChan(request *DeleteEventRuleRequest) (<-chan *DeleteEventRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteEventRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEventRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEventRuleWithCallback invokes the cms.DeleteEventRule API asynchronously
// api document: https://help.aliyun.com/api/cms/deleteeventrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteEventRuleWithCallback(request *DeleteEventRuleRequest, callback func(response *DeleteEventRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEventRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteEventRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEventRuleRequest is the request struct for api DeleteEventRule
type DeleteEventRuleRequest struct {
	*requests.RpcRequest
	RuleNames *[]string `position:"Query" name:"RuleNames"  type:"Repeated"`
	RuleName  string    `position:"Query" name:"RuleName"`
}

// DeleteEventRuleResponse is the response struct for api DeleteEventRule
type DeleteEventRuleResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEventRuleRequest creates a request to invoke DeleteEventRule API
func CreateDeleteEventRuleRequest() (request *DeleteEventRuleRequest) {
	request = &DeleteEventRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "DeleteEventRule", "cms", "openAPI")
	return
}

// CreateDeleteEventRuleResponse creates a response to parse from DeleteEventRule response
func CreateDeleteEventRuleResponse() (response *DeleteEventRuleResponse) {
	response = &DeleteEventRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
