package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTasks invokes the cms.DeleteTasks API synchronously
// api document: https://help.aliyun.com/api/cms/deletetasks.html
func (client *Client) DeleteTasks(request *DeleteTasksRequest) (response *DeleteTasksResponse, err error) {
	response = CreateDeleteTasksResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTasksWithChan invokes the cms.DeleteTasks API asynchronously
// api document: https://help.aliyun.com/api/cms/deletetasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTasksWithChan(request *DeleteTasksRequest) (<-chan *DeleteTasksResponse, <-chan error) {
	responseChan := make(chan *DeleteTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTasksWithCallback invokes the cms.DeleteTasks API asynchronously
// api document: https://help.aliyun.com/api/cms/deletetasks.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTasksWithCallback(request *DeleteTasksRequest, callback func(response *DeleteTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTasksResponse
		var err error
		defer close(result)
		response, err = client.DeleteTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTasksRequest is the request struct for api DeleteTasks
type DeleteTasksRequest struct {
	*requests.RpcRequest
	IsDeleteAlarms requests.Integer `position:"Query" name:"IsDeleteAlarms"`
	TaskIds        string           `position:"Query" name:"TaskIds"`
}

// DeleteTasksResponse is the response struct for api DeleteTasks
type DeleteTasksResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDeleteTasksRequest creates a request to invoke DeleteTasks API
func CreateDeleteTasksRequest() (request *DeleteTasksRequest) {
	request = &DeleteTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "DeleteTasks", "cms", "openAPI")
	return
}

// CreateDeleteTasksResponse creates a response to parse from DeleteTasks response
func CreateDeleteTasksResponse() (response *DeleteTasksResponse) {
	response = &DeleteTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
