package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTaskMonitorData invokes the cms.QueryTaskMonitorData API synchronously
// api document: https://help.aliyun.com/api/cms/querytaskmonitordata.html
func (client *Client) QueryTaskMonitorData(request *QueryTaskMonitorDataRequest) (response *QueryTaskMonitorDataResponse, err error) {
	response = CreateQueryTaskMonitorDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTaskMonitorDataWithChan invokes the cms.QueryTaskMonitorData API asynchronously
// api document: https://help.aliyun.com/api/cms/querytaskmonitordata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTaskMonitorDataWithChan(request *QueryTaskMonitorDataRequest) (<-chan *QueryTaskMonitorDataResponse, <-chan error) {
	responseChan := make(chan *QueryTaskMonitorDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTaskMonitorData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTaskMonitorDataWithCallback invokes the cms.QueryTaskMonitorData API asynchronously
// api document: https://help.aliyun.com/api/cms/querytaskmonitordata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTaskMonitorDataWithCallback(request *QueryTaskMonitorDataRequest, callback func(response *QueryTaskMonitorDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTaskMonitorDataResponse
		var err error
		defer close(result)
		response, err = client.QueryTaskMonitorData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTaskMonitorDataRequest is the request struct for api QueryTaskMonitorData
type QueryTaskMonitorDataRequest struct {
	*requests.RpcRequest
	Cursor     string           `position:"Query" name:"Cursor"`
	Period     string           `position:"Query" name:"Period"`
	Length     requests.Integer `position:"Query" name:"Length"`
	EndTime    string           `position:"Query" name:"EndTime"`
	StartTime  string           `position:"Query" name:"StartTime"`
	Type       string           `position:"Query" name:"Type"`
	MetricName string           `position:"Query" name:"metricName"`
	TaskId     string           `position:"Query" name:"TaskId"`
}

// QueryTaskMonitorDataResponse is the response struct for api QueryTaskMonitorData
type QueryTaskMonitorDataResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   string `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Data      string `json:"Data" xml:"Data"`
	Cursor    string `json:"Cursor" xml:"Cursor"`
}

// CreateQueryTaskMonitorDataRequest creates a request to invoke QueryTaskMonitorData API
func CreateQueryTaskMonitorDataRequest() (request *QueryTaskMonitorDataRequest) {
	request = &QueryTaskMonitorDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QueryTaskMonitorData", "cms", "openAPI")
	return
}

// CreateQueryTaskMonitorDataResponse creates a response to parse from QueryTaskMonitorData response
func CreateQueryTaskMonitorDataResponse() (response *QueryTaskMonitorDataResponse) {
	response = &QueryTaskMonitorDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
