package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRepoAuthorization invokes the cr.CreateRepoAuthorization API synchronously
// api document: https://help.aliyun.com/api/cr/createrepoauthorization.html
func (client *Client) CreateRepoAuthorization(request *CreateRepoAuthorizationRequest) (response *CreateRepoAuthorizationResponse, err error) {
	response = CreateCreateRepoAuthorizationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRepoAuthorizationWithChan invokes the cr.CreateRepoAuthorization API asynchronously
// api document: https://help.aliyun.com/api/cr/createrepoauthorization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRepoAuthorizationWithChan(request *CreateRepoAuthorizationRequest) (<-chan *CreateRepoAuthorizationResponse, <-chan error) {
	responseChan := make(chan *CreateRepoAuthorizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRepoAuthorization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRepoAuthorizationWithCallback invokes the cr.CreateRepoAuthorization API asynchronously
// api document: https://help.aliyun.com/api/cr/createrepoauthorization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateRepoAuthorizationWithCallback(request *CreateRepoAuthorizationRequest, callback func(response *CreateRepoAuthorizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRepoAuthorizationResponse
		var err error
		defer close(result)
		response, err = client.CreateRepoAuthorization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRepoAuthorizationRequest is the request struct for api CreateRepoAuthorization
type CreateRepoAuthorizationRequest struct {
	*requests.RoaRequest
	RepoNamespace string `position:"Path" name:"RepoNamespace"`
	RepoName      string `position:"Path" name:"RepoName"`
}

// CreateRepoAuthorizationResponse is the response struct for api CreateRepoAuthorization
type CreateRepoAuthorizationResponse struct {
	*responses.BaseResponse
}

// CreateCreateRepoAuthorizationRequest creates a request to invoke CreateRepoAuthorization API
func CreateCreateRepoAuthorizationRequest() (request *CreateRepoAuthorizationRequest) {
	request = &CreateRepoAuthorizationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "CreateRepoAuthorization", "/repos/[RepoNamespace]/[RepoName]/authorizations", "cr", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateCreateRepoAuthorizationResponse creates a response to parse from CreateRepoAuthorization response
func CreateCreateRepoAuthorizationResponse() (response *CreateRepoAuthorizationResponse) {
	response = &CreateRepoAuthorizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
