package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepoSyncTaskList invokes the cr.GetRepoSyncTaskList API synchronously
// api document: https://help.aliyun.com/api/cr/getreposynctasklist.html
func (client *Client) GetRepoSyncTaskList(request *GetRepoSyncTaskListRequest) (response *GetRepoSyncTaskListResponse, err error) {
	response = CreateGetRepoSyncTaskListResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepoSyncTaskListWithChan invokes the cr.GetRepoSyncTaskList API asynchronously
// api document: https://help.aliyun.com/api/cr/getreposynctasklist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoSyncTaskListWithChan(request *GetRepoSyncTaskListRequest) (<-chan *GetRepoSyncTaskListResponse, <-chan error) {
	responseChan := make(chan *GetRepoSyncTaskListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepoSyncTaskList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepoSyncTaskListWithCallback invokes the cr.GetRepoSyncTaskList API asynchronously
// api document: https://help.aliyun.com/api/cr/getreposynctasklist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoSyncTaskListWithCallback(request *GetRepoSyncTaskListRequest, callback func(response *GetRepoSyncTaskListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepoSyncTaskListResponse
		var err error
		defer close(result)
		response, err = client.GetRepoSyncTaskList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepoSyncTaskListRequest is the request struct for api GetRepoSyncTaskList
type GetRepoSyncTaskListRequest struct {
	*requests.RoaRequest
	RepoNamespace string           `position:"Path" name:"RepoNamespace"`
	RepoName      string           `position:"Path" name:"RepoName"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Page          requests.Integer `position:"Query" name:"Page"`
}

// GetRepoSyncTaskListResponse is the response struct for api GetRepoSyncTaskList
type GetRepoSyncTaskListResponse struct {
	*responses.BaseResponse
}

// CreateGetRepoSyncTaskListRequest creates a request to invoke GetRepoSyncTaskList API
func CreateGetRepoSyncTaskListRequest() (request *GetRepoSyncTaskListRequest) {
	request = &GetRepoSyncTaskListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetRepoSyncTaskList", "/repos/[RepoNamespace]/[RepoName]/syncTasks", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRepoSyncTaskListResponse creates a response to parse from GetRepoSyncTaskList response
func CreateGetRepoSyncTaskListResponse() (response *GetRepoSyncTaskListResponse) {
	response = &GetRepoSyncTaskListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
