package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchRepo invokes the cr.SearchRepo API synchronously
// api document: https://help.aliyun.com/api/cr/searchrepo.html
func (client *Client) SearchRepo(request *SearchRepoRequest) (response *SearchRepoResponse, err error) {
	response = CreateSearchRepoResponse()
	err = client.DoAction(request, response)
	return
}

// SearchRepoWithChan invokes the cr.SearchRepo API asynchronously
// api document: https://help.aliyun.com/api/cr/searchrepo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchRepoWithChan(request *SearchRepoRequest) (<-chan *SearchRepoResponse, <-chan error) {
	responseChan := make(chan *SearchRepoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchRepo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchRepoWithCallback invokes the cr.SearchRepo API asynchronously
// api document: https://help.aliyun.com/api/cr/searchrepo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchRepoWithCallback(request *SearchRepoRequest, callback func(response *SearchRepoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchRepoResponse
		var err error
		defer close(result)
		response, err = client.SearchRepo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchRepoRequest is the request struct for api SearchRepo
type SearchRepoRequest struct {
	*requests.RoaRequest
	Origin   string           `position:"Query" name:"Origin"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Page     requests.Integer `position:"Query" name:"Page"`
	Keyword  string           `position:"Query" name:"Keyword"`
}

// SearchRepoResponse is the response struct for api SearchRepo
type SearchRepoResponse struct {
	*responses.BaseResponse
}

// CreateSearchRepoRequest creates a request to invoke SearchRepo API
func CreateSearchRepoRequest() (request *SearchRepoRequest) {
	request = &SearchRepoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "SearchRepo", "/search", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateSearchRepoResponse creates a response to parse from SearchRepo response
func CreateSearchRepoResponse() (response *SearchRepoResponse) {
	response = &SearchRepoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
