package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartRepoBuildByRule invokes the cr.StartRepoBuildByRule API synchronously
// api document: https://help.aliyun.com/api/cr/startrepobuildbyrule.html
func (client *Client) StartRepoBuildByRule(request *StartRepoBuildByRuleRequest) (response *StartRepoBuildByRuleResponse, err error) {
	response = CreateStartRepoBuildByRuleResponse()
	err = client.DoAction(request, response)
	return
}

// StartRepoBuildByRuleWithChan invokes the cr.StartRepoBuildByRule API asynchronously
// api document: https://help.aliyun.com/api/cr/startrepobuildbyrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartRepoBuildByRuleWithChan(request *StartRepoBuildByRuleRequest) (<-chan *StartRepoBuildByRuleResponse, <-chan error) {
	responseChan := make(chan *StartRepoBuildByRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartRepoBuildByRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartRepoBuildByRuleWithCallback invokes the cr.StartRepoBuildByRule API asynchronously
// api document: https://help.aliyun.com/api/cr/startrepobuildbyrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartRepoBuildByRuleWithCallback(request *StartRepoBuildByRuleRequest, callback func(response *StartRepoBuildByRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartRepoBuildByRuleResponse
		var err error
		defer close(result)
		response, err = client.StartRepoBuildByRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartRepoBuildByRuleRequest is the request struct for api StartRepoBuildByRule
type StartRepoBuildByRuleRequest struct {
	*requests.RoaRequest
	RepoNamespace string           `position:"Path" name:"RepoNamespace"`
	RepoName      string           `position:"Path" name:"RepoName"`
	BuildRuleId   requests.Integer `position:"Path" name:"BuildRuleId"`
}

// StartRepoBuildByRuleResponse is the response struct for api StartRepoBuildByRule
type StartRepoBuildByRuleResponse struct {
	*responses.BaseResponse
}

// CreateStartRepoBuildByRuleRequest creates a request to invoke StartRepoBuildByRule API
func CreateStartRepoBuildByRuleRequest() (request *StartRepoBuildByRuleRequest) {
	request = &StartRepoBuildByRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "StartRepoBuildByRule", "/repos/[RepoNamespace]/[RepoName]/rules/[BuildRuleId]/build", "cr", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateStartRepoBuildByRuleResponse creates a response to parse from StartRepoBuildByRule response
func CreateStartRepoBuildByRuleResponse() (response *StartRepoBuildByRuleResponse) {
	response = &StartRepoBuildByRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
