package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeReplicationGroup invokes the dds.DescribeReplicationGroup API synchronously
// api document: https://help.aliyun.com/api/dds/describereplicationgroup.html
func (client *Client) DescribeReplicationGroup(request *DescribeReplicationGroupRequest) (response *DescribeReplicationGroupResponse, err error) {
	response = CreateDescribeReplicationGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeReplicationGroupWithChan invokes the dds.DescribeReplicationGroup API asynchronously
// api document: https://help.aliyun.com/api/dds/describereplicationgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeReplicationGroupWithChan(request *DescribeReplicationGroupRequest) (<-chan *DescribeReplicationGroupResponse, <-chan error) {
	responseChan := make(chan *DescribeReplicationGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeReplicationGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeReplicationGroupWithCallback invokes the dds.DescribeReplicationGroup API asynchronously
// api document: https://help.aliyun.com/api/dds/describereplicationgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeReplicationGroupWithCallback(request *DescribeReplicationGroupRequest, callback func(response *DescribeReplicationGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeReplicationGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribeReplicationGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeReplicationGroupRequest is the request struct for api DescribeReplicationGroup
type DescribeReplicationGroupRequest struct {
	*requests.RpcRequest
	DestinationInstanceIds string           `position:"Query" name:"DestinationInstanceIds"`
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken          string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	ReplicationGroupId     string           `position:"Query" name:"ReplicationGroupId"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	SourceInstanceId       string           `position:"Query" name:"SourceInstanceId"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeReplicationGroupResponse is the response struct for api DescribeReplicationGroup
type DescribeReplicationGroupResponse struct {
	*responses.BaseResponse
	RequestId     string   `json:"RequestId" xml:"RequestId"`
	TunnelContext []string `json:"tunnelContext" xml:"tunnelContext"`
}

// CreateDescribeReplicationGroupRequest creates a request to invoke DescribeReplicationGroup API
func CreateDescribeReplicationGroupRequest() (request *DescribeReplicationGroupRequest) {
	request = &DescribeReplicationGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeReplicationGroup", "dds", "openAPI")
	return
}

// CreateDescribeReplicationGroupResponse creates a response to parse from DescribeReplicationGroup response
func CreateDescribeReplicationGroupResponse() (response *DescribeReplicationGroupResponse) {
	response = &DescribeReplicationGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
