package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Sample invokes the dds.Sample API synchronously
// api document: https://help.aliyun.com/api/dds/sample.html
func (client *Client) Sample(request *SampleRequest) (response *SampleResponse, err error) {
	response = CreateSampleResponse()
	err = client.DoAction(request, response)
	return
}

// SampleWithChan invokes the dds.Sample API asynchronously
// api document: https://help.aliyun.com/api/dds/sample.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SampleWithChan(request *SampleRequest) (<-chan *SampleResponse, <-chan error) {
	responseChan := make(chan *SampleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Sample(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SampleWithCallback invokes the dds.Sample API asynchronously
// api document: https://help.aliyun.com/api/dds/sample.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SampleWithCallback(request *SampleRequest, callback func(response *SampleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SampleResponse
		var err error
		defer close(result)
		response, err = client.Sample(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SampleRequest is the request struct for api Sample
type SampleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// SampleResponse is the response struct for api Sample
type SampleResponse struct {
	*responses.BaseResponse
	RequestId        string                   `json:"RequestId" xml:"RequestId"`
	SecurityIps      string                   `json:"SecurityIps" xml:"SecurityIps"`
	SecurityIpGroups SecurityIpGroupsInSample `json:"SecurityIpGroups" xml:"SecurityIpGroups"`
}

// CreateSampleRequest creates a request to invoke Sample API
func CreateSampleRequest() (request *SampleRequest) {
	request = &SampleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "Sample", "dds", "openAPI")
	return
}

// CreateSampleResponse creates a response to parse from Sample response
func CreateSampleResponse() (response *SampleResponse) {
	response = &SampleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
