package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwithcDBInstanceHA invokes the dds.SwithcDBInstanceHA API synchronously
// api document: https://help.aliyun.com/api/dds/swithcdbinstanceha.html
func (client *Client) SwithcDBInstanceHA(request *SwithcDBInstanceHARequest) (response *SwithcDBInstanceHAResponse, err error) {
	response = CreateSwithcDBInstanceHAResponse()
	err = client.DoAction(request, response)
	return
}

// SwithcDBInstanceHAWithChan invokes the dds.SwithcDBInstanceHA API asynchronously
// api document: https://help.aliyun.com/api/dds/swithcdbinstanceha.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SwithcDBInstanceHAWithChan(request *SwithcDBInstanceHARequest) (<-chan *SwithcDBInstanceHAResponse, <-chan error) {
	responseChan := make(chan *SwithcDBInstanceHAResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwithcDBInstanceHA(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwithcDBInstanceHAWithCallback invokes the dds.SwithcDBInstanceHA API asynchronously
// api document: https://help.aliyun.com/api/dds/swithcdbinstanceha.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SwithcDBInstanceHAWithCallback(request *SwithcDBInstanceHARequest, callback func(response *SwithcDBInstanceHAResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwithcDBInstanceHAResponse
		var err error
		defer close(result)
		response, err = client.SwithcDBInstanceHA(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwithcDBInstanceHARequest is the request struct for api SwithcDBInstanceHA
type SwithcDBInstanceHARequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TargetInstanceId     requests.Integer `position:"Query" name:"TargetInstanceId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	SwitchType           requests.Integer `position:"Query" name:"SwitchType"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	SourceInstanceId     requests.Integer `position:"Query" name:"SourceInstanceId"`
	NodeId               string           `position:"Query" name:"NodeId"`
}

// SwithcDBInstanceHAResponse is the response struct for api SwithcDBInstanceHA
type SwithcDBInstanceHAResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSwithcDBInstanceHARequest creates a request to invoke SwithcDBInstanceHA API
func CreateSwithcDBInstanceHARequest() (request *SwithcDBInstanceHARequest) {
	request = &SwithcDBInstanceHARequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "SwithcDBInstanceHA", "dds", "openAPI")
	return
}

// CreateSwithcDBInstanceHAResponse creates a response to parse from SwithcDBInstanceHA response
func CreateSwithcDBInstanceHAResponse() (response *SwithcDBInstanceHAResponse) {
	response = &SwithcDBInstanceHAResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
