package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeShardDBs invokes the drds.DescribeShardDBs API synchronously
// api document: https://help.aliyun.com/api/drds/describesharddbs.html
func (client *Client) DescribeShardDBs(request *DescribeShardDBsRequest) (response *DescribeShardDBsResponse, err error) {
	response = CreateDescribeShardDBsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeShardDBsWithChan invokes the drds.DescribeShardDBs API asynchronously
// api document: https://help.aliyun.com/api/drds/describesharddbs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeShardDBsWithChan(request *DescribeShardDBsRequest) (<-chan *DescribeShardDBsResponse, <-chan error) {
	responseChan := make(chan *DescribeShardDBsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeShardDBs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeShardDBsWithCallback invokes the drds.DescribeShardDBs API asynchronously
// api document: https://help.aliyun.com/api/drds/describesharddbs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeShardDBsWithCallback(request *DescribeShardDBsRequest, callback func(response *DescribeShardDBsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeShardDBsResponse
		var err error
		defer close(result)
		response, err = client.DescribeShardDBs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeShardDBsRequest is the request struct for api DescribeShardDBs
type DescribeShardDBsRequest struct {
	*requests.RpcRequest
	DbName         string `position:"Query" name:"DbName"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// DescribeShardDBsResponse is the response struct for api DescribeShardDBs
type DescribeShardDBsResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Success   bool                   `json:"Success" xml:"Success"`
	Data      DataInDescribeShardDBs `json:"Data" xml:"Data"`
}

// CreateDescribeShardDBsRequest creates a request to invoke DescribeShardDBs API
func CreateDescribeShardDBsRequest() (request *DescribeShardDBsRequest) {
	request = &DescribeShardDBsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "DescribeShardDBs", "", "")
	return
}

// CreateDescribeShardDBsResponse creates a response to parse from DescribeShardDBs response
func CreateDescribeShardDBsResponse() (response *DescribeShardDBsResponse) {
	response = &DescribeShardDBsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
