package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDrdsIpWhiteList invokes the drds.ModifyDrdsIpWhiteList API synchronously
// api document: https://help.aliyun.com/api/drds/modifydrdsipwhitelist.html
func (client *Client) ModifyDrdsIpWhiteList(request *ModifyDrdsIpWhiteListRequest) (response *ModifyDrdsIpWhiteListResponse, err error) {
	response = CreateModifyDrdsIpWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDrdsIpWhiteListWithChan invokes the drds.ModifyDrdsIpWhiteList API asynchronously
// api document: https://help.aliyun.com/api/drds/modifydrdsipwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDrdsIpWhiteListWithChan(request *ModifyDrdsIpWhiteListRequest) (<-chan *ModifyDrdsIpWhiteListResponse, <-chan error) {
	responseChan := make(chan *ModifyDrdsIpWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDrdsIpWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDrdsIpWhiteListWithCallback invokes the drds.ModifyDrdsIpWhiteList API asynchronously
// api document: https://help.aliyun.com/api/drds/modifydrdsipwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDrdsIpWhiteListWithCallback(request *ModifyDrdsIpWhiteListRequest, callback func(response *ModifyDrdsIpWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDrdsIpWhiteListResponse
		var err error
		defer close(result)
		response, err = client.ModifyDrdsIpWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDrdsIpWhiteListRequest is the request struct for api ModifyDrdsIpWhiteList
type ModifyDrdsIpWhiteListRequest struct {
	*requests.RpcRequest
	Mode           requests.Boolean `position:"Query" name:"Mode"`
	DbName         string           `position:"Query" name:"DbName"`
	GroupAttribute string           `position:"Query" name:"GroupAttribute"`
	IpWhiteList    string           `position:"Query" name:"IpWhiteList"`
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
	GroupName      string           `position:"Query" name:"GroupName"`
}

// ModifyDrdsIpWhiteListResponse is the response struct for api ModifyDrdsIpWhiteList
type ModifyDrdsIpWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyDrdsIpWhiteListRequest creates a request to invoke ModifyDrdsIpWhiteList API
func CreateModifyDrdsIpWhiteListRequest() (request *ModifyDrdsIpWhiteListRequest) {
	request = &ModifyDrdsIpWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "ModifyDrdsIpWhiteList", "", "")
	return
}

// CreateModifyDrdsIpWhiteListResponse creates a response to parse from ModifyDrdsIpWhiteList response
func CreateModifyDrdsIpWhiteListResponse() (response *ModifyDrdsIpWhiteListResponse) {
	response = &ModifyDrdsIpWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
