package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddNodes invokes the ehpc.AddNodes API synchronously
// api document: https://help.aliyun.com/api/ehpc/addnodes.html
func (client *Client) AddNodes(request *AddNodesRequest) (response *AddNodesResponse, err error) {
	response = CreateAddNodesResponse()
	err = client.DoAction(request, response)
	return
}

// AddNodesWithChan invokes the ehpc.AddNodes API asynchronously
// api document: https://help.aliyun.com/api/ehpc/addnodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddNodesWithChan(request *AddNodesRequest) (<-chan *AddNodesResponse, <-chan error) {
	responseChan := make(chan *AddNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddNodesWithCallback invokes the ehpc.AddNodes API asynchronously
// api document: https://help.aliyun.com/api/ehpc/addnodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddNodesWithCallback(request *AddNodesRequest, callback func(response *AddNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddNodesResponse
		var err error
		defer close(result)
		response, err = client.AddNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddNodesRequest is the request struct for api AddNodes
type AddNodesRequest struct {
	*requests.RpcRequest
	AutoRenewPeriod       requests.Integer `position:"Query" name:"AutoRenewPeriod"`
	Period                requests.Integer `position:"Query" name:"Period"`
	ImageId               string           `position:"Query" name:"ImageId"`
	Count                 requests.Integer `position:"Query" name:"Count"`
	ClusterId             string           `position:"Query" name:"ClusterId"`
	ComputeSpotStrategy   string           `position:"Query" name:"ComputeSpotStrategy"`
	JobQueue              string           `position:"Query" name:"JobQueue"`
	ImageOwnerAlias       string           `position:"Query" name:"ImageOwnerAlias"`
	PeriodUnit            string           `position:"Query" name:"PeriodUnit"`
	AutoRenew             string           `position:"Query" name:"AutoRenew"`
	EcsChargeType         string           `position:"Query" name:"EcsChargeType"`
	CreateMode            string           `position:"Query" name:"CreateMode"`
	SystemDiskSize        requests.Integer `position:"Query" name:"SystemDiskSize"`
	InstanceType          string           `position:"Query" name:"InstanceType"`
	ComputeSpotPriceLimit string           `position:"Query" name:"ComputeSpotPriceLimit"`
}

// AddNodesResponse is the response struct for api AddNodes
type AddNodesResponse struct {
	*responses.BaseResponse
	RequestId   string                `json:"RequestId" xml:"RequestId"`
	InstanceIds InstanceIdsInAddNodes `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateAddNodesRequest creates a request to invoke AddNodes API
func CreateAddNodesRequest() (request *AddNodesRequest) {
	request = &AddNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "AddNodes", "ehs", "openAPI")
	return
}

// CreateAddNodesResponse creates a response to parse from AddNodes response
func CreateAddNodesResponse() (response *AddNodesResponse) {
	response = &AddNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
