package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFlowProjectById invokes the emr.DeleteFlowProjectById API synchronously
// api document: https://help.aliyun.com/api/emr/deleteflowprojectbyid.html
func (client *Client) DeleteFlowProjectById(request *DeleteFlowProjectByIdRequest) (response *DeleteFlowProjectByIdResponse, err error) {
	response = CreateDeleteFlowProjectByIdResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFlowProjectByIdWithChan invokes the emr.DeleteFlowProjectById API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteflowprojectbyid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFlowProjectByIdWithChan(request *DeleteFlowProjectByIdRequest) (<-chan *DeleteFlowProjectByIdResponse, <-chan error) {
	responseChan := make(chan *DeleteFlowProjectByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFlowProjectById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFlowProjectByIdWithCallback invokes the emr.DeleteFlowProjectById API asynchronously
// api document: https://help.aliyun.com/api/emr/deleteflowprojectbyid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFlowProjectByIdWithCallback(request *DeleteFlowProjectByIdRequest, callback func(response *DeleteFlowProjectByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFlowProjectByIdResponse
		var err error
		defer close(result)
		response, err = client.DeleteFlowProjectById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFlowProjectByIdRequest is the request struct for api DeleteFlowProjectById
type DeleteFlowProjectByIdRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Query" name:"ProjectId"`
}

// DeleteFlowProjectByIdResponse is the response struct for api DeleteFlowProjectById
type DeleteFlowProjectByIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateDeleteFlowProjectByIdRequest creates a request to invoke DeleteFlowProjectById API
func CreateDeleteFlowProjectByIdRequest() (request *DeleteFlowProjectByIdRequest) {
	request = &DeleteFlowProjectByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteFlowProjectById", "emr", "openAPI")
	return
}

// CreateDeleteFlowProjectByIdResponse creates a response to parse from DeleteFlowProjectById response
func CreateDeleteFlowProjectByIdResponse() (response *DeleteFlowProjectByIdResponse) {
	response = &DeleteFlowProjectByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
